/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.designhierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.FilteredList;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.RootDesignElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.AbstractFilteredView;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.designhierarchy.DHViewMessages;
import ro.amiq.dvt.ui.views.designhierarchy.DesignElementConfigurationPair;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.DVTDHLabelProvider;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.LazyDesignHierarchyView;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.LazyDesignHierarchyViewSelectTopDialogElement;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.LazyDesignHierarchyViewSelectTopUtils;
import ro.amiq.dvt.utils.DVTJobsUtils;
import ro.amiq.dvt.utils.StringMatcher;

public class LazyDesignHierarchyViewSelectTopAction
extends Action {
    private DVTDHLabelProvider labelProvider;
    private LazyDesignHierarchyView view;
    private Composite composite;
    private LazyDesignHierarchyViewSelectTopMenu topMenuCreator = new LazyDesignHierarchyViewSelectTopMenu();

    LazyDesignHierarchyViewSelectTopAction(LazyDesignHierarchyView view, Composite composite) {
        super(DHViewMessages.fDHSelectTopDialogTitle);
        this.setImageDescriptor(DVTImages.DESIGN_HIERARCHY_TOP);
        this.setToolTipText(DHViewMessages.fDHSelectTopDialogTitle);
        this.view = view;
        this.composite = composite;
        this.labelProvider = (DVTDHLabelProvider)view.getLabelProvider();
        this.composite = composite;
    }

    public void runWithEvent(Event event) {
        Menu menu = this.topMenuCreator.getMenu((Control)this.composite);
        if (menu != null) {
            menu.setVisible(true);
        }
    }

    private IProject getProject() {
        return this.view.getProject();
    }

    class LazyDesignHierarchyViewSelectTopMenu
    implements IMenuCreator {
        private Menu menu;
        private boolean isGUIFiltered;

        LazyDesignHierarchyViewSelectTopMenu() {
        }

        public void dispose() {
            if (this.menu != null) {
                this.menu.dispose();
                this.menu = null;
                this.isGUIFiltered = false;
            }
        }

        private Map<LanguageKind, Collection<LazyDesignHierarchyViewSelectTopDialogElement>> getItemsForSelectTopDialog() throws CoreException {
            LanguageKind[] languages;
            LinkedHashMap<LanguageKind, Collection<LazyDesignHierarchyViewSelectTopDialogElement>> result = new LinkedHashMap<LanguageKind, Collection<LazyDesignHierarchyViewSelectTopDialogElement>>();
            this.isGUIFiltered = false;
            IProject project = LazyDesignHierarchyViewSelectTopAction.this.getProject();
            if (project == null) {
                return null;
            }
            if (project.hasNature("ro.amiq.vhdldt.VhdlNature") && !DVTPlugin.getDefault().collect().c(project, "F7668646C")) {
                return null;
            }
            if (project.hasNature("ro.amiq.vlogdt.VlogNature") && !DVTPlugin.getDefault().collect().c(project, "F7376")) {
                return null;
            }
            final EnumMap topModules = new EnumMap(LanguageKind.class);
            DVTJobsUtils.runWithBusyIndicator(new Runnable(){

                @Override
                public void run() {
                    try {
                        Map<LanguageKind, List<DesignElementConfigurationPair>> temp = LazyDesignHierarchyViewSelectTopUtils.getTops(LazyDesignHierarchyViewSelectTopAction.this.getProject());
                        if (temp != null) {
                            topModules.putAll(temp);
                        }
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
            });
            if (topModules.isEmpty()) {
                return Collections.emptyMap();
            }
            LanguageKind[] languageKindArray = languages = new LanguageKind[]{LanguageKind.VHDL, LanguageKind.VLOG};
            int n = languages.length;
            int n2 = 0;
            while (n2 < n) {
                LanguageKind language = languageKindArray[n2];
                if (topModules.containsKey((Object)language)) {
                    for (DesignElementConfigurationPair topModule : (Collection)topModules.get((Object)language)) {
                        LazyDesignHierarchyViewSelectTopDialogElement lazyDesignHierarchyViewSelectTopDialogElement;
                        IRfDesignElement element = topModule.getElement();
                        if (element == null || element.isShallowCompiled() || element.isIncrementalShallowCompiled() || (lazyDesignHierarchyViewSelectTopDialogElement = LazyDesignHierarchyViewSelectTopUtils.getDialogElement(element, topModule)) == null) continue;
                        if (result.get((Object)language) == null) {
                            result.put(language, new ArrayList());
                        }
                        ((Collection)result.get((Object)language)).add(lazyDesignHierarchyViewSelectTopDialogElement);
                    }
                }
                ++n2;
            }
            return result;
        }

        public Menu getMenu(Control parent) {
            if (this.menu != null) {
                this.menu.dispose();
                this.menu = null;
                this.isGUIFiltered = false;
            }
            Map<LanguageKind, Collection<ActionContributionItem>> topItemsByProvider = this.getTopItems();
            ActionContributionItem firstAction = null;
            int n = 0;
            RfMixedLangProject rfProject = RfMixedLangManager.getInstance().getRfMixedLangProject(LazyDesignHierarchyViewSelectTopAction.this.getProject(), true);
            if (rfProject == null) {
                return null;
            }
            for (Collection<ActionContributionItem> c : topItemsByProvider.values()) {
                n += c.size();
                if (firstAction != null || c.isEmpty()) continue;
                firstAction = c.iterator().next();
            }
            if (n == 1 && firstAction != null) {
                firstAction.getAction().run();
                return null;
            }
            if (n < 11 && firstAction != null) {
                this.menu = new Menu(parent);
                boolean first = true;
                ActionContributionItem root = this.getRootEntry(rfProject);
                if (root != null) {
                    root.fill(this.menu, -1);
                    new Separator().fill(this.menu, -1);
                }
                for (Map.Entry<LanguageKind, Collection<ActionContributionItem>> entry : topItemsByProvider.entrySet()) {
                    for (ActionContributionItem ci : entry.getValue()) {
                        ci.fill(this.menu, -1);
                    }
                    if (!first || topItemsByProvider.keySet().size() <= 1) continue;
                    first = false;
                    new Separator().fill(this.menu, -1);
                }
                return this.menu;
            }
            this.showDialog(rfProject);
            return null;
        }

        private final ActionContributionItem getRootEntry(RfMixedLangProject rfProject) {
            ELManager elManager = rfProject.getELManager();
            if (elManager == null) {
                return null;
            }
            RootDesignElement rootDesignElement = elManager.getRoot();
            SelectTopItemAction topMenuItemAction = new SelectTopItemAction(rootDesignElement, "$root", LazyDesignHierarchyViewSelectTopAction.this.labelProvider.getImage(new DVTTreeElementWrapper(rootDesignElement)));
            return new ActionContributionItem((IAction)topMenuItemAction);
        }

        public Map<LanguageKind, Collection<ActionContributionItem>> getTopItems() {
            try {
                Map<LanguageKind, Collection<LazyDesignHierarchyViewSelectTopDialogElement>> topModules = this.getItemsForSelectTopDialog();
                if (topModules == null || topModules.isEmpty()) {
                    return Collections.emptyMap();
                }
                LinkedHashMap<LanguageKind, Collection<ActionContributionItem>> result = new LinkedHashMap<LanguageKind, Collection<ActionContributionItem>>();
                for (Map.Entry<LanguageKind, Collection<LazyDesignHierarchyViewSelectTopDialogElement>> topModuleEntry : topModules.entrySet()) {
                    LanguageKind language = topModuleEntry.getKey();
                    Collection<LazyDesignHierarchyViewSelectTopDialogElement> topElements = topModuleEntry.getValue();
                    for (LazyDesignHierarchyViewSelectTopDialogElement topModule : topElements) {
                        String elementLabel;
                        IRfNamedElement element = topModule.getElement();
                        if (!(element instanceof IRfDesignElement) || DVTNamedElementGUIFilterMatcher.filterElement(ViewSet.ViewName.DESIGN_HIERARCHY, element, () -> LazyDesignHierarchyViewSelectTopMenu.lambda$0(elementLabel = topModule.getElementName())) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) continue;
                        SelectTopItemAction topMenuItemAction = new SelectTopItemAction(topModule, topModule.getElementLabel(), LazyDesignHierarchyViewSelectTopAction.this.labelProvider.getImage(new DVTTreeElementWrapper(element)));
                        ActionContributionItem actionContributionItem = new ActionContributionItem((IAction)topMenuItemAction);
                        if (result.get((Object)language) == null) {
                            result.put(language, new ArrayList());
                        }
                        ((Collection)result.get((Object)language)).add(actionContributionItem);
                    }
                }
                return result;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return Collections.emptyMap();
            }
        }

        private void showDialog(RfMixedLangProject rfProject) {
            try {
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), LazyDesignHierarchyViewSelectTopAction.this.labelProvider){

                    protected FilteredList createFilteredList(Composite parent2) {
                        FilteredList list = super.createFilteredList(parent2);
                        list.setFilterMatcher(new FilteredList.FilterMatcher(){
                            private StringMatcher localMatcher;

                            public void setFilter(String pattern, boolean ignoreCase, boolean ignoreWildCards) {
                                this.localMatcher = ViewsUtils.createCamelCaseOrRegexMatcher(pattern, ignoreCase, ignoreWildCards);
                            }

                            public boolean match(Object element) {
                                if (!(element instanceof LazyDesignHierarchyViewSelectTopDialogElement)) {
                                    return false;
                                }
                                LazyDesignHierarchyViewSelectTopDialogElement selectTopElement = (LazyDesignHierarchyViewSelectTopDialogElement)element;
                                Object selectTopActualElement = null;
                                selectTopActualElement = selectTopElement.getRootConfig() != null && "$root".equals(selectTopElement.getElementLabel()) ? selectTopElement.getRootConfig() : selectTopElement.getTreePath();
                                return ViewsUtils.matchCamelCaseOrRegex(this.localMatcher, fFilteredList.getLabelProvider().getText(selectTopActualElement));
                            }
                        });
                        return list;
                    }
                };
                dialog.setTitle(DHViewMessages.fDHSelectTopDialogTitle);
                dialog.setMessage(DHViewMessages.fDHSelectTopDialogHeader);
                dialog.setMultipleSelection(false);
                dialog.setHelpAvailable(false);
                Map<LanguageKind, Collection<LazyDesignHierarchyViewSelectTopDialogElement>> tops = this.getItemsForSelectTopDialog();
                if (tops == null || tops.isEmpty()) {
                    if (this.isGUIFiltered) {
                        dialog.setElements(AbstractFilteredView.GUI_FILTERED_EMPTY_CONTENT.toArray());
                    } else {
                        dialog.setElements(AbstractFilteredView.NO_DATA_MESSAGE.toArray());
                    }
                } else {
                    ELManager elManager;
                    ArrayList<LazyDesignHierarchyViewSelectTopDialogElement> elements = new ArrayList<LazyDesignHierarchyViewSelectTopDialogElement>();
                    if (rfProject != null && (elManager = rfProject.getELManager()) != null) {
                        elements.add(new LazyDesignHierarchyViewSelectTopDialogElement(elManager.getRoot(), "$root"));
                    }
                    for (Map.Entry<LanguageKind, Collection<LazyDesignHierarchyViewSelectTopDialogElement>> top : tops.entrySet()) {
                        elements.addAll(top.getValue());
                    }
                    dialog.setElements(elements.toArray());
                }
                if (dialog.open() == 0) {
                    Object firstObj = dialog.getFirstResult();
                    if (!(firstObj instanceof LazyDesignHierarchyViewSelectTopDialogElement)) {
                        return;
                    }
                    LazyDesignHierarchyViewSelectTopDialogElement firstResult = (LazyDesignHierarchyViewSelectTopDialogElement)firstObj;
                    if (firstResult.getRootConfig() != null && "$root".equals(firstResult.getElementLabel())) {
                        LazyDesignHierarchyViewSelectTopAction.this.view.showAllTops();
                        return;
                    }
                    TreePath topTreePath = firstResult.getTreePath();
                    String configName = firstResult.getConfigName();
                    if (topTreePath == null || configName == null) {
                        return;
                    }
                    LazyDesignHierarchyViewSelectTopAction.this.view.resetForTop(topTreePath);
                }
            }
            catch (CoreException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        private static /* synthetic */ String lambda$0(String string) {
            return string;
        }
    }

    private class SelectTopItemAction
    extends Action {
        private LazyDesignHierarchyViewSelectTopDialogElement topModuleDialogElement;
        private RootDesignElement rootDesignElement;

        public SelectTopItemAction(LazyDesignHierarchyViewSelectTopDialogElement topModuleDialogElement, String label, Image image) {
            super(label);
            this.setImageDescriptor(ImageDescriptor.createFromImage((Image)image));
            this.topModuleDialogElement = topModuleDialogElement;
        }

        public SelectTopItemAction(RootDesignElement rootDesignElement, String label, Image image) {
            super(label);
            this.setImageDescriptor(ImageDescriptor.createFromImage((Image)image));
            this.rootDesignElement = rootDesignElement;
        }

        public void run() {
            if (this.rootDesignElement != null) {
                LazyDesignHierarchyViewSelectTopAction.this.view.showAllTops();
                return;
            }
            if (this.topModuleDialogElement == null) {
                return;
            }
            TreePath topTreePath = this.topModuleDialogElement.getTreePath();
            String configName = this.topModuleDialogElement.getConfigName();
            if (topTreePath == null || configName == null) {
                return;
            }
            LazyDesignHierarchyViewSelectTopAction.this.view.resetForTop(topTreePath);
        }
    }
}

