/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.designhierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfConfiguration;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfEntityComplement;
import ro.amiq.dvt.model.reflection.IRfHDLNamedElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.designhierarchy.DesignElementConfigurationPair;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.utils.TreePathUtils;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.LazyDHUtils;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.LazyDesignHierarchyViewSelectTopDialogElement;

public class LazyDesignHierarchyViewSelectTopUtils {
    public static LazyDesignHierarchyViewSelectTopDialogElement getDialogElement(IRfDesignElement element, DesignElementConfigurationPair topModule) {
        String elementLabel;
        String qualifiedName = null;
        if (element instanceof IRfHDLNamedElement && (element.getKind() == IRfNamedElement.ElementKind.VHDL_COMPONENT || element.getKind() == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE || element.getKind() == IRfNamedElement.ElementKind.VHDL_ENTITY)) {
            qualifiedName = ((IRfHDLNamedElement)((Object)element)).getQualifiedName();
        }
        String string = elementLabel = qualifiedName != null ? qualifiedName : topModule.getElementName();
        if (element.getKind() == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE || element.getKind() == IRfNamedElement.ElementKind.VHDL_CONFIGURATION) {
            element = ((IRfEntityComplement)((Object)element)).getEntity();
        }
        TreePath topTreePath = TreePathUtils.getElabTopTrimmedTreePath(element.getRfProject().getProject(), element);
        if (DVTNamedElementGUIFilterMatcher.filterElement(ViewSet.ViewName.DESIGN_HIERARCHY, element, () -> elementLabel) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
            return null;
        }
        return new LazyDesignHierarchyViewSelectTopDialogElement(topTreePath, topModule.getElementName(), topModule.getConfigurationName(), elementLabel);
    }

    public static Map<LanguageKind, List<DesignElementConfigurationPair>> getTops(IProject project) {
        try {
            if (project == null) {
                return Collections.emptyMap();
            }
            EnumMap<LanguageKind, List<DesignElementConfigurationPair>> topModules = new EnumMap<LanguageKind, List<DesignElementConfigurationPair>>(LanguageKind.class);
            RfMixedLangProject rfProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, true);
            if (rfProject == null) {
                return Collections.emptyMap();
            }
            List<IRfDesignElement> topsForElab = LazyDHUtils.getInstance().getTopsForElab(rfProject);
            if (topsForElab == null || topsForElab.isEmpty()) {
                return topModules;
            }
            for (IRfDesignElement tops : topsForElab) {
                if (DVTNamedElementGUIFilterMatcher.filterElement(ViewSet.ViewName.DESIGN_HIERARCHY_TOP_SELECTOR, tops, () -> tops.getName()) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) continue;
                LanguageKind languageKind = tops.getLanguageKind();
                if (!topModules.containsKey((Object)languageKind)) {
                    topModules.put(languageKind, new ArrayList());
                }
                ((List)topModules.get((Object)languageKind)).add(new DesignElementConfigurationPair(tops, null));
            }
            return topModules;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return Collections.emptyMap();
        }
    }

    private static void addDesignsNotInstantiated(Map<LanguageKind, List<DesignElementConfigurationPair>> topModules, Collection<? extends IRfLibraryElement> libs, IRfConfiguration selectedTopConfig, boolean addOnlyVhdlTops) {
        ArrayList<IRfDesignElement> modules = new ArrayList<IRfDesignElement>();
        LazyDesignHierarchyViewSelectTopUtils.recursiveCollectDesign(modules, libs, addOnlyVhdlTops);
        LinkedHashSet<String> instanceNames = new LinkedHashSet<String>();
        for (IRfDesignElement iRfDesignElement : modules) {
            ArrayList<IRfInstanceElement> instances = new ArrayList<IRfInstanceElement>();
            DesignUtils.getInstancesIncludingGenerate(instances, iRfDesignElement, false);
            if (instances.isEmpty()) continue;
            for (IRfInstanceElement instance : instances) {
                String instanceName = null;
                instanceName = iRfDesignElement.getKind() == IRfNamedElement.ElementKind.VLOG_MODULE ? instance.getAssociatedTypeName("logic", null) : instance.getAssociatedTypeName();
                if (instanceName == null) continue;
                instanceNames.add(instanceName);
            }
        }
        for (IRfDesignElement iRfDesignElement : modules) {
            if (instanceNames.contains(iRfDesignElement.getName()) || iRfDesignElement instanceof IRfEntityComplement && instanceNames.contains(((IRfEntityComplement)((Object)iRfDesignElement)).getEntityName()) || iRfDesignElement.getKind() == IRfNamedElement.ElementKind.VLOG_GENERATE || iRfDesignElement.getKind() == IRfNamedElement.ElementKind.VHDL_BLOCK || DVTNamedElementGUIFilterMatcher.filterElement(ViewSet.ViewName.DESIGN_HIERARCHY_TOP_SELECTOR, iRfDesignElement, () -> module.getName()) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) continue;
            LanguageKind languageKind = iRfDesignElement.getLanguageKind();
            if (topModules.get((Object)languageKind) == null) {
                topModules.put(languageKind, new ArrayList());
            }
            topModules.get((Object)languageKind).add(new DesignElementConfigurationPair(iRfDesignElement, selectedTopConfig));
        }
        if (topModules.isEmpty()) {
            return;
        }
        for (List list : topModules.values()) {
            Collections.sort(list, new Comparator<DesignElementConfigurationPair>(){

                @Override
                public int compare(DesignElementConfigurationPair o1, DesignElementConfigurationPair o2) {
                    return o1.getElementName().compareTo(o2.getElementName());
                }
            });
        }
    }

    private static void recursiveCollectDesign(List<IRfDesignElement> modules, Collection<? extends IRfNamedElement> roots, boolean addOnlyVhdlTops) {
        if (roots == null) {
            return;
        }
        for (IRfNamedElement iRfNamedElement : roots) {
            if (!(iRfNamedElement instanceof IRfHDLNamedElement) || addOnlyVhdlTops && iRfNamedElement.getLanguageKind() == LanguageKind.VLOG) continue;
            if (iRfNamedElement instanceof IRfDesignElement && (((IRfDesignElement)iRfNamedElement).getKind() == IRfNamedElement.ElementKind.VHDL_ENTITY || ((IRfDesignElement)iRfNamedElement).getKind() == IRfNamedElement.ElementKind.VHDL_COMPONENT)) {
                List<IRfDesignElement> localConfigsAndArchs = ((IRfHDLNamedElement)iRfNamedElement).getLocalMembers(IRfDesignElement.class);
                if (localConfigsAndArchs == null) continue;
                for (IRfDesignElement localConfigsAndArch : localConfigsAndArchs) {
                    if (localConfigsAndArch.getKind() != IRfNamedElement.ElementKind.VHDL_ARCHITECTURE && localConfigsAndArch.getKind() != IRfNamedElement.ElementKind.VHDL_CONFIGURATION) continue;
                    modules.add(localConfigsAndArch);
                }
                continue;
            }
            List<IRfDesignElement> localModules = ((IRfHDLNamedElement)iRfNamedElement).getLocalMembers(IRfDesignElement.class);
            if (localModules == null) continue;
            ArrayList<IRfDesignElement> toAdd = new ArrayList<IRfDesignElement>();
            for (IRfDesignElement local : localModules) {
                if (local.getKind() == IRfNamedElement.ElementKind.VHDL_COMPONENT || local.getKind() == IRfNamedElement.ElementKind.VHDL_ENTITY) continue;
                toAdd.add(local);
            }
            modules.addAll(toAdd);
            LazyDesignHierarchyViewSelectTopUtils.recursiveCollectDesign(modules, localModules, addOnlyVhdlTops);
        }
    }
}

