/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.designhierarchy;

import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.ui.views.lazy.tree.ElTreeIteratorConfig;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.utils.TreePathUtils;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.AbstractElDesignHierarchyModel;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.ShowInstancesInDHCache;

public class LazyELShowInstancesOfModuleDHModel
extends AbstractElDesignHierarchyModel {
    private IRfNamedElement designElement;
    private ShowInstancesInDHCache instancesCache = new ShowInstancesInDHCache();

    public LazyELShowInstancesOfModuleDHModel(IRfNamedElement designElement) {
        this.designElement = designElement;
    }

    @Override
    public TreePath getElEndTreePath(TreePath treePath, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return null;
        }
        ELManager manager = this.getManager();
        if (manager == null) {
            return null;
        }
        List<ELInstance> instancesOf = manager.getMemory().getInstancesFor(this.designElement, true, Integer.MAX_VALUE);
        ELInstance lastElInstance = instancesOf == null || instancesOf.isEmpty() ? null : instancesOf.get(instancesOf.size() - 1);
        return TreePathUtils.getTreePathFromELInstance(null, lastElInstance, manager, false, monitor);
    }

    @Override
    public TreePath getFirstChildOfPath(TreePath treePath, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return null;
        }
        ELManager manager = this.getManager();
        if (manager == null) {
            return null;
        }
        List<ELInstance> instancesOf = manager.getMemory().getInstancesFor(this.designElement, true, 1);
        ELInstance lastElInstance = instancesOf == null || instancesOf.isEmpty() ? null : instancesOf.get(0);
        TreePath treePathFromELInstance = TreePathUtils.getTreePathFromELInstance(null, lastElInstance, manager, false, monitor);
        if (treePath == TreePath.TOP_DUMMY_TREE_PATH) {
            List<TreePath> allParents = TreePath.parentsList(treePathFromELInstance, false);
            if (allParents == null || allParents.isEmpty()) {
                return treePathFromELInstance;
            }
            return allParents.get(allParents.size() - 1);
        }
        return treePathFromELInstance;
    }

    @Override
    public Map<ElementPath, ELInstance> getElNextInstances(ElementPath elementPath, ELManager manager, ElTreeIteratorConfig elTreeIteratorConfig, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return null;
        }
        return this.instancesCache.getNextFor(this.designElement, elementPath, manager, elTreeIteratorConfig);
    }

    @Override
    public Map<ElementPath, ELInstance> getElPrevInstances(ElementPath elementPath, ELManager manager, ElTreeIteratorConfig elTreeIteratorConfig, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return null;
        }
        return this.instancesCache.getPrevFor(this.designElement, elementPath, manager, elTreeIteratorConfig);
    }

    @Override
    public long getNumberOfElements() {
        ELManager manager = this.getManager();
        if (manager == null) {
            return 0L;
        }
        List<ELInstance> instancesOf = manager.getMemory().getInstancesFor(this.designElement, true, Integer.MAX_VALUE);
        return instancesOf == null || instancesOf.isEmpty() ? 0 : instancesOf.size();
    }

    @Override
    public void resetNumOfElements() {
    }

    public void setModuleTreePath(IRfNamedElement designElement) {
        this.designElement = designElement;
    }

    private ELManager getManager() {
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        RfMixedLangProject mixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false);
        if (mixedLangProject == null) {
            return null;
        }
        return mixedLangProject.getELManager();
    }

    private IProject getProject() {
        if (this.designElement == null) {
            return null;
        }
        IRfSingleLangProject rfProject = this.designElement.getRfProject();
        if (rfProject == null) {
            return null;
        }
        return rfProject.getProject();
    }

    @Override
    public void resetCache() {
        if (this.instancesCache != null) {
            this.instancesCache.reset();
        }
        super.clearModelCaches();
    }

    @Override
    public void clearModelCaches() {
        this.resetCache();
        super.clearModelCaches();
    }
}

