/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.designhierarchy;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.DVTViewManagerCommon;
import ro.amiq.dvt.ui.views.lazy.tree.ElTreeIteratorConfig;
import ro.amiq.dvt.ui.views.lazy.tree.LazyELTrimModel;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.utils.TreePathUtils;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.LazyDHUtils;

public class LazyELTrimDesignHierarchy
extends LazyELTrimModel {
    private long numOfTotalElements = -1L;
    private boolean hasContentFilters;

    public LazyELTrimDesignHierarchy(TreePath topTreePath, IProject project) {
        super(topTreePath, project);
        this.hasContentFilters = project != null && DVTViewManagerCommon.hasGuiFilters(project, ViewSet.ViewName.DESIGN_HIERARCHY);
    }

    @Override
    public TreePath getElEndTreePath(TreePath treePath, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return null;
        }
        ElementPath topTreePathElementPath = TreePathUtils.getElementPathFromTreePath(this.getTopTreePath());
        if (topTreePathElementPath == null) {
            return null;
        }
        IProject project = this.getProject();
        if (project == null || monitor.isCanceled()) {
            return null;
        }
        RfMixedLangProject mixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false);
        if (mixedLangProject == null) {
            return null;
        }
        ELManager manager = mixedLangProject.getELManager();
        if (manager == null) {
            return null;
        }
        Map<ElementPath, ELInstance> directSubInstancesOf = manager.getMemory().subtreeOf(topTreePathElementPath, true);
        if (directSubInstancesOf == null || directSubInstancesOf.isEmpty()) {
            return null;
        }
        Set<Map.Entry<ElementPath, ELInstance>> entrySet = directSubInstancesOf.entrySet();
        if (entrySet == null) {
            return null;
        }
        Iterator<Map.Entry<ElementPath, ELInstance>> iterator = entrySet.iterator();
        if (iterator == null) {
            return null;
        }
        Map.Entry<ElementPath, ELInstance> next = iterator.next();
        if (next == null) {
            return null;
        }
        ELInstance lastElInstance = next.getValue();
        return TreePathUtils.getTreePathFromELInstance(this.getTopTreePath(), lastElInstance, manager, true, monitor);
    }

    @Override
    public TreePath getFirstChildOfPath(TreePath treePath, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return null;
        }
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        RfMixedLangProject mixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false);
        if (mixedLangProject == null) {
            return null;
        }
        ELManager manager = mixedLangProject.getELManager();
        if (manager == null) {
            return null;
        }
        ElementPath topTreePathElementPath = TreePathUtils.getElementPathFromTreePath(this.getTopTreePath());
        if (topTreePathElementPath == null) {
            return null;
        }
        ElementPath elementPath = TreePathUtils.getElementPathFromTreePath(treePath);
        if (treePath == TreePath.TOP_DUMMY_TREE_PATH) {
            return LazyDHUtils.getInstance().computeTreeRootForElab(project, false, true);
        }
        if (!topTreePathElementPath.isPrefixOf(elementPath)) {
            return null;
        }
        Map<ElementPath, ELInstance> nextInstances = this.getElNextInstances(TreePathUtils.getElementPathFromTreePath(treePath), manager, null, monitor);
        if (nextInstances == null || nextInstances.isEmpty()) {
            return null;
        }
        ElementPath next = nextInstances.keySet().iterator().next();
        ELInstance firstElInstance = nextInstances.get(next);
        return TreePathUtils.getTreePathFromELInstance(treePath, firstElInstance, manager, true, monitor);
    }

    @Override
    public Map<ElementPath, ELInstance> getElNextInstances(ElementPath elementPath, ELManager manager, ElTreeIteratorConfig elTreeIteratorConfig, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return null;
        }
        ElementPath topTreePathElementPath = TreePathUtils.getElementPathFromTreePath(this.getTopTreePath());
        if (topTreePathElementPath == null) {
            return null;
        }
        Map<ElementPath, ELInstance> directSubInstancesOf = manager.getMemory().subtreeOf(topTreePathElementPath, true);
        if (directSubInstancesOf == null || directSubInstancesOf.isEmpty()) {
            return null;
        }
        Set<Map.Entry<ElementPath, ELInstance>> entrySet = directSubInstancesOf.entrySet();
        if (entrySet == null) {
            return null;
        }
        Iterator<Map.Entry<ElementPath, ELInstance>> iterator = entrySet.iterator();
        if (iterator == null) {
            return null;
        }
        Map.Entry<ElementPath, ELInstance> next = iterator.next();
        if (next == null) {
            return null;
        }
        ELInstance lastElInstance = next.getValue();
        return manager.getMemory().subMap(elementPath, true, lastElInstance.getHierarchyPath(), true, false);
    }

    @Override
    public Map<ElementPath, ELInstance> getElPrevInstances(ElementPath elementPath, ELManager manager, ElTreeIteratorConfig elTreeIteratorConfig, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return null;
        }
        ElementPath topTreePathElementPath = TreePathUtils.getElementPathFromTreePath(this.getTopTreePath());
        if (topTreePathElementPath == null) {
            return null;
        }
        if (topTreePathElementPath.equals(elementPath)) {
            return null;
        }
        return manager.getMemory().subMap(topTreePathElementPath, true, elementPath, true, true);
    }

    @Override
    public long getNumberOfElements() {
        if (this.numOfTotalElements >= 0L) {
            return this.numOfTotalElements;
        }
        RfMixedLangProject mixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(this.getProject(), false);
        if (mixedLangProject == null) {
            return 0L;
        }
        ELManager manager = mixedLangProject.getELManager();
        if (manager == null) {
            return 0L;
        }
        ElementPath topTreePathElementPath = TreePathUtils.getElementPathFromTreePath(this.getTopTreePath());
        int numOfInstancesInSubtreeOf = manager.getMemory().numOfInstancesInSubtreeOf(topTreePathElementPath);
        if (numOfInstancesInSubtreeOf > 0) {
            ++numOfInstancesInSubtreeOf;
        }
        this.numOfTotalElements = numOfInstancesInSubtreeOf;
        return numOfInstancesInSubtreeOf;
    }

    @Override
    public void resetNumOfElements() {
        this.numOfTotalElements = -1L;
    }

    @Override
    public void clearModelCaches() {
    }
}

