/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.designhierarchy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.DVTViewManagerCommon;
import ro.amiq.dvt.ui.views.lazy.tree.ElTreeIteratorConfig;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.utils.TreePathUtils;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.AbstractElDesignHierarchyModel;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.LazyDHUtils;

public class LazyElDesignHierarchyModel
extends AbstractElDesignHierarchyModel {
    private IProject project;
    private long numOfTotalElements = -1L;
    private boolean hasContentFilters;

    public LazyElDesignHierarchyModel(IProject project) {
        this.project = project;
        this.hasContentFilters = project != null && DVTViewManagerCommon.hasGuiFilters(project, ViewSet.ViewName.DESIGN_HIERARCHY);
    }

    @Override
    public TreePath getElEndTreePath(TreePath treePath, IProgressMonitor monitor) {
        Map<ElementPath, ELInstance> directSubInstancesOf;
        if (this.project == null || monitor.isCanceled()) {
            return null;
        }
        RfMixedLangProject mixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(this.project, false);
        if (mixedLangProject == null) {
            return null;
        }
        ELManager manager = mixedLangProject.getELManager();
        if (manager == null) {
            return null;
        }
        TreePath parentTreePath = treePath;
        if (parentTreePath == TreePath.TOP_DUMMY_TREE_PATH) {
            List<IRfDesignElement> topDesigns = manager.getTopDesigns();
            if (topDesigns == null || topDesigns.isEmpty()) {
                return null;
            }
            parentTreePath = topDesigns.size() == 1 ? LazyDHUtils.getInstance().computeTreeRootForElab(this.project, false, false) : LazyDHUtils.getInstance().computeTreeRootForElab(this.project, true, false);
        }
        if ((directSubInstancesOf = manager.getMemory().subtreeOf(TreePathUtils.getElementPathFromTreePath(parentTreePath), true)) == null || directSubInstancesOf.isEmpty()) {
            return null;
        }
        Set<Map.Entry<ElementPath, ELInstance>> entrySet = directSubInstancesOf.entrySet();
        if (entrySet == null) {
            return null;
        }
        Iterator<Map.Entry<ElementPath, ELInstance>> iterator = entrySet.iterator();
        if (iterator == null) {
            return null;
        }
        Map.Entry<ElementPath, ELInstance> next = iterator.next();
        if (next == null) {
            return null;
        }
        ELInstance lastElInstance = next.getValue();
        return TreePathUtils.getTreePathFromELInstance(null, lastElInstance, manager, false, monitor);
    }

    @Override
    public TreePath getFirstChildOfPath(TreePath treePath, IProgressMonitor monitor) {
        if (this.project == null) {
            return null;
        }
        RfMixedLangProject mixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(this.project, false);
        if (mixedLangProject == null) {
            return null;
        }
        ELManager manager = mixedLangProject.getELManager();
        if (manager == null) {
            return null;
        }
        if (treePath == TreePath.TOP_DUMMY_TREE_PATH) {
            return LazyDHUtils.getInstance().computeTreeRootForElab(this.project, false, false);
        }
        ElementPath elementPathFromTreePath = TreePathUtils.getElementPathFromTreePath(treePath);
        Map<ElementPath, ELInstance> nextInstances = this.getElNextInstances(elementPathFromTreePath, manager, null, monitor);
        if (nextInstances == null || nextInstances.isEmpty()) {
            return null;
        }
        ElementPath next = nextInstances.keySet().iterator().next();
        if (!elementPathFromTreePath.isPrefixOf(next) || next.length() != elementPathFromTreePath.length() + 1) {
            return null;
        }
        ELInstance firstElInstance = nextInstances.get(next);
        return TreePathUtils.getTreePathFromELInstance(treePath, firstElInstance, manager, false, monitor);
    }

    public List<TreePath> getAllChildrenOfPath(TreePath parentPath) {
        if (this.project == null) {
            return null;
        }
        RfMixedLangProject mixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(this.project, false);
        if (mixedLangProject == null) {
            return null;
        }
        ELManager manager = mixedLangProject.getELManager();
        if (manager == null) {
            return null;
        }
        ElementPath elementPath = TreePathUtils.getElementPathFromTreePath(parentPath);
        Map<ElementPath, ELInstance> nextInstances = this.getElNextInstances(elementPath, manager, null, (IProgressMonitor)new NullProgressMonitor());
        if (nextInstances == null || nextInstances.isEmpty()) {
            return null;
        }
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        for (Map.Entry<ElementPath, ELInstance> entry : nextInstances.entrySet()) {
            if (!elementPath.isPrefixOf(entry.getKey()) || entry.getKey().length() != elementPath.length() + 1) continue;
            TreePath childPath = TreePath.of(null, entry.getKey().getSegments(), null);
            childPath.setElement(entry.getValue().getDescription());
            result.add(childPath);
        }
        return result;
    }

    @Override
    public Map<ElementPath, ELInstance> getElNextInstances(ElementPath elementPath, ELManager manager, ElTreeIteratorConfig elTreeIteratorConfig, IProgressMonitor monitor) {
        if (manager == null) {
            return null;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        return manager.getMemory().nextOf(elementPath);
    }

    @Override
    public Map<ElementPath, ELInstance> getElPrevInstances(ElementPath elementPath, ELManager manager, ElTreeIteratorConfig elTreeIteratorConfig, IProgressMonitor monitor) {
        if (manager == null) {
            return null;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        return manager.getMemory().prevOf(elementPath);
    }

    @Override
    public long getNumberOfElements() {
        if (this.numOfTotalElements >= 0L) {
            return this.numOfTotalElements;
        }
        RfMixedLangProject mixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(this.project, false);
        if (mixedLangProject == null) {
            return 0L;
        }
        ELManager manager = mixedLangProject.getELManager();
        if (manager == null) {
            return 0L;
        }
        int numOfInstancesInSubtreeOf = manager.getMemory().numOfInstancesInSubtreeOf(null);
        this.numOfTotalElements = numOfInstancesInSubtreeOf;
        return numOfInstancesInSubtreeOf;
    }

    @Override
    public void resetNumOfElements() {
        this.numOfTotalElements = -1L;
    }
}

