/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.designhierarchy;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.ui.views.lazy.tree.ElTreeIteratorConfig;

public class ShowInstancesInDHCache {
    private static int NUM_OF_ELEMENTS_IN_CACHE = 1000;
    private TreeMap<ElementPath, Boolean> instanesWithParentsCache = new TreeMap();

    public Map<ElementPath, ELInstance> getNextFor(IRfNamedElement module, ElementPath startPath, ELManager manager, ElTreeIteratorConfig elTreeIteratorConfig) {
        if (this.instanesWithParentsCache == null || this.instanesWithParentsCache.isEmpty()) {
            this.instanesWithParentsCache = this.getNextInstancesFor(module, startPath, manager, elTreeIteratorConfig);
        } else {
            ElementPath lastInstanceInCache = this.getLastInstanceOfModuleInCache(this.instanesWithParentsCache);
            ElementPath lastNodeInCache = this.instanesWithParentsCache.descendingKeySet().iterator().next();
            boolean recomputeCache = false;
            if (lastInstanceInCache == null) {
                recomputeCache = true;
            } else if (startPath != null && lastInstanceInCache != null && lastInstanceInCache.compareTo(startPath) <= 0) {
                recomputeCache = true;
            } else if (startPath != null && lastNodeInCache != null && lastNodeInCache.compareTo(lastNodeInCache) <= 0) {
                recomputeCache = true;
            }
            if (recomputeCache) {
                this.instanesWithParentsCache = this.getNextInstancesFor(module, startPath, manager, elTreeIteratorConfig);
            }
        }
        return this.getNextFromMemoryCache(this.instanesWithParentsCache, startPath, manager);
    }

    private ElementPath getLastInstanceOfModuleInCache(TreeMap<ElementPath, Boolean> cache) {
        if (cache == null || cache.isEmpty()) {
            return null;
        }
        for (ElementPath instancePath : cache.descendingKeySet()) {
            Boolean isInstanceOfSelectedModule = cache.get(instancePath);
            if (!isInstanceOfSelectedModule.booleanValue()) continue;
            return instancePath;
        }
        return null;
    }

    private Map<ElementPath, ELInstance> getNextFromMemoryCache(TreeMap<ElementPath, Boolean> cache, ElementPath startPath, ELManager manager) {
        if (cache == null || cache.isEmpty() || manager == null || manager.getMemory() == null) {
            return null;
        }
        IELMemory memory = manager.getMemory();
        TreeMap<ElementPath, ELInstance> result = new TreeMap<ElementPath, ELInstance>();
        for (Map.Entry<ElementPath, Boolean> instanceEntry : cache.entrySet()) {
            ElementPath instance = instanceEntry.getKey();
            if (instance.isPrefixOf(startPath) || instance.equals(startPath) || result.containsKey(instance) || instance.compareTo(startPath) < 0) continue;
            ELInstance instanceElInstance = memory.instanceFor(instance);
            result.put(instance, ELInstance.copyOf(instanceElInstance, instance, false));
        }
        return result;
    }

    public Map<ElementPath, ELInstance> getPrevFor(IRfNamedElement module, ElementPath uptoPath, ELManager manager, ElTreeIteratorConfig elTreeIteratorConfig) {
        if (this.instanesWithParentsCache == null || this.instanesWithParentsCache.isEmpty()) {
            this.instanesWithParentsCache = this.getPrevInstancesFor(module, uptoPath, manager, elTreeIteratorConfig);
        } else {
            ElementPath firstInstanceInCache = this.getFirstInstanceOfModuleInCache(this.instanesWithParentsCache);
            ElementPath firstNodeInCache = this.instanesWithParentsCache.keySet().iterator().next();
            boolean recomputeCache = false;
            if (firstInstanceInCache == null) {
                recomputeCache = true;
            } else if (uptoPath != null && firstInstanceInCache != null && uptoPath.compareTo(firstInstanceInCache) <= 0) {
                recomputeCache = true;
            } else if (uptoPath != null && firstNodeInCache != null && uptoPath.compareTo(firstNodeInCache) <= 0) {
                recomputeCache = true;
            }
            if (recomputeCache) {
                this.instanesWithParentsCache = this.getPrevInstancesFor(module, uptoPath, manager, elTreeIteratorConfig);
            }
        }
        return this.getPrevFromMemoryCache(this.instanesWithParentsCache, uptoPath, manager);
    }

    private ElementPath getFirstInstanceOfModuleInCache(TreeMap<ElementPath, Boolean> cache) {
        if (cache == null || cache.isEmpty()) {
            return null;
        }
        for (Map.Entry<ElementPath, Boolean> entry : cache.entrySet()) {
            Boolean isInstanceOfSelectedModule = entry.getValue();
            if (!isInstanceOfSelectedModule.booleanValue()) continue;
            return entry.getKey();
        }
        return null;
    }

    private Map<ElementPath, ELInstance> getPrevFromMemoryCache(TreeMap<ElementPath, Boolean> cache, ElementPath uptoPath, ELManager manager) {
        TreeMap<ElementPath, ELInstance> result = new TreeMap<ElementPath, ELInstance>();
        IELMemory memory = manager.getMemory();
        for (Map.Entry<ElementPath, Boolean> instanceEntry : cache.entrySet()) {
            ElementPath instance = instanceEntry.getKey();
            if (uptoPath.isPrefixOf(instance) || uptoPath.equals(instance) || result.containsKey(instance) || uptoPath.compareTo(instance) <= 0) continue;
            ELInstance instanceElInstance = memory.instanceFor(instance);
            result.put(instance, ELInstance.copyOf(instanceElInstance, instance, false));
        }
        if (result == null || result.isEmpty()) {
            ElementPath parent = ElementPath.upperPathOf(uptoPath);
            while (parent != null && !parent.isEmpty() && !parent.equals(uptoPath)) {
                ELInstance parentElInstance = memory.instanceFor(parent);
                result.put(parent, ELInstance.copyOf(parentElInstance, parent, false));
                parent = ElementPath.upperPathOf(parent);
            }
        }
        return result.descendingMap();
    }

    private TreeMap<ElementPath, Boolean> getNextInstancesFor(final IRfNamedElement module, final ElementPath startPath, ELManager manager, final ElTreeIteratorConfig elTreeIteratorConfig) {
        if (manager == null) {
            return null;
        }
        IELMemory memory = manager.getMemory();
        if (module == null || !memory.hasBindings()) {
            return null;
        }
        final TreeMap<ElementPath, Boolean> result = new TreeMap<ElementPath, Boolean>();
        final boolean isVHDLComponent = DesignUtils.getDesignKind(module) == IRfNamedElement.ElementKind.VHDL_COMPONENT;
        final AtomicBoolean addToResult = new AtomicBoolean(false);
        IELMemory.IELMemoryVisitor visitor = new IELMemory.IELMemoryVisitor(){

            @Override
            public boolean visitBindings(ElementPath path, ELInstance instance) {
                if (path.equals(startPath)) {
                    addToResult.set(true);
                    return true;
                }
                if (!addToResult.get()) {
                    return true;
                }
                if (isVHDLComponent) {
                    IRfInstanceElement description = instance.getDescription();
                    if (description != null && description.getVHDLPreElaborationDesign() == module) {
                        ElementPath parent = ElementPath.upperPathOf(path);
                        while (parent != null && !parent.isEmpty() && !parent.equals(path)) {
                            boolean isCollapsed;
                            boolean bl = isCollapsed = elTreeIteratorConfig != null && elTreeIteratorConfig.isSkipCollapsed() && elTreeIteratorConfig.isPrevPathCollapsed() && startPath.isPrefixOf(parent);
                            if (isCollapsed || result.containsKey(parent)) {
                                parent = ElementPath.upperPathOf(parent);
                                continue;
                            }
                            result.put(parent, false);
                            parent = ElementPath.upperPathOf(parent);
                        }
                        if (elTreeIteratorConfig != null && elTreeIteratorConfig.isSkipCollapsed() && elTreeIteratorConfig.isPrevPathCollapsed() && startPath.isPrefixOf(path)) {
                            return result.size() < NUM_OF_ELEMENTS_IN_CACHE;
                        }
                        result.put(path, true);
                    }
                    return result.size() < NUM_OF_ELEMENTS_IN_CACHE;
                }
                IRfNamedElement currInstanceBinding = instance.getBinding(true);
                if (currInstanceBinding == module) {
                    ElementPath parent = ElementPath.upperPathOf(path);
                    while (parent != null && !parent.isEmpty() && !parent.equals(path)) {
                        boolean isCollapsed;
                        boolean bl = isCollapsed = elTreeIteratorConfig != null && elTreeIteratorConfig.isSkipCollapsed() && elTreeIteratorConfig.isPrevPathCollapsed() && startPath.isPrefixOf(parent);
                        if (isCollapsed || result.containsKey(parent)) {
                            parent = ElementPath.upperPathOf(parent);
                            continue;
                        }
                        result.put(parent, false);
                        parent = ElementPath.upperPathOf(parent);
                    }
                    if (elTreeIteratorConfig != null && elTreeIteratorConfig.isSkipCollapsed() && elTreeIteratorConfig.isPrevPathCollapsed() && startPath.isPrefixOf(path)) {
                        return result.size() < NUM_OF_ELEMENTS_IN_CACHE;
                    }
                    result.put(path, true);
                }
                return result.size() < NUM_OF_ELEMENTS_IN_CACHE;
            }
        };
        memory.visitBindings(visitor);
        return result;
    }

    private TreeMap<ElementPath, Boolean> getPrevInstancesFor(final IRfNamedElement module, final ElementPath upToPath, ELManager manager, final ElTreeIteratorConfig elTreeIteratorConfig) {
        if (manager == null) {
            return null;
        }
        IELMemory memory = manager.getMemory();
        if (module == null || !memory.hasBindings()) {
            return null;
        }
        final TreeMap<ElementPath, Boolean> result = new TreeMap<ElementPath, Boolean>();
        final boolean isVHDLComponent = DesignUtils.getDesignKind(module) == IRfNamedElement.ElementKind.VHDL_COMPONENT;
        ElementPath parent = ElementPath.upperPathOf(upToPath);
        while (parent != null && !parent.isEmpty() && !parent.equals(upToPath)) {
            boolean isCollapsed;
            boolean bl = isCollapsed = elTreeIteratorConfig != null && elTreeIteratorConfig.hasCollapsedParents(parent);
            if (isCollapsed || result.containsKey(parent)) {
                parent = ElementPath.upperPathOf(parent);
                continue;
            }
            result.put(parent, false);
            parent = ElementPath.upperPathOf(parent);
        }
        final AtomicBoolean addToResult = new AtomicBoolean(false);
        IELMemory.IELMemoryVisitor visitor = new IELMemory.IELMemoryVisitor(){

            @Override
            public boolean visitBindings(ElementPath path, ELInstance instance) {
                if (path.equals(upToPath)) {
                    addToResult.set(true);
                }
                if (!addToResult.get()) {
                    return true;
                }
                if (isVHDLComponent) {
                    IRfInstanceElement description = instance.getDescription();
                    if (description != null && description.getVHDLPreElaborationDesign() == module) {
                        ElementPath parent = ElementPath.upperPathOf(path);
                        boolean isCollapsed = parent != null && !parent.isEmpty() && !parent.equals(path);
                        while (isCollapsed || result.containsKey(parent)) {
                            if (elTreeIteratorConfig != null && elTreeIteratorConfig.hasCollapsedParents(parent)) {
                                parent = ElementPath.upperPathOf(parent);
                                continue;
                            }
                            result.put(parent, false);
                            parent = ElementPath.upperPathOf(parent);
                        }
                        if (elTreeIteratorConfig != null && elTreeIteratorConfig.hasCollapsedParents(path)) {
                            return result.size() < NUM_OF_ELEMENTS_IN_CACHE;
                        }
                        result.put(path, true);
                    }
                    return result.size() < NUM_OF_ELEMENTS_IN_CACHE;
                }
                IRfNamedElement currInstanceBinding = instance.getBinding(true);
                if (currInstanceBinding == module) {
                    ElementPath parent = ElementPath.upperPathOf(path);
                    while (parent != null && !parent.isEmpty() && !parent.equals(path)) {
                        boolean isCollapsed;
                        boolean bl = isCollapsed = elTreeIteratorConfig != null && elTreeIteratorConfig.hasCollapsedParents(parent);
                        if (isCollapsed || result.containsKey(parent)) {
                            parent = ElementPath.upperPathOf(parent);
                            continue;
                        }
                        result.put(parent, false);
                        parent = ElementPath.upperPathOf(parent);
                    }
                    if (elTreeIteratorConfig != null && elTreeIteratorConfig.hasCollapsedParents(path)) {
                        return result.size() < NUM_OF_ELEMENTS_IN_CACHE;
                    }
                    result.put(path, true);
                }
                return result.size() < NUM_OF_ELEMENTS_IN_CACHE;
            }
        };
        memory.visitBindingsReverseOrder(visitor);
        return result;
    }

    public void reset() {
        if (this.instanesWithParentsCache != null) {
            this.instanesWithParentsCache.clear();
        }
        this.instanesWithParentsCache = null;
    }
}

