/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.designhierarchy;

import java.util.List;
import org.eclipse.ui.IViewPart;
import ro.amiq.dvt.startup.core.EclipseUtils;
import ro.amiq.dvt.ui.views.ViewsUtils;

public enum SwitchToNewViews {
    INSTANCE;

    public static final String TERMINALS_VIEW_OLD_ID = "org.eclipse.tm.terminal.view.ui.TerminalsView";
    public static final String TERMINALS_VIEW_NEW_ID = "org.eclipse.terminal.view.ui.TerminalsView";

    public void start() {
        this.switchToNewView(false, "ro.amiq.dvt.ui.views.LazyDesignHierarchyView", "ro.amiq.dvt.ui.views.DesignHierarchyView");
        if (ViewsUtils.getViewById("ro.amiq.dvt.ui.views.LazyCompileOrderView", false) != null) {
            ViewsUtils.closeViewById("ro.amiq.dvt.ui.views.LazyCompileOrderView");
            ViewsUtils.showViewById("ro.amiq.dvt.ui.views.CompileOrderView");
        }
        if (ViewsUtils.getViewById("ro.amiq.dvt.ui.views.LazyTypesView", false) != null) {
            ViewsUtils.closeViewById("ro.amiq.dvt.ui.views.LazyTypesView");
            ViewsUtils.showViewById("ro.amiq.dvt.ui.views.TypesView");
        }
        if (ViewsUtils.getViewById("ro.amiq.dvt.ui.views.LazyMacrosView", false) != null) {
            ViewsUtils.closeViewById("ro.amiq.dvt.ui.views.LazyMacrosView");
            ViewsUtils.showViewById("ro.amiq.dvt.ui.views.MacrosView");
        }
        this.switchTerminalsView();
    }

    private void switchTerminalsView() {
        if (EclipseUtils.isAtLeastEclipse437()) {
            List<IViewPart> oldTerminalViews = ViewsUtils.findViewsContainingId(TERMINALS_VIEW_OLD_ID);
            if (oldTerminalViews == null || oldTerminalViews.isEmpty()) {
                return;
            }
            for (IViewPart view : oldTerminalViews) {
                ViewsUtils.closeView(view);
            }
            ViewsUtils.showViewById(TERMINALS_VIEW_NEW_ID);
        } else {
            List<IViewPart> newTerminalViews = ViewsUtils.findViewsContainingId(TERMINALS_VIEW_NEW_ID);
            if (newTerminalViews == null || newTerminalViews.isEmpty()) {
                return;
            }
            for (IViewPart view : newTerminalViews) {
                ViewsUtils.closeView(view);
            }
            ViewsUtils.showViewById(TERMINALS_VIEW_OLD_ID);
        }
    }

    void switchToNewView(boolean isViewSwitchToOldMode, String newViewId, String oldViewId) {
        if (isViewSwitchToOldMode) {
            return;
        }
        IViewPart newView = ViewsUtils.getViewById(newViewId, false);
        IViewPart oldView = ViewsUtils.getViewById(oldViewId, false);
        if (newView == null && oldView == null) {
            return;
        }
        if (newView != null && oldView != null) {
            return;
        }
        if (newView != null) {
            return;
        }
        ViewsUtils.closeViewById(oldViewId);
        ViewsUtils.showViewById(newViewId);
    }
}

