/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.macros;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension2.DummyElement;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.DVTLanguageElement;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.DVTViewContributors;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.lazy.tree.DVTModelEvent;
import ro.amiq.dvt.ui.views.lazy.tree.DVTModelEventType;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTModelStateListener;
import ro.amiq.dvt.ui.views.lazy.tree.IModel;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.views.macros.IMacrosViewContributor;
import ro.amiq.dvt.ui.views.lazy.views.macros.MacrosWrapper;

public class MacrosModel
implements IModel {
    public static final Comparator<TreePath> comparator = new Comparator<TreePath>(){

        @Override
        public int compare(TreePath o1, TreePath o2) {
            if (o1 == null || o2 == null || o1.equals(o2)) {
                return 0;
            }
            if (TreePath.isParent(o1, o2)) {
                return -1;
            }
            if (TreePath.isParent(o2, o1)) {
                return 1;
            }
            int[] inds1 = o1.getIndices();
            int[] inds2 = o2.getIndices();
            int i = 0;
            while (i < Math.min(inds1.length, inds2.length)) {
                if (inds1[i] != inds2[i]) {
                    return inds1[i] - inds2[i];
                }
                ++i;
            }
            Object wr1 = o1.getElement();
            Object wr2 = o2.getElement();
            if (wr1 instanceof DVTLanguageElement && wr2 instanceof DVTLanguageElement) {
                return ((DVTLanguageElement)wr1).getKind().compareTo(((DVTLanguageElement)wr2).getKind());
            }
            if (wr1 instanceof IRfNamedElement && wr2 instanceof IRfNamedElement) {
                String name1 = ((IRfNamedElement)wr1).getName();
                String name2 = ((IRfNamedElement)wr2).getName();
                if (o1.getParent().equals(o2.getParent()) && name1.equals(name2)) {
                    return o1.getIndexInParent() - o2.getIndexInParent();
                }
                return name1.compareTo(name2);
            }
            return -1;
        }
    };
    private IProject project;
    private boolean hasGUIFilteredElements;
    private boolean hasMacrosFilteredElements;
    private boolean hasSearchedElementFiltered;
    private List<IMacrosViewContributor> allMacrosContibutors = DVTViewContributors.getInstance().getAllInstanceOf(IMacrosViewContributor.class);
    private IRfFilterableTreeAccessor macrosView;
    private DVTBaseLabelProvider labelProvider;
    List<MacrosWrapper> allMacroWrappers = new ArrayList<MacrosWrapper>();
    private int nofMacroTotal;
    private int nofNotFilteredTotal;
    private int nofReplMacro;
    private int nofConfigUndefMacro;
    private int nofConfigDefinedMacro;
    private int nofIfndefGuard;
    private List<IDVTModelStateListener> fStateListeners;

    public MacrosModel(IProject project, DVTBaseLabelProvider labelProvider, IRfFilterableTreeAccessor macrosView) {
        this.project = project;
        this.labelProvider = labelProvider;
        this.nofMacroTotal = 0;
        this.nofNotFilteredTotal = 0;
        this.macrosView = macrosView;
        this.fStateListeners = new ArrayList<IDVTModelStateListener>();
    }

    private synchronized void computeElements(IProject project, IProgressMonitor monitor) {
        if (!this.allMacroWrappers.isEmpty()) {
            return;
        }
        this.nofMacroTotal = 0;
        this.nofNotFilteredTotal = 0;
        this.nofReplMacro = 0;
        this.nofConfigUndefMacro = 0;
        this.nofConfigDefinedMacro = 0;
        this.nofIfndefGuard = 0;
        this.hasGUIFilteredElements = false;
        this.hasSearchedElementFiltered = false;
        for (IMacrosViewContributor contributor : this.allMacrosContibutors) {
            if (monitor.isCanceled()) {
                this.notifyStateListeners(new DVTModelEvent(DVTModelEventType.MODEL_COMPUTING_CANCELED));
                return;
            }
            MacrosWrapper languageWrapper = contributor.getLanguageMacrosWrapper(project, this.macrosView, monitor);
            if (languageWrapper.getAllMacrosByCategory().isEmpty() || languageWrapper.getLanguageElement().getInfo().isEmpty()) {
                this.hasGUIFilteredElements = this.hasGUIFilteredElements || languageWrapper.hasGUIFilteredElements();
                this.hasSearchedElementFiltered = this.hasSearchedElementFiltered || languageWrapper.hasSearchedElementFiltered();
                continue;
            }
            boolean duplicateLanguageElement = this.computeDuplicateLanguageElement(languageWrapper);
            if (!duplicateLanguageElement) {
                this.allMacroWrappers.add(languageWrapper);
            }
            this.nofMacroTotal += languageWrapper.getNofMacros();
            this.nofNotFilteredTotal += languageWrapper.getNofMacros();
            this.nofReplMacro += languageWrapper.getNofReplMacro();
            this.nofConfigUndefMacro += languageWrapper.getNofConfigUndefMacro();
            this.nofConfigDefinedMacro += languageWrapper.getNofConfigDefinedMacro();
            this.nofIfndefGuard += languageWrapper.getNofIfndefGuard();
            this.hasGUIFilteredElements = this.hasGUIFilteredElements || languageWrapper.hasGUIFilteredElements();
            this.hasSearchedElementFiltered = this.hasSearchedElementFiltered || languageWrapper.hasSearchedElementFiltered();
            LinkedHashMap<IRfNamedElement, List<Object>> allMacrosByCategory = languageWrapper.getAllMacrosByCategory();
            if (allMacrosByCategory == null) continue;
            ArrayList<IRfNamedElement> categoryList = new ArrayList<IRfNamedElement>(allMacrosByCategory.keySet());
            for (IRfNamedElement key : categoryList) {
                if (!this.shouldFilter(key)) continue;
                this.nofNotFilteredTotal -= languageWrapper.getAllMacrosByCategory().get(key).size();
            }
        }
        this.notifyStateListeners(new DVTModelEvent(DVTModelEventType.MODEL_COMPUTING_DONE));
    }

    private boolean computeDuplicateLanguageElement(MacrosWrapper newLanguageWrapper) {
        for (MacrosWrapper existentMacroWrapper : this.allMacroWrappers) {
            DVTLanguageElement<String> languageElement = newLanguageWrapper.getLanguageElement();
            DVTLanguageElement<String> wrapperLanguageElement = existentMacroWrapper.getLanguageElement();
            if (wrapperLanguageElement == null || !wrapperLanguageElement.getClass().equals(languageElement.getClass())) continue;
            LinkedHashMap<IRfNamedElement, List<Object>> allMacrosByCategory = newLanguageWrapper.getAllMacrosByCategory();
            existentMacroWrapper.addMacros(allMacrosByCategory);
            return true;
        }
        return false;
    }

    @Override
    public List<TreePath> getChildren(TreePath treePath, int childStartIndex, int childEndIndex, IProgressMonitor monitor) {
        return this.getChildrenInternal(treePath, childStartIndex, childEndIndex, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TreePath> getChildrenInternal(TreePath treePath, int startChunkIndex, int endChunkIndex, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        if (this.project == null || treePath == null) {
            return Collections.emptyList();
        }
        MacrosModel macrosModel = this;
        synchronized (macrosModel) {
            if (this.allMacroWrappers == null || this.allMacroWrappers.isEmpty()) {
                this.computeElements(this.project, monitor);
            }
        }
        if (this.allMacroWrappers == null || this.allMacroWrappers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        if (startChunkIndex < 0 || endChunkIndex < 0) {
            return Collections.emptyList();
        }
        Object element = treePath.getElement();
        List<Object> macrosList = null;
        ArrayList<Object> categoriesList = new ArrayList<Object>();
        if (treePath == TreePath.TOP_DUMMY_TREE_PATH) {
            if (ViewsUtils.hasMoreThanOneDVTNature(this.project)) {
                return this.computeResultForLanguageElements(treePath);
            }
            for (MacrosWrapper macroWrapper : this.allMacroWrappers) {
                LinkedHashMap<IRfNamedElement, List<Object>> macrosByCategoryMap = macroWrapper.getAllMacrosByCategory();
                if (macrosByCategoryMap == null || macrosByCategoryMap.isEmpty()) continue;
                macrosList = this.addCategoriesToMacrosList(categoriesList, macrosByCategoryMap);
                break;
            }
        } else if (element instanceof DVTLanguageElement) {
            for (MacrosWrapper macroWrapper : this.allMacroWrappers) {
                if (!macroWrapper.getLanguageElement().getInfo().equals(((DVTLanguageElement)element).getInfo())) continue;
                macrosList = this.addCategoriesToMacrosList(categoriesList, macroWrapper.getAllMacrosByCategory());
                break;
            }
        } else {
            block5: for (MacrosWrapper macroWrapper : this.allMacroWrappers) {
                Set<IRfNamedElement> categoriesByLanguage;
                LinkedHashMap<IRfNamedElement, List<Object>> macrosInCurrentLanguage = macroWrapper.getAllMacrosByCategory();
                if (macrosInCurrentLanguage == null || macrosInCurrentLanguage.isEmpty() || (categoriesByLanguage = macrosInCurrentLanguage.keySet()) == null || categoriesByLanguage.isEmpty() || !this.isCategory(treePath, categoriesByLanguage)) continue;
                categoriesList.addAll(categoriesByLanguage);
                String treePathName = element instanceof DummyElement ? ((DummyElement)element).getName() : ((IRfNamedElement)element).getName();
                for (IRfNamedElement category : categoriesByLanguage) {
                    if (!category.getName().equals(treePathName)) continue;
                    macrosList = macrosInCurrentLanguage.get(category);
                    continue block5;
                }
            }
        }
        if (macrosList == null) {
            return null;
        }
        int i = startChunkIndex;
        while (i < Math.min(endChunkIndex, macrosList.size())) {
            TreePath prevChild;
            if (monitor.isCanceled()) {
                return result;
            }
            Object dvtElementWrapper = macrosList.get(i);
            String text = categoriesList.contains(dvtElementWrapper) ? ((IRfNamedElement)dvtElementWrapper).getName() : this.labelProvider.getText(dvtElementWrapper);
            TreePath child = TreePath.child(treePath, text, i, comparator);
            child.setElement(dvtElementWrapper);
            TreePath treePath2 = prevChild = result.isEmpty() ? null : (TreePath)result.get(result.size() - 1);
            if (child.equals(prevChild, true)) {
                child.append("@(" + i + ")@");
            }
            result.add(child);
            ++i;
        }
        return result;
    }

    private boolean isCategory(TreePath treePath, Set<IRfNamedElement> categories) {
        Object element = treePath.getElement();
        if (!(element instanceof IRfNamedElement) && !(element instanceof DummyElement)) {
            return false;
        }
        String categoryName = element instanceof DummyElement ? ((DummyElement)element).getName() : ((IRfNamedElement)element).getName();
        for (IRfNamedElement category : categories) {
            if (!category.getName().equals(categoryName) || !category.getClass().equals(element.getClass())) continue;
            return true;
        }
        return false;
    }

    private List<Object> addCategoriesToMacrosList(List<Object> categoriesList, LinkedHashMap<IRfNamedElement, List<Object>> macrosByCategoryMap) {
        ArrayList<Object> macrosList = new ArrayList<Object>();
        if (macrosByCategoryMap == null || macrosByCategoryMap.isEmpty()) {
            return macrosList;
        }
        for (Map.Entry<IRfNamedElement, List<Object>> entrySet : macrosByCategoryMap.entrySet()) {
            IRfNamedElement key = entrySet.getKey();
            if (key instanceof DummyElement) {
                return macrosByCategoryMap.get(key);
            }
            if (this.shouldFilter(key) || macrosByCategoryMap.get(key) == null || macrosByCategoryMap.get(key).isEmpty()) continue;
            categoriesList.add(key);
            macrosList.add(key);
        }
        return macrosList;
    }

    private List<TreePath> computeResultForLanguageElements(TreePath treePath) {
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        int index = 0;
        for (MacrosWrapper macroWrapper : this.allMacroWrappers) {
            TreePath prevChild;
            if (macroWrapper.isEmpty() || this.hasAllCategoriesFiltered(macroWrapper)) continue;
            DVTLanguageElement<String> languageElement = macroWrapper.getLanguageElement();
            String text = this.labelProvider.getText(languageElement);
            TreePath child = TreePath.child(treePath, text, index, comparator);
            child.setElement(languageElement);
            TreePath treePath2 = prevChild = result.isEmpty() ? null : (TreePath)result.get(result.size() - 1);
            if (child.equals(prevChild, true)) {
                child.append("@(" + index + ")@");
            }
            ++index;
            result.add(child);
        }
        return result;
    }

    private boolean hasAllCategoriesFiltered(MacrosWrapper macroWrapper) {
        LinkedHashMap<IRfNamedElement, List<Object>> allMacrosByCategory = macroWrapper.getAllMacrosByCategory();
        if (allMacrosByCategory == null) {
            return true;
        }
        for (IRfNamedElement category : allMacrosByCategory.keySet()) {
            if (this.shouldFilter(category)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Boolean hasChildren(TreePath treePath, IProgressMonitor monitor) {
        List<TreePath> children = this.getChildrenInternal(treePath, 0, 1, monitor);
        if (children != null && !children.isEmpty()) {
            return true;
        }
        return false;
    }

    @Override
    public TreePath getLastChild(TreePath path, IProgressMonitor monitor) {
        List<TreePath> children = this.getChildrenInternal(path, 0, Integer.MAX_VALUE, monitor);
        return children == null || children.isEmpty() ? null : children.get(children.size() - 1);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public TreePath getEndTreePath(TreePath path, IProgressMonitor monitor) {
        currentPath = path;
        children = this.getChildrenInternal(currentPath, 0, 0x7FFFFFFF, monitor);
        if (children != null && !children.isEmpty()) ** GOTO lbl7
        return currentPath;
lbl-1000:
        // 1 sources

        {
            currentPath = children.get(children.size() - 1);
            children = this.getChildrenInternal(currentPath, 0, 0x7FFFFFFF, monitor);
lbl7:
            // 2 sources

            ** while (children != null && !children.isEmpty())
        }
lbl8:
        // 1 sources

        return currentPath;
    }

    @Override
    public void resetModel(IProgressMonitor monitor) {
        if (this.allMacroWrappers != null) {
            this.allMacroWrappers.clear();
        }
    }

    private boolean shouldFilter(IRfNamedElement macrosKey) {
        if (macrosKey.getName().equals("Ifndef Guards") && PrefConst.getMacrosViewVlogdtHideIfndefGuardsLazy()) {
            this.hasMacrosFilteredElements = true;
            return true;
        }
        if (macrosKey.getName().equals("If(n)def Controls") && PrefConst.getMacrosViewVlogdtHideConfigUnDefinedLazy()) {
            this.hasMacrosFilteredElements = true;
            return true;
        }
        if (macrosKey.getName().equals("Defines") && PrefConst.getMacrosViewVlogdtHideReplacementLazy()) {
            this.hasMacrosFilteredElements = true;
            return true;
        }
        return false;
    }

    public boolean hasGUIFilteredElements() {
        return this.hasGUIFilteredElements;
    }

    public boolean hasMacrosFilteredElements() {
        return this.hasMacrosFilteredElements;
    }

    public boolean hasSearchedElementFiltered() {
        return this.hasSearchedElementFiltered;
    }

    public int getNofMacroTotal() {
        return this.nofMacroTotal;
    }

    public int getNofNotFilteredTotal() {
        return this.nofNotFilteredTotal;
    }

    public int getNofReplMacro() {
        return this.nofReplMacro;
    }

    public int getNofConfigUndefMacro() {
        return this.nofConfigUndefMacro;
    }

    public int getNofConfigDefinedMacro() {
        return this.nofConfigDefinedMacro;
    }

    public int getNofIfndefGuard() {
        return this.nofIfndefGuard;
    }

    public void clearElements() {
        for (MacrosWrapper macroWrapper : this.allMacroWrappers) {
            macroWrapper.clearMacros();
        }
        this.hasMacrosFilteredElements = false;
        this.allMacroWrappers.clear();
    }

    @Override
    public void clearModelCaches() {
        this.clearElements();
    }

    public List<Object> testGetRoots() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (MacrosWrapper macroWrapper : this.allMacroWrappers) {
            Set<IRfNamedElement> keySet;
            LinkedHashMap<IRfNamedElement, List<Object>> allMacrosByCategory;
            boolean hasMacros = false;
            DVTTreeElementWrapper wrapper = null;
            if (ViewsUtils.hasMoreThanOneDVTNature(this.project)) {
                DVTLanguageElement<String> languageElement = macroWrapper.getLanguageElement();
                wrapper = new DVTTreeElementWrapper(languageElement);
            }
            if ((allMacrosByCategory = macroWrapper.getAllMacrosByCategory()) == null || (keySet = allMacrosByCategory.keySet()) == null) continue;
            for (IRfNamedElement category : keySet) {
                List<Object> macrosList;
                if (this.shouldFilter(category) || (macrosList = allMacrosByCategory.get(category)).isEmpty()) continue;
                hasMacros = true;
                DVTTreeElementWrapper categoryWrapper = new DVTTreeElementWrapper(category);
                categoryWrapper.addChildren(macrosList.stream().map(macro -> new DVTTreeElementWrapper(macro)).collect(Collectors.toList()));
                if (wrapper == null) {
                    result.add(categoryWrapper);
                    continue;
                }
                ((IDVTElementWrapper)wrapper).addChild(categoryWrapper);
            }
            if (wrapper == null || !hasMacros) continue;
            result.add(wrapper);
        }
        return result;
    }

    public void addStateListener(IDVTModelStateListener l) {
        this.fStateListeners.add(l);
    }

    @Override
    public void notifyStateListeners(DVTModelEvent event) {
        if (this.fStateListeners == null) {
            return;
        }
        for (IDVTModelStateListener l : this.fStateListeners) {
            l.stateChanged(event);
        }
    }

    public void clearStateListeners() {
        if (this.fStateListeners == null) {
            return;
        }
        this.fStateListeners.clear();
    }
}

