/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.macros;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.startup.core.EclipseUtils;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.projectcolors.ProjectColorUtils;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.DVTLabelProviderProxy;
import ro.amiq.dvt.ui.views.TextFilterObject;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.inspect.InspectViewSelectionListener;
import ro.amiq.dvt.ui.views.lazy.tree.DVTModelEventType;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTLazyTable;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTModel;
import ro.amiq.dvt.ui.views.lazy.tree.IModel;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeIteratorType;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeMessageCompositeType;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeAction;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSearchActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeUpdateViewActionArguments;
import ro.amiq.dvt.ui.views.lazy.views.CollapseAllAction;
import ro.amiq.dvt.ui.views.lazy.views.ExpandAllAction;
import ro.amiq.dvt.ui.views.lazy.views.macros.CDTMacroWrapper;
import ro.amiq.dvt.ui.views.lazy.views.macros.IMacrosViewContributor;
import ro.amiq.dvt.ui.views.lazy.views.macros.MacrosModel;
import ro.amiq.dvt.ui.views.lazy.views.macros.MacrosViewCommon;
import ro.amiq.dvt.ui.views.lazy.views.macros.MacrosViewTestUtils;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.Utils;

public class MacrosView
extends MacrosViewCommon
implements IDVTLazyTable {
    public static final String FILTER_BY_NAME = "Filter by: name";
    DVTLabelProviderProxy<IMacrosViewContributor> labelProvider = new DVTLabelProviderProxy<IMacrosViewContributor>(IMacrosViewContributor.class, "default-tree");
    private final MacrosViewTestUtils lazyTreeTestUtils = new MacrosViewTestUtils(this);
    private Composite controlParent;
    private Label contentFiltersLabel;
    private Label labelInfo;
    private FilterAction filtersAction;
    private Action cancelAction;
    private MacrosModel lazyMacrosModel;
    public int nofReplMacro;
    public int nofConfigUndefMacro;
    public int nofConfigDefinedMacro;
    public int nofIfndefGuard;
    private boolean hasGUIFilteredElements;
    private boolean hasSearchedElementFiltered;
    private Image contentFiltersEnabledIcon = DVTImages.imageCache.getImage(DVTImages.GUI_FILTERS_ICON_MINI);
    private Image contentFiltersDisabledIcon = DVTImages.imageCache.getImage(DVTImages.GUI_FILTERS_ICON_MINI_DISABLED);
    protected boolean modelComputingCanceled;

    @Override
    public void update(BuildEvents updateEvent) {
        IProject project = this.getProject();
        if (project == null || !project.isAccessible()) {
            this.clean();
            return;
        }
        LazyTree lazyTree = this.getLazyTree();
        if (lazyTree == null) {
            return;
        }
        boolean resetSelection = updateEvent == null;
        boolean resetModel = updateEvent == null || updateEvent == BuildEvents.FULL_BUILD || updateEvent == BuildEvents.INCREMENTAL_BUILD || updateEvent == BuildEvents.GUI_FILTERS_PROJECT || updateEvent == BuildEvents.GUI_FILTERS_WORKSPACE;
        boolean resetTop = updateEvent == null || updateEvent != BuildEvents.INCREMENTAL_BUILD;
        this.hasGUIFilteredElements = false;
        this.hasSearchedElementFiltered = false;
        ProjectColorUtils.setFgBg(this, this.getProject().getName());
        if (this.lazyMacrosModel == null || resetSelection || resetModel) {
            if (this.lazyMacrosModel != null) {
                this.lazyMacrosModel.clearStateListeners();
            }
            this.lazyMacrosModel = new MacrosModel(this.getProject(), (DVTBaseLabelProvider)this.getLabelProvider(), this);
            this.lazyMacrosModel.addStateListener(event -> {
                if (event.getEventType() == DVTModelEventType.MODEL_COMPUTING_CANCELED) {
                    this.modelComputingCanceled = true;
                }
                if (event.getEventType() == DVTModelEventType.MODEL_COMPUTING_DONE) {
                    this.modelComputingCanceled = false;
                    this.updateLabelInfo(this.labelInfo);
                }
            });
        }
        lazyTree.doAction(LazyTreeAction.UPDATE_VIEW, new LazyTreeUpdateViewActionArguments(this, this.lazyMacrosModel, resetSelection, resetTop, false, Objection.MACROS));
    }

    @Override
    public void clean() {
        try {
            IProject project = this.getProject();
            if (project == null || !project.isAccessible() || !Utils.hasDvtNature(project)) {
                this.labelInfo.setText(LazyTreeMessageCompositeType.NO_DVT_PROJECT_SELECTED.getMessage());
                ProjectColorUtils.setFgBg(this, null);
                this.contentFiltersLabel.setEnabled(false);
            } else {
                this.labelInfo.setText("[" + project.getName() + "]");
                ProjectColorUtils.setFgBg(this, project.getName());
                if (EclipseUtils.isAtLeastEclipse419()) {
                    this.contentFiltersLabel.setImage(this.hasGUIFilteredElements ? this.contentFiltersEnabledIcon : this.contentFiltersDisabledIcon);
                }
                this.contentFiltersLabel.setEnabled(this.hasGUIFilteredElements);
            }
            if (this.getLazyTree() != null) {
                this.getLazyTree().doAction(LazyTreeAction.CLEAN, new LazyTreeActionArguments(Objection.MACROS));
            }
            if (this.lazyMacrosModel != null) {
                this.lazyMacrosModel.clearElements();
                this.lazyMacrosModel.clearStateListeners();
            }
            this.lazyMacrosModel = null;
        }
        finally {
            if (TestHelper.isTestMode()) {
                ObjectionManager.getInstance().clear(Objection.MACRO_LABEL);
            }
        }
    }

    private void updateLabelInfo(Label label) {
        Display display = Display.getDefault();
        display.asyncExec(() -> {
            try {
                if (label == null || label.isDisposed()) {
                    return;
                }
                IProject project = this.getProject();
                if (project == null || !project.isAccessible()) {
                    label.setText("[no DVT Project or file selected]");
                    return;
                }
                String labelText = "[" + project.getName() + "]";
                StringMatcher[] searchSegments = this.getTreeSearchSegments();
                if (searchSegments.length == 0 && this.lazyMacrosModel != null) {
                    this.nofReplMacro = this.lazyMacrosModel.getNofReplMacro();
                    this.nofConfigUndefMacro = this.lazyMacrosModel.getNofConfigUndefMacro();
                    this.nofConfigDefinedMacro = this.lazyMacrosModel.getNofConfigDefinedMacro();
                    this.nofIfndefGuard = this.lazyMacrosModel.getNofIfndefGuard();
                    int fNofMacroTotal = this.lazyMacrosModel.getNofMacroTotal();
                    int fNofNotFilteredTotal = this.lazyMacrosModel.getNofNotFilteredTotal();
                    labelText = String.valueOf(labelText) + "[" + (fNofNotFilteredTotal != fNofMacroTotal ? String.valueOf(fNofNotFilteredTotal) + "/" + fNofMacroTotal : Integer.valueOf(fNofMacroTotal)) + ViewsUtils.getUnitName("macro", fNofMacroTotal, " ", "") + "]";
                }
                this.hasGUIFilteredElements = this.hasGUIFilteredElements || this.lazyMacrosModel != null && this.lazyMacrosModel.hasGUIFilteredElements();
                boolean bl = this.hasSearchedElementFiltered = this.hasSearchedElementFiltered || this.lazyMacrosModel != null && this.lazyMacrosModel.hasSearchedElementFiltered();
                if (EclipseUtils.isAtLeastEclipse419()) {
                    this.contentFiltersLabel.setImage(this.hasGUIFilteredElements ? this.contentFiltersEnabledIcon : this.contentFiltersDisabledIcon);
                }
                this.contentFiltersLabel.setEnabled(this.hasGUIFilteredElements);
                this.labelInfo.setText(labelText);
            }
            finally {
                if (TestHelper.isTestMode()) {
                    ObjectionManager.getInstance().clear(Objection.MACRO_LABEL);
                }
            }
        });
    }

    @Override
    public Control getControlToColorBg() {
        return this.labelInfo.getParent();
    }

    @Override
    public Control getControlToColorFg() {
        return this.labelInfo;
    }

    @Override
    public void setCancelActionEnabled(boolean enabled) {
        this.cancelAction.setEnabled(enabled);
    }

    @Override
    public void createToolBar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.removeAll();
        if (toolBarManager.getItems().length > 0) {
            toolBarManager.add((IContributionItem)new Separator());
        }
        this.cancelAction = new Action("", DVTImages.STOP_CURRENT_BUILD_PROCESS){

            public void run() {
                MacrosView.this.getLazyTree().cancelOperations();
                this.setEnabled(false);
            }
        };
        this.cancelAction.setEnabled(false);
        this.cancelAction.setToolTipText("Cancel Current Operation");
        toolBarManager.add((IAction)this.cancelAction);
        toolBarManager.add((IContributionItem)new Separator());
        this.filtersAction = new FilterAction();
        LazyTree lazyTree = this.getLazyTree();
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.filtersAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)new ExpandAllAction(lazyTree));
        toolBarManager.add((IAction)new CollapseAllAction(lazyTree));
    }

    @Override
    public IDVTModel getModel(Class<? extends IDVTModel> modelClass) {
        if (modelClass == null) {
            return null;
        }
        if (modelClass == IModel.class) {
            return this.lazyMacrosModel;
        }
        return null;
    }

    @Override
    public ILabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new DVTLabelProviderProxy<IMacrosViewContributor>(IMacrosViewContributor.class, "default-tree");
        }
        return this.labelProvider;
    }

    @Override
    public LazyTreeIteratorType getIteratorType() {
        return LazyTreeIteratorType.LAZY_MACROS;
    }

    @Override
    public Objection getObjection() {
        return Objection.MACROS;
    }

    @Override
    public void gotoSelectedElement(String treeId) {
        Object selectedElement = this.getSelectedElement();
        if (selectedElement != null) {
            RfMixedLangManager.getInstance().gotoElement(this.getProject(), selectedElement);
            return;
        }
    }

    private Object getSelectedElement() {
        TreePath selection = this.getLazyTree().getSelection();
        if (selection == null || selection.getElement() == null) {
            return null;
        }
        if (!(selection.getElement() instanceof IRfNamedElement) && !(selection.getElement() instanceof CDTMacroWrapper)) {
            return null;
        }
        return selection.getElement();
    }

    @Override
    public String prepareText(String textFilterId, String text) {
        return text;
    }

    @Override
    public void stringMatcherUpdated(String uIJobTextFilterId) {
        this.updateLabelInfo(this.labelInfo);
        this.getLazyTree().doAction(LazyTreeAction.SEARCH, new LazyTreeSearchActionArguments(true, true, this.lazyMacrosModel, Objection.MACROS));
    }

    @Override
    public Text getTextFilter(String textFilterId) {
        TextFilterObject textFilterObject = this.getTextFilterObject(textFilterId);
        if (textFilterObject == null) {
            return null;
        }
        Text textFilter = textFilterObject.getTextFilter();
        if (textFilter.isDisposed()) {
            return null;
        }
        return textFilter;
    }

    @Override
    public ILabelProvider getTreeLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public StringMatcher[] getTreeSearchSegments() {
        TextFilterObject textFilterObject = this.getTextFilterObject("default-filter");
        if (textFilterObject == null) {
            return null;
        }
        return textFilterObject.getSearchSegments();
    }

    @Override
    public boolean[] getTreeSearchStrictness() {
        TextFilterObject textFilterObject = this.getTextFilterObject("default-filter");
        if (textFilterObject == null) {
            return null;
        }
        return textFilterObject.getSearchTextStrictness();
    }

    public StringMatcher getStringMatcher(String textFilterId) {
        TextFilterObject textFilterObject = this.getTextFilterObject(textFilterId);
        if (textFilterObject == null) {
            return null;
        }
        return textFilterObject.getStringMatcher();
    }

    @Override
    public boolean isFiltered() {
        TextFilterObject textFilterObject = this.getTextFilterObject("default-filter");
        if (textFilterObject == null) {
            return false;
        }
        return textFilterObject.isFiltered();
    }

    @Override
    public MacrosViewTestUtils getLazyTreeTestUtils() {
        return this.lazyTreeTestUtils;
    }

    @Override
    public String getMessageText() {
        if (this.getProject() == null || !this.getProject().isAccessible() || !Utils.hasDvtNature(this.getProject())) {
            return "Select a DVT Project or file.";
        }
        if (!this.getTextFilter("default-filter").getText().isEmpty()) {
            if (this.lazyMacrosModel == null) {
                return LazyTreeMessageCompositeType.NO_DATA.getMessage();
            }
            if (this.modelComputingCanceled) {
                this.modelComputingCanceled = false;
                return LazyTreeMessageCompositeType.SEARCH_CANCELED.getMessage();
            }
            if (this.lazyMacrosModel.hasSearchedElementFiltered()) {
                return LazyTreeMessageCompositeType.GUI_FILTERED.getMessage();
            }
            return LazyTreeMessageCompositeType.NO_MATCHES_FOUND.getMessage();
        }
        if (this.lazyMacrosModel != null && this.lazyMacrosModel.hasMacrosFilteredElements()) {
            return LazyTreeMessageCompositeType.MACROS_FILTERED.getMessage();
        }
        if (this.lazyMacrosModel != null && this.lazyMacrosModel.hasGUIFilteredElements()) {
            return LazyTreeMessageCompositeType.GUI_FILTERED.getMessage();
        }
        return LazyTreeMessageCompositeType.NO_DATA.getMessage();
    }

    @Override
    protected void createViewSpecificPartControl(Composite parent) {
        this.controlParent = parent;
        LazyTree lazyTree = new LazyTree(this);
        this.setLazyTree(lazyTree);
        GridData gridData = new GridData(1808);
        parent.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        Composite labelContainer = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(5, 5).applyTo(labelContainer);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)labelContainer);
        this.contentFiltersLabel = new Label(labelContainer, 0);
        if (EclipseUtils.isAtLeastEclipse419()) {
            this.contentFiltersLabel.setImage(this.hasGUIFilteredElements ? this.contentFiltersEnabledIcon : this.contentFiltersDisabledIcon);
        } else {
            this.contentFiltersLabel.setImage(this.contentFiltersEnabledIcon);
        }
        this.contentFiltersLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.contentFiltersLabel.setToolTipText("Content Filters matched!");
        this.contentFiltersLabel.setEnabled(this.hasGUIFilteredElements);
        GridDataFactory.fillDefaults().align(1, 128).grab(false, false).applyTo((Control)this.contentFiltersLabel);
        this.labelInfo = new Label(labelContainer, 16384);
        this.labelInfo.setLayoutData((Object)new GridData(768));
        this.createTextFilter("default-filter", parent, "default-tree", false);
        TextFilterObject filter = this.getTextFilterObject("default-filter");
        filter.setTextFilterMessage(FILTER_BY_NAME);
        lazyTree.setSearchBar(filter);
        lazyTree.setLabelProvider(this.getLabelProvider(), false);
        lazyTree.install(parent);
        Tree fTree = lazyTree.getTree();
        fTree.setHeaderVisible(false);
        this.addSelectionChangedListener(InspectViewSelectionListener.getInstance());
        fTree.addKeyListener((KeyListener)this.getKeyListener("default-filter", "default-tree"));
    }

    @Override
    public void createAndSyncTreeColumns(Table topTable, Tree tree, ScrolledComposite scrolledComposite) {
        int n = tree.getSize().x;
        if (n == 0) {
            n = 1000;
        }
        TableColumn nameColumn = new TableColumn(topTable, 16384);
        nameColumn.setText("Name");
        nameColumn.setWidth(n * 65 / 100);
        TreeColumn treeNameColumn = new TreeColumn(tree, 16384);
        treeNameColumn.setWidth(nameColumn.getWidth());
        TableColumn valueColumn = new TableColumn(topTable, 16384);
        valueColumn.setText("Value");
        valueColumn.setWidth(n * 45 / 100);
        TreeColumn treeValueColumn = new TreeColumn(tree, 16384);
        treeValueColumn.setWidth(valueColumn.getWidth());
        TableColumn fileColumn = new TableColumn(topTable, 16384);
        fileColumn.setText("Source File");
        fileColumn.setWidth(n * 20 / 100);
        TreeColumn treeFileColumn = new TreeColumn(tree, 16384);
        treeFileColumn.setWidth(fileColumn.getWidth());
        TableColumn lineColumn = new TableColumn(topTable, 16384);
        lineColumn.setText("Line");
        lineColumn.setWidth(n * 10 / 100);
        TreeColumn treeLineColumn = new TreeColumn(tree, 16384);
        treeLineColumn.setWidth(lineColumn.getWidth());
        nameColumn.addListener(11, event -> {
            int n1 = nameColumn.getWidth() + valueColumn.getWidth() + fileColumn.getWidth() + lineColumn.getWidth();
            scrolledComposite.setMinWidth(n1);
            treeNameColumn.setWidth(nameColumn.getWidth());
        });
        valueColumn.addListener(11, event -> {
            int n1 = nameColumn.getWidth() + valueColumn.getWidth() + fileColumn.getWidth() + lineColumn.getWidth();
            scrolledComposite.setMinWidth(n1);
            treeValueColumn.setWidth(valueColumn.getWidth());
        });
        fileColumn.addListener(11, event -> {
            int n1 = nameColumn.getWidth() + valueColumn.getWidth() + fileColumn.getWidth() + lineColumn.getWidth();
            scrolledComposite.setMinWidth(n1);
            treeFileColumn.setWidth(fileColumn.getWidth());
        });
        lineColumn.addListener(11, event -> {
            int n1 = nameColumn.getWidth() + valueColumn.getWidth() + fileColumn.getWidth() + lineColumn.getWidth();
            scrolledComposite.setMinWidth(n1);
            treeLineColumn.setWidth(lineColumn.getWidth());
        });
    }

    protected void setTextFilterMessage(String textFilterId, String message) {
        TextFilterObject textFilterObject = this.getTextFilterObject(textFilterId);
        if (textFilterObject == null) {
            return;
        }
        textFilterObject.setTextFilterMessage(message);
    }

    @Override
    protected void createCustomContextMenu(IMenuManager manager) {
    }

    protected void updateActionState() {
        if (!(PrefConst.getMacrosViewVlogdtHideConfigUnDefinedLazy() || PrefConst.getMacrosViewVlogdtHideReplacementLazy() || PrefConst.getMacrosViewVlogdtHideIfndefGuardsLazy())) {
            this.filtersAction.setChecked(false);
        } else {
            this.filtersAction.setChecked(true);
        }
    }

    public Control getControlParent() {
        return this.controlParent;
    }

    public Label getInfoLabel() {
        return this.labelInfo;
    }

    public Label getContentFilteredIndication() {
        return this.contentFiltersLabel;
    }

    public List<Object> getTestRoots() {
        return this.lazyMacrosModel == null ? Collections.emptyList() : this.lazyMacrosModel.testGetRoots();
    }

    @Override
    public int getViewColumnCount() {
        return 4;
    }

    class FilterAction
    extends Action {
        public FilterAction() {
            super("Filters...", 2);
            this.setDescription("Filters...");
            this.setToolTipText("Filters...");
            this.setImageDescriptor(DVTImages.FILTER);
        }

        public void run() {
            new MacrosViewMenuCreator().getMenu((Control)MacrosView.this.getViewSite().getShell()).setVisible(true);
            MacrosView.this.updateActionState();
        }
    }

    class MacrosViewMenuCreator
    implements IMenuCreator {
        Menu fMenu;

        MacrosViewMenuCreator() {
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        public Menu getMenu(Control parent) {
            this.fMenu = new Menu(parent);
            this.fMenu.setVisible(true);
            if (ViewsUtils.projectContainsVlogNature(MacrosView.this.getProject())) {
                MenuItem menuItem;
                if (MacrosView.this.nofIfndefGuard > 0) {
                    menuItem = new MenuItem(this.fMenu, 32);
                    menuItem.setText("Hide SystemVerilog `ifndef guard defines [" + MacrosView.this.nofIfndefGuard + "]");
                    menuItem.setSelection(PrefConst.getMacrosViewVlogdtHideIfndefGuardsLazy());
                    menuItem.setEnabled(true);
                    menuItem.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            if (!(e.widget instanceof MenuItem)) {
                                return;
                            }
                            PrefConst.setMacrosViewVlogdtHideIfndefGuardsLazy(((MenuItem)e.widget).getSelection());
                            MacrosView.this.updateActionState();
                            MacrosView.this.update(null);
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                            this.widgetSelected(e);
                        }
                    });
                }
                if (MacrosView.this.nofConfigDefinedMacro > 0) {
                    menuItem = new MenuItem(this.fMenu, 32);
                    menuItem.setText("Hide SystemVerilog `if(n)def controls [" + MacrosView.this.nofConfigDefinedMacro + "]");
                    menuItem.setSelection(PrefConst.getMacrosViewVlogdtHideConfigUnDefinedLazy());
                    menuItem.setEnabled(true);
                    menuItem.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            if (!(e.widget instanceof MenuItem)) {
                                return;
                            }
                            PrefConst.setMacrosViewVlogdtHideConfigUnDefinedLazy(((MenuItem)e.widget).getSelection());
                            MacrosView.this.updateActionState();
                            MacrosView.this.update(null);
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                            this.widgetSelected(e);
                        }
                    });
                }
                if (MacrosView.this.nofReplMacro > 0) {
                    menuItem = new MenuItem(this.fMenu, 32);
                    menuItem.setText("Hide SystemVerilog defines [" + MacrosView.this.nofReplMacro + "]");
                    menuItem.setSelection(PrefConst.getMacrosViewVlogdtHideReplacementLazy());
                    menuItem.setEnabled(true);
                    menuItem.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            if (!(e.widget instanceof MenuItem)) {
                                return;
                            }
                            PrefConst.setMacrosViewVlogdtHideHasReplacementLazy(((MenuItem)e.widget).getSelection());
                            MacrosView.this.updateActionState();
                            MacrosView.this.update(null);
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                            this.widgetSelected(e);
                        }
                    });
                }
            }
            return this.fMenu;
        }

        public void dispose() {
            if (this.fMenu != null) {
                this.fMenu.dispose();
            }
        }
    }
}

