/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.macros;

import java.util.List;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.test.ForTestingOrDebuggingOnly;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.DVTSyntheticEvent;
import ro.amiq.dvt.ui.views.DVTLabelProviderProxy;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.utils.ILazyTreeTestUtils;
import ro.amiq.dvt.ui.views.lazy.views.IDVTLazyView;
import ro.amiq.dvt.ui.views.lazy.views.macros.CDTMacroWrapper;
import ro.amiq.dvt.ui.views.lazy.views.macros.MacrosView;
import ro.amiq.dvt.ui.views.lazy.views.macros.QuickMacrosView;
import ro.amiq.dvt.utils.DVTStringUtil;

@ForTestingOrDebuggingOnly
public class MacrosViewTestUtils
implements ILazyTreeTestUtils {
    private IDVTLazyView lazyView;

    public MacrosViewTestUtils(IDVTLazyView lazyView) {
        this.lazyView = lazyView;
    }

    @Override
    public IDVTLazyView getLazyView() {
        return this.lazyView;
    }

    @Override
    public boolean selectInLazyTree(String searchedElement, int num) {
        TreePath searchedPath = null;
        for (TreePath path : this.getViewContent()) {
            String instanceName = path.getLastSegment();
            if (instanceName == null || !instanceName.equals(searchedElement)) continue;
            searchedPath = path;
            break;
        }
        if (searchedPath == null) {
            throw new RuntimeException("Unable to select non-existing node " + searchedElement);
        }
        Tree typesTree = this.getViewTree();
        if (typesTree == null) {
            return false;
        }
        TreeItem[] treeItems = typesTree.getItems();
        TreeItem selection = null;
        String[] stringArray = searchedPath.getSegments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            selection = null;
            TreeItem[] treeItemArray = treeItems;
            int n3 = treeItems.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem candidate = treeItemArray[n4];
                Object data = candidate.getData();
                if (!(data instanceof TreePath)) {
                    return false;
                }
                if (((TreePath)data).getLastSegment().equals(segment)) {
                    treeItems = candidate.getItems();
                    selection = candidate;
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        if (selection == null) {
            throw new RuntimeException("Unable to select non-existing node " + DVTStringUtil.join(searchedPath.getSegments(), "/"));
        }
        typesTree.setSelection(selection);
        this.testSetSelection(searchedPath);
        typesTree.showSelection();
        typesTree.notifyListeners(13, (Event)new DVTSyntheticEvent(true));
        return true;
    }

    public List<TreePath> getViewContent() {
        return this.getLazyTree().getViewContent();
    }

    @Override
    public LazyTree getLazyTree() {
        if (this.lazyView instanceof MacrosView) {
            return ((MacrosView)this.lazyView).getLazyTree();
        }
        if (this.lazyView instanceof QuickMacrosView) {
            return ((QuickMacrosView)this.lazyView).getLazyTree();
        }
        return null;
    }

    private Tree getViewTree() {
        return this.getLazyTree().getTree();
    }

    @Override
    public void testSetSelection(TreePath path) {
        this.getLazyTree().testSetSelection(path);
    }

    @Override
    public Objection getObjection() {
        return Objection.MACROS;
    }

    public Control getControlParent() {
        LazyTree lazyTree = this.getLazyTree();
        if (lazyTree != null) {
            return lazyTree.getControlParent();
        }
        return null;
    }

    public Label getInfoLabel() {
        if (!(this.lazyView instanceof MacrosView)) {
            return null;
        }
        return ((MacrosView)this.lazyView).getInfoLabel();
    }

    public Label getContentFilteredIndication() {
        if (!(this.lazyView instanceof MacrosView)) {
            return null;
        }
        return ((MacrosView)this.lazyView).getContentFilteredIndication();
    }

    public Object getTreeRootElement(String id) {
        if (this.lazyView instanceof MacrosView) {
            return ((MacrosView)this.lazyView).getTestRoots();
        }
        if (this.lazyView instanceof QuickMacrosView) {
            return ((QuickMacrosView)this.lazyView).getTestRoots();
        }
        return null;
    }

    public Text getTextFilter(String defaultFilterId) {
        if (!(this.lazyView instanceof MacrosView)) {
            return null;
        }
        return ((MacrosView)this.lazyView).getTextFilter(defaultFilterId);
    }

    public LabelProvider getTreeLabelProvider() {
        if (!(this.lazyView instanceof MacrosView)) {
            return null;
        }
        MacrosView lazyTypesView = (MacrosView)this.lazyView;
        if (!(lazyTypesView.getLabelProvider() instanceof DVTLabelProviderProxy)) {
            return null;
        }
        return (DVTLabelProviderProxy)lazyTypesView.getLabelProvider();
    }

    private Object getSelectedElement() {
        TreePath selection = this.getLazyTree().getSelection();
        if (selection == null || selection.getElement() == null) {
            return null;
        }
        if (!(selection.getElement() instanceof IRfNamedElement) && !(selection.getElement() instanceof CDTMacroWrapper)) {
            return null;
        }
        return selection.getElement();
    }

    public boolean selectAndGoToMacro(String searchedElement, int num) {
        return this.selectAndGoToMacro(searchedElement, num, 5000L);
    }

    public boolean selectAndGoToMacro(String searchedElement, int num, long timeout) {
        return TestHelper.SYNCER.getWithRetry(timeout, () -> {
            this.search(searchedElement);
            this.selectInLazyTree(searchedElement, num);
            Object selectedElement = this.getSelectedElement();
            this.resetSearch();
            if (selectedElement != null) {
                RfMixedLangManager.getInstance().gotoElement(this.getLazyView().getProject(), selectedElement);
                return true;
            }
            return false;
        }, RuntimeException.class);
    }
}

