/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.macros;

import java.util.LinkedHashMap;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.views.DVTLanguageElement;

public class MacrosWrapper {
    public static final String DEFINES = "Defines";
    public static final String IFDEF_CONTROLS = "If(n)def Controls";
    public static final String IFNDEF_GUARDS = "Ifndef Guards";
    private int nofMacros;
    private int nofReplMacro;
    private int nofIfndefGuard;
    private int nofConfigUndefMacro;
    private int nofConfigDefinedMacro;
    private boolean hasGUIFilteredElements;
    private boolean hasSearchedElementFiltered;
    private final DVTLanguageElement<String> languageElement;
    private final LinkedHashMap<IRfNamedElement, List<Object>> macrosByCategory;

    public MacrosWrapper(DVTLanguageElement<String> languageElement) {
        this.languageElement = languageElement;
        this.macrosByCategory = new LinkedHashMap();
    }

    public DVTLanguageElement<String> getLanguageElement() {
        return this.languageElement;
    }

    public LinkedHashMap<IRfNamedElement, List<Object>> getAllMacrosByCategory() {
        return this.macrosByCategory;
    }

    protected void addMacros(LinkedHashMap<IRfNamedElement, List<Object>> macrosByCategory) {
        this.macrosByCategory.putAll(macrosByCategory);
    }

    protected int getNofMacros() {
        return this.nofMacros;
    }

    public void incrementNofMacros() {
        ++this.nofMacros;
    }

    protected int getNofReplMacro() {
        return this.nofReplMacro;
    }

    public void incrementNofReplMacro() {
        ++this.nofReplMacro;
    }

    protected int getNofIfndefGuard() {
        return this.nofIfndefGuard;
    }

    public void incrementNofIfndefGuard() {
        ++this.nofIfndefGuard;
    }

    protected int getNofConfigDefinedMacro() {
        return this.nofConfigDefinedMacro;
    }

    public void incrementNofConfigDefinedMacro() {
        ++this.nofConfigDefinedMacro;
    }

    protected int getNofConfigUndefMacro() {
        return this.nofConfigUndefMacro;
    }

    public void incrementNofConfigUndefMacro() {
        ++this.nofConfigUndefMacro;
    }

    protected boolean hasGUIFilteredElements() {
        return this.hasGUIFilteredElements;
    }

    public void setHasGUIFilteredElements(boolean hasGUIFilteredElements) {
        this.hasGUIFilteredElements = hasGUIFilteredElements;
    }

    public boolean hasSearchedElementFiltered() {
        return this.hasSearchedElementFiltered;
    }

    public void setHasSearchedElementFiltered(boolean hasSearchedElementFiltered) {
        this.hasSearchedElementFiltered = hasSearchedElementFiltered;
    }

    protected boolean isEmpty() {
        for (List<Object> macroList : this.macrosByCategory.values()) {
            if (macroList == null || macroList.isEmpty()) continue;
            return false;
        }
        return true;
    }

    protected void clearMacros() {
        for (List<Object> macroList : this.macrosByCategory.values()) {
            if (macroList == null || macroList.isEmpty()) continue;
            macroList.clear();
        }
        this.macrosByCategory.clear();
    }
}

