/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.macros;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.DVTLabelProviderProxy;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTModel;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeIteratorType;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeMessageCompositeType;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeAction;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSearchActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeUpdateViewActionArguments;
import ro.amiq.dvt.ui.views.lazy.views.macros.CDTMacroWrapper;
import ro.amiq.dvt.ui.views.lazy.views.macros.IMacrosViewContributor;
import ro.amiq.dvt.ui.views.lazy.views.macros.MacrosModel;
import ro.amiq.dvt.ui.views.lazy.views.macros.MacrosViewTestUtils;
import ro.amiq.dvt.ui.views.lazy.views.quick.DVTQuickLazyView;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.Utils;

public class QuickMacrosView
extends DVTQuickLazyView
implements IRfFilterableTreeAccessor {
    public static final String ID = "ro.amiq.dvt.ui.views.QuickMacrosView";
    public static final String TITLE = "Quick Macros";
    private static final String DEFAULT_FILTER_HELPER_TEXT = "Filter by: define name or match expression";
    private static final String INFO_TEXT = "Search patterns may contain: * = any string, ? = any character.";
    private static final String WARNING_MESSAGE_INPUT = "WARNING!\nFunctionality for files\noutside a project is\nlimited. Create a project\nor use linked resources\nto existing project.";
    DVTLabelProviderProxy<IMacrosViewContributor> labelProvider = new DVTLabelProviderProxy<IMacrosViewContributor>(IMacrosViewContributor.class, "default-tree");
    private boolean hasGUIFilteredElements;
    private MacrosModel quickMacrosModel;
    private final MacrosViewTestUtils lazyTreeTestUtils = new MacrosViewTestUtils(this);

    public QuickMacrosView(Shell parent, IProject project) {
        super(parent, 48, project);
        this.quickMacrosModel = new MacrosModel(this.getProject(), this.getLabelProvider(), this);
        this.setTextFilterMessage("default-filter", DEFAULT_FILTER_HELPER_TEXT);
    }

    @Override
    protected String getId() {
        return ID;
    }

    @Override
    public LazyTreeIteratorType getIteratorType() {
        return LazyTreeIteratorType.QUICK_MACROS_VIEW;
    }

    @Override
    public Objection getObjection() {
        return Objection.QUICK_MACROS_VIEW;
    }

    @Override
    public MacrosViewTestUtils getLazyTreeTestUtils() {
        return this.lazyTreeTestUtils;
    }

    @Override
    public boolean supportsDecorations() {
        return true;
    }

    @Override
    protected String getTitle() {
        return String.valueOf(this.hasGUIFilteredElements ? "*" : "") + TITLE + (this.project != null ? " [" + this.project.getName() + "]" : "");
    }

    @Override
    public DVTBaseLabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new DVTLabelProviderProxy<IMacrosViewContributor>(IMacrosViewContributor.class, "default-tree");
        }
        return this.labelProvider;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public IDVTModel getModel(Class<? extends IDVTModel> modelClass) {
        return this.quickMacrosModel;
    }

    @Override
    public String getMessageText() {
        if (this.getProject() == null || !this.getProject().isAccessible() || !Utils.hasDvtNature(this.getProject())) {
            return WARNING_MESSAGE_INPUT;
        }
        if (!this.getTextFilterObject("default-filter").getTextFilterText().isEmpty()) {
            if (this.quickMacrosModel == null) {
                return LazyTreeMessageCompositeType.NO_DATA.getMessage();
            }
            if (this.quickMacrosModel.hasSearchedElementFiltered()) {
                return LazyTreeMessageCompositeType.GUI_FILTERED.getMessage();
            }
            return LazyTreeMessageCompositeType.NO_MATCHES_FOUND.getMessage();
        }
        if (this.quickMacrosModel.hasGUIFilteredElements()) {
            return LazyTreeMessageCompositeType.GUI_FILTERED.getMessage();
        }
        return LazyTreeMessageCompositeType.NO_DATA.getMessage();
    }

    @Override
    public void setCancelActionEnabled(boolean enabled) {
    }

    @Override
    public void setInput(Object information) {
        try {
            if (!DVTPlugin.getDefault().collect().c(this.project, "F636F7265")) {
                return;
            }
            this.getShell().setText(this.getTitle());
            this.setTitleText(this.getTitle());
            this.setInfoText(INFO_TEXT);
            if (this.quickMacrosModel == null) {
                this.quickMacrosModel = new MacrosModel(this.getProject(), this.getLabelProvider(), this);
            }
            this.update();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void update() {
        try {
            LazyTree lazyTree = this.getLazyTree();
            lazyTree.doAction(LazyTreeAction.UPDATE_VIEW, new LazyTreeUpdateViewActionArguments(this, this.quickMacrosModel, true, false, false, Objection.QUICK_MACROS_VIEW));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected void fillDialogMenu(IMenuManager viewMenu) {
        super.fillDialogMenu(viewMenu);
    }

    @Override
    public void stringMatcherUpdated(String uIJobTextFilterId) {
        this.getLazyTree().setSearchBar(this.getTextFilterObject("default-filter"));
        this.getLazyTree().doAction(LazyTreeAction.SEARCH, new LazyTreeSearchActionArguments(true, true, this.quickMacrosModel, Objection.QUICK_MACROS_VIEW));
    }

    @Override
    protected void gotoSelectedElement() {
        if (this.project == null) {
            return;
        }
        TreePath selectedPath = this.getSelectedPath();
        if (selectedPath == null) {
            return;
        }
        this.goToElement(selectedPath);
    }

    @Override
    protected void goToElement(TreePath selectedPath) {
        Object selectedElement = this.getSelectedElement(selectedPath);
        if (selectedElement != null) {
            RfMixedLangManager.getInstance().gotoElement(this.getProject(), selectedElement);
            return;
        }
    }

    private Object getSelectedElement(TreePath selection) {
        if (selection == null || selection.getElement() == null) {
            return null;
        }
        if (!(selection.getElement() instanceof IRfNamedElement) && !(selection.getElement() instanceof CDTMacroWrapper)) {
            return null;
        }
        return selection.getElement();
    }

    @Override
    public ILabelProvider getTreeLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new DVTLabelProviderProxy<IMacrosViewContributor>(IMacrosViewContributor.class, "default-tree");
        }
        return this.labelProvider;
    }

    @Override
    public StringMatcher[] getTreeSearchSegments() {
        return this.getSearchSegments("default-filter");
    }

    @Override
    public boolean[] getTreeSearchStrictness() {
        return this.getSearchStrictness("default-filter");
    }

    @Override
    public String getTreeSearchPort() {
        return null;
    }

    @Override
    public List<String> getMemberNames(IDVTElementWrapper node) {
        return null;
    }

    @Override
    public boolean isFiltered() {
        return this.hasGUIFilteredElements;
    }

    @Override
    public UpdateJob getUpdateJob() {
        return null;
    }

    public List<Object> getTestRoots() {
        return this.quickMacrosModel == null ? Collections.emptyList() : this.quickMacrosModel.testGetRoots();
    }
}

