/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.quick;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.core.IPluginConfig;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.DVTPopupDialog;
import ro.amiq.dvt.ui.views.IFilterableView;
import ro.amiq.dvt.ui.views.TextFilterObject;
import ro.amiq.dvt.ui.views.lazy.tree.AbstractTreeIterator;
import ro.amiq.dvt.ui.views.lazy.tree.IModel;
import ro.amiq.dvt.ui.views.lazy.tree.ITreeIteratorStateListener;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.lazy.tree.TreeIteratorEvent;
import ro.amiq.dvt.ui.views.lazy.tree.TreeIteratorEventType;
import ro.amiq.dvt.ui.views.lazy.tree.TreeIteratorGoToElementEvent;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeAction;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeExpandCollapseActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeQuickSearchGoToElementActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSearchActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSetSelectionActionArguments;
import ro.amiq.dvt.ui.views.lazy.views.IDVTLazyView;
import ro.amiq.dvt.utils.StringMatcher;

public abstract class DVTQuickLazyView
extends DVTPopupDialog
implements IDVTLazyView,
IInformationControl,
IInformationControlExtension,
IInformationControlExtension2,
DisposeListener,
IFilterableView {
    public static final String DEFAULT_TREE_ID = "default-tree";
    public static final String DEFAULT_FILTER_ID = "default-filter";
    private Map<String, TextFilterObject> fTextFilters = new HashMap<String, TextFilterObject>();
    protected IProject project;
    protected IPluginConfig pluginConfig;
    private LazyTree lazyTree;
    private Text selectRootTextBox;
    private Composite textBoxComposite;
    private Composite fViewMenuButtonComposite;
    private IAction fShowViewMenuAction;
    private Composite fTopComposite;
    private TextFilterObject filter;
    private ITreeIteratorStateListener treeIteratorStateListener;

    protected DVTQuickLazyView(Shell parent, int shellStyle, IProject project) {
        super(parent, shellStyle, true, true, true, true, true, null, null);
        this.project = project;
        if (this.hasHeader()) {
            this.setTitleText("");
        }
        this.setInfoText("");
        this.create();
        this.setInfoText(this.getStatusFieldText());
    }

    protected Control createDialogArea(Composite parent) {
        this.fTopComposite = parent;
        final LazyTree lazyTree = new LazyTree(this);
        this.setLazyTree(lazyTree);
        this.setInitialFilter();
        lazyTree.setSearchBar(this.filter);
        lazyTree.setLabelProvider(this.getLabelProvider(), true);
        this.createIteratorStateListener();
        lazyTree.install(parent);
        TreeViewer treeViewer = new TreeViewer(lazyTree.getTree());
        treeViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.getShell().setText(this.getTitle());
        final Tree tree = lazyTree.getTree();
        tree.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
                DVTQuickLazyView.this.handleKeyEvent(event);
                if (event.character == '\u001b') {
                    DVTQuickLazyView.this.dispose();
                } else if (event.keyCode == 13 || event.keyCode == 0x1000050) {
                    DVTQuickLazyView.this.gotoSelectedElement(DVTQuickLazyView.DEFAULT_TREE_ID);
                } else if (event.keyCode == 8) {
                    TextFilterObject textFilterObject = DVTQuickLazyView.this.fTextFilters.get(DVTQuickLazyView.DEFAULT_FILTER_ID);
                    if (textFilterObject == null) {
                        return;
                    }
                    Text filterText = textFilterObject.getTextFilter();
                    if (filterText == null) {
                        return;
                    }
                    String currentText = filterText.getText();
                    filterText.setFocus();
                    filterText.setText(currentText.substring(0, Math.max(0, currentText.length() - 1)));
                    filterText.setSelection(filterText.getCharCount(), filterText.getCharCount());
                } else if (event.character != '\u0000' && (Character.isJavaIdentifierPart(event.character) && event.keyCode != 27 || event.character == '*' || event.character == '.' || event.character == '?')) {
                    if (event.character != (char)event.keyCode) {
                        return;
                    }
                    TextFilterObject textFilterObject = DVTQuickLazyView.this.fTextFilters.get(DVTQuickLazyView.DEFAULT_FILTER_ID);
                    if (textFilterObject == null) {
                        return;
                    }
                    Text filterText = textFilterObject.getTextFilter();
                    if (filterText == null) {
                        return;
                    }
                    filterText.setText(String.valueOf(filterText.getText()) + event.character);
                    filterText.setFocus();
                    filterText.setSelection(filterText.getCharCount(), filterText.getCharCount());
                } else if (event.keyCode == 0x1000003) {
                    TreeItem[] selection = tree.getSelection();
                    if (selection == null || selection.length == 0) {
                        return;
                    }
                    TreePath treePath = (TreePath)selection[0].getData();
                    DVTQuickLazyView.this.getLazyTree().doAction(LazyTreeAction.COLLAPSE, new LazyTreeExpandCollapseActionArguments(treePath, Objection.LAZY_TREE_COLLAPSE));
                } else if (event.keyCode == 0x1000004) {
                    TreeItem[] selection = tree.getSelection();
                    if (selection == null || selection.length == 0) {
                        return;
                    }
                    TreePath treePath = (TreePath)selection[0].getData();
                    DVTQuickLazyView.this.getLazyTree().doAction(LazyTreeAction.EXPAND, new LazyTreeExpandCollapseActionArguments(treePath, Objection.LAZY_TREE_EXPAND));
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                DVTQuickLazyView.this.gotoSelectedElement();
            }
        });
        this.addMouseListenerHyperlink(tree);
        this.filter.getTextFilter().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    DVTQuickLazyView.this.filter.getFilterJob().cancel();
                }
                if (e.keyCode == 0x1000002 || e.keyCode == 0x1000001) {
                    DVTQuickLazyView.this.setFocusOnTree(DVTQuickLazyView.this.getId());
                    lazyTree.doAction(LazyTreeAction.SET_SELECTION, new LazyTreeSetSelectionActionArguments(DVTQuickLazyView.this.getSelectionFromTree(), null));
                }
            }

            public void keyReleased(KeyEvent e) {
                if (!DVTQuickLazyView.this.supportsQuickSearchGoToElement()) {
                    return;
                }
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    lazyTree.doAction(LazyTreeAction.QUICK_SEARCH_GO_TO_ELEMENT, new LazyTreeQuickSearchGoToElementActionArguments(DVTQuickLazyView.this, DVTQuickLazyView.this.getObjection()));
                }
            }
        });
        this.addDisposeListener(this);
        return tree;
    }

    protected void addMouseListenerHyperlink(final Tree tree) {
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (tree.getSelectionCount() < 1) {
                    return;
                }
                if (e.button != 1) {
                    return;
                }
                if (tree.equals(e.getSource())) {
                    TreeItem o = tree.getItem(new Point(e.x, e.y));
                    TreeItem selection = tree.getSelection()[0];
                    if (selection.equals(o)) {
                        DVTQuickLazyView.this.gotoSelectedElement();
                    }
                }
            }
        });
    }

    private TreePath getSelectionFromTree() {
        Tree tree = this.getTree();
        if (tree == null) {
            return null;
        }
        TreeItem[] treeSelection = tree.getSelection();
        if (treeSelection.length == 0) {
            return null;
        }
        return (TreePath)treeSelection[0].getData();
    }

    private void createIteratorStateListener() {
        this.treeIteratorStateListener = new ITreeIteratorStateListener(){

            @Override
            public void stateChanged(TreeIteratorEvent event) {
                TreeIteratorEventType type = event.getEventType();
                if (type != TreeIteratorEventType.WINDOW_GO_TO_FIRST_ELEMENT) {
                    return;
                }
                if (!(event instanceof TreeIteratorGoToElementEvent)) {
                    return;
                }
                TreePath treePath = ((TreeIteratorGoToElementEvent)event).getTreePath();
                if (treePath == null) {
                    return;
                }
                if (DVTQuickLazyView.this.filter.getFilterJob() != null) {
                    DVTQuickLazyView.this.filter.getFilterJob().cancel();
                }
                Display.getDefault().asyncExec(() -> DVTQuickLazyView.this.goToElement(treePath));
            }
        };
    }

    protected boolean supportsQuickSearchGoToElement() {
        return true;
    }

    private void setInitialFilter() {
        if (this.filter == null) {
            return;
        }
        IWorkbenchPage activePage = Utils.getActivePage();
        if (activePage == null) {
            return;
        }
        ISelection selection = activePage.getSelection();
        if (!(selection instanceof TextSelection) || selection.isEmpty()) {
            return;
        }
        this.filter.setTextFilterText(((TextSelection)selection).getText());
        this.filter.getTextFilter().selectAll();
        this.filter.getFilterJob().cancel();
    }

    @Override
    public void addViewSpecificListeners(AbstractTreeIterator treeIterator) {
        treeIterator.addStateListener(this.treeIteratorStateListener);
    }

    private void setLazyTree(LazyTree lazyTree) {
        this.lazyTree = lazyTree;
    }

    private Tree getTree() {
        return this.lazyTree == null ? null : this.lazyTree.getTree();
    }

    protected boolean hasHeader() {
        return false;
    }

    protected String getStatusFieldText() {
        return "";
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.open();
        } else {
            this.saveDialogBounds(this.getShell());
            this.getShell().setVisible(false);
        }
    }

    public boolean close() {
        if (this.getTextFilterObject(DEFAULT_FILTER_ID) != null) {
            this.getTextFilterObject(DEFAULT_FILTER_ID).dispose();
        }
        this.lazyTree.doAction(LazyTreeAction.CLEAR_CACHE, new LazyTreeActionArguments(this.getObjection()));
        Tree tree = this.getTree();
        if (tree != null && tree.isDisposed()) {
            tree.dispose();
        }
        this.setLazyTree(null);
        return super.close();
    }

    public void dispose() {
    }

    public void widgetDisposed(DisposeEvent event) {
    }

    public boolean hasContents() {
        return this.getTree() != null;
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
    }

    public Point computeSizeHint() {
        return this.getShell().getSize();
    }

    public void setLocation(Point location) {
        if (!this.getPersistLocation() || !this.getPersistSize() || this.getDialogSettings() == null) {
            this.getShell().setLocation(location);
        }
    }

    public void setSize(int width, int height) {
        this.getShell().setSize(width, height);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.getShell().addDisposeListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.getShell().removeDisposeListener(listener);
    }

    public void setForegroundColor(Color foreground) {
        this.applyForegroundColor(foreground, this.getContents());
    }

    public void setBackgroundColor(Color background) {
        this.applyBackgroundColor(background, this.getContents());
    }

    public boolean isFocusControl() {
        Tree tree = this.getTree();
        return tree != null && tree.isFocusControl() || this.getTextFilterObject(DEFAULT_FILTER_ID).isFocusControl();
    }

    public void setFocus() {
        this.getShell().forceFocus();
        this.getTextFilterObject(DEFAULT_FILTER_ID).getTextFilter().setFocus();
    }

    public void addFocusListener(FocusListener listener) {
        this.getShell().addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.getShell().removeFocusListener(listener);
    }

    protected void createTextFilter(String textFilterId, Composite parent, String treeId, boolean searchForPorts) {
        this.filter = new TextFilterObject(this, textFilterId, parent, treeId, searchForPorts);
        this.fTextFilters.put(textFilterId, this.filter);
    }

    protected void setTextFilterMessage(String textFilterId, String message) {
        TextFilterObject textFilterObject = this.getTextFilterObject(textFilterId);
        if (textFilterObject == null) {
            return;
        }
        textFilterObject.setTextFilterMessage(message);
    }

    public TextFilterObject getTextFilterObject(String textFilterId) {
        if (textFilterId == null) {
            return null;
        }
        return this.fTextFilters.get(textFilterId);
    }

    public StringMatcher[] getSearchSegments(String textFilterId) {
        TextFilterObject textFilterObject = this.getTextFilterObject(textFilterId);
        if (textFilterObject == null) {
            return new StringMatcher[0];
        }
        return textFilterObject.getSearchSegments();
    }

    public String getSearchPort(String textFilterId) {
        TextFilterObject textFilterObject = this.getTextFilterObject(textFilterId);
        if (textFilterObject == null) {
            return "";
        }
        return textFilterObject.getSearchPort();
    }

    public boolean[] getSearchStrictness(String textFilterId) {
        TextFilterObject textFilterObject = this.getTextFilterObject(textFilterId);
        if (textFilterObject == null) {
            return new boolean[0];
        }
        return textFilterObject.getSearchTextStrictness();
    }

    public StringMatcher getStringMatcher(String textFilterId) {
        TextFilterObject textFilterObject = this.getTextFilterObject(textFilterId);
        if (textFilterObject == null) {
            return null;
        }
        return textFilterObject.getStringMatcher();
    }

    protected Control createTitleMenuArea(Composite parent) {
        this.fViewMenuButtonComposite = (Composite)super.createTitleMenuArea(parent);
        if (this.hasHeader()) {
            this.createTextFilter(DEFAULT_FILTER_ID, parent, DEFAULT_TREE_ID, false);
        }
        this.fShowViewMenuAction = new Action("showViewMenu"){

            public void run() {
                DVTQuickLazyView.this.showDialogMenu();
            }
        };
        this.fShowViewMenuAction.setEnabled(true);
        this.fShowViewMenuAction.setActionDefinitionId("org.eclipse.ui.window.showViewMenu");
        return this.fViewMenuButtonComposite;
    }

    protected Control createTitleControl(Composite parent) {
        if (this.hasHeader()) {
            return super.createTitleControl(parent);
        }
        this.createTextFilter(DEFAULT_FILTER_ID, parent, DEFAULT_TREE_ID, false);
        return this.getTextFilterObject(DEFAULT_FILTER_ID).getTextFilter();
    }

    protected void setTabOrder(Composite composite) {
        if (this.hasHeader()) {
            composite.setTabList(new Control[]{this.getTextFilterObject(DEFAULT_FILTER_ID).getTextFilter(), this.fTopComposite});
        } else {
            this.fViewMenuButtonComposite.setTabList(new Control[]{this.getTextFilterObject(DEFAULT_FILTER_ID).getControl()});
            composite.setTabList(new Control[]{this.fViewMenuButtonComposite, this.getTreeControlParent()});
        }
    }

    protected IProject getProject(ITextEditor editor) {
        if (editor == null) {
            return null;
        }
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        if (file == null) {
            return null;
        }
        return file.getProject();
    }

    @Override
    public void gotoSelectedElement(String treeId) {
        this.gotoSelectedElement();
    }

    @Override
    public void setFocusOnTree(String treeId) {
        Tree tree = this.getTree();
        if (tree == null) {
            return;
        }
        tree.setFocus();
    }

    @Override
    public String prepareText(String textFilterId, String text) {
        DVTColorUtil.INSTANCE.setBackground((Control)this.getTextFilterObject(DEFAULT_FILTER_ID).getTextFilter(), this.getBackground());
        return text;
    }

    @Override
    public void stringMatcherUpdated(String uIJobTextFilterId) {
        this.getLazyTree().setSearchBar(this.filter);
        this.getLazyTree().doAction(LazyTreeAction.SEARCH, new LazyTreeSearchActionArguments(true, true, this.getModel(IModel.class), this.getObjection()));
    }

    protected void setInfoText(String text) {
        super.setInfoText(text);
        if (this.fTopComposite == null) {
            return;
        }
        this.fTopComposite.layout(true);
    }

    public TreePath getSelectedPath() {
        Tree tree = this.getTree();
        if (tree == null) {
            return null;
        }
        TreeItem[] sel = tree.getSelection();
        if (sel == null || sel.length == 0 || sel[0].getData() == null) {
            return null;
        }
        if (!(sel[0].getData() instanceof TreePath)) {
            return null;
        }
        return (TreePath)sel[0].getData();
    }

    protected Control getTreeControlParent() {
        return this.lazyTree == null ? null : this.lazyTree.getControlParent();
    }

    public void setInformation(String information) {
    }

    @Override
    public LazyTree getLazyTree() {
        return this.lazyTree;
    }

    @Override
    public void swapToMessageComposite() {
        Display.getDefault().syncExec(() -> {
            LazyTree lazyTree = this.getLazyTree();
            Composite stackComposite = lazyTree.getStackComposite();
            if (stackComposite == null || stackComposite.isDisposed()) {
                return;
            }
            Layout layout = stackComposite.getLayout();
            if (!(layout instanceof StackLayout)) {
                return;
            }
            if (this.textBoxComposite == null || this.textBoxComposite.isDisposed() || this.selectRootTextBox == null || this.selectRootTextBox.isDisposed()) {
                this.textBoxComposite = new Composite(stackComposite, 16);
                GridLayout textBox = new GridLayout();
                textBox.marginBottom = 0;
                textBox.marginHeight = 0;
                textBox.marginLeft = 0;
                textBox.marginRight = 0;
                textBox.marginTop = 0;
                textBox.marginWidth = 0;
                this.textBoxComposite.setLayout((Layout)textBox);
                GridData textBoxCompositeGridData = new GridData(4, 4, true, true);
                this.textBoxComposite.setLayoutData((Object)textBoxCompositeGridData);
                this.selectRootTextBox = new Text(this.textBoxComposite, 74);
                GridData textBoxGridData = new GridData(4, 4, true, true);
                this.selectRootTextBox.setLayoutData((Object)textBoxGridData);
            }
            this.selectRootTextBox.setText(this.getMessageText());
            ((StackLayout)layout).topControl = this.textBoxComposite;
            stackComposite.layout();
        });
    }

    @Override
    public void swapToTreeComposite() {
        Display.getDefault().syncExec(() -> {
            LazyTree lazyTree = this.getLazyTree();
            Composite stackComposite = lazyTree.getStackComposite();
            if (stackComposite == null || stackComposite.isDisposed()) {
                return;
            }
            Layout layout = stackComposite.getLayout();
            if (!(layout instanceof StackLayout)) {
                return;
            }
            ((StackLayout)layout).topControl = lazyTree.getTableAndTreeComposite();
            stackComposite.layout();
        });
    }

    @Override
    public void selectionChanged() {
    }

    public void setInput(Object input) {
    }

    @Override
    public void createToolBar() {
    }

    public void handleKeyEvent(KeyEvent event) {
    }

    protected abstract String getTitle();

    @Override
    public abstract DVTBaseLabelProvider getLabelProvider();

    protected abstract void gotoSelectedElement();

    protected abstract void goToElement(TreePath var1);

    public abstract void update();

    protected Color getForeground() {
        if ((this.getShellStyle() & 0x80000) != 0) {
            return DVTColorUtil.INSTANCE.getSystemColor(28);
        }
        return DVTColorUtil.INSTANCE.getSystemColor(24);
    }

    protected Color getBackground() {
        if ((this.getShellStyle() & 0x80000) != 0) {
            return DVTColorUtil.INSTANCE.getSystemColor(29);
        }
        return DVTColorUtil.INSTANCE.getSystemColor(25);
    }
}

