/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.quickquery;

import java.util.Comparator;
import java.util.EnumMap;
import ro.amiq.dvt.symbolcollector.DVTSymbolKind;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.views.compileorder.CompileOrderModel;
import ro.amiq.dvt.ui.views.lazy.views.macros.MacrosModel;
import ro.amiq.dvt.ui.views.lazy.views.quickquery.QuickQueryUtils;
import ro.amiq.dvt.ui.views.lazy.views.types.TypesModel;

public enum QuickQueryComparator implements Comparator<TreePath>
{
    INSTANCE;

    private static final EnumMap<DVTSymbolKind, Comparator<TreePath>> COMPARATORS;

    static {
        COMPARATORS = new EnumMap(DVTSymbolKind.class);
        COMPARATORS.put(DVTSymbolKind.TYPE, TypesModel.indexComparator);
        COMPARATORS.put(DVTSymbolKind.MACRO, MacrosModel.comparator);
        COMPARATORS.put(DVTSymbolKind.COMPILED_FILE, CompileOrderModel.TreePathComparator);
    }

    @Override
    public int compare(TreePath t1, TreePath t2) {
        DVTSymbolKind symbolKind1 = QuickQueryUtils.getSymbolKind(t1);
        if (symbolKind1 == null) {
            return -1;
        }
        DVTSymbolKind symbolKind2 = QuickQueryUtils.getSymbolKind(t2);
        if (symbolKind2 == null) {
            return 1;
        }
        if (symbolKind1 != symbolKind2) {
            return symbolKind1.compareTo(symbolKind2);
        }
        Comparator<TreePath> comparator = COMPARATORS.get((Object)symbolKind1);
        if (comparator == null) {
            return 0;
        }
        return comparator.compare(t1, t2);
    }
}

