/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.quickquery;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.symbolcollector.SymbolQueryKey;

public class QuickQueryContentAssistProvider
implements IContentProposalProvider {
    private static final Comparator<IContentProposal> PROPOSAL_COMPARATOR = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return o1.getContent().compareTo(o2.getContent());
    };

    private QuickQueryContentAssistProvider() {
    }

    public static QuickQueryContentAssistProvider getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public IContentProposal[] getProposals(String query, int position) {
        if (query == null) {
            return null;
        }
        int colonPosition = query.indexOf(":");
        if (colonPosition >= 0 && position > colonPosition) {
            return null;
        }
        IProject project = DVTPlugin.getSelectionManager().getLastSelectedProject();
        if (project == null || !project.isAccessible()) {
            return null;
        }
        EnumSet<LanguageKind> languageKinds = this.getLanguageKinds(project);
        if (languageKinds == null || languageKinds.isEmpty()) {
            return null;
        }
        String queryKeyPrefix = query.substring(0, position);
        TreeSet<IContentProposal> proposals = new TreeSet<IContentProposal>(PROPOSAL_COMPARATOR);
        for (LanguageKind languageKind : languageKinds) {
            Set<String> queryKeys = SymbolQueryKey.getSupportedQueryKeys(languageKind);
            if (queryKeys == null) continue;
            for (String queryKey : queryKeys) {
                if (!queryKey.startsWith(queryKeyPrefix)) continue;
                proposals.add((IContentProposal)new ContentProposal(queryKey));
            }
        }
        return proposals.toArray(new IContentProposal[proposals.size()]);
    }

    private EnumSet<LanguageKind> getLanguageKinds(IProject project) {
        EnumSet<LanguageKind> result = EnumSet.noneOf(LanguageKind.class);
        try {
            EnumSet<LanguageKind> allLanguageKinds = SymbolQueryKey.getAllSupportedLanguageKinds();
            for (LanguageKind languageKind : allLanguageKinds) {
                if (!project.hasNature(languageKind.NATURE_ID)) continue;
                result.add(languageKind);
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    private static class InstanceHolder {
        private static final QuickQueryContentAssistProvider INSTANCE = new QuickQueryContentAssistProvider();

        private InstanceHolder() {
        }
    }
}

