/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.quickquery;

import java.util.Objects;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.symbolcollector.DVTSymbolKind;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;

public class QuickQueryElement {
    private final IDVTElementWrapper elementWrapper;

    protected QuickQueryElement(IDVTElementWrapper element) {
        this.elementWrapper = element;
    }

    protected void setAdditionalInfo() {
        if (this.elementWrapper == null) {
            return;
        }
        IRfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return;
        }
        this.elementWrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.QUICK_QUERY_EXTRA_INFO, namedElement.getFullNameLabel());
    }

    private IRfNamedElement getNamedElement() {
        if (this.elementWrapper == null) {
            return null;
        }
        Object rfElement = this.elementWrapper.getRfElement();
        if (!(rfElement instanceof IRfNamedElement)) {
            return null;
        }
        return (IRfNamedElement)rfElement;
    }

    public int hashCode() {
        IRfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return 0;
        }
        String name = DVTSymbolKind.TYPE.getLabelProvider().getText(this.elementWrapper);
        String kind = namedElement.getKindName();
        return Objects.hash(name, kind);
    }

    public boolean equals(Object obj) {
        IRfNamedElement otherNamedElement;
        String otherName;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QuickQueryElement other = (QuickQueryElement)obj;
        String name = DVTSymbolKind.TYPE.getLabelProvider().getText(this.elementWrapper);
        if (!Objects.equals(name, otherName = DVTSymbolKind.TYPE.getLabelProvider().getText(other.elementWrapper))) {
            return false;
        }
        IRfNamedElement namedElement = this.getNamedElement();
        if (namedElement == (otherNamedElement = other.getNamedElement())) {
            return true;
        }
        if (namedElement == null || otherNamedElement == null) {
            return false;
        }
        return Objects.equals(namedElement.getKindName(), otherNamedElement.getKindName());
    }
}

