/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.quickquery;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.symbolcollector.DVTSymbolCollector;
import ro.amiq.dvt.symbolcollector.DVTSymbolKind;
import ro.amiq.dvt.symbolcollector.ISymbolCollectorPrerequisite;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.DVTLabelProviderProxy;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IDVTViewContributor;
import ro.amiq.dvt.ui.views.lazy.tree.IModel;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.views.quickquery.QuickQueryComparator;
import ro.amiq.dvt.ui.views.lazy.views.quickquery.QuickQueryElement;
import ro.amiq.dvt.ui.views.lazy.views.quickquery.QuickQuerySymbolsRequest;

public class QuickQueryModel
implements IModel {
    private final IProject project;
    private final int maxElementsPerCategory;
    private String query;
    private List<TreePath> cachedTreePaths;
    private IProgressMonitor progressMonitor;

    protected QuickQueryModel(IProject project) {
        this.project = project;
        this.maxElementsPerCategory = PrefConst.getQuickQueryMaxElementsPerCategory();
        this.query = "";
    }

    @Override
    public List<TreePath> getChildren(TreePath segments, int childStartIndex, int childEndIndex, IProgressMonitor monitor) {
        try {
            this.progressMonitor = monitor;
            if (monitor.isCanceled()) {
                return null;
            }
            if (childStartIndex < 0 || childStartIndex > childEndIndex) {
                return null;
            }
            if (segments != TreePath.TOP_DUMMY_TREE_PATH) {
                return null;
            }
            List<TreePath> allChildren = this.getAllChildren();
            if (allChildren == null || allChildren.isEmpty()) {
                return null;
            }
            int nOfChildren = allChildren.size();
            if (childStartIndex >= nOfChildren) {
                return null;
            }
            List<TreePath> list = allChildren.subList(childStartIndex, Math.min(childEndIndex, nOfChildren));
            return list;
        }
        finally {
            this.progressMonitor = null;
        }
    }

    private List<TreePath> getAllChildren() {
        if (this.cachedTreePaths != null) {
            return this.cachedTreePaths;
        }
        QuickQuerySymbolsRequest request = new QuickQuerySymbolsRequest(this.query, this.project, this.maxElementsPerCategory, this.progressMonitor);
        List<ISymbolCollectorPrerequisite> symbolsPrerequisites = DVTSymbolCollector.INSTANCE.collectSymbolsPrerequisites(request);
        if (symbolsPrerequisites == null || symbolsPrerequisites.isEmpty()) {
            return null;
        }
        HashSet<QuickQueryElement> uniqueElements = new HashSet<QuickQueryElement>();
        for (ISymbolCollectorPrerequisite symbolPrerequisite : symbolsPrerequisites) {
            this.addTreePath(symbolPrerequisite, uniqueElements);
        }
        return this.cachedTreePaths;
    }

    private void addTreePath(ISymbolCollectorPrerequisite prerequisite, Set<QuickQueryElement> uniqueElements) {
        DVTSymbolKind symbolKind;
        if (prerequisite == null || uniqueElements == null) {
            return;
        }
        if (this.cachedTreePaths == null) {
            this.cachedTreePaths = new ArrayList<TreePath>();
        }
        if ((symbolKind = DVTSymbolKind.of(prerequisite)) == null) {
            return;
        }
        if (symbolKind == DVTSymbolKind.TYPE) {
            this.setTypeAdditionalInfo(prerequisite, uniqueElements);
        }
        DVTLabelProviderProxy<? extends IDVTViewContributor> labelProvider = symbolKind.getLabelProvider();
        String text = labelProvider.getText(prerequisite);
        TreePath treePath = TreePath.child(TreePath.TOP_DUMMY_TREE_PATH, text, this.cachedTreePaths.size(), QuickQueryComparator.INSTANCE);
        treePath.setElement(prerequisite);
        this.cachedTreePaths.add(treePath);
    }

    private void setTypeAdditionalInfo(ISymbolCollectorPrerequisite symbolPrerequisite, Set<QuickQueryElement> uniqueElements) {
        if (!(symbolPrerequisite instanceof IDVTElementWrapper)) {
            return;
        }
        IDVTElementWrapper element = (IDVTElementWrapper)symbolPrerequisite;
        QuickQueryElement qqElement = new QuickQueryElement(element);
        if (!uniqueElements.contains(qqElement)) {
            uniqueElements.add(qqElement);
            return;
        }
        Optional<QuickQueryElement> similarElement = uniqueElements.stream().filter(e -> Objects.equals(e, qqElement)).findFirst();
        if (!similarElement.isPresent()) {
            return;
        }
        qqElement.setAdditionalInfo();
        similarElement.get().setAdditionalInfo();
    }

    protected void updateQuery(String query) {
        this.query = query;
    }

    @Override
    public Boolean hasChildren(TreePath path, IProgressMonitor monitor) {
        if (path == TreePath.TOP_DUMMY_TREE_PATH) {
            return true;
        }
        List<TreePath> children = this.getChildren(path, 0, 1, monitor);
        if (children != null && !children.isEmpty()) {
            return true;
        }
        return false;
    }

    @Override
    public TreePath getLastChild(TreePath path, IProgressMonitor monitor) {
        List<TreePath> children = this.getChildren(path, 0, Integer.MAX_VALUE, monitor);
        return children == null || children.isEmpty() ? null : children.get(children.size() - 1);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public TreePath getEndTreePath(TreePath path, IProgressMonitor monitor) {
        currentPath = path;
        children = this.getChildren(currentPath, 0, 0x7FFFFFFF, monitor);
        if (children != null && !children.isEmpty()) ** GOTO lbl7
        return currentPath;
lbl-1000:
        // 1 sources

        {
            currentPath = children.get(children.size() - 1);
            children = this.getChildren(currentPath, 0, 0x7FFFFFFF, monitor);
lbl7:
            // 2 sources

            ** while (children != null && !children.isEmpty())
        }
lbl8:
        // 1 sources

        return currentPath;
    }

    @Override
    public void clearModelCaches() {
        this.cachedTreePaths = null;
        this.progressMonitor = null;
    }

    @Override
    public void resetModel(IProgressMonitor monitor) {
        this.clearModelCaches();
    }

    protected void cancelOperationInProgress() {
        if (this.progressMonitor == null) {
            return;
        }
        this.progressMonitor.setCanceled(true);
        this.clearModelCaches();
    }

    protected List<TreePath> testGetAllTreePaths() {
        return this.cachedTreePaths;
    }
}

