/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.quickquery;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.symbolcollector.DVTSymbolKind;
import ro.amiq.dvt.symbolcollector.ISymbolCollectorPrerequisite;
import ro.amiq.dvt.ui.views.DVTViewContributors;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.compileorder.ICompileOrderViewContributor;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;

public class QuickQueryUtils {
    private QuickQueryUtils() {
    }

    public static DVTSymbolKind getSymbolKind(TreePath treePath) {
        if (treePath == null) {
            return null;
        }
        Object element = treePath.getElement();
        if (!(element instanceof ISymbolCollectorPrerequisite)) {
            return null;
        }
        return DVTSymbolKind.of((ISymbolCollectorPrerequisite)element);
    }

    protected static void goToElement(TreePath treePath, IProject project) {
        if (treePath == null) {
            return;
        }
        DVTSymbolKind symbolKind = QuickQueryUtils.getSymbolKind(treePath);
        if (symbolKind == null) {
            return;
        }
        switch (symbolKind) {
            case TYPE: {
                QuickQueryUtils.goToTypesElement(treePath, project);
                break;
            }
            case MACRO: {
                QuickQueryUtils.goToMacroElement(treePath, project);
                break;
            }
            case COMPILED_FILE: {
                QuickQueryUtils.goToCompileOrderElement(treePath, project);
                break;
            }
            default: {
                return;
            }
        }
    }

    private static void goToMacroElement(TreePath selection, IProject project) {
        if (selection.getElement() == null) {
            return;
        }
        Object selectedElement = selection.getElement();
        if (!(selectedElement instanceof IRfNamedElement)) {
            return;
        }
        RfMixedLangManager.getInstance().gotoElement(project, selectedElement);
    }

    private static void goToTypesElement(TreePath selectedPath, IProject project) {
        try {
            Object selectedElement = selectedPath.getElement();
            if (!(selectedElement instanceof IDVTElementWrapper)) {
                return;
            }
            IDVTElementWrapper selectedWrapper = (IDVTElementWrapper)selectedElement;
            QuickQueryUtils.setDataForPathManager(selectedWrapper);
            RfMixedLangManager.getInstance().gotoElement(project, selectedWrapper);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private static void setDataForPathManager(IDVTElementWrapper wrapper) throws CoreException {
        if (wrapper == null) {
            return;
        }
        Object element = wrapper.getRfElement();
        if (!(element instanceof IRfNamedElement)) {
            return;
        }
        IRfDefElement declaration = ((IRfNamedElement)element).getDeclaration();
        if (declaration == null) {
            return;
        }
        IRfFileDef fileDef = declaration.getDefFile();
        if (fileDef == null) {
            return;
        }
        IResource file = (IResource)fileDef.getAdapter(IResource.class);
        if (file == null) {
            return;
        }
        file.setSessionProperty(IDVTConstants.FILE_INSTANCE_QN, (Object)wrapper);
    }

    private static void goToCompileOrderElement(TreePath selectedPath, IProject project) {
        if (selectedPath == null || project == null) {
            return;
        }
        Object selectedElement = selectedPath.getElement();
        if (!(selectedElement instanceof IDVTElementWrapper)) {
            return;
        }
        IDVTElementWrapper selectedWrapper = (IDVTElementWrapper)selectedElement;
        ICompileOrderViewContributor contributor = DVTViewContributors.getInstance().getViewContributor(selectedWrapper, ICompileOrderViewContributor.class);
        if (contributor != null) {
            contributor.gotoElement(project, selectedWrapper);
        }
    }
}

