/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.quickquery;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.TextFilterObject;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTModel;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeIteratorType;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeMessageCompositeType;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeAction;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSearchActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeUpdateViewActionArguments;
import ro.amiq.dvt.ui.views.lazy.views.quick.DVTQuickLazyView;
import ro.amiq.dvt.ui.views.lazy.views.quickquery.QuickQueryContentAssistAdapter;
import ro.amiq.dvt.ui.views.lazy.views.quickquery.QuickQueryContentAssistProvider;
import ro.amiq.dvt.ui.views.lazy.views.quickquery.QuickQueryLabelProvider;
import ro.amiq.dvt.ui.views.lazy.views.quickquery.QuickQueryModel;
import ro.amiq.dvt.ui.views.lazy.views.quickquery.QuickQueryTestUtils;
import ro.amiq.dvt.ui.views.lazy.views.quickquery.QuickQueryUtils;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.Utils;

public class QuickQueryView
extends DVTQuickLazyView
implements IRfFilterableTreeAccessor {
    public static final String ID = "ro.amiq.dvt.ui.views.QuickQueryView";
    private static final String TITLE = "Quick Query";
    private static final String DEFAULT_FILTER_HELPER_TEXT = "Filter by: <query key>:<search pattern>";
    private static final String INFO_TEXT = "Search patterns may contain: * = any string, ? = any character.";
    private final QuickQueryModel quickQueryModel;
    private final QuickQueryTestUtils quickQueryTestUtils = new QuickQueryTestUtils(this);

    public QuickQueryView(Shell parent, IProject project) {
        super(parent, 48, project);
        this.setTextFilterMessage("default-filter", DEFAULT_FILTER_HELPER_TEXT);
        this.quickQueryModel = new QuickQueryModel(project);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        TextFilterObject textFilterObject = this.getTextFilterObject("default-filter");
        if (textFilterObject == null) {
            return control;
        }
        new ContentAssistCommandAdapter((Control)textFilterObject.getTextFilter(), (IControlContentAdapter)QuickQueryContentAssistAdapter.getInstance(), (IContentProposalProvider)QuickQueryContentAssistProvider.getInstance(), "org.eclipse.ui.edit.text.contentAssist.proposals", null, true);
        return control;
    }

    @Override
    protected boolean supportsQuickSearchGoToElement() {
        return false;
    }

    @Override
    protected String getId() {
        return ID;
    }

    @Override
    public LazyTreeIteratorType getIteratorType() {
        return LazyTreeIteratorType.QUICK_QUERY_VIEW;
    }

    @Override
    public Objection getObjection() {
        return Objection.QUICK_QUERY;
    }

    @Override
    public QuickQueryTestUtils getLazyTreeTestUtils() {
        return this.quickQueryTestUtils;
    }

    @Override
    public boolean supportsDecorations() {
        return true;
    }

    @Override
    protected String getTitle() {
        return TITLE + (this.project != null ? " [" + this.project.getName() + "]" : "");
    }

    @Override
    public DVTBaseLabelProvider getLabelProvider() {
        return QuickQueryLabelProvider.getInstance();
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public QuickQueryModel getModel(Class<? extends IDVTModel> modelClass) {
        return this.quickQueryModel;
    }

    @Override
    public String getMessageText() {
        if (this.getProject() == null || !this.getProject().isAccessible() || !Utils.hasDvtNature(this.getProject())) {
            return "Select a DVT Project or file.";
        }
        if (this.quickQueryModel == null) {
            return LazyTreeMessageCompositeType.NO_DATA.getMessage();
        }
        if (!this.getTextFilterObject("default-filter").getTextFilterText().isEmpty()) {
            return LazyTreeMessageCompositeType.NO_MATCHES_FOUND.getMessage();
        }
        return LazyTreeMessageCompositeType.NO_DATA.getMessage();
    }

    @Override
    public void setCancelActionEnabled(boolean enabled) {
    }

    @Override
    public void setInput(Object information) {
        try {
            if (!DVTPlugin.getDefault().collect().c(this.project, "F636F7265")) {
                return;
            }
            this.getShell().setText(this.getTitle());
            this.setTitleText(this.getTitle());
            this.setInfoText(INFO_TEXT);
            this.update();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void update() {
        try {
            this.updateQuery();
            this.getLazyTree().doAction(LazyTreeAction.UPDATE_VIEW, new LazyTreeUpdateViewActionArguments(this, this.quickQueryModel, true, true, true, Objection.QUICK_QUERY));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void stringMatcherUpdated(String uIJobTextFilterId) {
        this.updateQuery();
        this.getLazyTree().doAction(LazyTreeAction.SEARCH, new LazyTreeSearchActionArguments(true, true, this.quickQueryModel, Objection.QUICK_QUERY));
    }

    private void updateQuery() {
        TextFilterObject textFilterObject = this.getTextFilterObject("default-filter");
        if (textFilterObject == null) {
            return;
        }
        this.quickQueryModel.updateQuery(textFilterObject.getTextFilterText());
        this.getLazyTree().setSearchBar(null);
    }

    @Override
    protected void gotoSelectedElement() {
        if (this.project == null) {
            return;
        }
        TreePath selectedPath = this.getSelectedPath();
        if (selectedPath == null) {
            return;
        }
        this.goToElement(selectedPath);
    }

    @Override
    protected void goToElement(TreePath selectedPath) {
        QuickQueryUtils.goToElement(selectedPath, this.project);
        this.close();
    }

    @Override
    public DVTBaseLabelProvider getTreeLabelProvider() {
        return this.getLabelProvider();
    }

    @Override
    public StringMatcher[] getTreeSearchSegments() {
        return ViewsUtils.EMPTY_SEARCH_SEGMENTS;
    }

    @Override
    public boolean[] getTreeSearchStrictness() {
        return ViewsUtils.EMPTY_SEARCH_STRICTNESS;
    }

    @Override
    public String getTreeSearchPort() {
        return null;
    }

    @Override
    public List<String> getMemberNames(IDVTElementWrapper node) {
        return null;
    }

    @Override
    public boolean isFiltered() {
        return false;
    }

    @Override
    public UpdateJob getUpdateJob() {
        return null;
    }

    @Override
    public boolean close() {
        this.quickQueryModel.cancelOperationInProgress();
        return super.close();
    }
}

