/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.registers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.interpreter.IXXVMRegBlock;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTViewContributor;
import ro.amiq.dvt.ui.views.TextFilterObject;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.views.DVTLazyView;
import ro.amiq.dvt.ui.views.registers.DVTXRegistersLabelProvider;
import ro.amiq.dvt.ui.views.registers.RegistersDisplayKind;
import ro.amiq.dvt.ui.views.registers.RegistersSortKind;
import ro.amiq.dvt.ui.views.registers.RegistersView;
import ro.amiq.dvt.utils.StringMatcher;

public interface IRegistersViewContributor
extends IDVTViewContributor {
    public static final String UVM_PKG = "uvm_pkg";
    public static final String OVM_PKG = "ovm_pkg";
    public static final String UVM = "uvm";
    public static final String OVM = "ovm";
    public static final String _REG_BLOCK = "_reg_block";
    public static final String _REG = "_reg";

    public static void sortRegistersListByName(List<? extends Object> registers) {
        Collections.sort(registers, (r1, r2) -> {
            if (!(r1 instanceof IXXVMRegBlock) || !(r2 instanceof IXXVMRegBlock)) {
                return 0;
            }
            int compareToValue = ((IXXVMRegBlock)r1).getName().compareTo(((IXXVMRegBlock)r2).getName());
            if (compareToValue == 0) {
                int compareToAddressValue = 0;
                IXXVMRegBlock.RegisterKind k1 = ((IXXVMRegBlock)r1).getKind();
                IXXVMRegBlock.RegisterKind k2 = ((IXXVMRegBlock)r2).getKind();
                if (k1 == IXXVMRegBlock.RegisterKind.REGISTER && k2 == IXXVMRegBlock.RegisterKind.REGISTER) {
                    compareToAddressValue = ((IXXVMRegBlock)r1).getAddressBase16().compareTo(((IXXVMRegBlock)r2).getAddressBase16());
                    if (compareToAddressValue == 0) {
                        return ((IXXVMRegBlock)r1).getGoToInfo() != null ? ((IXXVMRegBlock)r1).getGoToInfo().compareTo(((IXXVMRegBlock)r2).getGoToInfo()) : compareToAddressValue;
                    }
                } else {
                    return ((IXXVMRegBlock)r1).getGoToInfo() != null ? ((IXXVMRegBlock)r1).getGoToInfo().compareTo(((IXXVMRegBlock)r2).getGoToInfo()) : compareToAddressValue;
                }
                return 0;
            }
            return compareToValue;
        });
    }

    public List<TreePath> createRootTreePath(IProgressMonitor var1, IProject var2);

    public List<? extends IXXVMRegBlock> computeRegistersModelTree(IProject var1, IProgressMonitor var2);

    public List<? extends IXXVMRegBlock> computeRegistersModelFlat(IProject var1, IProgressMonitor var2);

    public List<Object> getChildrenForElement(Object var1, boolean var2, IProject var3, IProgressMonitor var4);

    public void sortRegisters(List<IXXVMRegBlock> var1, boolean var2);

    public String getTreeLabelText(HistoryItem var1);

    public void resetState();

    public boolean isModelBuildDone(IProject var1);

    public void buildModel(IProject var1);

    default public TreePath createTreePath(GoToInfo goToInfo, IRfNamedElement namedElement) {
        boolean isFlatHierarchy;
        IViewPart registersViewPart = this.getView();
        if (!(registersViewPart instanceof RegistersView)) {
            return null;
        }
        IProject project = namedElement.getRfProject().getProject();
        RegistersView registersView = (RegistersView)registersViewPart;
        boolean isSortByName = registersView.getSortKind() == RegistersSortKind.NAME;
        boolean bl = isFlatHierarchy = registersView.getDisplayKind() == RegistersDisplayKind.List;
        if (isFlatHierarchy && this.isXVMRegBlockSubclass(namedElement)) {
            TextFilterObject filter = registersView.getFilter();
            if (filter != null) {
                filter.setTextFilterText(namedElement.getName());
            }
            return TreePath.TOP_DUMMY_TREE_PATH;
        }
        List<? extends IXXVMRegBlock> regBlocks = null;
        regBlocks = isFlatHierarchy ? this.computeRegistersModelFlat(project, (IProgressMonitor)new NullProgressMonitor()) : this.computeRegistersModelTree(project, (IProgressMonitor)new NullProgressMonitor());
        if (regBlocks == null || regBlocks.isEmpty()) {
            return null;
        }
        int index = -1;
        LinkedHashMap<IXXVMRegBlock, Integer> pathSegments = new LinkedHashMap<IXXVMRegBlock, Integer>();
        for (IXXVMRegBlock iXXVMRegBlock : regBlocks) {
            pathSegments.put(iXXVMRegBlock, ++index);
            if (namedElement.equals(iXXVMRegBlock.getNamedElement())) {
                TreePath child = TreePath.child(TreePath.TOP_DUMMY_TREE_PATH, iXXVMRegBlock.getRegisterFullName(), index);
                child.setElement(iXXVMRegBlock);
                return child;
            }
            if (isFlatHierarchy) {
                pathSegments.remove(iXXVMRegBlock);
                continue;
            }
            List<IXXVMRegBlock> children = iXXVMRegBlock.getChildren();
            if (children == null || children.isEmpty()) continue;
            this.sortRegisters(children, isSortByName);
            boolean foundChild = false;
            int childIndex = -1;
            for (IXXVMRegBlock child : children) {
                pathSegments.put(child, ++childIndex);
                if (namedElement.equals(child.getNamedElement())) {
                    foundChild = true;
                    break;
                }
                foundChild = this.internalFindTreePath(goToInfo, pathSegments, child, isSortByName, namedElement);
                if (foundChild) break;
                pathSegments.remove(child);
            }
            if (foundChild) break;
            pathSegments.remove(iXXVMRegBlock);
        }
        if (pathSegments.isEmpty()) {
            return null;
        }
        ArrayList arrayList = new ArrayList(pathSegments.keySet());
        TreePath prevParent = TreePath.TOP_DUMMY_TREE_PATH;
        for (IXXVMRegBlock regBlock : arrayList) {
            TreePath child = TreePath.child(prevParent, regBlock.getName(), (Integer)pathSegments.get(regBlock));
            child.setElement(regBlock);
            prevParent = child;
        }
        return prevParent;
    }

    public boolean isXVMRegBlockSubclass(IRfNamedElement var1);

    default public boolean internalFindTreePath(GoToInfo info, Map<IXXVMRegBlock, Integer> pathSegments, IXXVMRegBlock prevChild, boolean isSortByName, IRfNamedElement namedElement) {
        List<IXXVMRegBlock> children = prevChild.getChildren();
        if (children == null || children.isEmpty()) {
            return false;
        }
        int index = -1;
        boolean foundChild = false;
        this.sortRegisters(children, isSortByName);
        for (IXXVMRegBlock child : children) {
            pathSegments.put(child, ++index);
            GoToInfo goToInfo = child.getGoToInfo();
            if (info != null && goToInfo != null && info.filePath.equals(goToInfo.filePath) && info.line == goToInfo.line) {
                foundChild = true;
            } else if (child.getNamedElement() != null && child.getNamedElement().equals(namedElement) || this.internalFindTreePath(info, pathSegments, child, isSortByName, namedElement)) {
                foundChild = true;
            }
            if (foundChild) {
                return true;
            }
            pathSegments.remove(child);
        }
        return false;
    }

    default public List<TreePath> createFlatTreePath(IProgressMonitor monitor, IProject project, boolean sortByName) {
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        List<? extends IXXVMRegBlock> registers = this.computeRegistersModelFlat(project, monitor);
        if (registers == null || registers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IXXVMRegBlock> objectRegisters = new ArrayList<IXXVMRegBlock>();
        objectRegisters.addAll(registers);
        if (!this.isStatic()) {
            this.sortRegisters(objectRegisters, sortByName);
        }
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        int i = 0;
        while (i < objectRegisters.size()) {
            IXXVMRegBlock block = (IXXVMRegBlock)objectRegisters.get(i);
            TreePath parentRoot = TreePath.child(TreePath.TOP_DUMMY_TREE_PATH, block.getRegisterFullName(), i);
            parentRoot.setElement(objectRegisters.get(i));
            paths.add(parentRoot);
            ++i;
        }
        return paths;
    }

    default public String getText(Object dvtElementWrapper, TreePath treePath) {
        if (!(dvtElementWrapper instanceof IXXVMRegBlock)) {
            return "";
        }
        IXXVMRegBlock register = (IXXVMRegBlock)dvtElementWrapper;
        String seqName = register.getSequencerName();
        String name = register.getName();
        if (this.isStatic()) {
            return name;
        }
        if (!register.isBlockRegisters() && (seqName == null || seqName.isEmpty())) {
            name = String.valueOf(name) + " [unmapped]";
        }
        return name;
    }

    default public boolean hasInterpreterFailed() {
        return false;
    }

    default public IViewPart getView() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return null;
        }
        IViewPart registersViewPart = activePage.findView("ro.amiq.dvt.ui.views.RegistersView");
        return registersViewPart;
    }

    default public boolean c(IProject project) {
        return DVTPlugin.getDefault().collect().c(project, "F7376");
    }

    default public void setHasInterpreterFailed(boolean isInterpreterProcessFailed) {
    }

    default public boolean isStatic() {
        return true;
    }

    default public GoToInfo computeGoToInfo(TreePath path) {
        return null;
    }

    @Override
    default public String getComment(Object wrapper) {
        return null;
    }

    @Override
    default public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        return new DVTXRegistersLabelProvider();
    }

    @Override
    default public boolean isSelectable(Object wrapper, Object referenceData, StringMatcher matcher) {
        return false;
    }

    @Override
    default public boolean adaptsTo(Object adapted) {
        return true;
    }

    @Override
    default public LanguageKind getLanguageKind() {
        return LanguageKind.VLOG;
    }

    public long getTotalRegisterCount();

    default public void addListener(DVTLazyView view) {
    }

    default public void cleanRegisterRoots() {
    }

    default public void clearStateListeners() {
    }
}

