/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.symbolcollector.ISymbolCollectorPrerequisite;
import ro.amiq.dvt.symbolcollector.SymbolCollectorConfigurator;
import ro.amiq.dvt.symbolcollector.SymbolQueryKey;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IMembersLabelProvider;
import ro.amiq.dvt.ui.views.lazy.views.types.ITypesViewContributor;
import ro.amiq.dvt.ui.views.lazy.views.types.TypesViewInput;
import ro.amiq.dvt.ui.views.lazy.views.types.TypesViewInputConfigurator;

public abstract class BaseTypesViewContributor
implements ITypesViewContributor {
    private IMembersLabelProvider fMembersLabelProvider;
    private DVTBaseLabelProvider fLabelProvider;

    protected BaseTypesViewContributor(DVTBaseLabelProvider typesViewLabelProvider, IMembersLabelProvider typesViewMembersLabelProvider) {
        this.fMembersLabelProvider = typesViewMembersLabelProvider;
        this.fLabelProvider = typesViewLabelProvider;
    }

    protected IRfNamedElement getNamedElement(Object wrapper) {
        if (!(wrapper instanceof IDVTElementWrapper)) {
            return null;
        }
        if (!(((IDVTElementWrapper)wrapper).getRfElement() instanceof IRfNamedElement)) {
            return null;
        }
        return (IRfNamedElement)((IDVTElementWrapper)wrapper).getRfElement();
    }

    @Override
    public String getComment(Object wrapper) {
        return this.getNamedElement(wrapper) == null ? "" : this.getNamedElement(wrapper).getComment();
    }

    @Override
    public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        return this.fLabelProvider;
    }

    @Override
    public IMembersLabelProvider getMembersViewLabelProvider() {
        return this.fMembersLabelProvider;
    }

    @Override
    public Comparator<IDVTElementWrapper> getMembersCategoryComparator() {
        return (o1, o2) -> {
            if (o1.getRfElement() instanceof IRfNamedElement && o2.getRfElement() instanceof IRfNamedElement) {
                IRfNamedElement ne1 = (IRfNamedElement)o1.getRfElement();
                IRfNamedElement ne2 = (IRfNamedElement)o2.getRfElement();
                return this.getKind(ne1).ordinal() - this.getKind(ne2).ordinal();
            }
            if (o1.getRfElement() instanceof IRfNamedElement) {
                return 1;
            }
            if (o2.getRfElement() instanceof IRfNamedElement) {
                return -1;
            }
            return 0;
        };
    }

    @Override
    public List<ISymbolCollectorPrerequisite> getSymbolsPrerequisites(SymbolCollectorConfigurator symbolConfigurator) {
        TypesViewInput input = this.getInput(new TypesViewInputConfigurator(symbolConfigurator));
        if (input == null) {
            return Collections.emptyList();
        }
        List<IDVTElementWrapper> elements = input.getElements();
        if (elements == null || elements.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<ISymbolCollectorPrerequisite>(elements);
    }

    protected final boolean shouldAddType(IDVTElementWrapper wrapper, TypesViewInputConfigurator configurator) {
        if (wrapper == null || configurator == null) {
            return false;
        }
        if (!configurator.isCollectingSymbols()) {
            return true;
        }
        if (!this.shouldCollectSymbol(wrapper, configurator.getSymbolConfigurator())) {
            return false;
        }
        configurator.countNewSymbol();
        return true;
    }

    @Override
    public boolean symbolMatchesQueryKey(ISymbolCollectorPrerequisite symbolPrerequisite, SymbolCollectorConfigurator configurator) {
        if (!(symbolPrerequisite instanceof IDVTElementWrapper) || configurator == null) {
            return false;
        }
        String queryKey = configurator.getQueryKey();
        if (queryKey.isEmpty()) {
            return true;
        }
        if (SymbolQueryKey.TYPE.isEqualTo(queryKey)) {
            return true;
        }
        Object element = ((IDVTElementWrapper)symbolPrerequisite).getRfElement();
        if (!(element instanceof IRfNamedElement)) {
            return false;
        }
        IRfNamedElement namedElement = (IRfNamedElement)element;
        if (namedElement instanceof IRfTypeAliasElement) {
            IRfKind rfKind = this.getKind(namedElement);
            if (rfKind == null) {
                return false;
            }
            if (SymbolQueryKey.symbolMatchesQueryKey(rfKind.getName(), queryKey)) {
                return true;
            }
            if ((namedElement = ((IRfTypeAliasElement)namedElement).getTranslatedType()) == null) {
                return false;
            }
        }
        return SymbolQueryKey.symbolMatchesQueryKey(namedElement.getKindName(), queryKey);
    }

    public abstract IRfKind getKind(String var1);

    protected abstract IRfKind getKind(IRfNamedElement var1);
}

