/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.types;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.DVTLabelProviderProxy;
import ro.amiq.dvt.ui.views.DVTLanguageElement;
import ro.amiq.dvt.ui.views.DVTViewContributors;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTModel;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeIteratorType;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeMessageCompositeType;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeAction;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSearchActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeUpdateViewActionArguments;
import ro.amiq.dvt.ui.views.lazy.views.quick.DVTQuickLazyView;
import ro.amiq.dvt.ui.views.lazy.views.types.ITypesViewContributor;
import ro.amiq.dvt.ui.views.lazy.views.types.SortByTypeAction;
import ro.amiq.dvt.ui.views.lazy.views.types.TypesModel;
import ro.amiq.dvt.ui.views.lazy.views.types.TypesTestUtils;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.Utils;

public class QuickTypesView
extends DVTQuickLazyView
implements IRfFilterableTreeAccessor {
    public static final String ID = "ro.amiq.dvt.ui.views.LazyQuickTypesView";
    public static final String TITLE = "Quick Types";
    private static final String DEFAULT_FILTER_HELPER_TEXT = "Filter by: type_name";
    private static final String INFO_TEXT = "Search patterns may contain: * = any string, ? = any character.";
    private DVTLabelProviderProxy<ITypesViewContributor> labelProvider = new DVTLabelProviderProxy<ITypesViewContributor>(ITypesViewContributor.class, "default-tree");
    private boolean hasGUIFilteredElements;
    private IDVTModel quickTypesModel;
    private final TypesTestUtils lazyTreeTestUtils = new TypesTestUtils(this);
    private SortByTypeAction sortByTypeAction = new SortByTypeAction(this);
    private List<ITypesViewContributor> allTypesContibutors = DVTViewContributors.getInstance().getAllInstanceOf(ITypesViewContributor.class);

    public QuickTypesView(Shell parent, IProject project) {
        super(parent, 48, project);
        this.quickTypesModel = new TypesModel(this.getLabelProvider(), this.getProject(), this.getStringMatcher("default-filter"), this, this.allTypesContibutors);
        this.setTextFilterMessage("default-filter", DEFAULT_FILTER_HELPER_TEXT);
    }

    @Override
    protected String getId() {
        return ID;
    }

    @Override
    public LazyTreeIteratorType getIteratorType() {
        return LazyTreeIteratorType.QUICK_TYPES_VIEW;
    }

    @Override
    public Objection getObjection() {
        return Objection.QUICK_TYPES_VIEW;
    }

    @Override
    public TypesTestUtils getLazyTreeTestUtils() {
        return this.lazyTreeTestUtils;
    }

    @Override
    public boolean supportsDecorations() {
        return true;
    }

    @Override
    protected String getTitle() {
        return String.valueOf(this.hasGUIFilteredElements ? "*" : "") + TITLE + (this.project != null ? " [" + this.project.getName() + "]" : "");
    }

    @Override
    public DVTBaseLabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new DVTLabelProviderProxy<ITypesViewContributor>(ITypesViewContributor.class, "default-tree");
        }
        return this.labelProvider;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public IDVTModel getModel(Class<? extends IDVTModel> modelClass) {
        return this.quickTypesModel;
    }

    @Override
    public String getMessageText() {
        if (this.getProject() == null || !this.getProject().isAccessible() || !Utils.hasDvtNature(this.getProject())) {
            return "Select a DVT Project or file.";
        }
        if (!this.getTextFilterObject("default-filter").getTextFilterText().isEmpty()) {
            if (this.quickTypesModel == null) {
                return LazyTreeMessageCompositeType.NO_DATA.getMessage();
            }
            if (((TypesModel)this.quickTypesModel).isSearchedElementFiltered()) {
                return LazyTreeMessageCompositeType.GUI_FILTERED.getMessage();
            }
            return LazyTreeMessageCompositeType.NO_MATCHES_FOUND.getMessage();
        }
        if (((TypesModel)this.quickTypesModel).hasGUIFilteredElements()) {
            return LazyTreeMessageCompositeType.GUI_FILTERED.getMessage();
        }
        return LazyTreeMessageCompositeType.NO_DATA.getMessage();
    }

    @Override
    public void setCancelActionEnabled(boolean enabled) {
    }

    @Override
    public void setInput(Object information) {
        try {
            if (!DVTPlugin.getDefault().collect().c(this.project, "F636F7265")) {
                return;
            }
            this.getShell().setText(this.getTitle());
            this.setTitleText(this.getTitle());
            this.setInfoText(INFO_TEXT);
            if (this.quickTypesModel == null) {
                this.quickTypesModel = new TypesModel(this.getLabelProvider(), this.getProject(), this.getStringMatcher("default-filter"), this, this.allTypesContibutors);
            }
            this.update();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void update() {
        try {
            LazyTree lazyTree = this.getLazyTree();
            lazyTree.doAction(LazyTreeAction.UPDATE_VIEW, new LazyTreeUpdateViewActionArguments(this, this.quickTypesModel, true, false, false, Objection.QUICK_TYPES_VIEW));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected void fillDialogMenu(IMenuManager viewMenu) {
        super.fillDialogMenu(viewMenu);
        viewMenu.add((IContributionItem)new Separator("Sorters"));
        viewMenu.add((IAction)this.sortByTypeAction);
    }

    @Override
    public void stringMatcherUpdated(String uIJobTextFilterId) {
        this.getLazyTree().setSearchBar(this.getTextFilterObject("default-filter"));
        this.getLazyTree().doAction(LazyTreeAction.SEARCH, new LazyTreeSearchActionArguments(true, true, this.quickTypesModel, Objection.QUICK_TYPES_VIEW));
    }

    @Override
    protected void gotoSelectedElement() {
        if (this.project == null) {
            return;
        }
        TreePath selectedPath = this.getSelectedPath();
        if (selectedPath == null) {
            return;
        }
        this.goToElement(selectedPath);
    }

    @Override
    protected void goToElement(TreePath selectedPath) {
        try {
            Object selectedElement = selectedPath.getElement();
            if (!(selectedElement instanceof IDVTElementWrapper)) {
                return;
            }
            IDVTElementWrapper selectedWrapper = (IDVTElementWrapper)selectedElement;
            this.setDataForPathManager(selectedWrapper);
            RfMixedLangManager.getInstance().gotoElement(this.getProject(), selectedWrapper);
            Object element = selectedWrapper.getRfElement();
            if (!(element instanceof DVTLanguageElement) && !(element instanceof String)) {
                this.close();
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void setDataForPathManager(IDVTElementWrapper wrapper) throws CoreException {
        if (wrapper == null) {
            return;
        }
        Object element = wrapper.getRfElement();
        if (!(element instanceof IRfNamedElement)) {
            return;
        }
        IRfDefElement declaration = ((IRfNamedElement)element).getDeclaration();
        if (declaration == null) {
            return;
        }
        IRfFileDef fileDef = declaration.getDefFile();
        if (fileDef == null) {
            return;
        }
        IResource file = (IResource)fileDef.getAdapter(IResource.class);
        if (file == null) {
            return;
        }
        file.setSessionProperty(IDVTConstants.FILE_INSTANCE_QN, (Object)wrapper);
    }

    @Override
    public ILabelProvider getTreeLabelProvider() {
        return this.getLabelProvider();
    }

    @Override
    public StringMatcher[] getTreeSearchSegments() {
        return this.getSearchSegments("default-filter");
    }

    @Override
    public boolean[] getTreeSearchStrictness() {
        return this.getSearchStrictness("default-filter");
    }

    @Override
    public String getTreeSearchPort() {
        return null;
    }

    @Override
    public List<String> getMemberNames(IDVTElementWrapper node) {
        return null;
    }

    @Override
    public boolean isFiltered() {
        return this.hasGUIFilteredElements;
    }

    @Override
    public UpdateJob getUpdateJob() {
        return null;
    }
}

