/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchPartSite;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfDummyElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.startup.core.EclipseUtils;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.AbstractFilteredView;
import ro.amiq.dvt.ui.views.BasicElementWrapper;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.DVTLanguageElement;
import ro.amiq.dvt.ui.views.DVTMembersViewContentProvider;
import ro.amiq.dvt.ui.views.DVTRfLabelProvider;
import ro.amiq.dvt.ui.views.DVTViewManager;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IMembersLabelProvider;
import ro.amiq.dvt.ui.views.MembersViewInput;
import ro.amiq.dvt.ui.views.SortKind;
import ro.amiq.dvt.ui.views.TreeViewContentProvider;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.comparators.LabelProviderWrapperComparator;
import ro.amiq.dvt.ui.views.comparators.PromoteComparator;
import ro.amiq.dvt.ui.views.inspect.InspectViewSelectionListener;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTModel;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.views.types.TypesMembersViewCommon;
import ro.amiq.dvt.ui.views.lazy.views.types.TypesModel;
import ro.amiq.dvt.ui.views.lazy.views.types.TypesView;
import ro.amiq.dvt.utils.CompositeComparator;
import ro.amiq.dvt.utils.StringMatcher;

public class TypesMembersView
extends TypesMembersViewCommon {
    private TableViewer table;
    private IMembersLabelProvider defaultLabelProvider = new DVTRfLabelProvider();
    private IMembersLabelProvider tableLabelProvider;
    private TypesView lazyView;
    private IDVTElementWrapper selectedWrapperPath;
    private StringMatcher memberToPromote;
    private IRfNamedElement selectedElement;
    private Label infoLabel;
    private SortKind sortKind;
    private Label contentFiltersLabel;
    private Image contentFiltersEnabledIcon = DVTImages.imageCache.getImage(DVTImages.GUI_FILTERS_ICON_MINI);
    private Image contentFiltersDisabledIcon = DVTImages.imageCache.getImage(DVTImages.GUI_FILTERS_ICON_MINI_DISABLED);
    private boolean hasGUIFilteredElements;
    private TreePath lastSelectedPath;

    public TypesMembersView(TypesView provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.valueOf(TypesMembersView.class.getName()) + " requires non-null " + TypesView.class.getName());
        }
        this.lazyView = provider;
    }

    public Objection getObjection() {
        return Objection.TYPES_MEMBERS_VIEW;
    }

    @Override
    public Control getControlToColorBg() {
        return null;
    }

    @Override
    public Control getControlToColorFg() {
        return null;
    }

    @Override
    public void clean() {
        this.cleanView(true);
    }

    @Override
    public void refreshSelection(IResource resource) {
    }

    @Override
    public TreeViewContentProvider getExpandableContentProvider() {
        return null;
    }

    @Override
    public void gotoSelectedElement(String treeId) {
        IDVTElementWrapper wrapper = this.getSelectedWrapper(null);
        wrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.MEMBER_PARENT_WRAPPER, this.selectedElement);
        RfMixedLangManager.getInstance().gotoSelectedMember(this.lazyView.getProject(), wrapper);
    }

    @Override
    public IDVTElementWrapper getSelectedWrapper(String treeId) {
        StructuredSelection selection = (StructuredSelection)this.getSelection(treeId);
        if (selection == null || selection.size() != 1) {
            return null;
        }
        Object elem = selection.getFirstElement();
        if (!(elem instanceof IDVTElementWrapper)) {
            return null;
        }
        return (IDVTElementWrapper)elem;
    }

    @Override
    public ISelection getSelection(String treeId) {
        return this.getSelection();
    }

    @Override
    public ISelection getSelection() {
        if (this.table == null || this.table.getControl() == null || this.table.getControl().isDisposed()) {
            return null;
        }
        return this.table.getSelection();
    }

    @Override
    public void stringMatcherUpdated(String textFilterId) {
        this.showFilteredPorts(this.lastSelectedPath);
    }

    @Override
    public Tree getTree(String treeId) {
        return null;
    }

    @Override
    public Object getTreeRootElement(String treeId) {
        return null;
    }

    public Control getControl() {
        if (this.table == null) {
            return null;
        }
        return this.table.getControl();
    }

    public boolean isFocused() {
        if (this.getControl() == null) {
            return false;
        }
        return this.getControl().isFocusControl();
    }

    public Label getContentFilteredIndication() {
        return this.contentFiltersLabel;
    }

    public Label getInfoLabel() {
        return this.infoLabel;
    }

    public List<?> testGetMembers() {
        List input = (List)this.table.getInput();
        ArrayList<IRfNamedElement> ports = new ArrayList<IRfNamedElement>();
        for (Object obj : input) {
            Object elem;
            if (!(obj instanceof IDVTElementWrapper) || !((elem = ((IDVTElementWrapper)obj).getRfElement()) instanceof IRfNamedElement)) continue;
            ports.add((IRfNamedElement)elem);
        }
        return ports;
    }

    @Override
    public void update(BuildEvents updateEvent) {
        TypesView typesView = this.lazyView;
        if (typesView == null) {
            return;
        }
        TreePath element = typesView.getLazyTree().getSelection();
        this.updatePortsUsingTreePath(element, typesView.getTreeSearchPort());
        IDVTModel model = typesView.getModel(TypesModel.class);
        if (!(model instanceof TypesModel)) {
            return;
        }
        boolean bl = this.hasGUIFilteredElements = this.hasGUIFilteredElements || ((TypesModel)model).hasGUIFilteredElements();
        if (EclipseUtils.isAtLeastEclipse419()) {
            this.contentFiltersLabel.setImage(DVTImages.imageCache.getImage(this.hasGUIFilteredElements ? DVTImages.GUI_FILTERS_ICON_MINI : DVTImages.GUI_FILTERS_ICON_MINI_DISABLED));
        }
        this.contentFiltersLabel.setEnabled(this.hasGUIFilteredElements);
    }

    public void setFocus() {
        Control control = this.getControl();
        if (control != null) {
            control.setFocus();
        }
    }

    @Override
    public void dispose() {
        DVTViewManager.getInstanceByCurrentWorkbenchWindow().unregisterView(this);
        this.fDataContainer = null;
        this.removeSelectionChangedListener(InspectViewSelectionListener.getInstance());
        DVTViewManager.getInstanceByCurrentWorkbenchWindow().unregisterView(this);
        DVTPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    public void cleanView(boolean showEmptyMessage) {
        this.selectedWrapperPath = null;
        this.selectedElement = null;
        this.lastSelectedPath = null;
        this.memberToPromote = null;
        if (this.tableLabelProvider != null) {
            this.tableLabelProvider.setBoldMatcher(this.memberToPromote);
        }
        this.hasGUIFilteredElements = false;
        if (this.contentFiltersLabel != null && !this.contentFiltersLabel.isDisposed()) {
            this.contentFiltersLabel.setEnabled(false);
        }
        if (this.infoLabel != null && !this.infoLabel.isDisposed()) {
            this.infoLabel.setText("");
        }
        if (this.table == null || this.table.getControl() == null || this.table.getControl().isDisposed()) {
            return;
        }
        boolean noMatchesFound = this.isFiltered();
        List elements = this.getHelpMsg();
        if (!showEmptyMessage) {
            elements = new ArrayList<IDVTElementWrapper>();
        }
        if (noMatchesFound) {
            elements = NO_MATCHES_FOUND;
        }
        if (this.table == null || this.table.getControl() == null || this.table.getControl().isDisposed()) {
            return;
        }
        this.table.setInput((Object)elements);
        this.table.setSelection(null);
    }

    @Override
    public void customCreatePartControl(Composite parent) {
        Composite labelComposite = new Composite(parent, 0);
        GridLayout labelLayout = new GridLayout(2, false);
        labelComposite.setLayout((Layout)labelLayout);
        labelComposite.setLayoutData((Object)new GridData(4, 1, false, false));
        this.contentFiltersLabel = new Label(labelComposite, 0);
        if (EclipseUtils.isAtLeastEclipse419()) {
            this.contentFiltersLabel.setImage(DVTImages.imageCache.getImage(this.hasGUIFilteredElements ? DVTImages.GUI_FILTERS_ICON_MINI : DVTImages.GUI_FILTERS_ICON_MINI_DISABLED));
        } else {
            this.contentFiltersLabel.setImage(DVTImages.imageCache.getImage(DVTImages.GUI_FILTERS_ICON_MINI));
        }
        this.contentFiltersLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.contentFiltersLabel.setToolTipText("Content Filters matched!");
        this.contentFiltersLabel.setEnabled(this.hasGUIFilteredElements);
        this.infoLabel = new Label(labelComposite, 0);
        this.infoLabel.setFont(labelComposite.getFont());
        this.infoLabel.setLayoutData((Object)new GridData(768));
        this.createTextFilter("default-filter", parent, "default-tree", false);
        this.setTextFilterMessage("default-filter", "Filter by: name");
        Composite tableComposite = new Composite(parent, 0);
        GridData compositeGridData = new GridData(1808);
        tableComposite.setLayoutData((Object)compositeGridData);
        tableComposite.setLayout((Layout)new FillLayout(256));
        this.table = new TableViewer(tableComposite, 268436228);
        this.table.setContentProvider((IContentProvider)new DVTMembersViewContentProvider());
        this.tableLabelProvider = this.defaultLabelProvider;
        this.table.setLabelProvider((IBaseLabelProvider)this.tableLabelProvider);
        this.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Object source = e.getSource();
                if (source instanceof Table) {
                    TypesMembersView.this.setFocus();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                TypesMembersView.this.gotoSelectedElement("default-tree");
            }
        });
        this.getControl().addKeyListener((KeyListener)this.getKeyListener("default-filter", "default-tree"));
        this.installContextMenuAndSelectionListener((Control)this.table.getTable());
    }

    public Control getTable() {
        return this.table.getControl();
    }

    private List<IDVTElementWrapper> getHelpMsg() {
        return Arrays.asList(new BasicElementWrapper("Select an element in the"), new BasicElementWrapper("Types View"), new BasicElementWrapper("to see its members."));
    }

    public void setSortKind() {
        this.sortKind = PrefConst.getTypesViewSortByType() ? SortKind.CATEGORY : SortKind.ALPHABETICAL;
    }

    public void initAndShow(Composite parent, String filterText) {
        this.setSite((IWorkbenchPartSite)this.lazyView.getViewSite());
        this.setSelectionChangedListeners(this.lazyView.getSelectionChangedListeners());
        this.createPartControl(parent);
        if (filterText != null && !filterText.isEmpty()) {
            this.initTextFilterSilent("default-filter", filterText);
        }
    }

    public void updatePortsUsingTreePath(TreePath path, String portToPromote) {
        if (path == null || !(path.getElement() instanceof IRfNamedElement) && !(path.getElement() instanceof IDVTElementWrapper)) {
            this.cleanView(true);
            ObjectionManager.getInstance().clearForMembers(this);
            return;
        }
        if (path.equals(this.lastSelectedPath)) {
            ObjectionManager.getInstance().clearForMembers(this);
            return;
        }
        Object element = null;
        if (path.getElement() instanceof IDVTElementWrapper) {
            this.selectedWrapperPath = (IDVTElementWrapper)path.getElement();
            element = ((IDVTElementWrapper)path.getElement()).getRfElement();
        }
        this.memberToPromote = portToPromote == null ? null : ViewsUtils.createCamelCaseOrRegexMatcher(portToPromote, true, false);
        this.tableLabelProvider.setBoldMatcher(this.memberToPromote);
        IRfNamedElement iRfNamedElement = this.selectedElement = element instanceof IRfNamedElement ? (IRfNamedElement)element : null;
        if (this.selectedElement instanceof RfDummyElement) {
            this.selectedElement = null;
        }
        this.setSortKind();
        this.tableLabelProvider = this.getCurrentTableLabelProvider(this.selectedWrapperPath);
        this.showFilteredPorts(path);
    }

    private void showFilteredPorts(TreePath selectionPath) {
        this.tableLabelProvider.setBoldMatcher(this.memberToPromote);
        this.table.setLabelProvider((IBaseLabelProvider)this.tableLabelProvider);
        MembersViewInput input = RfMixedLangManager.getInstance().getMembersInput(this.lazyView.getProject(), this.selectedWrapperPath, this.getStringMatcher("default-filter"), this.getCurrentTableLabelProvider(this.selectedWrapperPath), true);
        this.lastSelectedPath = selectionPath;
        if (input == null) {
            return;
        }
        List<Object> elements = input.getElements();
        if (elements == null) {
            elements = Collections.emptyList();
        }
        if (this.infoLabel != null) {
            this.infoLabel.setText("");
            DVTBaseLabelProvider elementLabelProvider = (DVTBaseLabelProvider)this.lazyView.getLabelProvider();
            if (!(this.selectedWrapperPath.getRfElement() instanceof DVTLanguageElement) && elementLabelProvider != null) {
                int nofMembers = elements.size();
                String elementLabel = elementLabelProvider.getText(this.selectedWrapperPath);
                String members = ViewsUtils.getUnitName("member", nofMembers, " ", "");
                this.infoLabel.setText(String.valueOf(elementLabel) + " [" + nofMembers + members + "]");
            }
        }
        CompositeComparator<IDVTElementWrapper> compositeComparator = new CompositeComparator<IDVTElementWrapper>();
        if (this.memberToPromote != null) {
            compositeComparator.add(new PromoteComparator(this.memberToPromote, this.tableLabelProvider));
        }
        if (this.sortKind == SortKind.ALPHABETICAL) {
            compositeComparator.add(new LabelProviderWrapperComparator(this.tableLabelProvider, true));
        } else if (this.sortKind == SortKind.CATEGORY) {
            compositeComparator.add(RfMixedLangManager.getInstance().getMembersCategoryComparator(this.lazyView.getProject(), this.selectedWrapperPath));
            compositeComparator.add(new LabelProviderWrapperComparator(this.tableLabelProvider, true));
        }
        Collections.sort(elements, compositeComparator);
        if (this.contentFiltersLabel != null) {
            if (EclipseUtils.isAtLeastEclipse419()) {
                this.contentFiltersLabel.setImage(input.isContentFiltered() ? this.contentFiltersEnabledIcon : this.contentFiltersDisabledIcon);
            }
            this.contentFiltersLabel.setEnabled(input.isContentFiltered());
        }
        if (elements.isEmpty()) {
            elements = this.selectedWrapperPath.getRfElement() instanceof DVTLanguageElement ? this.getHelpMsg() : (this.isFiltered() ? NO_MATCHES_FOUND : (input.isContentFiltered() ? AbstractFilteredView.GUI_FILTERED_EMPTY_CONTENT : Arrays.asList(new BasicElementWrapper("No members."))));
        }
        this.table.setInput(elements);
        this.table.setSelection(null);
        ObjectionManager.getInstance().clearForMembers(this);
    }

    public IMembersLabelProvider getCurrentTableLabelProvider(IDVTElementWrapper node) {
        IProject project = this.lazyView.getProject();
        this.tableLabelProvider = RfMixedLangManager.getInstance().getMembersLabelProvider(project, node);
        if (this.tableLabelProvider == null) {
            this.tableLabelProvider = new DVTRfLabelProvider();
        }
        return this.tableLabelProvider;
    }
}

