/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.DVTLanguageElement;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.lazy.tree.DVTModelEvent;
import ro.amiq.dvt.ui.views.lazy.tree.DVTModelEventType;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTModelStateListener;
import ro.amiq.dvt.ui.views.lazy.tree.IModel;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.views.types.ITypesViewContributor;
import ro.amiq.dvt.ui.views.lazy.views.types.TypesViewInput;
import ro.amiq.dvt.ui.views.lazy.views.types.TypesViewInputConfigurator;
import ro.amiq.dvt.utils.StringMatcher;

public class TypesModel
implements IModel {
    public static final Comparator<TreePath> indexComparator = (o1, o2) -> {
        if (o1 == null || o2 == null) {
            return 0;
        }
        if (TreePath.isParent(o1, o2)) {
            return -1;
        }
        if (TreePath.isParent(o2, o1)) {
            return 1;
        }
        Object wr1 = o1.getElement();
        Object wr2 = o2.getElement();
        if (!(wr1 instanceof IDVTElementWrapper) || !(wr2 instanceof IDVTElementWrapper)) {
            return -1;
        }
        Object index1 = ((IDVTElementWrapper)wr1).getAdditionalInfo((Object)IDVTElementWrapper.Attribute.TYPES_INDEX);
        Object index2 = ((IDVTElementWrapper)wr2).getAdditionalInfo((Object)IDVTElementWrapper.Attribute.TYPES_INDEX);
        if (index1 instanceof Integer && index2 instanceof Integer) {
            return (Integer)index1 - (Integer)index2;
        }
        return -1;
    };
    private DVTBaseLabelProvider labelProvider;
    private List<IDVTElementWrapper> allElements;
    private int totalTypeCount;
    private int matchedTypeCount;
    private boolean hasGUIFilteredElements;
    private boolean searchedElementFiltered;
    private IProject project;
    private StringMatcher stringMatcher;
    private IRfFilterableTreeAccessor lazyView;
    private List<ITypesViewContributor> allTypesContibutors;
    private List<IDVTModelStateListener> fStateListeners = new ArrayList<IDVTModelStateListener>();

    public TypesModel(DVTBaseLabelProvider labelProvider, IProject project, StringMatcher stringMatcher, IRfFilterableTreeAccessor lazyView, List<ITypesViewContributor> fAllTypesContibutors) {
        this.labelProvider = labelProvider;
        this.project = project;
        this.stringMatcher = stringMatcher;
        this.lazyView = lazyView;
        this.totalTypeCount = 0;
        this.matchedTypeCount = 0;
        this.allTypesContibutors = fAllTypesContibutors;
    }

    @Override
    public List<TreePath> getChildren(TreePath segments, int childStartIndex, int childEndIndex, IProgressMonitor monitor) {
        return this.getChildrenInternal(segments, childStartIndex, childEndIndex, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<TreePath> getChildrenInternal(TreePath treePath, int startIndex, int endIndex, IProgressMonitor monitor) {
        try {
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            if (this.project == null || treePath == null) {
                return Collections.emptyList();
            }
            TypesModel typesModel = this;
            synchronized (typesModel) {
                if (this.allElements == null || this.allElements.isEmpty()) {
                    this.allElements = this.computeAllElements(monitor);
                }
            }
            if (this.allElements == null || this.allElements.isEmpty()) {
                return null;
            }
            List<Object> elements = new ArrayList();
            ArrayList<TreePath> result = new ArrayList<TreePath>();
            if (treePath == TreePath.TOP_DUMMY_TREE_PATH) {
                elements = this.allElements;
            } else if (treePath.getElement() instanceof IDVTElementWrapper) {
                if (monitor.isCanceled()) {
                    return null;
                }
                Object element = treePath.getElement();
                List children = ((IDVTElementWrapper)element).getChildren();
                if (children == null || children.isEmpty()) {
                    return null;
                }
                elements.addAll(children);
            }
            if (elements == null || elements.isEmpty()) {
                return null;
            }
            if (startIndex >= elements.size()) {
                return null;
            }
            int i = startIndex;
            while (true) {
                TreePath prevChild;
                DVTLanguageElement dvtLanguageElement;
                String langElementInfo;
                int bracketIndex;
                if (i >= Math.min(endIndex, elements.size())) {
                    return result;
                }
                if (monitor.isCanceled()) {
                    return Collections.emptyList();
                }
                IDVTElementWrapper dvtElementWrapper = (IDVTElementWrapper)elements.get(i);
                String text = this.labelProvider.getText(dvtElementWrapper);
                if (dvtElementWrapper.getRfElement() instanceof DVTLanguageElement && (bracketIndex = (langElementInfo = (dvtLanguageElement = (DVTLanguageElement)dvtElementWrapper.getRfElement()).getInfo() instanceof String ? (String)dvtLanguageElement.getInfo() : "").indexOf("[")) >= 0) {
                    text = langElementInfo.substring(0, bracketIndex).trim();
                }
                TreePath child = TreePath.child(treePath, text, i, indexComparator);
                dvtElementWrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.TREE_PATH, child);
                child.setElement(dvtElementWrapper);
                TreePath treePath2 = prevChild = result.isEmpty() ? null : (TreePath)result.get(result.size() - 1);
                if (child.equals(prevChild, true)) {
                    child.append("@(" + i + ")@");
                }
                result.add(child);
                ++i;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public Boolean hasChildren(TreePath treePath, IProgressMonitor monitor) {
        List<TreePath> children = this.getChildrenInternal(treePath, 0, 1, monitor);
        if (children != null && !children.isEmpty()) {
            return true;
        }
        return false;
    }

    @Override
    public TreePath getLastChild(TreePath treePath, IProgressMonitor monitor) {
        List<TreePath> children = this.getChildren(treePath, 0, Integer.MAX_VALUE, monitor);
        return children == null || children.isEmpty() ? null : children.get(children.size() - 1);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public TreePath getEndTreePath(TreePath path, IProgressMonitor monitor) {
        currentPath = path;
        children = this.getChildren(currentPath, 0, 0x7FFFFFFF, monitor);
        if (children != null && !children.isEmpty()) ** GOTO lbl7
        return currentPath;
lbl-1000:
        // 1 sources

        {
            currentPath = children.get(children.size() - 1);
            children = this.getChildren(currentPath, 0, 0x7FFFFFFF, monitor);
lbl7:
            // 2 sources

            ** while (children != null && !children.isEmpty())
        }
lbl8:
        // 1 sources

        return currentPath;
    }

    private synchronized List<IDVTElementWrapper> computeAllElements(IProgressMonitor monitor) {
        try {
            this.hasGUIFilteredElements = false;
            this.searchedElementFiltered = false;
            ArrayList<IDVTElementWrapper> elements = new ArrayList<IDVTElementWrapper>();
            this.resetElementCount();
            for (ITypesViewContributor typesViewContentProvider : this.allTypesContibutors) {
                TypesViewInput input;
                if (typesViewContentProvider == null || (input = typesViewContentProvider.getInput(new TypesViewInputConfigurator(this.lazyView, this.project, this.stringMatcher, PrefConst.getTypesViewSortByType(), ViewsUtils.hasMoreThanOneDVTNature(this.project), true, monitor))) == null) continue;
                if (monitor.isCanceled()) {
                    this.notifyStateListeners(new DVTModelEvent(DVTModelEventType.MODEL_COMPUTING_CANCELED));
                    return elements;
                }
                List<IDVTElementWrapper> origElems = input.getElements();
                if (origElems == null) continue;
                elements.addAll(origElems);
                this.totalTypeCount += input.getNrTypes() >= 0 ? input.getNrTypes() : 0;
                this.matchedTypeCount += input.getNrMatchedTypes() >= 0 ? input.getNrMatchedTypes() : 0;
                this.hasGUIFilteredElements = this.hasGUIFilteredElements || input.hasGUIFilteredElements();
                boolean bl = this.searchedElementFiltered = this.searchedElementFiltered || input.isSearchedElementFiltered();
            }
            this.updateWrapperIndexMetaInfo(elements, new AtomicInteger(0), monitor);
            this.notifyStateListeners(new DVTModelEvent(DVTModelEventType.MODEL_COMPUTING_DONE));
            return elements;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            this.notifyStateListeners(new DVTModelEvent(DVTModelEventType.MODEL_COMPUTING_DONE));
            return null;
        }
    }

    private void updateWrapperIndexMetaInfo(List<IDVTElementWrapper> elements, AtomicInteger index, IProgressMonitor monitor) {
        ArrayList<IDVTElementWrapper> elementsCopy = new ArrayList<IDVTElementWrapper>();
        elementsCopy.addAll(elements);
        for (IDVTElementWrapper element : elementsCopy) {
            if (element == null) continue;
            if (monitor.isCanceled()) {
                return;
            }
            element.setAdditionalInfo(IDVTElementWrapper.Attribute.TYPES_INDEX, index.getAndIncrement());
            List<IDVTElementWrapper> children = element.getChildren();
            if (children == null) continue;
            this.updateWrapperIndexMetaInfo(children, index, monitor);
        }
    }

    @Override
    public void resetModel(IProgressMonitor monitor) {
        if (this.allElements != null) {
            this.allElements.clear();
        }
    }

    private void resetElementCount() {
        this.allElements = null;
        this.totalTypeCount = 0;
        this.matchedTypeCount = 0;
    }

    public List<IDVTElementWrapper> testGetRoots() {
        if (this.allElements == null || this.allElements.isEmpty()) {
            this.resetElementCount();
            this.allElements = this.computeAllElements((IProgressMonitor)new NullProgressMonitor());
        }
        return this.allElements;
    }

    public int getElementCount() {
        return this.totalTypeCount;
    }

    public int getNotFilteredElementCount() {
        return this.matchedTypeCount;
    }

    public boolean hasGUIFilteredElements() {
        return this.hasGUIFilteredElements;
    }

    public boolean isSearchedElementFiltered() {
        return this.searchedElementFiltered;
    }

    public void addStateListener(IDVTModelStateListener l) {
        this.fStateListeners.add(l);
    }

    @Override
    public void notifyStateListeners(DVTModelEvent event) {
        for (IDVTModelStateListener l : this.fStateListeners) {
            l.stateChanged(event);
        }
    }

    public void clearStateListeners() {
        this.fStateListeners.clear();
    }

    @Override
    public void clearModelCaches() {
        this.resetModel((IProgressMonitor)new NullProgressMonitor());
    }
}

