/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.types;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import ro.amiq.dvt.test.ForTestingOrDebuggingOnly;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.DVTSyntheticEvent;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.utils.ILazyTreeTestUtils;
import ro.amiq.dvt.ui.views.lazy.views.IDVTLazyView;
import ro.amiq.dvt.ui.views.lazy.views.types.QuickTypesView;
import ro.amiq.dvt.ui.views.lazy.views.types.TypesMembersView;
import ro.amiq.dvt.ui.views.lazy.views.types.TypesView;
import ro.amiq.dvt.utils.DVTStringUtil;

@ForTestingOrDebuggingOnly
public class TypesTestUtils
implements ILazyTreeTestUtils {
    private IDVTLazyView lazyView;
    private boolean doSelectionInView;

    public TypesTestUtils(IDVTLazyView lazyView) {
        this.lazyView = lazyView;
    }

    public List<TreePath> getViewContent() {
        return this.getLazyTree().getViewContent();
    }

    @Override
    public LazyTree getLazyTree() {
        if (this.lazyView instanceof TypesView) {
            return ((TypesView)this.lazyView).getLazyTree();
        }
        if (this.lazyView instanceof QuickTypesView) {
            return ((QuickTypesView)this.lazyView).getLazyTree();
        }
        return null;
    }

    public TypesMembersView getMembersView() {
        if (!(this.lazyView instanceof TypesView)) {
            return null;
        }
        return ((TypesView)this.lazyView).getMembersView();
    }

    public List<IDVTElementWrapper> getTreeRoots() {
        if (!(this.lazyView instanceof TypesView)) {
            return null;
        }
        return ((TypesView)this.lazyView).getTreeRoots();
    }

    public DVTBaseLabelProvider getTreeLabelProvider() {
        if (!(this.lazyView instanceof TypesView)) {
            return null;
        }
        TypesView lazyTypesView = (TypesView)this.lazyView;
        if (!(lazyTypesView.getLabelProvider() instanceof DVTBaseLabelProvider)) {
            return null;
        }
        return (DVTBaseLabelProvider)lazyTypesView.getLabelProvider();
    }

    public Text getTextFilter(String filterId) {
        if (this.lazyView instanceof TypesView) {
            return ((TypesView)this.lazyView).getTextFilter(filterId);
        }
        if (this.lazyView instanceof QuickTypesView) {
            return ((QuickTypesView)this.lazyView).getTextFilterObject(filterId).getTextFilter();
        }
        return null;
    }

    public int getNofTypes() {
        if (!(this.lazyView instanceof TypesView)) {
            return -1;
        }
        return ((TypesView)this.lazyView).getNofTypes();
    }

    public List<?> testHelpGetMembers() {
        TypesMembersView membersView = this.getMembersView();
        if (membersView == null) {
            return null;
        }
        return membersView.testGetMembers();
    }

    @Override
    public IDVTLazyView getLazyView() {
        return this.lazyView;
    }

    public Control getControlParent() {
        if (!(this.lazyView instanceof TypesView)) {
            return null;
        }
        return ((TypesView)this.lazyView).getControlParent();
    }

    public Label getInfoLabel() {
        if (!(this.lazyView instanceof TypesView)) {
            return null;
        }
        return ((TypesView)this.lazyView).getInfoLabel();
    }

    public Label getMembersInfoLabel() {
        TypesMembersView membersView = this.getMembersView();
        if (membersView == null) {
            return null;
        }
        return membersView.getInfoLabel();
    }

    @Override
    public Objection getObjection() {
        if (this.lazyView instanceof QuickTypesView) {
            return Objection.QUICK_TYPES_VIEW;
        }
        return Objection.TYPES;
    }

    public Action getMembersViewAction() {
        if (!(this.lazyView instanceof TypesView)) {
            return null;
        }
        return ((TypesView)this.lazyView).getMembersViewAction();
    }

    public Label getContentFilteredIndication() {
        if (!(this.lazyView instanceof TypesView)) {
            return null;
        }
        return ((TypesView)this.lazyView).getContentFilteredIndication();
    }

    public Label getMembersContentFilteredIndication() {
        TypesMembersView membersView = this.getMembersView();
        if (membersView == null) {
            return null;
        }
        return membersView.getContentFilteredIndication();
    }

    public Control getMembersTable() {
        TypesMembersView membersView = this.getMembersView();
        if (membersView == null) {
            return null;
        }
        return membersView.getTable();
    }

    private Tree getViewTree() {
        return this.getLazyTree().getTree();
    }

    public boolean selectInView(String searchedElement) {
        TreePath searchedPath = null;
        for (TreePath path : this.getViewContent()) {
            String instanceName = path.getLastSegment();
            if (instanceName == null || !instanceName.equals(searchedElement)) continue;
            searchedPath = path;
            break;
        }
        if (searchedPath == null) {
            throw new RuntimeException("Unable to select non-existing node " + searchedElement);
        }
        Tree typesTree = this.getViewTree();
        if (typesTree == null) {
            return false;
        }
        TreeItem[] treeItems = typesTree.getItems();
        TreeItem selection = null;
        String[] stringArray = searchedPath.getSegments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            selection = null;
            TreeItem[] treeItemArray = treeItems;
            int n3 = treeItems.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem candidate = treeItemArray[n4];
                Object data = candidate.getData();
                if (!(data instanceof TreePath)) {
                    return false;
                }
                if (((TreePath)data).getLastSegment().equals(segment)) {
                    treeItems = candidate.getItems();
                    selection = candidate;
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        if (selection == null) {
            throw new RuntimeException("Unable to select non-existing node " + DVTStringUtil.join(searchedPath.getSegments(), "/"));
        }
        typesTree.setSelection(selection);
        this.testSetSelection(searchedPath);
        typesTree.showSelection();
        typesTree.notifyListeners(13, (Event)new DVTSyntheticEvent(true));
        return true;
    }

    @Override
    public boolean selectInLazyTree(String searchedElement, int num) {
        if (this.doSelectionInView) {
            return this.selectInView(searchedElement);
        }
        ILabelProvider labelProvider = this.getLazyTree().getLabelProvider();
        List<IDVTElementWrapper> elements = this.getTreeRoots();
        if (elements == null) {
            return false;
        }
        IDVTElementWrapper searchedPath = null;
        LinkedList<IDVTElementWrapper> treeItems = new LinkedList<IDVTElementWrapper>();
        treeItems.addAll(elements);
        while (!treeItems.isEmpty()) {
            IDVTElementWrapper candidate = (IDVTElementWrapper)treeItems.poll();
            if (candidate == null) break;
            String instanceName = labelProvider.getText((Object)candidate);
            if (instanceName != null && instanceName.equals(searchedElement)) {
                searchedPath = candidate;
                break;
            }
            if (!candidate.hasChildren()) continue;
            treeItems.addAll(candidate.getChildren());
        }
        if (searchedPath == null) {
            throw new RuntimeException("Unable to select non-existing node " + searchedElement);
        }
        String selectionName = labelProvider.getText(searchedPath);
        ArrayList<Objection> objectionList = new ArrayList<Objection>();
        objectionList.add(Objection.TYPES_MEMBERS_VIEW);
        this.addSelectionInTree(searchedPath, selectionName, objectionList);
        return true;
    }

    public void addSelectionInTree(IDVTElementWrapper searchedPath, String selectionName, List<Objection> objectionList) {
        TreePath child = TreePath.child(TreePath.TOP_DUMMY_TREE_PATH, selectionName, 0, null);
        child.setElement(searchedPath);
        TreeItem treeItem = new TreeItem(this.getLazyTree().getTree(), 0);
        treeItem.setData((Object)child);
        this.getLazyTree().getTree().setSelection(treeItem);
        this.testSetSelection(child);
        this.getLazyTree().getTree().showSelection();
        this.getLazyTree().getTree().notifyListeners(13, (Event)new DVTSyntheticEvent(true));
        Objection[] objs = new Objection[objectionList.size()];
        ObjectionManager.getInstance().waitFor(objectionList.toArray(objs));
    }

    @Override
    public void testSetSelection(TreePath path) {
        this.getLazyTree().testSetSelection(path);
    }

    public void testShowMembers(boolean below) {
        if (!(this.lazyView instanceof TypesView)) {
            return;
        }
        ((TypesView)this.lazyView).showMembersView(below);
    }

    public String getTestsLabelInfo() {
        if (!(this.lazyView instanceof TypesView)) {
            return "";
        }
        return ((TypesView)this.lazyView).getTestsLabelInfo();
    }

    public void setDoSelectionInView(boolean doSelectionInView) {
        this.doSelectionInView = doSelectionInView;
    }
}

