/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.EclipseUtils;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.dnd.RfNamedElementTransfer;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.projectcolors.ProjectColorUtils;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.DVTLabelProviderProxy;
import ro.amiq.dvt.ui.views.DVTViewContributors;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IMembersLabelProvider;
import ro.amiq.dvt.ui.views.MembersViewInput;
import ro.amiq.dvt.ui.views.TextFilterObject;
import ro.amiq.dvt.ui.views.TreeViewContentProvider;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.lazy.tree.AbstractTreeIterator;
import ro.amiq.dvt.ui.views.lazy.tree.DVTModelEventType;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTModel;
import ro.amiq.dvt.ui.views.lazy.tree.IModel;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeIteratorType;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeMessageCompositeType;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeAction;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSearchActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeUpdateViewActionArguments;
import ro.amiq.dvt.ui.views.lazy.views.CollapseAllAction;
import ro.amiq.dvt.ui.views.lazy.views.ExpandAllAction;
import ro.amiq.dvt.ui.views.lazy.views.types.ITypesViewContributor;
import ro.amiq.dvt.ui.views.lazy.views.types.SortByTypeAction;
import ro.amiq.dvt.ui.views.lazy.views.types.TypesMembersView;
import ro.amiq.dvt.ui.views.lazy.views.types.TypesModel;
import ro.amiq.dvt.ui.views.lazy.views.types.TypesTestUtils;
import ro.amiq.dvt.ui.views.lazy.views.types.TypesViewCommon;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.Utils;

public class TypesView
extends TypesViewCommon
implements IPropertyChangeListener {
    public static final GridLayout LAYOUT = new GridLayout(1, true);
    public static final GridLayout TWO_PART_LAYOUT;
    private final TypesTestUtils lazyTreeTestUtils = new TypesTestUtils(this);
    private DVTLabelProviderProxy<ITypesViewContributor> labelProvider = new DVTLabelProviderProxy<ITypesViewContributor>(ITypesViewContributor.class, "default-tree");
    private int totalTypeCount;
    private int matchedTypeCount;
    private boolean hasGUIFilteredElements;
    private Image contentFiltersEnabledIcon = DVTImages.imageCache.getImage(DVTImages.GUI_FILTERS_ICON_MINI);
    private Image contentFiltersDisabledIcon = DVTImages.imageCache.getImage(DVTImages.GUI_FILTERS_ICON_MINI_DISABLED);
    protected int[] sashWeights = new int[]{2, 1};
    private final SortByTypeAction sortByTypeAction = new SortByTypeAction(this);
    private final Action membersViewAction = new MembersViewAction();
    private Action cancelAction;
    private Composite controlParent;
    protected Composite sashChildTree;
    protected Composite sashChildPorts;
    private Label contentFiltersLabel;
    private Label infoLabel;
    protected SashForm mainSashForm;
    protected SashForm upperSashForm;
    private TypesModel lazyTypesModel;
    private TypesMembersView membersView;
    private boolean showMembersView = true;
    private boolean showMembersViewBelow;
    private boolean modelComputingCanceled;
    private List<ITypesViewContributor> allTypesContibutors = DVTViewContributors.getInstance().getAllInstanceOf(ITypesViewContributor.class);

    static {
        TypesView.LAYOUT.marginWidth = 0;
        TypesView.LAYOUT.marginHeight = 0;
        TypesView.LAYOUT.verticalSpacing = 0;
        TWO_PART_LAYOUT = new GridLayout(2, false);
        TypesView.TWO_PART_LAYOUT.marginWidth = 0;
        TypesView.TWO_PART_LAYOUT.marginHeight = 0;
        TypesView.TWO_PART_LAYOUT.verticalSpacing = 0;
    }

    public TypesView() {
        DVTPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.sortByTypeAction);
    }

    @Override
    public Control getControlToColorBg() {
        return this.infoLabel.getParent();
    }

    @Override
    public Control getControlToColorFg() {
        return this.infoLabel;
    }

    @Override
    public LazyTreeIteratorType getIteratorType() {
        return LazyTreeIteratorType.LAZY_TYPES;
    }

    @Override
    public Objection getObjection() {
        return Objection.TYPES;
    }

    @Override
    public void setCancelActionEnabled(boolean enabled) {
        this.cancelAction.setEnabled(enabled);
    }

    @Override
    public IDVTModel getModel(Class<? extends IDVTModel> modelClass) {
        if (modelClass == null) {
            return null;
        }
        if (modelClass == IModel.class) {
            return this.lazyTypesModel;
        }
        return null;
    }

    @Override
    public ILabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new DVTLabelProviderProxy<ITypesViewContributor>(ITypesViewContributor.class, "default-tree");
        }
        return this.labelProvider;
    }

    @Override
    public ISelection getSelection() {
        if (this.hasMembersView() && this.membersView.isFocused()) {
            return this.membersView.getSelection();
        }
        return super.getSelection();
    }

    @Override
    public boolean isFiltered() {
        TextFilterObject textFilterObject = this.getTextFilterObject("default-filter");
        if (textFilterObject == null) {
            return false;
        }
        return textFilterObject.isFiltered();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("typesViewSortByType")) {
            this.update(null);
        }
    }

    @Override
    public void updateLabels(EnumSet<TreeViewContentProvider.LabelUpdateKind> labelUpdateKind) {
        super.updateLabels(labelUpdateKind);
    }

    @Override
    public ILabelProvider getTreeLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public TypesTestUtils getLazyTreeTestUtils() {
        return this.lazyTreeTestUtils;
    }

    protected Composite getControlParent() {
        return this.controlParent;
    }

    protected Action getMembersViewAction() {
        return this.membersViewAction;
    }

    public Label getInfoLabel() {
        return this.infoLabel == null ? null : this.infoLabel;
    }

    public Label getContentFilteredIndication() {
        return this.contentFiltersLabel;
    }

    @Override
    public String getMessageText() {
        if (this.getProject() == null || !this.getProject().isAccessible() || !Utils.hasDvtNature(this.getProject())) {
            return "Select a DVT Project or file.";
        }
        if (!this.getTextFilter("default-filter").getText().isEmpty()) {
            if (this.lazyTypesModel == null) {
                return LazyTreeMessageCompositeType.NO_DATA.getMessage();
            }
            if (this.modelComputingCanceled) {
                this.modelComputingCanceled = false;
                return LazyTreeMessageCompositeType.SEARCH_CANCELED.getMessage();
            }
            if (this.lazyTypesModel.isSearchedElementFiltered()) {
                return LazyTreeMessageCompositeType.GUI_FILTERED.getMessage();
            }
            return LazyTreeMessageCompositeType.NO_MATCHES_FOUND.getMessage();
        }
        if (this.lazyTypesModel != null && this.lazyTypesModel.hasGUIFilteredElements()) {
            return LazyTreeMessageCompositeType.GUI_FILTERED.getMessage();
        }
        return LazyTreeMessageCompositeType.NO_DATA.getMessage();
    }

    private void setShowMembersBelowPreference(boolean p) {
        PrefConst.setTypesViewShowPortsBelow(p);
    }

    @Override
    public void createToolBar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.removeAll();
        if (toolBarManager.getItems().length > 0) {
            toolBarManager.add((IContributionItem)new Separator());
        }
        this.cancelAction = new Action("", DVTImages.STOP_CURRENT_BUILD_PROCESS){

            public void run() {
                TypesView.this.getLazyTree().cancelOperations();
                this.setEnabled(false);
            }
        };
        this.cancelAction.setEnabled(false);
        this.cancelAction.setToolTipText("Cancel Current Operation");
        toolBarManager.add((IAction)this.cancelAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.membersViewAction);
        LazyTree lazyTree = this.getLazyTree();
        toolBarManager.add((IAction)this.sortByTypeAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)new ExpandAllAction(lazyTree));
        toolBarManager.add((IAction)new CollapseAllAction(lazyTree));
        toolBarManager.update(true);
    }

    @Override
    protected void createViewSpecificPartControl(Composite parent) {
        this.controlParent = parent;
        final LazyTree lazyTree = new LazyTree(this);
        this.setLazyTree(lazyTree);
        Composite childComposite = new Composite(parent, 0);
        childComposite.setLayoutData((Object)new GridData(1808));
        childComposite.setLayout((Layout)LAYOUT);
        this.mainSashForm = new SashForm(childComposite, 512);
        this.mainSashForm.setLayout((Layout)LAYOUT);
        this.mainSashForm.setFont(childComposite.getFont());
        this.mainSashForm.setLayoutData((Object)new GridData(1808));
        Composite fUpperSashFormComposite = new Composite((Composite)this.mainSashForm, 0);
        fUpperSashFormComposite.setLayout((Layout)LAYOUT);
        fUpperSashFormComposite.setLayoutData((Object)new GridData(1808));
        this.upperSashForm = new SashForm(fUpperSashFormComposite, 512);
        this.upperSashForm.setLayout((Layout)TWO_PART_LAYOUT);
        this.upperSashForm.setLayoutData((Object)new GridData(1808));
        this.sashChildTree = new Composite((Composite)this.upperSashForm, 0);
        this.sashChildTree.setLayout((Layout)LAYOUT);
        this.sashChildTree.setLayoutData((Object)new GridData(1808));
        Composite labelComposite = new Composite(this.sashChildTree, 0);
        GridLayout labelLayout = new GridLayout(2, false);
        labelComposite.setLayout((Layout)labelLayout);
        labelComposite.setLayoutData((Object)new GridData(4, 1, false, false));
        this.contentFiltersLabel = new Label(labelComposite, 0);
        if (EclipseUtils.isAtLeastEclipse419()) {
            this.contentFiltersLabel.setImage(this.hasGUIFilteredElements ? this.contentFiltersEnabledIcon : this.contentFiltersDisabledIcon);
        } else {
            this.contentFiltersLabel.setImage(this.contentFiltersEnabledIcon);
        }
        this.contentFiltersLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.contentFiltersLabel.setToolTipText("Content Filters matched!");
        this.contentFiltersLabel.setEnabled(this.hasGUIFilteredElements);
        this.infoLabel = new Label(labelComposite, 16384);
        this.infoLabel.setFont(labelComposite.getFont());
        this.infoLabel.setLayoutData((Object)new GridData(768));
        this.updateViewLabelInfo();
        Text filterText = this.createNewTextFilter(this.sashChildTree);
        if (filterText != null) {
            filterText.setMessage("Filter by: hierarchical name .port");
        }
        TextFilterObject filter = this.getTextFilterObject("default-filter");
        lazyTree.setSearchBar(filter);
        lazyTree.setLabelProvider(this.getLabelProvider(), false);
        lazyTree.install(this.sashChildTree);
        lazyTree.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                TypesView.this.updateMembersView();
            }
        });
        Tree tree = lazyTree.getTree();
        DragSource source = new DragSource((Control)tree, 1);
        source.setTransfer(new Transfer[]{RfNamedElementTransfer.getInstance()});
        source.addDragListener(new DragSourceListener(){
            ArrayList<IRfNamedElement> selectedRfNamedElements = new ArrayList();

            public void dragStart(DragSourceEvent event) {
                this.selectedRfNamedElements.clear();
                TreeItem[] treeItemArray = lazyTree.getTree().getSelection();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem selectedTreeItem = treeItemArray[n2];
                    Object selectedData = selectedTreeItem.getData();
                    if (!(selectedData instanceof TreePath)) {
                        event.doit = false;
                        return;
                    }
                    TreePath selectedTreePath = (TreePath)selectedData;
                    if (!(selectedTreePath.getElement() instanceof IDVTElementWrapper)) {
                        event.doit = false;
                        return;
                    }
                    IDVTElementWrapper selectedElementWrapper = (IDVTElementWrapper)selectedTreePath.getElement();
                    if (!(selectedElementWrapper.getRfElement() instanceof IRfNamedElement)) {
                        event.doit = false;
                        return;
                    }
                    this.selectedRfNamedElements.add((IRfNamedElement)selectedElementWrapper.getRfElement());
                    ++n2;
                }
                event.doit = !this.selectedRfNamedElements.isEmpty();
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = this.selectedRfNamedElements.toArray(new IRfNamedElement[this.selectedRfNamedElements.size()]);
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        if (this.shouldShowMembersView()) {
            this.showMembersView(false);
        }
        lazyTree.getTree().addKeyListener((KeyListener)this.getKeyListener("default-filter", "default-tree"));
    }

    void showMembersView(boolean below) {
        if (this.upperSashForm == null) {
            return;
        }
        this.showMembersView = true;
        this.showMembersViewBelow = below;
        this.setShowMembersBelowPreference(below);
        this.setShowMembersPreference(true);
        Composite parent = this.upperSashForm.getParent();
        SashForm oldSash = this.upperSashForm;
        int[] oldWeights = oldSash.getWeights();
        if (oldWeights != null && oldWeights.length == 2) {
            this.sashWeights = oldWeights;
        }
        this.upperSashForm = new SashForm(parent, this.showMembersViewBelow ? 512 : 256);
        this.upperSashForm.setLayout(oldSash.getLayout());
        this.upperSashForm.setLayoutData(oldSash.getLayoutData());
        this.sashChildTree.setParent((Composite)this.upperSashForm);
        if (this.sashChildPorts == null) {
            this.sashChildPorts = new Composite((Composite)this.upperSashForm, 0);
            this.sashChildPorts.setLayout((Layout)LAYOUT);
            this.sashChildPorts.setFont(this.mainSashForm.getFont());
            this.sashChildPorts.setLayoutData((Object)new GridData(1808));
            this.membersView = this.makeMembersViewInstance();
            this.membersView.initAndShow(this.sashChildPorts, "");
            this.membersView.setSortKind();
            this.sashChildPorts.layout();
            this.upperSashForm.setWeights(this.sashWeights);
        } else {
            this.sashChildPorts.setParent((Composite)this.upperSashForm);
        }
        oldSash.dispose();
        parent.layout();
        TreePath selection = this.getLazyTree().getSelection();
        this.membersView.updatePortsUsingTreePath(selection, this.getTreeSearchPort());
    }

    @Override
    public void clean() {
        IProject project = this.getProject();
        if (project == null || !project.isAccessible() || !Utils.hasDvtNature(project)) {
            this.infoLabel.setText(LazyTreeMessageCompositeType.NO_DVT_PROJECT_SELECTED.getMessage());
            ProjectColorUtils.setFgBg(this, null);
            this.contentFiltersLabel.setEnabled(false);
        } else {
            this.infoLabel.setText("[" + project.getName() + "]" + "[" + this.totalTypeCount + " types]");
            ProjectColorUtils.setFgBg(this, project.getName());
            if (EclipseUtils.isAtLeastEclipse419()) {
                this.contentFiltersLabel.setImage(DVTImages.imageCache.getImage(this.hasGUIFilteredElements ? DVTImages.GUI_FILTERS_ICON_MINI : DVTImages.GUI_FILTERS_ICON_MINI_DISABLED));
            }
            this.contentFiltersLabel.setEnabled(this.hasGUIFilteredElements);
        }
        this.resetElementCount();
        if (this.hasMembersView()) {
            this.membersView.updatePortsUsingTreePath(null, this.getTreeSearchPort());
        }
        this.cleanMembersView(false);
        if (this.getLazyTree() != null) {
            this.getLazyTree().doAction(LazyTreeAction.CLEAN, new LazyTreeActionArguments(Objection.TYPES));
        }
        if (this.lazyTypesModel != null) {
            this.lazyTypesModel.clearStateListeners();
        }
        this.lazyTypesModel = null;
    }

    @Override
    public void update(BuildEvents updateEvent) {
        try {
            IProject project = this.getProject();
            if (project == null || !project.isAccessible() || !Utils.hasDvtNature(project)) {
                this.clean();
                return;
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F636F7265")) {
                return;
            }
            LazyTree lazyTree = this.getLazyTree();
            if (lazyTree == null) {
                return;
            }
            boolean resetSelection = updateEvent == null;
            boolean resetModel = updateEvent == null || updateEvent == BuildEvents.FULL_BUILD || updateEvent == BuildEvents.INCREMENTAL_BUILD || updateEvent == BuildEvents.GUI_FILTERS_PROJECT || updateEvent == BuildEvents.GUI_FILTERS_WORKSPACE;
            this.hasGUIFilteredElements = false;
            boolean recomputeModelElements = false;
            boolean resetTop = false;
            if (this.lazyTypesModel == null || resetModel || resetSelection) {
                this.lazyTypesModel = new TypesModel((DVTBaseLabelProvider)this.getLabelProvider(), this.getProject(), this.getStringMatcher("default-filter"), this, this.allTypesContibutors);
                this.lazyTypesModel.addStateListener(event -> {
                    if (event.getEventType() == DVTModelEventType.MODEL_COMPUTING_CANCELED) {
                        this.modelComputingCanceled = true;
                    }
                    if (event.getEventType() == DVTModelEventType.MODEL_COMPUTING_DONE) {
                        this.modelComputingCanceled = false;
                        this.updateViewLabelInfo();
                    }
                });
                this.resetElementCount();
                recomputeModelElements = true;
                if (updateEvent != BuildEvents.INCREMENTAL_BUILD) {
                    resetTop = true;
                }
            }
            if (updateEvent == BuildEvents.GUI_FILTERS_PROJECT || updateEvent == BuildEvents.GUI_FILTERS_WORKSPACE || updateEvent == BuildEvents.INCREMENTAL_BUILD) {
                ObjectionManager.getInstance().clear(Objection.TYPES);
            }
            if (this.hasMembersView()) {
                this.membersView.updatePortsUsingTreePath(null, this.getTreeSearchPort());
            }
            lazyTree.doAction(LazyTreeAction.UPDATE_VIEW, new LazyTreeUpdateViewActionArguments(this, this.lazyTypesModel, resetSelection, resetTop, recomputeModelElements, Objection.TYPES));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void updateViewLabelInfo() {
        Display display = Display.getDefault();
        display.asyncExec(() -> {
            if (this.lazyTypesModel == null) {
                return;
            }
            this.totalTypeCount = this.lazyTypesModel.getElementCount();
            this.matchedTypeCount = this.lazyTypesModel.getNotFilteredElementCount();
            String typesInfo = this.computeTypesInfo();
            this.infoLabel.setText("[" + this.getProject().getName() + "]" + "[" + typesInfo + "]");
            ProjectColorUtils.setFgBg(this, this.getProject().getName());
            boolean bl = this.hasGUIFilteredElements = this.hasGUIFilteredElements || this.lazyTypesModel.hasGUIFilteredElements();
            if (EclipseUtils.isAtLeastEclipse419()) {
                this.contentFiltersLabel.setImage(this.hasGUIFilteredElements ? this.contentFiltersEnabledIcon : this.contentFiltersDisabledIcon);
            }
            this.contentFiltersLabel.setEnabled(this.hasGUIFilteredElements);
            ObjectionManager.getInstance().clear(Objection.TYPES_LABEL_INFO);
        });
    }

    private String computeTypesInfo() {
        if (this.lazyTypesModel == null) {
            return "";
        }
        this.totalTypeCount = this.lazyTypesModel.getElementCount();
        this.matchedTypeCount = this.lazyTypesModel.getNotFilteredElementCount();
        String typesInfo = String.valueOf(this.totalTypeCount) + ViewsUtils.getUnitName("type", this.totalTypeCount, " ", "");
        if (this.isFiltered()) {
            typesInfo = String.valueOf(this.matchedTypeCount) + "/" + this.totalTypeCount + ViewsUtils.getUnitName("type", this.totalTypeCount, " ", "");
        }
        return typesInfo;
    }

    private void resetElementCount() {
        this.totalTypeCount = 0;
        this.matchedTypeCount = 0;
    }

    @Override
    public String prepareText(String textFilterId, String text) {
        return text;
    }

    @Override
    public void stringMatcherUpdated(String uIJobTextFilterId) {
        if (this.infoLabel != null && !this.infoLabel.isDisposed() && this.getProject() != null) {
            this.infoLabel.setText("[" + this.getProject().getName() + "]");
        }
        this.resetElementCount();
        if (this.hasMembersView() && this.isFiltered()) {
            this.membersView.updatePortsUsingTreePath(null, this.getTreeSearchPort());
        }
        this.getLazyTree().doAction(LazyTreeAction.SEARCH, new LazyTreeSearchActionArguments(true, true, this.lazyTypesModel, Objection.TYPES));
    }

    @Override
    public StringMatcher[] getTreeSearchSegments() {
        TextFilterObject textFilterObject = this.getTextFilterObject("default-filter");
        if (textFilterObject == null) {
            return null;
        }
        return textFilterObject.getSearchSegments();
    }

    @Override
    public boolean[] getTreeSearchStrictness() {
        TextFilterObject textFilterObject = this.getTextFilterObject("default-filter");
        if (textFilterObject == null) {
            return null;
        }
        return textFilterObject.getSearchTextStrictness();
    }

    @Override
    public String getTreeSearchPort() {
        TextFilterObject textFilterObject = this.getTextFilterObject("default-filter");
        if (textFilterObject == null) {
            return "";
        }
        return textFilterObject.getSearchPort();
    }

    public StringMatcher getStringMatcher(String textFilterId) {
        TextFilterObject textFilterObject = this.getTextFilterObject(textFilterId);
        if (textFilterObject == null) {
            return null;
        }
        return textFilterObject.getStringMatcher();
    }

    @Override
    public void selectionChanged() {
        this.updateMembersView();
    }

    @Override
    public void gotoSelectedElement(String treeId) {
        try {
            IDVTElementWrapper selectedWrapper = this.getSelectedWrapper();
            if (selectedWrapper == null) {
                return;
            }
            this.setDataForPathManager(selectedWrapper);
            RfMixedLangManager.getInstance().gotoElement(this.getProject(), selectedWrapper);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void testGotoSelectedElement(IDVTElementWrapper selectedWrapper) {
        if (selectedWrapper == null) {
            return;
        }
        RfMixedLangManager.getInstance().gotoElement(this.getProject(), selectedWrapper);
    }

    private IDVTElementWrapper getSelectedWrapper() {
        TreePath selection = this.getLazyTree().getSelection();
        if (selection == null || selection.getElement() == null) {
            return null;
        }
        if (!(selection.getElement() instanceof IDVTElementWrapper)) {
            return null;
        }
        return (IDVTElementWrapper)selection.getElement();
    }

    private void setDataForPathManager(IDVTElementWrapper wrapper) throws CoreException {
        if (wrapper == null) {
            return;
        }
        Object element = wrapper.getRfElement();
        if (!(element instanceof IRfNamedElement)) {
            return;
        }
        IRfDefElement declaration = ((IRfNamedElement)element).getDeclaration();
        if (declaration == null) {
            return;
        }
        IRfFileDef fileDef = declaration.getDefFile();
        if (fileDef == null) {
            return;
        }
        IResource file = (IResource)fileDef.getAdapter(IResource.class);
        if (file == null) {
            return;
        }
        file.setSessionProperty(IDVTConstants.FILE_INSTANCE_QN, (Object)wrapper);
    }

    public TypesMembersView getMembersView() {
        return this.membersView;
    }

    public boolean shouldShowMembersView() {
        return this.showMembersView;
    }

    private TypesMembersView makeMembersViewInstance() {
        return new TypesMembersView(this);
    }

    @Override
    public List<? extends IRfNamedElement> getPorts(TreePath path) {
        if (path == null) {
            return null;
        }
        IDVTElementWrapper wrapper = (IDVTElementWrapper)path.getElement();
        ArrayList<IRfNamedElement> result = new ArrayList<IRfNamedElement>();
        MembersViewInput input = RfMixedLangManager.getInstance().getMembersInput(this.getProject(), wrapper, new StringMatcher("*", true, false), this.membersView.getCurrentTableLabelProvider(wrapper), true);
        if (input == null) {
            return null;
        }
        List<IDVTElementWrapper> elements = input.getElements();
        if (elements == null) {
            elements = Collections.emptyList();
        }
        for (IDVTElementWrapper element : elements) {
            Object namedElement = element.getRfElement();
            if (!(namedElement instanceof IRfNamedElement)) continue;
            result.add((IRfNamedElement)namedElement);
        }
        if (wrapper == null) {
            return null;
        }
        return result;
    }

    @Override
    public List<String> getMemberNames(IDVTElementWrapper node) {
        if (node == null) {
            return null;
        }
        if (this.membersView == null) {
            return null;
        }
        IMembersLabelProvider tableLabelProvider = this.membersView.getCurrentTableLabelProvider(node);
        List<IDVTElementWrapper> wrappers = RfMixedLangManager.getInstance().getMembersInput(this.getProject(), node, null, tableLabelProvider, true).getElements();
        if (wrappers == null) {
            return null;
        }
        return wrappers.stream().map(elem -> {
            IMembersLabelProvider tableLabelProvider1 = this.membersView.getCurrentTableLabelProvider((IDVTElementWrapper)elem);
            String text = tableLabelProvider1.getText(elem);
            return text;
        }).collect(Collectors.toList());
    }

    @Override
    public List<String> getUnfilteredMemberNames(IDVTElementWrapper node) {
        if (node == null) {
            return null;
        }
        if (this.membersView == null) {
            return null;
        }
        IMembersLabelProvider tableLabelProvider = this.membersView.getCurrentTableLabelProvider(node);
        List<IDVTElementWrapper> wrappers = RfMixedLangManager.getInstance().getMembersInput(this.getProject(), node, null, tableLabelProvider, false).getElements();
        if (wrappers == null) {
            return null;
        }
        return wrappers.stream().map(elem -> {
            IMembersLabelProvider tableLabelProvider1 = this.membersView.getCurrentTableLabelProvider((IDVTElementWrapper)elem);
            String text = tableLabelProvider1.getText(elem);
            return text;
        }).collect(Collectors.toList());
    }

    public String getMembersName() {
        return "Members";
    }

    private void updateMembersView() {
        if (!this.hasMembersView()) {
            return;
        }
        LazyTree lazyTree = this.getLazyTree();
        if (lazyTree == null) {
            return;
        }
        TreePath selection = lazyTree.getSelection();
        if (selection == null || this.membersView == null) {
            return;
        }
        this.membersView.updatePortsUsingTreePath(selection, this.getTreeSearchPort());
    }

    private void hideMembersView() {
        this.showMembersView = false;
        this.setShowMembersPreference(false);
        int[] oldWeights = this.upperSashForm.getWeights();
        if (oldWeights != null && oldWeights.length == 2) {
            this.sashWeights = oldWeights;
        }
        if (this.sashChildPorts != null && !this.sashChildPorts.isDisposed()) {
            this.sashChildPorts.dispose();
        }
        this.sashChildPorts = null;
        if (this.hasMembersView()) {
            this.membersView.dispose();
        }
        this.membersView = null;
        this.upperSashForm.setWeights(new int[]{1});
        this.upperSashForm.layout();
    }

    public void cleanMembersView(boolean showEmptyMessage) {
        if (this.hasMembersView()) {
            this.membersView.cleanView(showEmptyMessage);
        }
    }

    protected boolean hasMembersView() {
        return this.showMembersView && this.membersView != null;
    }

    protected void setShowMembersPreference(boolean p) {
        PrefConst.setTypesViewShowPorts(p);
    }

    public int getNofTypes() {
        return this.lazyTypesModel.getElementCount();
    }

    public List<IDVTElementWrapper> getTreeRoots() {
        return this.lazyTypesModel == null ? Collections.emptyList() : this.lazyTypesModel.testGetRoots();
    }

    public String getTestsLabelInfo() {
        return "[" + this.getProject().getName() + "]" + "[" + this.computeTypesInfo() + "]";
    }

    @Override
    protected void createCustomContextMenu(IMenuManager manager) {
    }

    @Override
    public void addViewSpecificListeners(AbstractTreeIterator treeIterator) {
    }

    private class LazyMembersViewMenuCreator
    implements IMenuCreator {
        private LazyMembersViewMenuCreator() {
        }

        public void dispose() {
        }

        public Menu getMenu(Control parent) {
            Menu menu = new Menu(parent);
            Action vertAction = new Action("Show " + TypesView.this.getMembersName() + " Below", 8){

                public void run() {
                    if (!this.isChecked()) {
                        return;
                    }
                    TypesView.this.showMembersView(true);
                }
            };
            vertAction.setChecked(TypesView.this.sashChildPorts != null && TypesView.this.showMembersViewBelow);
            ActionContributionItem vertItem = new ActionContributionItem((IAction)vertAction);
            vertItem.fill(menu, -1);
            Action horizAction = new Action("Show " + TypesView.this.getMembersName() + " to the Right", 8){

                public void run() {
                    if (!this.isChecked()) {
                        return;
                    }
                    TypesView.this.showMembersView(false);
                }
            };
            horizAction.setChecked(TypesView.this.sashChildPorts != null && !TypesView.this.showMembersViewBelow);
            ActionContributionItem horizItem = new ActionContributionItem((IAction)horizAction);
            horizItem.fill(menu, -1);
            Action hideAction = new Action("Hide " + TypesView.this.getMembersName(), 8){

                public void run() {
                    if (!this.isChecked()) {
                        return;
                    }
                    TypesView.this.hideMembersView();
                }
            };
            hideAction.setChecked(TypesView.this.sashChildPorts == null && !TypesView.this.showMembersView);
            ActionContributionItem hideItem = new ActionContributionItem((IAction)hideAction);
            hideItem.fill(menu, -1);
            return menu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }
    }

    public class MembersViewAction
    extends Action {
        public MembersViewAction() {
            super("Show/Hide " + TypesView.this.getMembersName(), 5);
            this.setImageDescriptor(DVTImages.SHOW_HIDE_PORTS);
            this.setMenuCreator(new LazyMembersViewMenuCreator());
        }

        public void run() {
            if (TypesView.this.hasMembersView()) {
                TypesView.this.hideMembersView();
            } else {
                TypesView.this.showMembersView(TypesView.this.showMembersViewBelow);
            }
            this.setChecked(true);
        }

        public void runWithEvent(Event event) {
            this.setChecked(true);
            super.runWithEvent(event);
            this.setChecked(true);
        }
    }
}

