/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.types;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.symbolcollector.BaseSymbolInputConfigurator;
import ro.amiq.dvt.symbolcollector.SymbolCollectorConfigurator;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.StringMatcher;

public class TypesViewInputConfigurator
extends BaseSymbolInputConfigurator {
    private final IProject fProject;
    private final StringMatcher fMatcher;
    private final boolean fCategorySort;
    private final boolean fShowLanguageNameAsRoot;
    private final boolean fShowMembers;
    private final boolean fHideDuplicates;
    private final IRfFilterableTreeAccessor fView;
    private final IProgressMonitor fMonitor;

    protected TypesViewInputConfigurator(IRfFilterableTreeAccessor view, IProject project, StringMatcher matcher, boolean categorySort, boolean showLanguageNameAsRoot, boolean showMembers, IProgressMonitor monitor) {
        this.fProject = project;
        this.fMatcher = matcher;
        this.fCategorySort = categorySort;
        this.fShowLanguageNameAsRoot = showLanguageNameAsRoot;
        this.fShowMembers = showMembers;
        this.fHideDuplicates = BuildConfigManager.isHideDuplicateTypesView(this.fProject);
        this.fView = view;
        this.fMonitor = monitor;
    }

    protected TypesViewInputConfigurator(SymbolCollectorConfigurator symbolConfigurator) {
        super(symbolConfigurator);
        this.fProject = super.getProject();
        this.fMatcher = super.getQueryPatternMatcher();
        this.fCategorySort = super.sortByCategory();
        this.fShowLanguageNameAsRoot = false;
        this.fShowMembers = false;
        this.fHideDuplicates = BuildConfigManager.isHideDuplicateTypesView(this.fProject);
        this.fView = super.getView();
        this.fMonitor = null;
    }

    public StringMatcher getStringMatcher() {
        return this.fMatcher;
    }

    public boolean isCategorySort() {
        return this.fCategorySort;
    }

    @Override
    public IProject getProject() {
        return this.fProject;
    }

    public boolean isShowLanguageNameAsRootElement() {
        return this.fShowLanguageNameAsRoot;
    }

    public UpdateJob getUpdateJob() {
        return this.fView.getUpdateJob();
    }

    public boolean isShowMembers() {
        return this.fShowMembers;
    }

    public boolean hideDuplicates() {
        return this.fHideDuplicates;
    }

    @Override
    public IRfFilterableTreeAccessor getView() {
        return this.fView;
    }

    public IProgressMonitor getMonitor() {
        return this.fMonitor;
    }

    public boolean isCanceled() {
        if (this.fMonitor != null && this.fMonitor.isCanceled()) {
            return true;
        }
        return ViewsUtils.isCanceled(this.getUpdateJob()) || this.isSymbolCollectionCanceled();
    }
}

