/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.IXvmFactoryInitListener;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.views.BuildEventManager;
import ro.amiq.dvt.ui.views.DVTLabelProviderProxy;
import ro.amiq.dvt.ui.views.IBuildEventManagerListener;
import ro.amiq.dvt.ui.views.ViewsUtilsCommon;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeMessageCompositeType;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.DummyAction;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.IVHViewContributor;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.UVMRuntimeSettings;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.UVMTestSelectionDialog;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VHViewMessages;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VerificationHierarchyActions;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.UVMTestSelectionFilteredList;

public abstract class AbstractSelectTopMenu
implements IMenuCreator,
IXvmFactoryInitListener,
IBuildEventManagerListener {
    private static final String UVM_TESTNAME = "+UVM_TESTNAME=";
    protected Menu menu;
    protected UVMRuntimeSettings uvmElabInfo;
    protected IProject project;
    protected RfMixedLangProject rfProject;
    protected DVTLabelProviderProxy<IVHViewContributor> topLabelProvider = new DVTLabelProviderProxy<IVHViewContributor>(IVHViewContributor.class, "default-top-dialog");
    private UVMTestSelectionDialog uvmTestSelectDialog;
    Map<HistoryItem, Action> historySelect;

    protected AbstractSelectTopMenu(IProject iProject) {
        this.project = iProject;
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
            this.removeListeners();
        }
    }

    public Menu getMenu(Control parent) {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
        this.rfProject = RfMixedLangManager.getInstance().getRfMixedLangProject(this.project, false);
        Map<LanguageKind, List<ActionContributionItem>> topItemsByProvider = this.getTopItemsByProvider();
        if (topItemsByProvider == null || topItemsByProvider.isEmpty()) {
            this.uvmElabInfo = null;
            return null;
        }
        this.showDialog(topItemsByProvider);
        return null;
    }

    private void showDialog(Map<LanguageKind, List<ActionContributionItem>> topItemsByProvider) {
        this.addListeners();
        this.uvmTestSelectDialog = new UVMTestSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.topLabelProvider, this.rfProject){
            private UVMTestSelectionFilteredList list;

            @Override
            protected UVMTestSelectionFilteredList createFilteredList(Composite parent2) {
                this.list = super.createFilteredList(parent2);
                this.list.setFilterMatcher(new UVMTestSelectionFilteredList.FilterMatcher(){
                    private StringMatcher localMatcher;

                    @Override
                    public void setFilter(String pattern, boolean ignoreCase, boolean ignoreWildCards) {
                        this.localMatcher = ViewsUtilsCommon.createCamelCaseOrRegexMatcher(pattern, ignoreCase, ignoreWildCards);
                    }

                    @Override
                    public boolean match(Object element) {
                        return ViewsUtilsCommon.matchCamelCaseOrRegex(this.localMatcher, fFilteredList.getLabelProvider().getText(element));
                    }
                });
                return this.list;
            }
        };
        this.uvmTestSelectDialog.setTitle(VHViewMessages.fVHSelectTopDialogTitle);
        this.uvmTestSelectDialog.setMessage(VHViewMessages.fVHSelectTopDialogHeader);
        this.uvmTestSelectDialog.setMultipleSelection(false);
        this.uvmTestSelectDialog.setHelpAvailable(false);
        List<HistoryItem> tops = this.getTopsItems(topItemsByProvider);
        if (tops == null || tops.isEmpty()) {
            this.uvmTestSelectDialog.setElements(new Object[]{LazyTreeMessageCompositeType.NO_DATA.getMessage()});
        } else {
            this.uvmTestSelectDialog.setElements(tops.toArray());
        }
        if (this.uvmTestSelectDialog.open() == 0) {
            this.removeListeners();
            Object firstObj = this.computeTestToRun();
            if (!(firstObj instanceof HistoryItem)) {
                this.uvmElabInfo = null;
                return;
            }
            Action abstractSelectTopItemAction = this.historySelect.get(firstObj);
            if (abstractSelectTopItemAction == null) {
                return;
            }
            abstractSelectTopItemAction.run();
            this.uvmElabInfo = this.computeUvmElabInfo(firstObj);
        } else {
            this.uvmElabInfo = null;
            this.removeListeners();
        }
    }

    private List<HistoryItem> getTopsItems(Map<LanguageKind, List<ActionContributionItem>> topItemsByProvider) {
        if (topItemsByProvider == null || topItemsByProvider.isEmpty()) {
            this.uvmElabInfo = null;
            this.uvmTestSelectDialog.setElements(new Object[]{LazyTreeMessageCompositeType.NO_DATA.getMessage()});
            return null;
        }
        LinkedList<HistoryItem> tops = new LinkedList<HistoryItem>();
        this.historySelect = new IdentityHashMap<HistoryItem, Action>();
        for (Map.Entry<LanguageKind, List<ActionContributionItem>> element : topItemsByProvider.entrySet()) {
            List<ActionContributionItem> actions = element.getValue();
            for (ActionContributionItem actionContribItem : actions) {
                HistoryItem selectedTop;
                IAction action = actionContribItem.getAction();
                if (!(action instanceof VerificationHierarchyActions.AbstractSelectTopItemAction) && !(action instanceof DummyAction)) {
                    this.uvmElabInfo = null;
                    throw new IllegalStateException("Unknown select action element " + action);
                }
                if (action instanceof VerificationHierarchyActions.AbstractSelectTopItemAction) {
                    actionHi = (VerificationHierarchyActions.AbstractSelectTopItemAction)action;
                    selectedTop = actionHi.getSelectedTop();
                    this.historySelect.put(selectedTop, (VerificationHierarchyActions.AbstractSelectTopItemAction)action);
                } else {
                    actionHi = (DummyAction)action;
                    selectedTop = actionHi.getSelectedTop();
                }
                tops.add(selectedTop);
            }
        }
        return tops;
    }

    private void displayTestNotFoundError(String testName) {
        Utils.asyncExec(() -> {
            MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "UVM test not found", null, "The specified UVM test name '" + testName + "' was not found. Please select an existing UVM test.", 1, new String[]{"OK"}, 0);
            dialog.open();
        });
    }

    private Object computeTestToRun() {
        String additionalArgs = this.uvmTestSelectDialog.getAdditionalArgs();
        if (!this.uvmTestSelectDialog.isPerformElab() || additionalArgs == null || !additionalArgs.contains(UVM_TESTNAME)) {
            return this.uvmTestSelectDialog.getFirstResult();
        }
        int overridingTestNameStartIndex = additionalArgs.lastIndexOf(UVM_TESTNAME) + UVM_TESTNAME.length();
        String overridingTestName = additionalArgs.substring(overridingTestNameStartIndex);
        int overridingTestNameEndIndex = overridingTestName.indexOf(32);
        if (overridingTestNameEndIndex == -1) {
            overridingTestNameEndIndex = overridingTestName.indexOf(10);
        }
        if (overridingTestNameEndIndex != -1) {
            overridingTestName = overridingTestName.substring(0, overridingTestNameEndIndex);
        }
        Object[] objectArray = this.uvmTestSelectDialog.getElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object top = objectArray[n2];
            String topName = this.getTestName(top);
            if (Objects.equals(overridingTestName, topName)) {
                return top;
            }
            ++n2;
        }
        this.displayTestNotFoundError(overridingTestName);
        return null;
    }

    private UVMRuntimeSettings computeUvmElabInfo(Object selectedObject) {
        UVMRuntimeSettings result = new UVMRuntimeSettings(this.getTestName(selectedObject));
        result.setHistoryItem(selectedObject instanceof HistoryItem ? (HistoryItem)selectedObject : null);
        boolean isPerformElab = this.uvmTestSelectDialog.isPerformElab();
        if (isPerformElab) {
            result.setPerformElaboration(isPerformElab);
            result.setSeed(this.uvmTestSelectDialog.getSeed());
            result.setVerbosity(this.uvmTestSelectDialog.getVerbosity());
            result.setUseBuiltinDPIC(this.uvmTestSelectDialog.isBUiltinDPIC());
            result.setAddArguments(this.uvmTestSelectDialog.getAdditionalArgs());
        }
        return result;
    }

    private String getTestName(Object firstObj) {
        if (firstObj instanceof HistoryItem) {
            return ((HistoryItem)firstObj).getElementName();
        }
        return null;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    protected List<ContributionItem> getItemsAndSeparators(Collection<List<ActionContributionItem>> topItemsByProvider) {
        ArrayList<ContributionItem> result = new ArrayList<ContributionItem>();
        boolean lastItemWasSeparator = true;
        for (List<ActionContributionItem> itemsFromProvider : topItemsByProvider) {
            if (!lastItemWasSeparator && !itemsFromProvider.isEmpty()) {
                result.add((ContributionItem)new Separator());
                lastItemWasSeparator = true;
            }
            for (ActionContributionItem item : itemsFromProvider) {
                result.add((ContributionItem)item);
                lastItemWasSeparator = false;
            }
        }
        return result;
    }

    protected UVMRuntimeSettings getUVMElabInfo() {
        return this.uvmElabInfo;
    }

    protected Map<LanguageKind, List<ActionContributionItem>> getDummyNodeItem(String text) {
        LinkedHashMap<LanguageKind, List<ActionContributionItem>> result = new LinkedHashMap<LanguageKind, List<ActionContributionItem>>();
        DummyAction dummyAction = new DummyAction(text);
        ActionContributionItem dummyActionContributionItem = new ActionContributionItem((IAction)dummyAction);
        ArrayList<ActionContributionItem> value = new ArrayList<ActionContributionItem>();
        value.add(dummyActionContributionItem);
        result.put(LanguageKind.VLOG, value);
        return result;
    }

    private void addListeners() {
        DVTMixedLangModelManager.getInstance().addXvmFactoryInitListeners(this);
        BuildEventManager.getInstance().registerListener(this);
    }

    private void removeListeners() {
        DVTMixedLangModelManager.getInstance().removeXvmFactoryInitListeners(this);
        BuildEventManager.getInstance().unregisterListener(this);
    }

    @Override
    public void postXvmReadyUpdate() {
        this.recomputeXVMTops();
    }

    private void recomputeXVMTops() {
        Display.getDefault().syncExec(() -> {
            Map<LanguageKind, List<ActionContributionItem>> topItemsByProvider = this.getTopItemsByProvider();
            List<HistoryItem> tops = this.getTopsItems(topItemsByProvider);
            if (tops == null || tops.isEmpty()) {
                topItemsByProvider = this.getDummyNodeItem("No data.");
                tops = this.getTopsItems(topItemsByProvider);
            }
            if (tops != null) {
                this.uvmTestSelectDialog.updateElements(tops.toArray());
            }
            this.uvmTestSelectDialog.updateLabelInfo();
        });
    }

    @Override
    public void notifyFullBuild(IProject project) {
        if (this.rfProject.hasNature("ro.amiq.vlogdt.VlogNature") && !this.rfProject.isXVMFactoryInitDone()) {
            this.rfProject.initXvmFactory();
            return;
        }
        this.recomputeXVMTops();
    }

    @Override
    public void notifyCleanBuild(IProject project) {
    }

    @Override
    public void notifyIncrementalBuild(IProject project, Map<LanguageKind, Set<FileCompileInfo>> changedFiles, Set<String> updateViewIds) {
        if (this.rfProject.hasNature("ro.amiq.vlogdt.VlogNature") && !this.rfProject.isXVMFactoryInitDone()) {
            this.rfProject.initXvmFactory();
            return;
        }
        this.recomputeXVMTops();
    }

    @Override
    public void notifyCancel() {
        this.recomputeXVMTops();
    }

    protected abstract Map<LanguageKind, List<ActionContributionItem>> getTopItemsByProvider();
}

