/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfVHBreadcrumbElement;
import ro.amiq.dvt.model.reflection.semantic.extension2.DummyElement;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.lazy.tree.DVTModelEvent;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTModelStateListener;
import ro.amiq.dvt.ui.views.lazy.tree.IVHViewModel;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.IVHViewContributor;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VHViewUtils;

public class LazyVHModel
implements IVHViewModel {
    protected static final Comparator<TreePath> fLexicalSorter = (w1, w2) -> {
        if (w1 == null || w2 == null || w1.equals(w2)) {
            return 0;
        }
        if (TreePath.isParent(w1, w2)) {
            return -1;
        }
        if (TreePath.isParent(w2, w1)) {
            return 1;
        }
        int[] inds1 = w1.getIndices();
        int[] inds2 = w2.getIndices();
        int i = 0;
        while (i < Math.min(inds1.length, inds2.length)) {
            if (inds1[i] != inds2[i]) {
                return inds1[i] - inds2[i];
            }
            ++i;
        }
        Object o1 = w1.getElement();
        Object o2 = w2.getElement();
        if (o1 instanceof IRfNamedElement && o2 instanceof IRfNamedElement) {
            return ((IRfNamedElement)o1).getName().compareTo(((IRfNamedElement)o2).getName());
        }
        if (o1 instanceof IRfVHBreadcrumbElement && o2 instanceof IRfVHBreadcrumbElement) {
            return ((IRfVHBreadcrumbElement)o1).getName().compareTo(((IRfVHBreadcrumbElement)o2).getName());
        }
        return 0;
    };
    protected IProject project;
    protected boolean isAlphabeticalSort;
    protected boolean isPrependPackage;
    private boolean isShowComponentsOnly;
    protected HistoryItem topElement;
    protected IVHViewContributor currentContributor;
    protected IRfFilterableTreeAccessor lazyView;
    protected List<IDVTModelStateListener> fStateListeners = new ArrayList<IDVTModelStateListener>();

    public LazyVHModel(IProject project, HistoryItem topElement, IRfFilterableTreeAccessor lazyView, boolean isAlphabeticalSort, boolean isPrependPackage, boolean isShowComponentsOnly) {
        this.project = project;
        this.isAlphabeticalSort = isAlphabeticalSort;
        this.isPrependPackage = isPrependPackage;
        this.isShowComponentsOnly = isShowComponentsOnly;
        this.topElement = topElement;
        this.lazyView = lazyView;
        if (topElement != null) {
            this.currentContributor = VHViewUtils.getViewContributor(topElement.getLanguage());
        }
    }

    @Override
    public List<TreePath> getChildren(TreePath treePath, int childStartIndex, int childEndIndex, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        if (this.project == null || treePath == null) {
            return Collections.emptyList();
        }
        if (this.topElement == null) {
            return Collections.emptyList();
        }
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        if (this.currentContributor == null) {
            this.currentContributor = VHViewUtils.getViewContributor(this.topElement.getLanguage());
        }
        if (treePath == TreePath.TOP_DUMMY_TREE_PATH) {
            HistoryItem top = this.topElement;
            TreePath child = this.currentContributor.createRootTreePath(top, treePath, this.isPrependPackage, monitor);
            result.add(child);
            return result;
        }
        if (this.isRecursiveNode(treePath)) {
            TreePath reccurenceNode = TreePath.child(treePath, DummyElement.RECURRENCE_NODE.getName(), 0);
            reccurenceNode.setElement(DummyElement.RECURRENCE_NODE);
            return Collections.singletonList(reccurenceNode);
        }
        Object element = treePath.getElement();
        if (element instanceof DummyElement) {
            return result;
        }
        List<Object> children = this.currentContributor.getChildrenForElement(element, this.lazyView, this.isPrependPackage, this.isAlphabeticalSort, this.isShowComponentsOnly, this.project, monitor);
        if (children == null) {
            return result;
        }
        int i = childStartIndex;
        while (i < Math.min(childEndIndex, children.size())) {
            TreePath prevChild;
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            Object dvtElementWrapper = children.get(i);
            String text = this.currentContributor.getText(dvtElementWrapper, treePath);
            TreePath child = TreePath.child(treePath, text, i, fLexicalSorter);
            child.setElement(dvtElementWrapper);
            TreePath treePath2 = prevChild = result.isEmpty() ? null : (TreePath)result.get(result.size() - 1);
            if (child.equals(prevChild, true)) {
                child.append("@(" + i + ")@");
            }
            result.add(child);
            ++i;
        }
        return result;
    }

    protected boolean isRecursiveNode(TreePath treePath) {
        Object elementObj = treePath.getElement();
        if (elementObj == null) {
            return false;
        }
        TreePath parentPath = treePath.getParent();
        while (parentPath != null) {
            Object parentPathElement = parentPath.getElement();
            if (elementObj.equals(parentPathElement)) {
                return true;
            }
            parentPath = parentPath.getParent();
        }
        return false;
    }

    @Override
    public Boolean hasChildren(TreePath treePath, IProgressMonitor monitor) {
        List<TreePath> children = this.getChildren(treePath, 0, 1, monitor);
        if (children != null && !children.isEmpty()) {
            return true;
        }
        return false;
    }

    @Override
    public TreePath getLastChild(TreePath treePath, IProgressMonitor monitor) {
        List<TreePath> children = this.getChildren(treePath, 0, Integer.MAX_VALUE, monitor);
        return children == null || children.isEmpty() ? null : children.get(children.size() - 1);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public TreePath getEndTreePath(TreePath path, IProgressMonitor monitor) {
        currentPath = path;
        children = this.getChildren(currentPath, 0, 0x7FFFFFFF, monitor);
        if (children != null && !children.isEmpty()) ** GOTO lbl7
        return currentPath;
lbl-1000:
        // 1 sources

        {
            currentPath = children.get(children.size() - 1);
            children = this.getChildren(currentPath, 0, 0x7FFFFFFF, monitor);
lbl7:
            // 2 sources

            ** while (children != null && !children.isEmpty())
        }
lbl8:
        // 1 sources

        return currentPath;
    }

    @Override
    public boolean hasGUIFilteredElements() {
        return this.currentContributor != null && this.currentContributor.hasGUIFilteredTree();
    }

    @Override
    public boolean hasInterpreterFailed() {
        return this.currentContributor != null && this.currentContributor.hasInterpreterFailed();
    }

    @Override
    public void setHasGUIFilteredElements(boolean hasGUIFilteredElements) {
        this.currentContributor.setHasGUIFilteredTree(hasGUIFilteredElements);
    }

    @Override
    public void clearModelCaches() {
    }

    @Override
    public List<Object> getTreeElementsForRoot(Object root) {
        ArrayList<Object> children = new ArrayList<Object>();
        if (this.topElement == null) {
            return children;
        }
        if (this.currentContributor == null) {
            this.currentContributor = VHViewUtils.getViewContributor(this.topElement.getLanguage());
        }
        List<TreePath> rootTreePaths = this.getChildren(TreePath.TOP_DUMMY_TREE_PATH, 0, Integer.MAX_VALUE, (IProgressMonitor)new NullProgressMonitor());
        for (TreePath rootTreePath : rootTreePaths) {
            DVTTreeElementWrapper rootWrapper = new DVTTreeElementWrapper(rootTreePath);
            this.computeChildrenForElement(rootWrapper);
            children.add(rootWrapper);
        }
        return children;
    }

    public void computeChildrenForElement(DVTTreeElementWrapper element) {
        List<TreePath> elementChildren = this.getChildren((TreePath)element.getRfElement(), 0, Integer.MAX_VALUE, (IProgressMonitor)new NullProgressMonitor());
        if (elementChildren == null || elementChildren.isEmpty()) {
            return;
        }
        for (TreePath child : elementChildren) {
            DVTTreeElementWrapper elementWrapper = new DVTTreeElementWrapper(child);
            this.computeChildrenForElement(elementWrapper);
            element.addChild(elementWrapper);
        }
    }

    @Override
    public void setHasInterpreterFailed(boolean isInterpreterProcessFailed) {
        this.currentContributor.setHasInterpreterFailed(isInterpreterProcessFailed);
    }

    public void addStateListener(IDVTModelStateListener l) {
        this.fStateListeners.add(l);
    }

    public void clearStateListeners() {
        this.fStateListeners.clear();
    }

    @Override
    public void notifyStateListeners(DVTModelEvent event) {
        for (IDVTModelStateListener l : this.fStateListeners) {
            l.stateChanged(event);
        }
    }
}

