/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.interpreter.IXContributor;
import ro.amiq.dvt.interpreter.XContributors;
import ro.amiq.dvt.model.BuildState;
import ro.amiq.dvt.model.BuildStateProvider;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.views.DVTViewContributors;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.AbstractSelectTopMenu;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.IVHViewContributor;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.SelectVHTopMenuUtils;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.UVMRuntimeSettings;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VerificationHierarchyActions;
import ro.amiq.dvt.utils.DVTPair;

public class SelectTopMenu
extends AbstractSelectTopMenu {
    public SelectTopMenu(IProject iproject) {
        super(iproject);
    }

    @Override
    protected Map<LanguageKind, List<ActionContributionItem>> getTopItemsByProvider() {
        if (BuildStateProvider.getInstance().getBuildState() == BuildState.PARSING) {
            return this.getDummyNodeItem("...");
        }
        LinkedHashMap<LanguageKind, List<ActionContributionItem>> results = new LinkedHashMap<LanguageKind, List<ActionContributionItem>>();
        LinkedHashMap allLangHistoryItems = new LinkedHashMap();
        if (this.rfProject.hasNature("ro.amiq.vlogdt.VlogNature") && !this.rfProject.isXVMFactoryInitDone()) {
            this.rfProject.initXvmFactory();
            return this.getDummyNodeItem("...");
        }
        List<IXContributor> xContributors = XContributors.getAnyXContributor("ro.amiq.dvt.ui.views.VerificationHierarchyView");
        for (IXContributor contributor : xContributors) {
            if (!(contributor instanceof IVHViewContributor)) {
                DVTLogger.INSTANCE.logError("Unknown view contributor received " + contributor);
                continue;
            }
            List<HistoryItem> serializedTops = ((IVHViewContributor)((Object)contributor)).getTops(this.project);
            if (serializedTops == null || serializedTops.isEmpty()) continue;
            ArrayList<HistoryItem> currentLanguageSerializedHistoryItems = new ArrayList<HistoryItem>();
            DVTPair serializedHistoryItems = new DVTPair(currentLanguageSerializedHistoryItems, new ArrayList());
            for (HistoryItem historyItem : serializedTops) {
                currentLanguageSerializedHistoryItems.add(historyItem.copy(false, true));
            }
            allLangHistoryItems.put(contributor.getLanguageKind(), serializedHistoryItems);
        }
        List<IVHViewContributor> contributors = DVTViewContributors.getInstance().getAllInstanceOf(IVHViewContributor.class);
        for (IVHViewContributor iVHViewContributor : contributors) {
            List<HistoryItem> staticTops;
            DVTPair currLangHistoryItems = (DVTPair)allLangHistoryItems.get((Object)iVHViewContributor.getLanguageKind());
            if (currLangHistoryItems == null) {
                currLangHistoryItems = new DVTPair(new ArrayList(), new ArrayList());
            }
            if ((staticTops = iVHViewContributor.getTops(this.project)) == null || staticTops.isEmpty()) continue;
            List allStaticHistoryItems = currLangHistoryItems.getValue();
            allStaticHistoryItems.addAll(staticTops);
            allLangHistoryItems.put(iVHViewContributor.getLanguageKind(), currLangHistoryItems);
        }
        for (Map.Entry entry : allLangHistoryItems.entrySet()) {
            LanguageKind language = (LanguageKind)((Object)entry.getKey());
            DVTPair currLangHistoryItems = (DVTPair)entry.getValue();
            ArrayList<ActionContributionItem> allItemsCurrLanguage = new ArrayList<ActionContributionItem>();
            List serializedHistoryItems = (List)currLangHistoryItems.getKey();
            List staticHistoryItems = (List)currLangHistoryItems.getValue();
            SelectVHTopMenuUtils.INSTANCE.markXVMAlreadyRegisteredItems(serializedHistoryItems, staticHistoryItems);
            for (HistoryItem serializedHistoryItem : serializedHistoryItems) {
                allItemsCurrLanguage.add(new ActionContributionItem((IAction)new VerificationHierarchyActions.SelectTopUVMElabItemAction(serializedHistoryItem, this.topLabelProvider)));
            }
            for (HistoryItem staticHistoryItem : staticHistoryItems) {
                allItemsCurrLanguage.add(new ActionContributionItem((IAction)new VerificationHierarchyActions.SelectTopItemAction(staticHistoryItem, this.topLabelProvider)));
            }
            results.put(language, allItemsCurrLanguage);
        }
        return results;
    }

    @Override
    protected UVMRuntimeSettings getUVMElabInfo() {
        return this.uvmElabInfo;
    }
}

