/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ui.actions.history.HistoryItem;

public enum SelectVHTopMenuUtils {
    INSTANCE;


    public void markXVMAlreadyRegisteredItems(List<HistoryItem> serializedHistoryItems, List<HistoryItem> staticHistoryItems) {
        Set<HistoryItem> currLanguageDuplicatedHistoryItems = this.markAndCollectVlogXVMRegisterDuplicates(staticHistoryItems);
        if (!currLanguageDuplicatedHistoryItems.isEmpty() && !serializedHistoryItems.isEmpty()) {
            for (HistoryItem staticHistoryItem : currLanguageDuplicatedHistoryItems) {
                for (HistoryItem serializedHistoryItem : serializedHistoryItems) {
                    if (staticHistoryItem.getLanguage() != serializedHistoryItem.getLanguage() || !staticHistoryItem.getElementName().equals(serializedHistoryItem.getElementName())) continue;
                    serializedHistoryItem.markAsXVMAlreadyRegistered();
                }
            }
        }
    }

    public Set<HistoryItem> markAndCollectVlogXVMRegisterDuplicates(List<HistoryItem> tops) {
        if (tops == null || tops.size() <= 1) {
            return Collections.emptySet();
        }
        HashSet<HistoryItem> historyItems = new HashSet<HistoryItem>();
        for (HistoryItem hi1 : tops) {
            if (hi1.getLanguage() != LanguageKind.VLOG) continue;
            for (HistoryItem hi2 : tops) {
                String e2;
                String e1;
                if (hi2.getLanguage() != LanguageKind.VLOG || hi1 == hi2 || (e1 = hi1.getElementName()) == null || e1.isEmpty() || (e2 = hi2.getElementName()) == null || e2.isEmpty() || !e1.equals(e2)) continue;
                hi1.markAsXVMAlreadyRegistered();
                hi2.markAsXVMAlreadyRegistered();
                historyItems.add(hi1);
            }
        }
        return historyItems;
    }
}

