/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.interpreter.XUVMElaborationStarters;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.AbstractSelectTopMenu;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.SelectTopMenu;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.UVMRuntimeSettings;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VHViewMessages;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VHViewUtils;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VerificationHierarchyView;

public class SelectVerificationTopAction
extends Action {
    private AbstractSelectTopMenu topMenuCreator;
    private Shell shell;
    private IProject iProject;

    public SelectVerificationTopAction(IProject iProject, Shell shell) {
        super(VHViewMessages.fVHSelectTopDialogTitle);
        this.iProject = iProject;
        this.shell = shell;
        this.topMenuCreator = new SelectTopMenu(this.iProject);
        this.setImageDescriptor(DVTImages.VERIFICATION_HIERARCHY_TOP);
        this.setToolTipText(VHViewMessages.fVHSelectTopDialogTitle);
    }

    public void run() {
        Job[] allJobs;
        Job[] jobArray = allJobs = Job.getJobManager().find(null);
        int n = allJobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            if (job.getName().startsWith("Rebuilding_") || job.getName().startsWith("Cleaning_") || job.getName().startsWith("Restoring")) {
                MessageDialog.openInformation((Shell)DVTUiUtils.getActiveWorkbenchShell(), (String)"Project build/restore in progress", (String)"Please wait for the project build/restore operation to finish before selecting a verification top.");
                return;
            }
            ++n2;
        }
        this.iProject = this.topMenuCreator.project = DVTPlugin.getSelectionManager().getLastSelectedProject();
        Menu menu = this.topMenuCreator.getMenu((Control)this.shell);
        UVMRuntimeSettings uvmElabInfo = this.topMenuCreator.getUVMElabInfo();
        if (menu != null) {
            menu.setVisible(true);
        }
        if (uvmElabInfo == null) {
            return;
        }
        if (uvmElabInfo.isPerformElaboration()) {
            Object xUVMElaborationManager = XUVMElaborationStarters.getStarter(LanguageKind.VLOG);
            if (xUVMElaborationManager == null) {
                return;
            }
            if (xUVMElaborationManager.generate(this.iProject, uvmElabInfo) == Status.CANCEL_STATUS) {
                return;
            }
        } else {
            HistoryItem historyItem = uvmElabInfo.getHistoryItem();
            if (historyItem == null) {
                return;
            }
            boolean hasUVMElabModel = historyItem.hasUVMElabModel();
            if (hasUVMElabModel) {
                Object xUVMElaborationManager = XUVMElaborationStarters.getStarter(LanguageKind.VLOG);
                if (xUVMElaborationManager == null) {
                    return;
                }
                if (xUVMElaborationManager.loadModelAction(this.iProject, historyItem.getElementName()) == Status.CANCEL_STATUS) {
                    return;
                }
            } else {
                try {
                    IViewPart vhView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ro.amiq.dvt.ui.views.VerificationHierarchyView");
                    if (!(vhView instanceof VerificationHierarchyView)) {
                        return;
                    }
                    ((VerificationHierarchyView)vhView).setUpAndUpdate(historyItem, true);
                }
                catch (PartInitException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return;
                }
            }
        }
    }

    public void setIProject(IProject project) {
        this.iProject = project;
        if (project == null || !project.isOpen()) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(VHViewUtils.hasAnySelectTopNature(project));
    }
}

