/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy;

import java.io.File;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.ch.model.XVMBuildPhaseXMLParser;
import ro.amiq.dvt.interpreter.XUVMElaborationStarters;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.DVTUVMReAdditionalArgsTextBox;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.UVMRuntimeSettings;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VHViewUtils;
import ro.amiq.dvt.utils.AbstractElementUVMTestSelectionListSelectionDialog;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.UVMTestSelectionFilteredList;

public class UVMTestSelectionDialog
extends AbstractElementUVMTestSelectionListSelectionDialog {
    private Object[] fElements;
    private final boolean isSaveLoadBuildPhaseModel;
    private Button performElab;
    private Combo verb;
    private Text seedText;
    private Button builtinDPI;
    private DVTUVMReAdditionalArgsTextBox argsEditor;
    private String argsString;
    private String verbString;
    private String seedString;
    private boolean isBuiltinValue;
    private boolean isPerformElabValue;
    private Label infoLabel;
    private Label infoImageLabel;
    private Label loadingImageLabel;
    private Label loadingLabel;
    private UVMTestSelectionFilteredList filteredList;
    protected RfMixedLangProject rfProject;

    public UVMTestSelectionDialog(Shell parent, ILabelProvider renderer, boolean isSaveLoadBuildPhaseModel, RfMixedLangProject rfProject) {
        super(parent, renderer);
        this.isSaveLoadBuildPhaseModel = isSaveLoadBuildPhaseModel;
        this.rfProject = rfProject;
    }

    public UVMTestSelectionDialog(Shell parent, ILabelProvider renderer, RfMixedLangProject rfProject) {
        super(parent, renderer);
        this.isSaveLoadBuildPhaseModel = false;
        this.rfProject = rfProject;
    }

    public Object[] getElements() {
        return this.fElements;
    }

    public void setElements(Object[] elements) {
        this.fElements = elements;
    }

    protected void computeResult() {
        this.setResult(Arrays.asList(this.getSelectedElements()));
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        this.createMessageArea(contents);
        this.createFilterText(contents);
        this.createFilteredList(contents);
        Composite container = new Composite(contents, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().applyTo(container);
        Composite start = new Composite(container, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(start);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)start);
        this.performElab = new Button(start, 32);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)this.performElab);
        this.performElab.setText("Perform UVM runtime elaboration");
        IProject project = DVTPlugin.getSelectionManager().getLastSelectedProject();
        if (project != null) {
            this.performElab.setEnabled(VHViewUtils.hasAnyPerformElaborationNature(project));
        }
        Label sep = new Label(start, 258);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)sep);
        final Composite runtimeOpts = new Composite(container, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)runtimeOpts);
        GridLayoutFactory.fillDefaults().applyTo(runtimeOpts);
        this.performElab.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Utils.setEnabledRecursive(runtimeOpts, UVMTestSelectionDialog.this.performElab.getSelection());
                if (UVMTestSelectionDialog.this.performElab.getSelection()) {
                    UVMTestSelectionDialog.this.infoLabel.setVisible(false);
                    UVMTestSelectionDialog.this.infoImageLabel.setVisible(false);
                    return;
                }
                Object[] selections = UVMTestSelectionDialog.this.filteredList.getSelection();
                if (selections == null || selections.length == 0) {
                    return;
                }
                Object selection = selections[0];
                if (!(selection instanceof HistoryItem)) {
                    return;
                }
                HistoryItem historyItem = (HistoryItem)selection;
                if (!historyItem.hasUVMElabModel()) {
                    UVMTestSelectionDialog.this.infoLabel.setVisible(false);
                    UVMTestSelectionDialog.this.infoImageLabel.setVisible(false);
                    return;
                }
                String elementName = historyItem.getElementName();
                Object xUVMElaborationManager = XUVMElaborationStarters.getStarter(LanguageKind.VLOG);
                if (xUVMElaborationManager == null) {
                    DVTLogger.INSTANCE.logError("Unable to locate UVM Elaboration Starter!");
                    return;
                }
                UVMRuntimeSettings runtimeSettings = xUVMElaborationManager.getRuntimeSettings(historyItem.getProject(), elementName);
                if (runtimeSettings != null) {
                    UVMTestSelectionDialog.this.infoLabel.setVisible(true);
                    UVMTestSelectionDialog.this.infoImageLabel.setVisible(true);
                }
            }
        });
        Composite c1 = new Composite(runtimeOpts, 0);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)c1);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(c1);
        Label verbLabel = new Label(c1, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)verbLabel);
        verbLabel.setText("Verbosity:");
        this.verb = new Combo(c1, 0);
        this.verb.setItems(new String[]{"UVM_NONE", "UVM_LOW", "UVM_MEDIUM", "UVM_HIGH", "UVM_FULL", "UVM_DEBUG"});
        this.verb.setText("UVM_MEDIUM");
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)this.verb);
        Label seedLabel = new Label(c1, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)seedLabel);
        seedLabel.setText("Seed:");
        this.seedText = new Text(c1, 2048);
        this.seedText.setMessage("1");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.seedText);
        Composite argsGroup = new Composite(runtimeOpts, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)argsGroup);
        GridLayoutFactory.fillDefaults().applyTo(argsGroup);
        this.builtinDPI = new Button(argsGroup, 32);
        this.builtinDPI.setSelection(true);
        this.builtinDPI.setText("Use builtin DPI-C");
        Label argsLabel = new Label(argsGroup, 0);
        argsLabel.setText("Additional arguments:");
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)argsLabel);
        this.argsEditor = new DVTUVMReAdditionalArgsTextBox(argsGroup);
        Label sepEnd = new Label(container, 258);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)sepEnd);
        this.setListElements(this.fElements);
        this.autoResize();
        this.setSelection(this.getInitialElementSelections().toArray());
        Utils.setEnabledRecursive(runtimeOpts, false);
        this.createInfoLabel(contents);
        if (this.rfProject.hasNature("ro.amiq.vlogdt.VlogNature") && !this.rfProject.isXVMFactoryInitDone()) {
            this.createLoadingLabel(contents);
        }
        return contents;
    }

    public void updateElements(Object[] fElements) {
        this.setElements(fElements);
        this.setListElements(fElements);
    }

    private void createInfoLabel(Composite contents) {
        Composite c1 = new Composite(contents, 0);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)c1);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(c1);
        this.infoImageLabel = new Label(c1, 0);
        this.infoImageLabel.setImage(DVTImages.imageCache.getImage(DVTImages.INFORMATION));
        this.infoImageLabel.setVisible(false);
        this.infoLabel = new Label(c1, 0);
        this.infoLabel.setText("Loads the UVM Runtime Elaboration Snapshot.");
        this.infoLabel.setVisible(false);
    }

    private void createLoadingLabel(Composite contents) {
        Composite c1 = new Composite(contents, 0);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)c1);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(c1);
        this.loadingImageLabel = new Label(c1, 0);
        this.loadingImageLabel.setImage(DVTImages.imageCache.getImage(DVTImages.INFORMATION));
        this.loadingImageLabel.setVisible(true);
        this.loadingLabel = new Label(c1, 0);
        this.loadingLabel.setText("Computing XVM factory...");
        this.loadingLabel.setVisible(true);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        final UVMTestSelectionDialog elementDialog = this;
        if (this.isSaveLoadBuildPhaseModel) {
            Button openButton = this.createButton(parent, 11, IDialogConstants.OPEN_LABEL, true);
            openButton.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    FileDialog dialog = new FileDialog(UVMTestSelectionDialog.this.getShell());
                    dialog.setFilterPath(DVTFileUtils.getInstance().getLastDirectory());
                    String path = dialog.open();
                    if (path == null || path.length() == 0) {
                        return;
                    }
                    elementDialog.close();
                    XVMBuildPhaseXMLParser.INSTANCE.parse(new File(path), DVTPlugin.getSelectionManager().getLastSelectedProject());
                }
            });
        }
        super.createButtonsForButtonBar(parent);
    }

    @Override
    protected UVMTestSelectionFilteredList createFilteredList(Composite parent) {
        this.filteredList = super.createFilteredList(parent);
        this.filteredList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Widget source = e.item;
                if (!(source instanceof TableItem)) {
                    return;
                }
                Object data = ((TableItem)source).getData();
                if (!(data instanceof HistoryItem)) {
                    return;
                }
                HistoryItem historyItem = (HistoryItem)data;
                String elementName = historyItem.getElementName();
                if (elementName == null || elementName.isEmpty()) {
                    return;
                }
                if (!historyItem.hasUVMElabModel()) {
                    UVMTestSelectionDialog.this.infoLabel.setVisible(false);
                    UVMTestSelectionDialog.this.infoImageLabel.setVisible(false);
                    UVMTestSelectionDialog.this.verb.setText("UVM_MEDIUM");
                    UVMTestSelectionDialog.this.seedText.setText("1");
                    UVMTestSelectionDialog.this.argsEditor.setArgs("");
                    UVMTestSelectionDialog.this.builtinDPI.setSelection(true);
                    return;
                }
                Object xUVMElaborationManager = XUVMElaborationStarters.getStarter(LanguageKind.VLOG);
                if (xUVMElaborationManager == null) {
                    DVTLogger.INSTANCE.logError("Unable to locate UVM Elaboration Starter!");
                    return;
                }
                UVMRuntimeSettings runtimeSettings = xUVMElaborationManager.getRuntimeSettings(historyItem.getProject(), elementName);
                if (runtimeSettings == null) {
                    if (UVMTestSelectionDialog.this.performElab.getSelection()) {
                        UVMTestSelectionDialog.this.infoLabel.setVisible(false);
                        UVMTestSelectionDialog.this.infoImageLabel.setVisible(false);
                    }
                    UVMTestSelectionDialog.this.verb.setText("UVM_MEDIUM");
                    UVMTestSelectionDialog.this.seedText.setText("1");
                    UVMTestSelectionDialog.this.argsEditor.setArgs("");
                    UVMTestSelectionDialog.this.builtinDPI.setSelection(true);
                    return;
                }
                if (!UVMTestSelectionDialog.this.performElab.getSelection()) {
                    UVMTestSelectionDialog.this.infoLabel.setVisible(true);
                    UVMTestSelectionDialog.this.infoImageLabel.setVisible(true);
                }
                UVMTestSelectionDialog.this.verb.setText(runtimeSettings.getVerbosity() != null ? runtimeSettings.getVerbosity() : "UVM_MEDIUM");
                UVMTestSelectionDialog.this.seedText.setText(runtimeSettings.getSeed() != null ? runtimeSettings.getSeed() : "1");
                UVMTestSelectionDialog.this.argsEditor.setArgs(runtimeSettings.getAddArguments() != null ? runtimeSettings.getAddArguments() : "");
                UVMTestSelectionDialog.this.builtinDPI.setSelection(runtimeSettings.isUseBuiltinDPIC());
            }
        });
        return this.filteredList;
    }

    public boolean isPerformElab() {
        return this.isPerformElabValue;
    }

    public String getVerbosity() {
        return this.verbString;
    }

    public String getSeed() {
        return this.seedString;
    }

    public boolean isBUiltinDPIC() {
        return this.isBuiltinValue;
    }

    public String getAdditionalArgs() {
        return this.argsString;
    }

    protected void okPressed() {
        this.argsString = this.argsEditor.getArgs();
        this.verbString = this.verb.getText();
        this.seedString = this.seedText.getText();
        this.isBuiltinValue = this.builtinDPI.getSelection();
        this.isPerformElabValue = this.performElab.getSelection();
        super.okPressed();
    }

    @Override
    protected void handleDefaultSelected() {
    }

    public void updateLabelInfo() {
        if (this.loadingLabel == null || this.loadingImageLabel == null) {
            return;
        }
        Display.getDefault().syncExec(() -> {
            this.loadingLabel.setVisible(false);
            this.loadingImageLabel.setVisible(false);
        });
        int[] selection = new int[1];
        this.filteredList.setSelection(selection);
    }
}

