/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.preference.BooleanPropertyAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.interpreter.IXVHContributor;
import ro.amiq.dvt.interpreter.XUVMElaborationStarters;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.actions.history.HistoryAction;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.DVTLabelProviderProxy;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeAction;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeActionArguments;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.IVHViewContributor;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.PortsViewMode;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VerificationHierarchyView;

public class VerificationHierarchyActions {

    protected static abstract class AbstractSelectTopItemAction
    extends Action {
        protected HistoryItem selectedTop;

        protected AbstractSelectTopItemAction(HistoryItem top, DVTLabelProviderProxy<IVHViewContributor> topLabelProvider) {
            super(topLabelProvider.getText(top));
            this.selectedTop = top;
            this.setImageDescriptor(this.getTopImage(top, topLabelProvider));
        }

        public ImageDescriptor getTopImage(HistoryItem top, DVTLabelProviderProxy<IVHViewContributor> topLabelProvider) {
            Image image = topLabelProvider.getImage(top);
            if (image == null) {
                return DVTImages.VLOG_PERSPECTIVE;
            }
            return ImageDescriptor.createFromImage((Image)image);
        }

        public HistoryItem getSelectedTop() {
            return this.selectedTop;
        }

        public abstract void run();
    }

    protected static class AlphabeticalSortAction
    extends BooleanPropertyAction {
        VerificationHierarchyView view;

        public AlphabeticalSortAction(VerificationHierarchyView view) {
            super("Alphabetical Sort", DVTPlugin.getDefault().getPreferenceStore(), "verificationhierarchyview.sortAlphabetically");
            this.view = view;
            this.setToolTipText("Alphabetical Sort");
            this.setImageDescriptor(DVTImages.ALPHAB_SORT);
            this.setChecked(PrefConst.getVHViewSortAlphabetically());
        }

        public void run() {
            PrefConst.setVHViewSortAlphabetically(this.isChecked());
            if (this.view.getCurrentContributor() instanceof IXVHContributor) {
                return;
            }
            this.view.update(null);
        }
    }

    protected static class CopyHierarchyPath
    extends Action {
        VerificationHierarchyView view;

        public CopyHierarchyPath(VerificationHierarchyView view) {
            super("Copy Hierarchy Path");
            this.view = view;
            this.setDescription("Copy Hierarchy Path");
            this.setToolTipText("Copy the hierarchy path of the element");
        }

        public String getId() {
            return "ro.amiq.dvt.ui.views.verification.hierarchy.copyHierarchyPath";
        }

        public void run() {
            TreePath selectedElement = this.view.getLazyTree().getSelection();
            this.view.getCurrentContributor().copyHierarchyPathAction(selectedElement, null);
        }
    }

    protected static class OpenCreateCallAction
    extends Action {
        VerificationHierarchyView view;

        public OpenCreateCallAction(VerificationHierarchyView view) {
            super("Open Create Call");
            this.view = view;
            this.setDescription("Open Create Call");
            this.setToolTipText("Jump in the editor to the create call of the field");
        }

        public String getId() {
            return "ro.amiq.dvt.ui.views.verification.hierarchy.OpenCreateCall";
        }

        public void run() {
            Object selectedWrapper = this.view.getSelectedElement();
            if (selectedWrapper == null) {
                return;
            }
            this.view.getCurrentContributor().openCreateCallAction(selectedWrapper, null);
        }
    }

    protected static class OpenTypeDeclarationAction
    extends Action {
        VerificationHierarchyView view;

        public OpenTypeDeclarationAction(VerificationHierarchyView view) {
            super("Open Type Declaration");
            this.view = view;
            this.setDescription("Open Type Declaration");
            this.setToolTipText("Jump in the editor to the type declaration");
        }

        public String getId() {
            return "ro.amiq.dvt.ui.views.verification.hierarchy.OpenTypeDeclaration";
        }

        public void run() {
            Object selectedWrapper = this.view.getSelectedElement();
            if (selectedWrapper == null) {
                return;
            }
            this.view.getCurrentContributor().openTypeDeclarationAction(selectedWrapper, this.view.getProject());
        }
    }

    public static class PortsViewAction
    extends Action {
        private VerificationHierarchyView view;

        public PortsViewAction(VerificationHierarchyView view) {
            super("Show/Hide Ports", 5);
            this.setImageDescriptor(DVTImages.SHOW_HIDE_PORTS);
            this.setMenuCreator(new PortsViewMenuCreator(view));
            this.view = view;
        }

        public void run() {
            PortsViewMode currentMode = this.view.getPortsViewMode();
            if (currentMode != PortsViewMode.HIDE) {
                this.view.hidePortsView();
            } else {
                this.view.showPortsView(this.view.getPortsModeFromPref(true));
            }
            this.setChecked(true);
        }

        public void runWithEvent(Event event) {
            this.setChecked(true);
            super.runWithEvent(event);
            this.setChecked(true);
        }
    }

    private static class PortsViewMenuCreator
    implements IMenuCreator {
        private VerificationHierarchyView view;

        public PortsViewMenuCreator(VerificationHierarchyView view) {
            this.view = view;
        }

        public void dispose() {
        }

        public Menu getMenu(Control parent) {
            Menu menu = new Menu(parent);
            Action vertAction = new Action(PortsViewMode.BELOW.getLabel(), 8){

                public void run() {
                    if (!this.isChecked()) {
                        return;
                    }
                    view.showPortsView(PortsViewMode.BELOW);
                }
            };
            vertAction.setChecked(this.view.getPortsViewMode() == PortsViewMode.BELOW);
            ActionContributionItem vertItem = new ActionContributionItem((IAction)vertAction);
            vertItem.fill(menu, -1);
            Action horizAction = new Action(PortsViewMode.RIGHT.getLabel(), 8){

                public void run() {
                    if (!this.isChecked()) {
                        return;
                    }
                    view.showPortsView(PortsViewMode.RIGHT);
                }
            };
            horizAction.setChecked(this.view.getPortsViewMode() == PortsViewMode.RIGHT);
            ActionContributionItem horizItem = new ActionContributionItem((IAction)horizAction);
            horizItem.fill(menu, -1);
            Action hideAction = new Action(PortsViewMode.HIDE.getLabel(), 8){

                public void run() {
                    if (!this.isChecked()) {
                        return;
                    }
                    view.hidePortsView();
                }
            };
            hideAction.setChecked(this.view.getPortsViewMode() == PortsViewMode.HIDE);
            ActionContributionItem hideItem = new ActionContributionItem((IAction)hideAction);
            hideItem.fill(menu, -1);
            return menu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }
    }

    protected static class PrependPackageAction
    extends BooleanPropertyAction {
        VerificationHierarchyView view;

        public PrependPackageAction(VerificationHierarchyView view) {
            super("Prepend Package Name", DVTPlugin.getDefault().getPreferenceStore(), "verificationhierarchyview.prependPackage");
            this.view = view;
            this.setDescription("Prepend Package Name");
            this.setToolTipText("Prepend Package Name");
            this.setImageDescriptor(DVTImages.PREPEND_PACKAGE);
            this.setChecked(PrefConst.getVHViewPrependPackage());
        }

        public void run() {
            PrefConst.setVHViewPrependPackage(this.isChecked());
            this.view.getLazyTree().doAction(LazyTreeAction.PREPEND_PACKAGE, new LazyTreeActionArguments(Objection.VERIFICATION_HIERARCHY));
        }
    }

    protected static class SelectTopItemAction
    extends AbstractSelectTopItemAction {
        protected SelectTopItemAction(HistoryItem top, DVTLabelProviderProxy<IVHViewContributor> topLabelProvider) {
            super(top, topLabelProvider);
        }

        @Override
        public void run() {
        }
    }

    protected static class SelectTopUVMElabItemAction
    extends AbstractSelectTopItemAction {
        protected SelectTopUVMElabItemAction(HistoryItem top, DVTLabelProviderProxy<IVHViewContributor> topLabelProvider) {
            super(top, topLabelProvider);
        }

        @Override
        public void run() {
        }
    }

    protected static class ShowOnlyComponentsAction
    extends BooleanPropertyAction {
        VerificationHierarchyView view;

        public ShowOnlyComponentsAction(VerificationHierarchyView view) {
            super("Show only UVM Components", DVTPlugin.getDefault().getPreferenceStore(), "verificationhierarchyview.showComponentsOnly");
            this.view = view;
            this.setDescription("Show only UVM Components");
            this.setToolTipText("Show only UVM Components");
            this.setImageDescriptor(DVTImages.XVM_COMPONENT_INSTANCE);
            this.setChecked(PrefConst.getVHViewShowComponentsOnly());
        }

        public void run() {
            PrefConst.setVHViewShowComponentsOnly(this.isChecked());
            if (this.view.getCurrentContributor() instanceof IXVHContributor) {
                return;
            }
            this.view.update(null);
        }
    }

    protected static class VHHistoryAction
    extends HistoryAction {
        VerificationHierarchyView view;

        public VHHistoryAction(VerificationHierarchyView view) {
            this.view = view;
        }

        @Override
        public void openHistoryItem(HistoryItem item) {
            if (item == null) {
                return;
            }
            if (item.hasUVMElabModel()) {
                new SelectTopUVMElabItemAction(item, new DVTLabelProviderProxy<IVHViewContributor>(IVHViewContributor.class, "default-top-dialog")).run();
                Object xUVMElaborationManager = XUVMElaborationStarters.getStarter(LanguageKind.VLOG);
                if (xUVMElaborationManager == null) {
                    return;
                }
                xUVMElaborationManager.loadModelAction(item.getProject(), item.getElementName());
                return;
            }
            for (IVHViewContributor c : this.view.getViewContributors()) {
                if (!c.acceptsHistoryItem(item)) continue;
                this.view.setUpAndUpdate(item, true);
                return;
            }
        }

        @Override
        public boolean checkHistoryItem(HistoryItem item) {
            return true;
        }
    }

    public static class XModelSaveCHDDiagram
    extends Action {
        VerificationHierarchyView view;

        public XModelSaveCHDDiagram(VerificationHierarchyView view) {
            super("Save CHD Diagram");
            this.view = view;
            this.setDescription("Save CHD Diagram");
            this.setToolTipText("Save Components Diagram in .chd format");
        }

        public void run() {
            IVHViewContributor xContributor = this.view.getCurrentContributor();
            if (!(xContributor instanceof IXVHContributor)) {
                return;
            }
            ((IXVHContributor)xContributor).saveCHDDiagram(this.view.getProject(), null);
        }

        public void testRun(String fileNameChd) {
            IVHViewContributor xContributor = this.view.getCurrentContributor();
            if (!(xContributor instanceof IXVHContributor)) {
                return;
            }
            ((IXVHContributor)xContributor).saveCHDDiagram(this.view.getProject(), fileNameChd);
        }
    }
}

