/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchPartSite;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.views.AbstractFilteredView;
import ro.amiq.dvt.ui.views.BasicElementWrapper;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.DVTLanguageElement;
import ro.amiq.dvt.ui.views.DVTMembersViewContentProvider;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.DVTViewManager;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IMembersLabelProvider;
import ro.amiq.dvt.ui.views.MembersViewInput;
import ro.amiq.dvt.ui.views.TreeViewContentProvider;
import ro.amiq.dvt.ui.views.ViewsUtilsCommon;
import ro.amiq.dvt.ui.views.inspect.InspectViewSelectionListener;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTModel;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.IVHViewContributor;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.LazyVHModel;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VHViewUtils;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VerificationHierarchyPortsViewCommon;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VerificationHierarchyView;
import ro.amiq.dvt.utils.StringMatcher;

public class VerificationHierarchyPortsView
extends VerificationHierarchyPortsViewCommon {
    public static final String COPY_HIERARCHY_PATH = "ro.amiq.dvt.ui.views.verification.hierarchy.copyHierarchyPath";
    public static final List<IDVTElementWrapper> INPUT_VERIFICATION_HIERARCHY_PORTS_VIEW = Arrays.asList(new BasicElementWrapper("Select an element in the"), new BasicElementWrapper("Verification Hierarchy tree"), new BasicElementWrapper("to see its ports."));
    private TableViewer table;
    private IDVTElementWrapper selectedWrapperPath;
    private StringMatcher memberToPromote;
    private Label infoLabel;
    private Label guiFilteredIndication;
    private boolean hasGUIFilteredElements;
    private TreePath lastSelectedPath;
    private MenuManager contextMenuManager;
    private LanguageKind currentLanguageKind;
    private final Action copyInstancePathAction = new CopyHierarchyPath();

    public VerificationHierarchyPortsView(VerificationHierarchyView provider) {
        super(provider);
    }

    public Objection getObjection() {
        return Objection.VERIFICATION_HIERARCHY_PORTS_VIEW;
    }

    public Object getSelectedPath() {
        return this.selectedPath;
    }

    private IVHViewContributor getCurrentContributor() {
        return VHViewUtils.getViewContributor(this.currentLanguageKind);
    }

    public void initAndShow(Composite parent, String filterText) {
        this.setSite((IWorkbenchPartSite)this.lazyView.getViewSite());
        this.setSelectionChangedListeners(this.lazyView.getSelectionChangedListeners());
        this.createPartControl(parent);
        if (filterText != null && !filterText.isEmpty()) {
            this.initTextFilterSilent("default-filter", filterText);
        }
    }

    public Control getControl() {
        if (this.table == null) {
            return null;
        }
        return this.table.getControl();
    }

    public boolean isFocused() {
        if (this.getControl() == null) {
            return false;
        }
        return this.getControl().isFocusControl();
    }

    public void setFocus() {
        Control control = this.getControl();
        if (control != null) {
            control.setFocus();
        }
    }

    @Override
    public Control getControlToColorBg() {
        return null;
    }

    @Override
    public Control getControlToColorFg() {
        return null;
    }

    @Override
    public Tree getTree(String treeId) {
        return null;
    }

    @Override
    public Object getTreeRootElement(String treeId) {
        return null;
    }

    @Override
    protected StringMatcher getStringMatcherForPorts() {
        return this.getStringMatcher("default-filter");
    }

    protected List<IDVTElementWrapper> getHelpMsg() {
        return INPUT_VERIFICATION_HIERARCHY_PORTS_VIEW;
    }

    public List<IDVTElementWrapper> getNoMembersMsg() {
        String noPortsMsg = this.currentLanguageKind != null && this.currentLanguageKind == LanguageKind.PSS ? "No actions." : "No ports.";
        return Arrays.asList(new BasicElementWrapper(noPortsMsg));
    }

    public void updatePortsUsingTreePath(TreePath path, String portToPromote, LanguageKind languageKind) {
        if (path == null) {
            this.cleanView(true);
            return;
        }
        this.selectedPath = path;
        this.currentLanguageKind = languageKind;
        this.selectedWrapperPath = new DVTTreeElementWrapper(path);
        IVHViewContributor contributor = this.lazyView.getCurrentContributor();
        this.tableLabelProvider = contributor.getMembersViewLabelProvider();
        this.setPortOrGenericToPromote(portToPromote == null ? null : ViewsUtilsCommon.createCamelCaseOrRegexMatcher(portToPromote, true, false));
        this.tableLabelProvider.setBoldMatcher(this.portOrGenericToPromote);
        this.showFilteredPorts(path);
    }

    private void showFilteredPorts(TreePath selectionPath) {
        this.tableLabelProvider.setBoldMatcher(this.portOrGenericToPromote);
        this.table.setLabelProvider((IBaseLabelProvider)this.tableLabelProvider);
        this.lastSelectedPath = selectionPath;
        MembersViewInput input = this.getMembersInput(this.selectedPath);
        if (input == null) {
            return;
        }
        List<Object> elements = input.getElements();
        if (elements == null) {
            elements = Collections.emptyList();
        }
        for (IDVTElementWrapper member : elements) {
            member.setAdditionalInfo(IDVTElementWrapper.Attribute.PORT_INSTANCE, this.selectedWrapperPath);
        }
        if (this.infoLabel != null) {
            this.infoLabel.setText("");
            DVTBaseLabelProvider elementLabelProvider = (DVTBaseLabelProvider)this.lazyView.getLabelProvider();
            if (elementLabelProvider != null) {
                int nofMembers = elements.size();
                String elementLabel = elementLabelProvider.getText(this.selectedWrapperPath);
                String members = ViewsUtilsCommon.getUnitName("member", nofMembers, " ", "");
                this.infoLabel.setText(String.valueOf(elementLabel) + " [" + nofMembers + members + "]");
            }
        }
        this.sortOrPromotePorts(elements);
        if (this.guiFilteredIndication != null) {
            this.guiFilteredIndication.setEnabled(input.isContentFiltered());
        }
        if (elements.isEmpty()) {
            elements = this.selectedWrapperPath.getRfElement() instanceof DVTLanguageElement ? this.getHelpMsg() : (input.isContentFiltered() ? AbstractFilteredView.GUI_FILTERED_EMPTY_CONTENT : (this.isFiltered() ? NO_MATCHES_FOUND : this.getNoMembersMsg()));
        }
        this.table.setInput(elements);
        this.table.setSelection(null);
        ObjectionManager.getInstance().clearForMembers(this);
    }

    @Override
    public void update(BuildEvents updateEvent) {
        VerificationHierarchyView lazyVHView = this.lazyView;
        if (lazyVHView == null) {
            return;
        }
        TreePath element = lazyVHView.getLazyTree().getSelection();
        this.updatePortsUsingTreePath(element, lazyVHView.getTreeSearchPort(), lazyVHView.getCurrentLanguageKind());
        IDVTModel model = lazyVHView.getModel(LazyVHModel.class);
        if (!(model instanceof LazyVHModel)) {
            return;
        }
        this.hasGUIFilteredElements = this.hasGUIFilteredElements || ((LazyVHModel)model).hasGUIFilteredElements();
        this.guiFilteredIndication.setEnabled(this.hasGUIFilteredElements);
    }

    public void cleanView(boolean showEmptyMessage) {
        this.selectedWrapperPath = null;
        this.selectedPath = null;
        this.lastSelectedPath = null;
        this.memberToPromote = null;
        if (this.tableLabelProvider != null) {
            this.tableLabelProvider.setBoldMatcher(this.memberToPromote);
        }
        this.hasGUIFilteredElements = false;
        if (this.guiFilteredIndication != null && !this.guiFilteredIndication.isDisposed()) {
            this.guiFilteredIndication.setEnabled(false);
        }
        if (this.infoLabel != null && !this.infoLabel.isDisposed()) {
            this.infoLabel.setText("");
        }
        if (this.table == null || this.table.getControl() == null || this.table.getControl().isDisposed()) {
            return;
        }
        boolean noMatchesFound = this.isFiltered();
        List elements = this.getHelpMsg();
        if (!showEmptyMessage) {
            elements = new ArrayList<IDVTElementWrapper>();
        }
        if (noMatchesFound) {
            elements = NO_MATCHES_FOUND;
        }
        if (this.table == null || this.table.getControl() == null || this.table.getControl().isDisposed()) {
            return;
        }
        this.table.setInput((Object)elements);
        this.table.setSelection(null);
    }

    @Override
    public void clean() {
        this.cleanView(true);
    }

    @Override
    public void dispose() {
        DVTViewManager.getInstanceByCurrentWorkbenchWindow().unregisterView(this);
        this.fDataContainer = null;
        this.removeSelectionChangedListener(InspectViewSelectionListener.getInstance());
        DVTViewManager.getInstanceByCurrentWorkbenchWindow().unregisterView(this);
        DVTPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    @Override
    public void customCreatePartControl(Composite parent) {
        this.createTextFilter("default-filter", parent, "default-tree", false);
        this.setTextFilterMessage("default-filter", "Filter by: name");
        Composite tableComposite = new Composite(parent, 0);
        GridData compositeGridData = new GridData(1808);
        tableComposite.setLayoutData((Object)compositeGridData);
        tableComposite.setLayout((Layout)new FillLayout(256));
        this.table = new TableViewer(tableComposite, 268436228);
        this.table.setContentProvider((IContentProvider)new DVTMembersViewContentProvider());
        this.tableLabelProvider = this.defaultLabelProvider;
        this.table.setLabelProvider((IBaseLabelProvider)this.tableLabelProvider);
        this.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Object source = e.getSource();
                if (source instanceof Table) {
                    VerificationHierarchyPortsView.this.setFocus();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                VerificationHierarchyPortsView.this.gotoSelectedElement("default-tree");
            }
        });
        this.getControl().addKeyListener((KeyListener)this.getKeyListener("default-filter", "default-tree"));
        this.contextMenuManager = this.installContextMenuAndSelectionListener((Control)this.table.getTable());
        this.createTreeContextMenu();
    }

    protected void createTreeContextMenu() {
        if (this.contextMenuManager == null) {
            return;
        }
        this.contextMenuManager.setRemoveAllWhenShown(true);
        this.contextMenuManager.addMenuListener(manager -> this.addToTreeContextMenu(manager, this.getCurrentContributor().getAdditionalContextMenuActionIds(this.getSelectedWrapper("default-tree"))));
    }

    private void addToTreeContextMenu(IMenuManager manager, List<String> additionalActions) {
        if (manager == null || additionalActions == null || additionalActions.isEmpty()) {
            return;
        }
        IContributionItem[] items = manager.getItems();
        HashSet<String> itemsIds = new HashSet<String>();
        IContributionItem[] iContributionItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            itemsIds.add(item.getId());
            ++n2;
        }
        for (String actionID : additionalActions) {
            if (!COPY_HIERARCHY_PATH.equals(actionID)) continue;
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.copyInstancePathAction);
        }
    }

    @Override
    public void refreshSelection(IResource resource) {
    }

    @Override
    public TreeViewContentProvider getExpandableContentProvider() {
        return null;
    }

    @Override
    public void gotoSelectedElement(String treeId) {
        IDVTElementWrapper wrapper = this.getSelectedWrapper(null);
        wrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.MEMBER_PARENT_WRAPPER, this.selectedPath);
        IVHViewContributor currentContributor = this.lazyView.getCurrentContributor();
        currentContributor.gotoSelectedMember(this.lazyView.getProject(), wrapper);
    }

    @Override
    public ISelection getSelection(String treeId) {
        return this.getSelection();
    }

    @Override
    public ISelection getSelection() {
        if (this.table == null || this.table.getControl() == null || this.table.getControl().isDisposed()) {
            return null;
        }
        return this.table.getSelection();
    }

    @Override
    public IDVTElementWrapper getSelectedWrapper(String treeId) {
        StructuredSelection selection = (StructuredSelection)this.getSelection(treeId);
        if (selection == null || selection.size() != 1) {
            return null;
        }
        Object elem = selection.getFirstElement();
        if (!(elem instanceof IDVTElementWrapper)) {
            return null;
        }
        return (IDVTElementWrapper)elem;
    }

    @Override
    public void stringMatcherUpdated(String textFilterId) {
        this.showFilteredPorts(this.lastSelectedPath);
    }

    public List<?> testHelpGetMembers() {
        return (List)this.table.getInput();
    }

    public IMembersLabelProvider testHelpGetLabelProvider() {
        return this.tableLabelProvider;
    }

    public void doCopyHierarchyWirePathAction(IDVTElementWrapper parent, Object child) {
        LanguageKind languageKind = parent.getLanguageKind();
        IVHViewContributor viewContributor = VHViewUtils.getViewContributor(languageKind);
        viewContributor.copyHierarchyPathAction(child, parent);
    }

    public class CopyHierarchyPath
    extends Action {
        public CopyHierarchyPath() {
            super("Copy Hierarchy Path");
            this.setDescription("Copy Hierarchy Path");
            this.setToolTipText("Copy the hierarchy path of the element");
        }

        public String getId() {
            return VerificationHierarchyPortsView.COPY_HIERARCHY_PATH;
        }

        public void run() {
            IDVTElementWrapper port = VerificationHierarchyPortsView.this.getSelectedWrapper("default-tree");
            VerificationHierarchyPortsView.this.lazyView.getCurrentContributor().copyHierarchyPathAction(VerificationHierarchyPortsView.this.selectedPath, port);
        }
    }
}

