/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.AbstractFilteredView;
import ro.amiq.dvt.ui.views.DVTRfLabelProvider;
import ro.amiq.dvt.ui.views.DVTViewContributors;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IDVTViewWithMembersContributor;
import ro.amiq.dvt.ui.views.IMembersLabelProvider;
import ro.amiq.dvt.ui.views.MembersViewInput;
import ro.amiq.dvt.ui.views.ViewKind;
import ro.amiq.dvt.ui.views.comparators.LabelProviderWrapperComparator;
import ro.amiq.dvt.ui.views.comparators.PromoteComparator;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.IVHViewContributor;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VerificationHierarchyPortsView;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VerificationHierarchyView;
import ro.amiq.dvt.utils.CompositeComparator;
import ro.amiq.dvt.utils.StringMatcher;

public abstract class VerificationHierarchyPortsViewCommon
extends AbstractFilteredView {
    public static final String ID = "ro.amiq.dvt.ui.views.VerificationHierarchyPortsView";
    public static final EnumSet<ViewKind> VIEW_KIND = EnumSet.of(ViewKind.NO_INFORMATION);
    protected TreePath selectedPath;
    protected final VerificationHierarchyView lazyView;
    protected StringMatcher portOrGenericToPromote;
    protected IMembersLabelProvider tableLabelProvider;
    protected IMembersLabelProvider defaultLabelProvider = new DVTRfLabelProvider();

    protected VerificationHierarchyPortsViewCommon(VerificationHierarchyView provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.valueOf(VerificationHierarchyPortsView.class.getName()) + " requires non-null " + VerificationHierarchyView.class.getName());
        }
        this.lazyView = provider;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public EnumSet<ViewKind> getKind() {
        return VIEW_KIND;
    }

    public MembersViewInput getMembersInput(TreePath selectionPath) {
        return this.lazyView.getCurrentContributor().getMembersInput(selectionPath.getElement(), this.getStringMatcherForPorts());
    }

    protected IDVTViewWithMembersContributor getViewContributor(IDVTElementWrapper selectedElement) {
        return DVTViewContributors.getInstance().getViewContributor(selectedElement, IVHViewContributor.class);
    }

    public void sortOrPromotePorts(List<IDVTElementWrapper> elements) {
        CompositeComparator<IDVTElementWrapper> compositeComparator = new CompositeComparator<IDVTElementWrapper>();
        if (this.portOrGenericToPromote != null) {
            compositeComparator.add(new PromoteComparator(this.portOrGenericToPromote, this.tableLabelProvider));
        }
        if (PrefConst.getVHViewSortAlphabetically()) {
            compositeComparator.add(new LabelProviderWrapperComparator(this.tableLabelProvider, true));
        }
        Collections.sort(elements, compositeComparator);
    }

    public IMembersLabelProvider getCurrentTableLabelProvider(IDVTElementWrapper elem) {
        IDVTViewWithMembersContributor contributor = this.getViewContributor(elem);
        this.tableLabelProvider = contributor.getMembersViewLabelProvider();
        if (this.tableLabelProvider == null) {
            this.tableLabelProvider = this.defaultLabelProvider;
        }
        return this.tableLabelProvider;
    }

    public void setPortOrGenericToPromote(StringMatcher portOrGenericToPromote) {
        this.portOrGenericToPromote = portOrGenericToPromote;
    }

    public void setSelectedPath(TreePath path) {
        this.selectedPath = path;
    }

    protected abstract StringMatcher getStringMatcherForPorts();
}

