/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.diagrams.ch.editor.CHEditorFactory;
import ro.amiq.dvt.interpreter.DVTXRunBuildPhaseUtils;
import ro.amiq.dvt.interpreter.IDVTXModelManager;
import ro.amiq.dvt.interpreter.IXVHContributor;
import ro.amiq.dvt.interpreter.IXXVMComponent;
import ro.amiq.dvt.interpreter.XUVMElaborationStarters;
import ro.amiq.dvt.interpreter.XViewsUtils;
import ro.amiq.dvt.logviewer.LogViewerContributorUtils;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.IXvmFactoryInitListener;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.EclipseUtils;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.DVTInfoPopup;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbViewer;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.projectcolors.ProjectColorUtils;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.DVTHelpListener;
import ro.amiq.dvt.ui.views.DVTLabelProviderProxy;
import ro.amiq.dvt.ui.views.DVTViewContributors;
import ro.amiq.dvt.ui.views.DVTViewEvent;
import ro.amiq.dvt.ui.views.IBuildEventManagerListener;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IMembersLabelProvider;
import ro.amiq.dvt.ui.views.SortKind;
import ro.amiq.dvt.ui.views.TextFilterObject;
import ro.amiq.dvt.ui.views.ViewDataContainer;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.ViewsUtilsCommon;
import ro.amiq.dvt.ui.views.inspect.InspectViewSelectionListener;
import ro.amiq.dvt.ui.views.interpreter.IInterpreterViews;
import ro.amiq.dvt.ui.views.interpreter.IInterpreterViewsCommon;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTLazyViewListener;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTModel;
import ro.amiq.dvt.ui.views.lazy.tree.IModel;
import ro.amiq.dvt.ui.views.lazy.tree.IVHViewModel;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeIteratorType;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeMessageCompositeType;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeAction;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSearchActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeUpdateViewActionArguments;
import ro.amiq.dvt.ui.views.lazy.views.CollapseAllAction;
import ro.amiq.dvt.ui.views.lazy.views.DVTLazyViewUtils;
import ro.amiq.dvt.ui.views.lazy.views.ExpandAllAction;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.DVTVHLabelProvider;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.IVHViewContributor;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.LazyVHModel;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.LazyVerificationHierarchyTestUtils;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.PortsViewMode;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.SelectVerificationTopAction;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VHViewUtils;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VerificationHierarchyActions;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VerificationHierarchyPortsView;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VerificationHierarchyViewCommon;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.XVHViewModel;

public class VerificationHierarchyView
extends VerificationHierarchyViewCommon
implements IXvmFactoryInitListener,
IInterpreterViews {
    public static final String TOP_DIALOG_ID = "default-top-dialog";
    public static final String OPEN_TYPE_DECLARATION_ACTION = "ro.amiq.dvt.ui.views.verification.hierarchy.OpenTypeDeclaration";
    public static final String OPEN_CREATE_CALL_ACTION = "ro.amiq.dvt.ui.views.verification.hierarchy.OpenCreateCall";
    public static final String COPY_HIERARCHY_PATH = "ro.amiq.dvt.ui.views.verification.hierarchy.copyHierarchyPath";
    private DVTLabelProviderProxy<IVHViewContributor> topDialogLabelProvider = new DVTLabelProviderProxy<IVHViewContributor>(IVHViewContributor.class, "default-top-dialog");
    private Composite controlParent;
    private SashForm mainSashForm;
    private SashForm upperSashForm;
    private Composite childComposite;
    private Composite sashChildTree;
    private Composite sashChildPorts;
    private int[] sashWeights = new int[]{2, 1};
    private SelectVerificationTopAction selectTopAction;
    private Action historyAction;
    private Action prependPackageAction;
    private Action showComponentsOnly;
    private Action alphabeticalSortAction;
    private Action openTypeDeclarationAction = new VerificationHierarchyActions.OpenTypeDeclarationAction(this);
    private Action openCreateCallAction = new VerificationHierarchyActions.OpenCreateCallAction(this);
    private Action copyInstancePathAction = new VerificationHierarchyActions.CopyHierarchyPath(this);
    private Action cancelAction;
    private VerificationHierarchyActions.PortsViewAction portsViewAction;
    private PortsViewMode portsViewMode = this.getPortsModeFromPref(false);
    private VerificationHierarchyPortsView portsView;
    private DVTVHLabelProvider labelProvider = new DVTVHLabelProvider();
    private Label labelInfo;
    private Label contentFiltersLabel;
    private Image contentFiltersEnabledIcon = DVTImages.imageCache.getImage(DVTImages.GUI_FILTERS_ICON_MINI);
    private Image contentFiltersDisabledIcon = DVTImages.imageCache.getImage(DVTImages.GUI_FILTERS_ICON_MINI_DISABLED);
    private boolean hasGUIFilteredElements;
    private LazyVerificationHierarchyTestUtils verificationHierarchyTestUtils = new LazyVerificationHierarchyTestUtils(this);
    private final UpdateCHDiagramAdapter updateCHDiagramAdapter = new UpdateCHDiagramAdapter(this);
    private final UpdateContentFiltersLabel updateContentFiltersLabel = new UpdateContentFiltersLabel(this);

    @Override
    public IDVTModel getModel(Class<? extends IDVTModel> modelClass) {
        return this.verificationHierarchyModel;
    }

    @Override
    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public void selectionChanged() {
        this.updatePortsView();
    }

    @Override
    public LazyTreeIteratorType getIteratorType() {
        return LazyTreeIteratorType.LAZY_VERIFICATION_HIERARCHY;
    }

    @Override
    public Objection getObjection() {
        return Objection.VERIFICATION_HIERARCHY;
    }

    @Override
    public Control getControlToColorBg() {
        if (this.labelInfo == null) {
            return null;
        }
        return this.labelInfo.getParent();
    }

    @Override
    public Control getControlToColorFg() {
        return this.labelInfo;
    }

    @Override
    public ILabelProvider getTreeLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public IProject getProject() {
        if (this.dataContainer == null || this.dataContainer.getProject() == null) {
            return null;
        }
        return this.dataContainer.getProject();
    }

    @Override
    public void setCancelActionEnabled(boolean isEnabled) {
        this.cancelAction.setEnabled(isEnabled);
    }

    @Override
    public ISelection getSelection() {
        boolean hasPortsView = this.hasPortsView();
        boolean focused = false;
        if (hasPortsView) {
            focused = this.portsView.isFocused();
        }
        if (focused) {
            return this.portsView.getSelection();
        }
        return super.getSelection();
    }

    public DVTLabelProviderProxy<IVHViewContributor> getTopDialogLabelProvider() {
        return this.topDialogLabelProvider;
    }

    @Override
    public void gotoSelectedElement(String treeId) {
        TreePath selectedElement = this.getLazyTree().getSelection();
        if (selectedElement == null) {
            return;
        }
        IProject project = this.getProject();
        if (project == null) {
            return;
        }
        this.currentContributor.setVHBreadcrumbData(selectedElement, project);
        this.currentContributor.gotoElement(project, selectedElement);
    }

    public HistoryItem getHistoryItem() {
        IProject project;
        HistoryItem xvhHistoryItem;
        if (IInterpreterViewsCommon.isInterpreterMode() && (xvhHistoryItem = this.getXVHHistoryItem(project = DVTPlugin.getSelectionManager().getLastSelectedProject())) != null) {
            return xvhHistoryItem;
        }
        if (this.dataContainer == null) {
            return null;
        }
        return this.dataContainer.getHistoryItem();
    }

    public HistoryItem getDataContainerHistoryItem() {
        if (this.dataContainer == null) {
            return null;
        }
        return this.dataContainer.getHistoryItem();
    }

    public TreeItem[] getTreeItems() {
        Tree tree = this.getLazyTree().getTree();
        if (tree != null) {
            return tree.getItems();
        }
        return null;
    }

    @Override
    public void postXvmReadyUpdate() {
        IProject project = this.getProject();
        if (project == null) {
            return;
        }
        DVTViewEvent event = new DVTViewEvent(DVTViewEvent.EventKind.CUSTOM, null, new ViewDataContainer(project, null));
        event.setOverrideView(true);
        event.setCustomImplementation(new DVTViewEvent.CustomEventImplementation(){

            @Override
            public void run() {
                if (!(this.view instanceof VerificationHierarchyView)) {
                    return;
                }
                ViewsUtilsCommon.updateView((VerificationHierarchyView)this.view, BuildEvents.INCREMENTAL_BUILD, false);
            }
        });
        Utils.safeRunSynchInUIThread(() -> ViewsUtils.notifyAllViewsById("ro.amiq.dvt.ui.views.VerificationHierarchyView", event, false));
    }

    @Override
    public void clean() {
        IProject project = this.getProject();
        if (project == null || !project.isAccessible() || !ro.amiq.dvt.utils.Utils.hasDvtNature(project)) {
            this.labelInfo.setText(LazyTreeMessageCompositeType.NO_DVT_PROJECT_SELECTED.getMessage());
            ProjectColorUtils.setFgBg(this, null);
            this.contentFiltersLabel.setEnabled(false);
        } else {
            this.labelInfo.setText("[" + project.getName() + "]");
            ProjectColorUtils.setFgBg(this, project.getName());
            this.contentFiltersLabel.setEnabled(this.hasGUIFilteredElements);
        }
        if (this.hasPortsView()) {
            this.portsView.updatePortsUsingTreePath(null, this.getTreeSearchPort(), this.getCurrentLanguageKind());
        }
        this.cleanPortsView(false);
        if (this.getLazyTree() != null) {
            this.getLazyTree().doAction(LazyTreeAction.CLEAN, new LazyTreeActionArguments(Objection.VERIFICATION_HIERARCHY));
        }
        this.verificationHierarchyModel = null;
    }

    @Override
    public void setInput(ViewDataContainer dataContainer) {
        this.selectTopAction.setIProject(dataContainer.getProject());
        super.setInput(dataContainer);
    }

    @Override
    public void update(BuildEvents updateEvent) {
        try {
            boolean resetVHModel;
            boolean isInterpreterMode;
            IProject project = this.getProject();
            if (project == null || !project.isAccessible()) {
                this.clean();
                return;
            }
            if (this.getHistoryItem() == null) {
                this.restoreTop(this.getProject());
            }
            if (this.getHistoryItem() == null) {
                this.clean();
                return;
            }
            if (IInterpreterViewsCommon.isInterpreterMode()) {
                if (this.alphabeticalSortAction.isEnabled()) {
                    this.alphabeticalSortAction.setEnabled(false);
                }
            } else if (!this.alphabeticalSortAction.isEnabled()) {
                this.alphabeticalSortAction.setEnabled(true);
            }
            if (this.currentContributor instanceof IXVHContributor && (updateEvent == BuildEvents.INCREMENTAL_BUILD || updateEvent == BuildEvents.GUI_FILTERS_WORKSPACE)) {
                return;
            }
            if (IInterpreterViewsCommon.isInterpreterMode() && updateEvent != BuildEvents.INTERPRETER_ACTION_VIEW) {
                this.verificationHierarchyModel = null;
                this.clean();
                updateEvent = this.currentContributor instanceof IXVHContributor && ((IXVHContributor)this.currentContributor).isXVMDatabaseReady() ? BuildEvents.INTERPRETER_MODE : null;
            }
            HistoryItem historyItem = updateEvent == BuildEvents.INTERPRETER_ACTION_VIEW ? this.getDataContainerHistoryItem() : this.getHistoryItem();
            boolean bl = isInterpreterMode = updateEvent == BuildEvents.PRE_INTERPRETER_MODE || updateEvent == BuildEvents.INTERPRETER_MODE || updateEvent == BuildEvents.INTERPRETER_FAILED || updateEvent == BuildEvents.INTERPRETER_ACTION_VIEW;
            if (!isInterpreterMode && historyItem.getLanguage() == LanguageKind.VLOG) {
                this.dataContainer.setHistoryItem(historyItem.copy(false, false));
            }
            this.resetContributor();
            if (project.hasNature("ro.amiq.vlogdt.VlogNature") && this.currentContributor != null && !this.currentContributor.isFactoryUpdateDone(project)) {
                this.currentContributor.initXVMFactory(project);
                return;
            }
            LazyTree lazyTree = this.getLazyTree();
            if (lazyTree == null) {
                return;
            }
            boolean resetSelection = updateEvent == null;
            boolean resetModel = historyItem == null || updateEvent == null || updateEvent == BuildEvents.FULL_BUILD || updateEvent == BuildEvents.INCREMENTAL_BUILD || updateEvent == BuildEvents.GUI_FILTERS_PROJECT || updateEvent == BuildEvents.GUI_FILTERS_WORKSPACE || updateEvent == BuildEvents.INTERPRETER_FAILED || updateEvent == BuildEvents.INTERPRETER_ACTION_VIEW;
            boolean resetTop = updateEvent == null || updateEvent != BuildEvents.INCREMENTAL_BUILD && updateEvent != BuildEvents.INTERPRETER_FAILED && updateEvent != BuildEvents.INTERPRETER_MODE;
            boolean interpreterFailed = updateEvent == BuildEvents.INTERPRETER_FAILED;
            boolean isPreInterpreterMode = updateEvent == BuildEvents.PRE_INTERPRETER_MODE;
            boolean isInterpreterFinishedEvent = updateEvent == BuildEvents.INTERPRETER_MODE || updateEvent == BuildEvents.INTERPRETER_FAILED;
            boolean bl2 = resetVHModel = !isInterpreterMode && this.verificationHierarchyModel instanceof XVHViewModel;
            if (this.verificationHierarchyModel == null || resetSelection || resetModel || interpreterFailed || isPreInterpreterMode) {
                this.labelProvider.setIsInterpreterActive(isInterpreterMode);
                IVHViewModel iVHViewModel = isInterpreterMode ? new XVHViewModel(this.getProject(), updateEvent == BuildEvents.INTERPRETER_ACTION_VIEW ? historyItem : null, this, this.getSortKind() == SortKind.ALPHABETICAL, this.isShowPrependPackage()) : (this.verificationHierarchyModel = new LazyVHModel(this.getProject(), historyItem, this, this.getSortKind() == SortKind.ALPHABETICAL, this.isShowPrependPackage(), this.isShowComponentsOnly()));
            }
            if (resetTop) {
                this.verificationHierarchyModel.setHasGUIFilteredElements(false);
            }
            if (interpreterFailed) {
                this.verificationHierarchyModel.setHasInterpreterFailed(true);
            }
            this.updateLabelInfo();
            if (this.hasPortsView()) {
                this.portsView.updatePortsUsingTreePath(null, this.getTreeSearchPort(), this.getCurrentLanguageKind());
            }
            LazyTreeUpdateViewActionArguments actionArg = new LazyTreeUpdateViewActionArguments(this, this.verificationHierarchyModel, resetSelection, resetTop, resetModel, isInterpreterFinishedEvent ? Objection.VERIFICATION_HIERARCHY_INTERPRETED : Objection.VERIFICATION_HIERARCHY);
            this.updateCHDiagramAdapter.setCurrentBuildEvent(updateEvent);
            actionArg.addUpdateListeners(this.updateCHDiagramAdapter);
            actionArg.addUpdateListeners(this.updateContentFiltersLabel);
            lazyTree.doAction(LazyTreeAction.UPDATE_VIEW, actionArg);
            if (resetVHModel) {
                this.updateVisibleBreadcrumbs();
                this.updateLogviewer(project);
            }
            if (updateEvent == BuildEvents.INTERPRETER_MODE) {
                this.addToHistoryAndSave(this.getHistoryItem());
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void updateLogviewer(IProject project) {
        LogViewerContributorUtils.get().updateHyperlinks(project);
    }

    private void updateVisibleBreadcrumbs() {
        List<IEditorPart> visibleEditors = Utils.computeVisibleEditors();
        for (IEditorPart editor : visibleEditors) {
            IDVTBreadcrumbHost bcHost;
            AbstractBreadcrumbViewer bcViewer;
            if (!(editor instanceof IDVTBreadcrumbHost) || !((bcViewer = (bcHost = (IDVTBreadcrumbHost)editor).getBreadcrumbViewer(VHBreadcrumbViewer.class)) instanceof VHBreadcrumbViewer)) continue;
            bcHost.updateBreadcrumb(VHBreadcrumbViewer.class, null);
        }
    }

    private void updateLabelInfo() {
        if (this.labelInfo == null || this.labelInfo.isDisposed()) {
            return;
        }
        String labelText = "";
        IProject project = this.getProject();
        if (project == null || !project.isAccessible()) {
            this.labelInfo.setText("[no DVT Project or file selected]");
            return;
        }
        if (this.getHistoryItem() == null) {
            this.labelInfo.setText("[" + project.getName() + "]");
            return;
        }
        HistoryItem top = this.getHistoryItem();
        IVHViewContributor iVHViewContributor = this.currentContributor = top.isInterpreterActive() ? XViewsUtils.getXVHContributor() : VHViewUtils.getViewContributor(top.getLanguage());
        if (this.currentContributor == null) {
            this.labelInfo.setText("[" + project.getName() + "]");
            return;
        }
        labelText = this.currentContributor.getTreeLabelText(this.getHistoryItem());
        if (labelText == null || labelText.isEmpty()) {
            if (this.getProject() == null) {
                return;
            }
            labelText = "[" + this.getProject().getName() + "]";
        }
        this.hasGUIFilteredElements = false;
        boolean bl = this.hasGUIFilteredElements = this.hasGUIFilteredElements || this.verificationHierarchyModel != null && this.verificationHierarchyModel.hasGUIFilteredElements();
        if (EclipseUtils.isAtLeastEclipse419()) {
            this.contentFiltersLabel.setImage(this.hasGUIFilteredElements ? this.contentFiltersEnabledIcon : this.contentFiltersDisabledIcon);
        }
        this.contentFiltersLabel.setEnabled(this.hasGUIFilteredElements);
        this.labelInfo.setText(labelText);
    }

    @Override
    public String getMessageText() {
        if (this.getProject() == null || !this.getProject().isAccessible() || !ro.amiq.dvt.utils.Utils.hasDvtNature(this.getProject())) {
            return "Select a DVT Project or file then click the \"Select Top\" button.";
        }
        if (this.getModel(IModel.class) != null) {
            if (!this.getTextFilter("default-filter").getText().isEmpty()) {
                if (this.getCurrentContributor().isSearchedElementFiltered()) {
                    return LazyTreeMessageCompositeType.GUI_FILTERED.getMessage();
                }
                return LazyTreeMessageCompositeType.NO_MATCHES_FOUND.getMessage();
            }
            if (this.verificationHierarchyModel.hasGUIFilteredElements()) {
                return LazyTreeMessageCompositeType.GUI_FILTERED.getMessage();
            }
            if (this.verificationHierarchyModel.hasInterpreterFailed()) {
                return LazyTreeMessageCompositeType.INTERPRETER_FAILED.getMessage();
            }
            return LazyTreeMessageCompositeType.NO_DATA.getMessage();
        }
        return LazyTreeMessageCompositeType.NO_DATA.getMessage();
    }

    @Override
    public boolean shouldShowSelectTopOption() {
        boolean isProjectSelected;
        boolean bl = isProjectSelected = this.getProject() != null && this.getProject().isAccessible() && ro.amiq.dvt.utils.Utils.hasDvtNature(this.getProject());
        return isProjectSelected && this.getHistoryItem() == null;
    }

    @Override
    public void selectTop() {
        this.selectTopAction.run();
    }

    protected void restoreTop(IProject project) {
        if (project == null || !project.isAccessible() || !ro.amiq.dvt.utils.Utils.hasDvtNature(project)) {
            this.clean();
            return;
        }
        this.setTop(null);
        LanguageKind lang = BuildConfigManager.getVerificationHierarchyTopLanguage(project);
        try {
            if (lang != null && project.hasNature(lang.NATURE_ID)) {
                String verificationHierarchyTop = BuildConfigManager.getVerificationHierarchyTop(project);
                HistoryItem historyItem = VHViewUtils.getViewContributor(lang).parseHistoryItem(project.getName(), verificationHierarchyTop);
                this.setTop(historyItem);
                this.addToHistory(historyItem);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (this.getHistoryItem() != null) {
            return;
        }
        List<HistoryItem> canditates = this.getTops();
        if (canditates != null && canditates.size() == 1) {
            this.setTop(canditates.get(0));
            this.addToHistoryAndSave(canditates.get(0));
        }
    }

    protected Object getSelectedElement() {
        TreePath selection = this.getLazyTree().getSelection();
        if (selection == null || selection.getElement() == null) {
            return null;
        }
        return selection.getElement();
    }

    public void setUpAndUpdate(HistoryItem historyItem, boolean saveInHistory) {
        IBuildEventManagerListener xModelEventListener;
        Object xModelStarter;
        this.setTop(historyItem);
        if (saveInHistory) {
            this.addToHistoryAndSave(historyItem);
        }
        if ((xModelStarter = XUVMElaborationStarters.getStarter(LanguageKind.VLOG)) != null && (xModelEventListener = xModelStarter.getXModelEventListener()) instanceof IDVTXModelManager) {
            ((IDVTXModelManager)xModelEventListener).refreshVHDependentViews(historyItem.getProject());
        }
        this.update(null);
    }

    public void setTop(HistoryItem top) {
        this.dataContainer.setHistoryItem(top);
    }

    @Override
    public List<IVHViewContributor> getViewContributors() {
        return DVTViewContributors.getInstance().getAllInstanceOf(IVHViewContributor.class);
    }

    private void resetContributor() {
        HistoryItem top = this.getHistoryItem();
        if (top != null) {
            if (top.isInterpreterActive()) {
                this.currentContributor = XViewsUtils.getXVHContributor();
            } else {
                if (this.currentContributor instanceof IXVHContributor) {
                    ((IXVHContributor)this.currentContributor).deepClean();
                }
                this.currentContributor = VHViewUtils.getViewContributor(top.getLanguage());
            }
            return;
        }
        if (this.currentContributor == null) {
            this.currentContributor = VHViewUtils.getViewContributor(LanguageKind.E);
        }
    }

    @Override
    public void dispose() {
        DVTMixedLangModelManager.getInstance().removeXvmFactoryInitListeners(this);
        super.dispose();
    }

    @Override
    public String prepareText(String textFilterId, String text) {
        return text;
    }

    @Override
    public void stringMatcherUpdated(String uIJobTextFilterId) {
        this.updateLabelInfo();
        if (this.hasPortsView() && this.isFiltered()) {
            this.portsView.updatePortsUsingTreePath(null, this.getTreeSearchPort(), this.getCurrentLanguageKind());
        }
        this.getCurrentContributor().setSearchedElementFiltered(false);
        this.getLazyTree().doAction(LazyTreeAction.SEARCH, new LazyTreeSearchActionArguments(false, Objection.VERIFICATION_HIERARCHY));
    }

    @Override
    public List<String> getMemberNames(IDVTElementWrapper node) {
        if (node == null) {
            return null;
        }
        IMembersLabelProvider tableLabelProvider = this.portsView.getCurrentTableLabelProvider(node);
        List<IDVTElementWrapper> wrappers = RfMixedLangManager.getInstance().getMembersInput(this.getProject(), node, null, tableLabelProvider, true).getElements();
        if (wrappers == null) {
            return null;
        }
        return wrappers.stream().map(elem -> {
            IMembersLabelProvider tableLabelProvider1 = this.portsView.getCurrentTableLabelProvider((IDVTElementWrapper)elem);
            String text = tableLabelProvider1.getText(elem);
            return text;
        }).collect(Collectors.toList());
    }

    public boolean hasPortsView() {
        return this.portsView != null && this.portsViewMode != PortsViewMode.HIDE;
    }

    public boolean shouldShowPortsView() {
        return this.portsViewMode != PortsViewMode.HIDE;
    }

    public PortsViewMode getPortsViewMode() {
        return this.portsViewMode;
    }

    public PortsViewMode getPortsModeFromPref(boolean noHide) {
        boolean showPorts = PrefConst.getDHViewShowPorts();
        if (!showPorts && !noHide) {
            return PortsViewMode.HIDE;
        }
        return PrefConst.getDHViewShowPortsBelow() ? PortsViewMode.BELOW : PortsViewMode.RIGHT;
    }

    public void setShowPortsView(PortsViewMode mode) {
        this.portsViewMode = mode;
        PrefConst.setDHViewShowPorts(mode != PortsViewMode.HIDE);
        if (mode != PortsViewMode.HIDE) {
            PrefConst.setDHViewShowPortsBelow(mode == PortsViewMode.BELOW);
        }
    }

    private void updatePortsView() {
        if (!this.hasPortsView()) {
            return;
        }
        LazyTree lazyTree = this.getLazyTree();
        if (lazyTree == null) {
            return;
        }
        TreePath selection = lazyTree.getSelection();
        if (selection == null || this.portsView == null) {
            return;
        }
        this.portsView.updatePortsUsingTreePath(selection, this.getTreeSearchPort(), this.getCurrentLanguageKind());
    }

    public void cleanPortsView(boolean showEmptyMessage) {
        if (this.hasPortsView()) {
            this.portsView.cleanView(showEmptyMessage);
        }
    }

    void hidePortsView() {
        this.setShowPortsView(PortsViewMode.HIDE);
        Composite parent = this.upperSashForm.getParent();
        SashForm oldSash = this.upperSashForm;
        int[] oldWeights = oldSash.getWeights();
        if (oldWeights != null && oldWeights.length == 2) {
            this.sashWeights = oldWeights;
        }
        this.upperSashForm = new SashForm(parent, oldSash.getStyle());
        this.upperSashForm.setLayout(oldSash.getLayout());
        this.upperSashForm.setLayoutData(oldSash.getLayoutData());
        this.sashChildTree.setParent((Composite)this.upperSashForm);
        if (this.sashChildPorts != null) {
            this.sashChildPorts.dispose();
        }
        this.sashChildPorts = null;
        if (this.portsView != null && !this.portsView.getControl().isDisposed()) {
            this.portsView.dispose();
        }
        this.portsView = null;
        oldSash.dispose();
        parent.layout();
    }

    protected SortKind getSortKind() {
        if (this.alphabeticalSortAction != null) {
            return this.alphabeticalSortAction.isChecked() ? SortKind.ALPHABETICAL : SortKind.NONE;
        }
        return PrefConst.getVHViewSortAlphabetically() ? SortKind.ALPHABETICAL : SortKind.NONE;
    }

    public boolean isShowComponentsOnly() {
        if (this.showComponentsOnly != null) {
            return this.showComponentsOnly.isChecked();
        }
        return PrefConst.getVHViewShowComponentsOnly();
    }

    public boolean isShowPrependPackage() {
        if (this.prependPackageAction != null) {
            return this.prependPackageAction.isChecked();
        }
        return PrefConst.getVHViewPrependPackage();
    }

    @Override
    protected void createViewSpecificPartControl(Composite parent) {
        this.controlParent = parent;
        LazyTree lazyTree = new LazyTree(this);
        this.setLazyTree(lazyTree);
        this.childComposite = new Composite(parent, 0);
        this.childComposite.setLayoutData((Object)new GridData(1808));
        this.childComposite.setLayout((Layout)DVTLazyViewUtils.LAYOUT);
        this.mainSashForm = new SashForm(this.childComposite, 512);
        this.mainSashForm.setLayout((Layout)DVTLazyViewUtils.LAYOUT);
        this.mainSashForm.setFont(this.childComposite.getFont());
        this.mainSashForm.setLayoutData((Object)new GridData(1808));
        Composite fUpperSashFormComposite = new Composite((Composite)this.mainSashForm, 0);
        fUpperSashFormComposite.setLayout((Layout)DVTLazyViewUtils.LAYOUT);
        fUpperSashFormComposite.setLayoutData((Object)new GridData(1808));
        Composite labelComposite = new Composite(fUpperSashFormComposite, 0);
        GridLayout labelLayout = new GridLayout(2, false);
        labelComposite.setLayout((Layout)labelLayout);
        labelComposite.setLayoutData((Object)new GridData(4, 1, false, false));
        this.contentFiltersLabel = new Label(labelComposite, 0);
        this.contentFiltersLabel.setImage(DVTImages.imageCache.getImage(DVTImages.GUI_FILTERS_ICON_MINI));
        this.contentFiltersLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.contentFiltersLabel.setToolTipText("Content Filters matched!");
        this.contentFiltersLabel.setEnabled(this.hasGUIFilteredElements);
        this.labelInfo = new Label(labelComposite, 16384);
        this.labelInfo.setFont(labelComposite.getFont());
        this.labelInfo.setLayoutData((Object)new GridData(768));
        this.updateLabelInfo();
        this.upperSashForm = new SashForm(fUpperSashFormComposite, 512);
        this.upperSashForm.setLayout((Layout)DVTLazyViewUtils.TWO_PART_LAYOUT);
        this.upperSashForm.setLayoutData((Object)new GridData(1808));
        this.sashChildTree = new Composite((Composite)this.upperSashForm, 0);
        this.sashChildTree.setLayout((Layout)DVTLazyViewUtils.LAYOUT);
        this.sashChildTree.setLayoutData((Object)new GridData(1808));
        Text filterText = this.createNewTextFilter(this.sashChildTree);
        if (filterText != null) {
            filterText.setMessage("Filter by: hierarchical name .port");
        }
        TextFilterObject filter = this.getTextFilterObject("default-filter");
        lazyTree.setSearchBar(filter);
        lazyTree.setLabelProvider(this.getLabelProvider(), false);
        lazyTree.install(this.sashChildTree);
        lazyTree.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                VerificationHierarchyView.this.updatePortsView();
            }
        });
        this.addSelectionChangedListener(InspectViewSelectionListener.getInstance());
        DVTMixedLangModelManager.getInstance().addXvmFactoryInitListeners(this);
        this.resetContributor();
        parent.addHelpListener((HelpListener)DVTHelpListener.getInstance());
        lazyTree.getTree().addKeyListener((KeyListener)this.getKeyListener("default-filter", "default-tree"));
        if (this.shouldShowPortsView()) {
            this.showPortsView(this.getPortsModeFromPref(true));
        }
    }

    @Override
    public void createToolBar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.removeAll();
        if (toolBarManager.getItems().length > 0) {
            toolBarManager.add((IContributionItem)new Separator());
        }
        this.cancelAction = new Action("", DVTImages.STOP_CURRENT_BUILD_PROCESS){

            public void run() {
                VerificationHierarchyView.this.getLazyTree().cancelOperations();
                this.setEnabled(false);
            }
        };
        this.cancelAction.setEnabled(false);
        this.cancelAction.setToolTipText("Cancel Current Operation");
        toolBarManager.add((IAction)this.cancelAction);
        toolBarManager.add((IContributionItem)new Separator());
        this.selectTopAction = new SelectVerificationTopAction(DVTPlugin.getSelectionManager().getLastSelectedProject(), PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        toolBarManager.add((IAction)this.selectTopAction);
        this.historyAction = new VerificationHierarchyActions.VHHistoryAction(this);
        toolBarManager.add((IAction)this.historyAction);
        toolBarManager.add((IContributionItem)new Separator());
        this.portsViewAction = new VerificationHierarchyActions.PortsViewAction(this);
        toolBarManager.add((IAction)this.portsViewAction);
        toolBarManager.add((IContributionItem)new Separator());
        this.showComponentsOnly = new VerificationHierarchyActions.ShowOnlyComponentsAction(this);
        toolBarManager.add((IAction)this.showComponentsOnly);
        this.prependPackageAction = new VerificationHierarchyActions.PrependPackageAction(this);
        toolBarManager.add((IAction)this.prependPackageAction);
        this.alphabeticalSortAction = new VerificationHierarchyActions.AlphabeticalSortAction(this);
        toolBarManager.add((IAction)this.alphabeticalSortAction);
        LazyTree lazyTree = this.getLazyTree();
        toolBarManager.add((IAction)new ExpandAllAction(lazyTree));
        toolBarManager.add((IAction)new CollapseAllAction(lazyTree));
        toolBarManager.update(true);
    }

    @Override
    protected void createCustomContextMenu(IMenuManager manager) {
        this.addToTreeContextMenu(manager, this.currentContributor.getAdditionalContextMenuActionIds(this.getSelectedElement()));
    }

    private void xSaveCHDDiagramAction(IMenuManager manager) {
        if (!(this.getCurrentContributor() instanceof IXVHContributor)) {
            return;
        }
        TreePath selection = this.getLazyTree().getSelection();
        if (selection == null) {
            return;
        }
        Object selectedElement = selection.getElement();
        if (!(selectedElement instanceof IXXVMComponent)) {
            return;
        }
        IXXVMComponent parent = ((IXXVMComponent)selectedElement).getParent();
        if (parent == null) {
            manager.add((IAction)new VerificationHierarchyActions.XModelSaveCHDDiagram(this));
        }
        if (parent == null || !DVTXRunBuildPhaseUtils.XVM_ROOT.contains(parent.getSanitizedType(LanguageKind.VLOG, false))) {
            return;
        }
        manager.add((IAction)new VerificationHierarchyActions.XModelSaveCHDDiagram(this));
    }

    private void addToTreeContextMenu(IMenuManager manager, List<String> additionalActions) {
        if (manager == null || additionalActions == null || additionalActions.isEmpty()) {
            return;
        }
        IContributionItem[] items = manager.getItems();
        HashSet<String> itemsIds = new HashSet<String>();
        IContributionItem[] iContributionItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            itemsIds.add(item.getId());
            ++n2;
        }
        for (String actionID : additionalActions) {
            if (COPY_HIERARCHY_PATH.equals(actionID)) {
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)this.copyInstancePathAction);
            }
            if (OPEN_TYPE_DECLARATION_ACTION.equals(actionID)) {
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)this.openTypeDeclarationAction);
            }
            if (!OPEN_CREATE_CALL_ACTION.equals(actionID)) continue;
            manager.add((IAction)this.openCreateCallAction);
        }
    }

    public void showPortsView(PortsViewMode mode) {
        this.setShowPortsView(mode);
        if (this.upperSashForm == null) {
            return;
        }
        Composite parent = this.upperSashForm.getParent();
        SashForm oldSash = this.upperSashForm;
        int[] oldWeights = oldSash.getWeights();
        if (oldWeights != null && oldWeights.length == 2) {
            this.sashWeights = oldWeights;
        }
        this.upperSashForm = new SashForm(parent, mode == PortsViewMode.BELOW ? 512 : 256);
        this.upperSashForm.setLayout(oldSash.getLayout());
        this.upperSashForm.setLayoutData(oldSash.getLayoutData());
        this.sashChildTree.setParent((Composite)this.upperSashForm);
        if (this.sashChildPorts == null) {
            this.sashChildPorts = new Composite((Composite)this.upperSashForm, 0);
            this.sashChildPorts.setLayout((Layout)DVTLazyViewUtils.LAYOUT);
            this.sashChildPorts.setFont(this.mainSashForm.getFont());
            this.sashChildPorts.setLayoutData((Object)new GridData(1808));
            this.portsView = new VerificationHierarchyPortsView(this);
            this.portsView.initAndShow(this.sashChildPorts, "");
            this.sashChildPorts.layout();
            this.upperSashForm.setWeights(this.sashWeights);
        } else {
            this.sashChildPorts.setParent((Composite)this.upperSashForm);
        }
        oldSash.dispose();
        parent.layout();
        TreePath selection = this.getLazyTree().getSelection();
        this.portsView.updatePortsUsingTreePath(selection, this.getTreeSearchPort(), this.getCurrentLanguageKind());
    }

    @Override
    public LazyVerificationHierarchyTestUtils getLazyTreeTestUtils() {
        return this.verificationHierarchyTestUtils;
    }

    public VerificationHierarchyPortsView testHelpGetPortsView() {
        return this.portsView;
    }

    public List<Object> getTreeElementsForRoot(Object root) {
        return this.verificationHierarchyModel.getTreeElementsForRoot(root);
    }

    public Composite getTestControlParent() {
        return this.controlParent;
    }

    public void testHelpSelectVHViewTreeItem(TreeItem item) {
        Tree tree = this.getLazyTree().getTree();
        if (tree == null || tree.isDisposed()) {
            return;
        }
        tree.setSelection(item);
        tree.showSelection();
        tree.notifyListeners(13, new Event());
    }

    public Object getRoot() {
        ArrayList<HistoryItem> arrayList = new ArrayList<HistoryItem>();
        arrayList.add(this.getHistoryItem());
        return arrayList;
    }

    String getTopHistoryItemText(HistoryItem top) {
        return this.topDialogLabelProvider.getText(top);
    }

    ImageDescriptor getTopHistoryItemImage(HistoryItem top) {
        Image image = this.topDialogLabelProvider.getImage(top);
        if (image == null) {
            return DVTImages.VLOG_PERSPECTIVE;
        }
        return ImageDescriptor.createFromImage((Image)image);
    }

    public void addToHistoryAndSave(HistoryItem top) {
        this.addToHistory(top);
        this.saveToBuildConfig(top);
    }

    private void saveToBuildConfig(final HistoryItem historyItem) {
        if (historyItem == null || historyItem.getProject() == null) {
            return;
        }
        if (!BuildConfigManager.setVerificationHierarchyTop(historyItem.getProject(), historyItem.toString(), historyItem.getLanguage())) {
            DVTInfoPopup popup = new DVTInfoPopup("Cannot Save Verification Hierarchy Top", "<a>.dvt/build_config.xml</a> is not writable", null);
            popup.open();
            popup.addLinkListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PreferencesUtil.createPropertyDialogOn((Shell)Display.getCurrent().getActiveShell(), (IAdaptable)historyItem.getProject().getFile(".dvt/build.config.xml"), (String)"org.eclipse.ui.propertypages.info.file", null, null).open();
                }
            });
        }
    }

    public void addToHistory(HistoryItem top) {
        if (top == null) {
            return;
        }
        ((VerificationHierarchyActions.VHHistoryAction)this.historyAction).addElement(top);
    }

    private static class UpdateCHDiagramAdapter
    implements IDVTLazyViewListener {
        private BuildEvents currentBuildEvent;
        private VerificationHierarchyView view;

        public UpdateCHDiagramAdapter(VerificationHierarchyView view) {
            this.view = view;
        }

        @Override
        public void stateChanged() {
            if (this.currentBuildEvent != null && this.currentBuildEvent != BuildEvents.CLEAN_BUILD) {
                Utils.safeRunAsynchInUIThread(() -> CHEditorFactory.refreshCHDiagrams(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), this.view));
            }
        }

        public void setCurrentBuildEvent(BuildEvents currentBuildEvent) {
            this.currentBuildEvent = currentBuildEvent;
        }
    }

    private static class UpdateContentFiltersLabel
    implements IDVTLazyViewListener {
        private VerificationHierarchyView view;

        public UpdateContentFiltersLabel(VerificationHierarchyView view) {
            this.view = view;
        }

        @Override
        public void stateChanged() {
            Display.getDefault().asyncExec(() -> this.view.updateLabelInfo());
        }
    }
}

