/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.actions.history.IVHHistoryItem;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.MembersViewInput;
import ro.amiq.dvt.ui.views.TextFilterObject;
import ro.amiq.dvt.ui.views.ViewDataContainer;
import ro.amiq.dvt.ui.views.ViewKind;
import ro.amiq.dvt.ui.views.lazy.tree.AbstractTreeIterator;
import ro.amiq.dvt.ui.views.lazy.tree.IVHViewModel;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.views.DVTLazyView;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.IVHViewContributor;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VHViewUtils;
import ro.amiq.dvt.utils.StringMatcher;

public abstract class VerificationHierarchyViewCommon
extends DVTLazyView {
    public static final String ID = "ro.amiq.dvt.ui.views.VerificationHierarchyView";
    public static final EnumSet<ViewKind> VIEW_KIND = EnumSet.of(ViewKind.DYNAMIC_ELEMENT_INFORMATION, ViewKind.CAN_HANDLE_ALL_BUILD_EVENTS, ViewKind.CAN_HANDLE_GUI_FILTERS);
    protected IVHViewContributor currentContributor = VHViewUtils.getViewContributor(LanguageKind.E) != null ? VHViewUtils.getViewContributor(LanguageKind.E) : VHViewUtils.getViewContributor(LanguageKind.VLOG);
    protected IVHViewModel verificationHierarchyModel;
    protected ViewDataContainer dataContainer;
    protected boolean dirty;

    @Override
    public void setInput(ViewDataContainer dataContainer) {
        this.dataContainer = dataContainer;
    }

    @Override
    public ViewDataContainer getDataContainer() {
        return this.dataContainer;
    }

    @Override
    public void setDirty(boolean isDirty) {
        this.dirty = isDirty;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public EnumSet<ViewKind> getKind() {
        return VIEW_KIND;
    }

    public IVHViewContributor getCurrentContributor() {
        return this.currentContributor;
    }

    public LanguageKind getCurrentLanguageKind() {
        return this.currentContributor.getLanguageKind();
    }

    public List<HistoryItem> getTops() {
        ArrayList<HistoryItem> results = new ArrayList<HistoryItem>();
        for (IVHViewContributor contributor : this.getViewContributors()) {
            results.addAll(contributor.getTops(this.getProject()));
        }
        return results;
    }

    @Override
    public List<? extends IRfNamedElement> getPorts(TreePath path) {
        if (path == null) {
            return null;
        }
        Object wrapper = path.getElement();
        ArrayList<IRfNamedElement> result = new ArrayList<IRfNamedElement>();
        IVHViewContributor contributor = VHViewUtils.getViewContributor(this.getCurrentLanguageKind());
        MembersViewInput input = contributor.getMembersInput(path.getElement(), new StringMatcher("*", true, false));
        if (input == null) {
            return null;
        }
        List<IDVTElementWrapper> elements = input.getElements();
        if (elements == null) {
            elements = Collections.emptyList();
        }
        for (IDVTElementWrapper element : elements) {
            IRfNamedElement namedElement = contributor.getMemberNamedElement(element);
            if (namedElement == null) continue;
            result.add(namedElement);
        }
        if (wrapper == null) {
            return null;
        }
        return result;
    }

    public void setCurrentContributor(IVHViewContributor currentContributor) {
        this.currentContributor = currentContributor;
    }

    @Override
    public void addViewSpecificListeners(AbstractTreeIterator treeIterator) {
    }

    @Override
    public boolean supportsDecorations() {
        return false;
    }

    @Override
    public String getTreeSearchPort() {
        TextFilterObject textFilterObject = this.getTextFilterObject("default-filter");
        if (textFilterObject == null) {
            return "";
        }
        return textFilterObject.getSearchPort();
    }

    public String getTestName() {
        if (this.dataContainer == null) {
            return null;
        }
        HistoryItem historyItem = this.dataContainer.getHistoryItem();
        if (!(historyItem instanceof IVHHistoryItem)) {
            return null;
        }
        return ((IVHHistoryItem)((Object)historyItem)).getTestName();
    }

    public abstract List<IVHViewContributor> getViewContributors();
}

