/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import ro.amiq.dvt.interpreter.XViewsUtils;
import ro.amiq.dvt.model.reflection.semantic.extension2.DummyElement;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.lazy.tree.AbstractTreeIterator;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.LazyVHModel;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VerificationHierarchyView;

public class XVHViewModel
extends LazyVHModel {
    public XVHViewModel(IProject project, HistoryItem historyItem, IRfFilterableTreeAccessor verificationHierarchyView, boolean isAlphabeticalSort, boolean showPrependPackage) {
        super(project, historyItem, verificationHierarchyView, isAlphabeticalSort, showPrependPackage, false);
        this.currentContributor = XViewsUtils.getXVHContributor();
        if (this.currentContributor != null) {
            this.currentContributor.resetState();
        }
    }

    @Override
    public List<TreePath> getChildren(TreePath treePath, int childStartIndex, int childEndIndex, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        if (this.project == null || treePath == null) {
            return Collections.emptyList();
        }
        if (this.currentContributor == null) {
            return Collections.emptyList();
        }
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        if (treePath == TreePath.TOP_DUMMY_TREE_PATH) {
            String testName = this.lazyView instanceof VerificationHierarchyView ? ((VerificationHierarchyView)this.lazyView).getTestName() : null;
            TreePath child = this.currentContributor.createRootTreePath(this.topElement, treePath, this.isPrependPackage, testName, monitor);
            if (child == null) {
                child = AbstractTreeIterator.getDummyOperatioNode(null);
            }
            result.add(child);
            return result;
        }
        if (this.isRecursiveNode(treePath)) {
            TreePath recurrenceNode = TreePath.child(treePath, DummyElement.RECURRENCE_NODE.getName(), 0);
            recurrenceNode.setElement(DummyElement.RECURRENCE_NODE);
            return Collections.singletonList(recurrenceNode);
        }
        Object element = treePath.getElement();
        if (element instanceof DummyElement) {
            return result;
        }
        List<Object> children = this.currentContributor.getChildrenForElement(element, this.lazyView, this.isPrependPackage, this.isAlphabeticalSort, this.isAlphabeticalSort, this.project, monitor);
        if (children == null) {
            return result;
        }
        int i = childStartIndex;
        while (i < Math.min(childEndIndex, children.size())) {
            TreePath prevChild;
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            Object dvtElementWrapper = children.get(i);
            String text = this.currentContributor.getText(dvtElementWrapper, treePath);
            TreePath child = TreePath.child(treePath, text, i, fLexicalSorter);
            child.setElement(dvtElementWrapper);
            TreePath treePath2 = prevChild = result.isEmpty() ? null : (TreePath)result.get(result.size() - 1);
            if (child.equals(prevChild, true)) {
                child.append("@(" + i + ")@");
            }
            result.add(child);
            ++i;
        }
        return result;
    }

    @Override
    public List<Object> getTreeElementsForRoot(Object root) {
        ArrayList<Object> children = new ArrayList<Object>();
        if (!(this.lazyView instanceof VerificationHierarchyView)) {
            return children;
        }
        VerificationHierarchyView vhView = (VerificationHierarchyView)this.lazyView;
        this.currentContributor = vhView.getCurrentContributor();
        List<TreePath> rootTreePaths = this.getChildren(TreePath.TOP_DUMMY_TREE_PATH, 0, Integer.MAX_VALUE, (IProgressMonitor)new NullProgressMonitor());
        for (TreePath rootTreePath : rootTreePaths) {
            DVTTreeElementWrapper rootWrapper = new DVTTreeElementWrapper(rootTreePath);
            this.computeChildrenForElement(rootWrapper);
            children.add(rootWrapper);
        }
        return children;
    }
}

