/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.power.domain;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.RootDesignElement;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.power.format.DVTPFInfo;
import ro.amiq.dvt.power.format.DVTPFIsolationStrategyInfo;
import ro.amiq.dvt.power.format.DVTPFRetentionRuleInfo;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.power.domain.PowerFormatContributor;

public class DVTPFLabelProvider
extends DVTBaseLabelProvider
implements ILabelProvider {
    private IProject project;

    @Override
    public String getText(Object wrapper) {
        if (wrapper == null) {
            return "";
        }
        if (wrapper instanceof RootDesignElement) {
            return "$root";
        }
        Object element = null;
        if (wrapper instanceof TreePath) {
            element = ((TreePath)wrapper).getElement();
        }
        if (wrapper instanceof DVTTreeElementWrapper) {
            element = ((DVTTreeElementWrapper)wrapper).getRfElement();
        }
        if (element instanceof DVTPFInfo) {
            return ((DVTPFInfo)element).getPowerDomainName();
        }
        if (element instanceof ElementPath) {
            return element.toString();
        }
        if (element instanceof PowerFormatContributor.PowerFormatItems) {
            return ((PowerFormatContributor.PowerFormatItems)((Object)element)).getName();
        }
        if (element instanceof DVTPFIsolationStrategyInfo) {
            return ((DVTPFIsolationStrategyInfo)element).getStrategyName();
        }
        if (element instanceof DVTPFRetentionRuleInfo) {
            return ((DVTPFRetentionRuleInfo)element).getRuleName();
        }
        return "";
    }

    @Override
    public Image getImage(Object wrapper) {
        Object element = null;
        TreePath treePath = null;
        if (wrapper instanceof TreePath) {
            treePath = (TreePath)wrapper;
        } else if (wrapper instanceof IDVTElementWrapper) {
            treePath = (TreePath)((IDVTElementWrapper)wrapper).getAdditionalInfo((Object)IDVTElementWrapper.Attribute.TREE_PATH);
        }
        if (treePath != null) {
            Object treePathElement;
            element = treePathElement = treePath.getElement();
            wrapper = new DVTTreeElementWrapper(treePathElement);
        }
        if (element == null) {
            return null;
        }
        Image result = null;
        if (element instanceof DVTPFInfo) {
            result = DVTImages.imageCache.getImage(DVTImages.POWER_DOMAIN);
        }
        if (element.equals((Object)PowerFormatContributor.PowerFormatItems.INSTANCES)) {
            result = DVTImages.imageCache.getImage(DVTImages.POWER_DOMAIN_INSTANCES);
        }
        if (element.equals((Object)PowerFormatContributor.PowerFormatItems.ISOLATION_STRATEGIES)) {
            result = DVTImages.imageCache.getImage(DVTImages.POWER_DOMAIN_IS_STRATEGIES);
        }
        if (element.equals((Object)PowerFormatContributor.PowerFormatItems.RETENTION_RULES)) {
            result = DVTImages.imageCache.getImage(DVTImages.POWER_DOMAIN_R_RULES);
        }
        if (element instanceof DVTPFIsolationStrategyInfo) {
            result = DVTImages.imageCache.getImage(DVTImages.POWER_DOMAIN_IS_STRATEGY);
        }
        if (element instanceof DVTPFRetentionRuleInfo) {
            result = DVTImages.imageCache.getImage(DVTImages.POWER_DOMAIN_R_RULE);
        }
        if (element instanceof ElementPath) {
            RfMixedLangProject mixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(this.project, false);
            if (mixedLangProject == null) {
                return null;
            }
            ELManager elManager = mixedLangProject.getELManager();
            if (elManager == null) {
                return null;
            }
            ELInstance elInstance = elManager.getMemory().instanceFor((ElementPath)element);
            IRfNamedElement binding = null;
            if (elInstance == null) {
                IRfNamedElement field;
                elInstance = elManager.getMemory().instanceFor(((ElementPath)element).removeLastSegment());
                if (elInstance == null) {
                    return DVTImages.imageCache.getImage(DVTImages.NONE);
                }
                binding = elInstance.getBinding(false);
                String portName = ((ElementPath)element).lastSegment();
                if (portName.contains("[")) {
                    portName = portName.substring(0, portName.indexOf(91));
                }
                if ((field = DesignUtils.getFieldOrInstanceByName(portName, DesignUtils.DesignRequest.of(binding))) == null) {
                    return DVTImages.imageCache.getImage(DVTImages.NONE);
                }
                if (field instanceof IRfPortElement) {
                    IRfPortElement port = (IRfPortElement)field;
                    if (port.isInput() || port.isOutput() || port.isInout()) {
                        return port.getImage();
                    }
                    if (port.isModportPort()) {
                        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_MODPORT);
                    }
                    if (port.isInterfacePort()) {
                        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_INTERFACE_PORT);
                    }
                    return DVTImages.imageCache.getImage(DVTImages.OUTLINE_NODIR_PORT);
                }
                return field.getImage();
            }
            binding = elInstance.getBinding(false);
            result = DesignUtils.getDesignImage(binding);
        }
        return result;
    }

    public void setProject(IProject project) {
        this.project = project;
    }
}

