/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.power.domain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.ui.views.lazy.tree.IModel;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.power.domain.PowerFormatContributor;

public class PowerDomainModel
implements IModel {
    private final Comparator<TreePath> comparator = (o1, o2) -> {
        if (o1 == null || o2 == null || o1.equals(o2)) {
            return 0;
        }
        if (TreePath.isParent(o1, o2)) {
            return -1;
        }
        if (TreePath.isParent(o2, o1)) {
            return 1;
        }
        int[] inds1 = o1.getIndices();
        int[] inds2 = o2.getIndices();
        int i = 0;
        while (i < Math.min(inds1.length, inds2.length)) {
            if (inds1[i] != inds2[i]) {
                return inds1[i] - inds2[i];
            }
            ++i;
        }
        return 0;
    };
    private IProject project;
    private PowerFormatContributor contributor;

    public PowerDomainModel(IProject project, PowerFormatContributor contributor) {
        this.project = project;
        this.contributor = contributor;
    }

    @Override
    public List<TreePath> getChildren(TreePath treePath, int childStartIndex, int childEndIndex, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        if (this.project == null || treePath == null) {
            return Collections.emptyList();
        }
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        List<Object> children = new ArrayList();
        children = treePath == TreePath.TOP_DUMMY_TREE_PATH ? this.contributor.getRootPowerDomains() : this.contributor.getChildrenForElement(treePath, monitor);
        if (children == null) {
            return result;
        }
        int i = childStartIndex;
        while (i < Math.min(childEndIndex, children.size())) {
            TreePath prevChild;
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            Object dvtElementWrapper = children.get(i);
            String text = this.contributor.getText(dvtElementWrapper);
            TreePath child = TreePath.child(treePath, text, i, this.comparator);
            child.setElement(dvtElementWrapper);
            TreePath treePath2 = prevChild = result.isEmpty() ? null : (TreePath)result.get(result.size() - 1);
            if (prevChild != null && child.equals(prevChild, true)) {
                child.append("@(" + i + ")@");
            }
            result.add(child);
            ++i;
        }
        return result;
    }

    @Override
    public Boolean hasChildren(TreePath treePath, IProgressMonitor monitor) {
        List<TreePath> children = this.getChildren(treePath, 0, 1, monitor);
        if (children != null && !children.isEmpty()) {
            return true;
        }
        return false;
    }

    @Override
    public TreePath getLastChild(TreePath treePath, IProgressMonitor monitor) {
        List<TreePath> children = this.getChildren(treePath, 0, Integer.MAX_VALUE, monitor);
        return children == null || children.isEmpty() ? null : children.get(children.size() - 1);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public TreePath getEndTreePath(TreePath path, IProgressMonitor monitor) {
        currentPath = path;
        children = this.getChildren(currentPath, 0, 0x7FFFFFFF, monitor);
        if (children != null && !children.isEmpty()) ** GOTO lbl7
        return currentPath;
lbl-1000:
        // 1 sources

        {
            currentPath = children.get(children.size() - 1);
            children = this.getChildren(currentPath, 0, 0x7FFFFFFF, monitor);
lbl7:
            // 2 sources

            ** while (children != null && !children.isEmpty())
        }
lbl8:
        // 1 sources

        return currentPath;
    }

    @Override
    public void clearModelCaches() {
    }
}

