/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.power.domain;

import java.util.EnumSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.RfProjectState;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.power.format.DVTPFInfo;
import ro.amiq.dvt.power.format.DVTPFIsolationStrategyInfo;
import ro.amiq.dvt.power.format.DVTPFRetentionRuleInfo;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.InspectViewUpdateEvent;
import ro.amiq.dvt.ui.views.TextFilterObject;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.ViewDataContainer;
import ro.amiq.dvt.ui.views.ViewKind;
import ro.amiq.dvt.ui.views.inspect.InspectViewComponent;
import ro.amiq.dvt.ui.views.inspect.InspectViewSelectionListener;
import ro.amiq.dvt.ui.views.lazy.tree.AbstractTreeIterator;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTModel;
import ro.amiq.dvt.ui.views.lazy.tree.IModel;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeIteratorType;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeMessageCompositeType;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeAction;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSearchActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeUpdateViewActionArguments;
import ro.amiq.dvt.ui.views.lazy.views.CollapseAllAction;
import ro.amiq.dvt.ui.views.lazy.views.DVTLazyView;
import ro.amiq.dvt.ui.views.lazy.views.DVTLazyViewUtils;
import ro.amiq.dvt.ui.views.lazy.views.ExpandAllAction;
import ro.amiq.dvt.ui.views.power.domain.DVTPFLabelProvider;
import ro.amiq.dvt.ui.views.power.domain.PowerDomainModel;
import ro.amiq.dvt.ui.views.power.domain.PowerDomainTestUtils;
import ro.amiq.dvt.ui.views.power.domain.PowerFormatContributor;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.Utils;

public class PowerDomainView
extends DVTLazyView {
    public static final String ID = "ro.amiq.dvt.ui.views.PowerDomainView";
    protected boolean dirty;
    protected ViewDataContainer dataContainer;
    private Composite childComposite;
    private Composite labelContainer;
    private Label infoLabel;
    private DVTPFLabelProvider labelProvider = new DVTPFLabelProvider();
    private PowerDomainModel powerDomainModel;
    private final PowerDomainTestUtils lazyTreeTestUtils = new PowerDomainTestUtils(this);
    private Action fShowRuleDefinitionMenuItem = new ShowRuleAction();
    private Action fShowStrategyDefinitionMenuItem = new ShowStrategyAction();
    private Action fShowPDDefinitionMenuItem = new ShowPDAction();
    private Action cancelAction;
    private InspectViewComponent fInspectViewComponent;
    private ToggleInspectPanelAction fToggleInspectPanelAction = new ToggleInspectPanelAction();
    private SashForm upperSashForm;
    private Composite sashChildTree;
    private PowerFormatContributor contributor;
    private Composite controlParent;

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public EnumSet<ViewKind> getKind() {
        return VIEW_KIND;
    }

    @Override
    public void setDirty(boolean isDirty) {
        this.dirty = isDirty;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setInput(ViewDataContainer dataContainer) {
        this.dataContainer = dataContainer;
    }

    @Override
    public ViewDataContainer getDataContainer() {
        return this.dataContainer;
    }

    @Override
    public List<String> getMemberNames(IDVTElementWrapper node) {
        return null;
    }

    @Override
    public UpdateJob getUpdateJob() {
        return null;
    }

    @Override
    public String getTreeSearchPort() {
        return null;
    }

    @Override
    public StringMatcher[] getTreeSearchSegments() {
        TextFilterObject textFilterObject = this.getTextFilterObject("default-filter");
        if (textFilterObject == null) {
            return null;
        }
        return textFilterObject.getSearchSegments();
    }

    @Override
    public boolean[] getTreeSearchStrictness() {
        TextFilterObject textFilterObject = this.getTextFilterObject("default-filter");
        if (textFilterObject == null) {
            return null;
        }
        return textFilterObject.getSearchTextStrictness();
    }

    @Override
    protected void createViewSpecificPartControl(Composite parent) {
        this.controlParent = parent;
        LazyTree lazyTree = new LazyTree(this);
        this.setLazyTree(lazyTree);
        lazyTree.setLabelProvider(this.getLabelProvider(), true);
        this.childComposite = new Composite(parent, 0);
        this.childComposite.setLayoutData((Object)new GridData(1808));
        this.childComposite.setLayout((Layout)DVTLazyViewUtils.LAYOUT);
        SashForm mainSashForm = new SashForm(this.childComposite, 512);
        mainSashForm.setLayout((Layout)DVTLazyViewUtils.LAYOUT);
        mainSashForm.setFont(this.childComposite.getFont());
        mainSashForm.setLayoutData((Object)new GridData(1808));
        Composite fUpperSashFormComposite = new Composite((Composite)mainSashForm, 0);
        fUpperSashFormComposite.setLayout((Layout)DVTLazyViewUtils.LAYOUT);
        fUpperSashFormComposite.setLayoutData((Object)new GridData(1808));
        this.labelContainer = new Composite(fUpperSashFormComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(5, 5).applyTo(this.labelContainer);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)this.labelContainer);
        this.infoLabel = new Label(this.labelContainer, 16384);
        this.infoLabel.setLayoutData((Object)new GridData(768));
        this.upperSashForm = new SashForm(fUpperSashFormComposite, 256);
        this.upperSashForm.setLayout((Layout)DVTLazyViewUtils.TWO_PART_LAYOUT);
        this.upperSashForm.setLayoutData((Object)new GridData(1808));
        this.sashChildTree = new Composite((Composite)this.upperSashForm, 0);
        this.sashChildTree.setLayout((Layout)DVTLazyViewUtils.LAYOUT);
        this.sashChildTree.setLayoutData((Object)new GridData(1808));
        this.createTextFilter("default-filter", this.sashChildTree, "default-tree", false);
        TextFilterObject filter = this.getTextFilterObject("default-filter");
        filter.setTextFilterMessage("Filter by: hierarchical name");
        this.fInspectViewComponent = new InspectViewComponent((Composite)this.upperSashForm);
        this.fInspectViewComponent.setVisible(PrefConst.getPowerFormatShowInspectPanel());
        lazyTree.setSearchBar(filter);
        lazyTree.setLabelProvider(this.getLabelProvider(), false);
        lazyTree.install(this.sashChildTree);
        this.addSelectionChangedListener(InspectViewSelectionListener.getInstance());
        lazyTree.getTree().addKeyListener((KeyListener)this.getKeyListener("default-filter", "default-tree"));
    }

    @Override
    public void gotoSelectedElement(String treeId) {
        TreePath selectedTreePath = this.getLazyTree().getSelection();
        if (selectedTreePath == null) {
            return;
        }
        IProject project = this.getProject();
        if (project == null) {
            return;
        }
        Object element = selectedTreePath.getElement();
        if (element == null) {
            return;
        }
        if (element instanceof PowerFormatContributor.PowerFormatItems) {
            return;
        }
        RfMixedLangProject mixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false);
        if (mixedLangProject == null) {
            return;
        }
        ELManager manager = mixedLangProject.getELManager();
        if (manager == null) {
            return;
        }
        if (element instanceof DVTPFIsolationStrategyInfo) {
            DVTPFIsolationStrategyInfo info = (DVTPFIsolationStrategyInfo)element;
            GoToInfo.of(info.getFilePath(), -1, -1, info.getStartLine(), info.getDomainName(), LanguageKind.PF).open(project, true);
            return;
        }
        if (element instanceof DVTPFRetentionRuleInfo) {
            DVTPFRetentionRuleInfo info = (DVTPFRetentionRuleInfo)element;
            GoToInfo.of(info.getFilePath(), -1, -1, info.getStartLine(), info.getDomainName(), LanguageKind.PF).open(project, true);
            return;
        }
        if (element instanceof DVTPFInfo) {
            DVTPFInfo info = (DVTPFInfo)element;
            GoToInfo.of(info.getFilePath(), -1, -1, info.getStartLine(), info.getPowerDomainName(), LanguageKind.PF).open(project, true);
            return;
        }
        if (!(element instanceof ElementPath)) {
            return;
        }
        ElementPath elementPath = (ElementPath)element;
        ELInstance elInstance = manager.getMemory().instanceFor(elementPath);
        if (elInstance != null) {
            IRfInstanceElement instance = elInstance.getDescription();
            if (instance != null) {
                DVTRfUtils.goToDeclaration(instance, true);
            }
            return;
        }
        elInstance = manager.getMemory().instanceFor(elementPath.removeLastSegment());
        if (elInstance.getDescription() != null && elInstance.getDescription().getAssociatedType() instanceof IRfDesignElement) {
            IRfNamedElement field;
            IRfInstanceElement instance = elInstance.getDescription();
            if (instance == null) {
                return;
            }
            String fieldName = elementPath.lastSegment();
            if (fieldName.contains("[")) {
                fieldName = fieldName.substring(0, fieldName.indexOf("["));
            }
            if ((field = DesignUtils.getFieldOrInstanceByName(fieldName, DesignUtils.DesignRequest.of(instance.getAssociatedType()))) != null) {
                DVTRfUtils.goToDeclaration(field, true);
            }
        }
    }

    @Override
    public String prepareText(String textFilterId, String text) {
        return text;
    }

    @Override
    public void stringMatcherUpdated(String uIJobTextFilterId) {
        this.getLazyTree().doAction(LazyTreeAction.SEARCH, new LazyTreeSearchActionArguments(false, Objection.POWER_DOMAIN));
    }

    @Override
    public void update(BuildEvents updateEvent) {
        try {
            LazyTree lazyTree;
            IProject project = this.getProject();
            if (project == null || project != null && !project.isAccessible() || !Utils.hasDvtNature(project)) {
                this.clean();
                return;
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F636F7265")) {
                return;
            }
            if (updateEvent == null) {
                this.clean();
                this.infoLabel.setText("[" + project.getName() + "]");
                RfMixedLangProject rfProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false);
                if (!rfProject.isBuildDone() && !rfProject.isState(RfProjectState.RESTORED)) {
                    return;
                }
            }
            if (this.contributor == null) {
                this.contributor = new PowerFormatContributor(project, this.labelProvider);
            }
            if (this.powerDomainModel == null) {
                this.powerDomainModel = new PowerDomainModel(project, this.contributor);
            }
            if ((lazyTree = this.getLazyTree()) == null) {
                return;
            }
            this.labelProvider.setProject(project);
            if (!this.shouldKeepInspectSelection()) {
                this.fInspectViewComponent.update(null);
            }
            this.updateViewLabelInfo();
            lazyTree.doAction(LazyTreeAction.UPDATE_VIEW, new LazyTreeUpdateViewActionArguments(this, this.powerDomainModel, false, false, false, Objection.POWER_DOMAIN));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private boolean shouldKeepInspectSelection() {
        if (this.contributor == null) {
            return false;
        }
        TreePath selection = this.getSelectionFromTree();
        if (selection == null) {
            return false;
        }
        return this.contributor.shouldKeepSelection(selection);
    }

    private TreePath getSelectionFromTree() {
        Tree tree = this.getTree();
        if (tree == null) {
            return null;
        }
        TreeItem[] treeSelection = tree.getSelection();
        if (treeSelection.length == 0) {
            return null;
        }
        return (TreePath)treeSelection[0].getData();
    }

    private Tree getTree() {
        return this.getLazyTree() == null ? null : this.getLazyTree().getTree();
    }

    private void updateViewLabelInfo() {
        if (this.powerDomainModel == null) {
            return;
        }
        IProject project = this.getProject();
        this.infoLabel.setText(this.getHeader(project, true));
    }

    public String getHeader(IProject project, boolean displayProjectName) {
        String projectName;
        IDVTModel model = this.getModel(IModel.class);
        String header = "";
        if (!(model instanceof PowerDomainModel)) {
            return "";
        }
        String string = projectName = project != null ? project.getName() : "";
        if (displayProjectName) {
            return "[" + projectName + "]" + header;
        }
        return header;
    }

    @Override
    public void clean() {
        IProject project;
        if (this.getLazyTree() != null) {
            this.getLazyTree().doAction(LazyTreeAction.CLEAN, new LazyTreeActionArguments(null));
        }
        if ((project = this.getProject()) == null || project != null && !project.isAccessible() || !Utils.hasDvtNature(project)) {
            this.infoLabel.setText("[no DVT Project or file selected]");
        } else {
            this.infoLabel.setText(project.getName());
        }
        this.fInspectViewComponent.update(null);
        this.powerDomainModel = null;
        this.contributor = null;
    }

    @Override
    public Control getControlToColorBg() {
        return null;
    }

    @Override
    public Control getControlToColorFg() {
        return null;
    }

    @Override
    public IProject getProject() {
        if (this.dataContainer == null || this.dataContainer.getProject() == null) {
            return null;
        }
        return this.dataContainer.getProject();
    }

    @Override
    public void setCancelActionEnabled(boolean isEnabled) {
        this.cancelAction.setEnabled(isEnabled);
    }

    @Override
    public void createToolBar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        if (actionBars == null) {
            return;
        }
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.removeAll();
        if (toolBarManager.getItems().length > 0) {
            toolBarManager.add((IContributionItem)new Separator());
        }
        toolBarManager.add((IAction)this.fToggleInspectPanelAction);
        toolBarManager.add((IContributionItem)new Separator());
        this.cancelAction = new Action("", DVTImages.STOP_CURRENT_BUILD_PROCESS){

            public void run() {
                PowerDomainView.this.getLazyTree().cancelOperations();
                this.setEnabled(false);
            }
        };
        this.cancelAction.setEnabled(false);
        this.cancelAction.setToolTipText("Cancel Current Operation");
        toolBarManager.add((IAction)this.cancelAction);
        toolBarManager.add((IContributionItem)new Separator());
        LazyTree lazyTree = this.getLazyTree();
        toolBarManager.add((IAction)new ExpandAllAction(lazyTree));
        toolBarManager.add((IAction)new CollapseAllAction(lazyTree));
        toolBarManager.update(true);
    }

    @Override
    public IDVTModel getModel(Class<? extends IDVTModel> modelClass) {
        if (modelClass == null) {
            return null;
        }
        if (modelClass == IModel.class) {
            return this.powerDomainModel;
        }
        return null;
    }

    @Override
    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public ILabelProvider getTreeLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public void selectionChanged() {
    }

    @Override
    public void fireSelectionChanged(SelectionChangedEvent event) {
        super.fireSelectionChanged(event);
        if (this.fInspectViewComponent == null) {
            return;
        }
        ISelection selection = event.getSelection();
        if (!(selection instanceof StructuredSelection) || selection.isEmpty()) {
            return;
        }
        Object wrapper = ((StructuredSelection)selection).getFirstElement();
        if (!(wrapper instanceof IDVTElementWrapper)) {
            return;
        }
        ((IDVTElementWrapper)wrapper).setProject(this.getProject());
        this.fInspectViewComponent.update(new InspectViewUpdateEvent((IDVTElementWrapper)wrapper, event));
    }

    @Override
    public LazyTreeIteratorType getIteratorType() {
        return LazyTreeIteratorType.LAZY_POWER_DOMAIN;
    }

    @Override
    public Objection getObjection() {
        return Objection.POWER_DOMAIN;
    }

    @Override
    public PowerDomainTestUtils getLazyTreeTestUtils() {
        return this.lazyTreeTestUtils;
    }

    protected Composite testGetControlParent() {
        return this.controlParent;
    }

    @Override
    public void addViewSpecificListeners(AbstractTreeIterator treeIterator) {
    }

    @Override
    public boolean supportsDecorations() {
        return false;
    }

    @Override
    public String getMessageText() {
        if (this.getProject() == null || !this.getProject().isAccessible() || !Utils.hasDvtNature(this.getProject())) {
            return "Select a DVT Project or file.";
        }
        if (!this.getTextFilter("default-filter").getText().isEmpty()) {
            return LazyTreeMessageCompositeType.NO_MATCHES_FOUND.getMessage();
        }
        return LazyTreeMessageCompositeType.NO_DATA.getMessage();
    }

    @Override
    protected void createCustomContextMenu(IMenuManager manager) {
        TreePath selection = this.getLazyTree().getSelection();
        if (selection == null) {
            return;
        }
        if (this.contributor.canShowGotoStrategyDefinitionMenu(selection)) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.fShowStrategyDefinitionMenuItem);
        }
        if (this.contributor.canShowGotoRuleDefinitionMenu(selection)) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.fShowRuleDefinitionMenuItem);
        }
        if (this.contributor.canShowPDDefinitionMenu(selection)) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.fShowPDDefinitionMenuItem);
        }
    }

    public void showRuleDefinitionAction() {
        TreePath selection = this.getLazyTree().getSelection();
        if (selection == null) {
            return;
        }
        this.contributor.gotoRuleDefinition(this.getProject(), selection);
    }

    public void showPDDefinitionAction() {
        TreePath selection = this.getLazyTree().getSelection();
        if (selection == null) {
            return;
        }
        this.contributor.gotoPDDefinition(this.getProject(), selection);
    }

    class ShowPDAction
    extends Action {
        public ShowPDAction() {
            super("Show PD definition", 1);
            this.setDescription("Show PD definition");
            this.setToolTipText("Show PD definition");
        }

        public void run() {
            PowerDomainView.this.showPDDefinitionAction();
        }
    }

    class ShowRuleAction
    extends Action {
        public ShowRuleAction() {
            super("Show rule definition", 1);
            this.setDescription("Show rule definition");
            this.setToolTipText("Show rule definition");
        }

        public void run() {
            PowerDomainView.this.showRuleDefinitionAction();
        }
    }

    class ShowStrategyAction
    extends Action {
        public ShowStrategyAction() {
            super("Show strategy definition", 1);
            this.setDescription("Show strategy definition");
            this.setToolTipText("Show strategy definition");
        }

        public void run() {
            PowerDomainView.this.showRuleDefinitionAction();
        }
    }

    class ToggleInspectPanelAction
    extends Action {
        private static final String TOGGLE_INSPECT_PANEL = "Toggle Inspect Panel";

        public ToggleInspectPanelAction() {
            super(TOGGLE_INSPECT_PANEL, 2);
            this.setDescription(TOGGLE_INSPECT_PANEL);
            this.setToolTipText(TOGGLE_INSPECT_PANEL);
            this.setImageDescriptor(DVTImages.INSPECT_LAYOUT);
            this.setChecked(PrefConst.getPowerFormatShowInspectPanel());
        }

        public void run() {
            PrefConst.setPowerFormatViewShowInspectPanel(this.isChecked());
            PowerDomainView.this.fInspectViewComponent.setVisible(PrefConst.getPowerFormatShowInspectPanel());
            PowerDomainView.this.upperSashForm.layout();
        }
    }
}

