/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.power.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.power.format.DVTPFInfo;
import ro.amiq.dvt.power.format.DVTPFIsolationStrategyInfo;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.power.format.DVTPFRetentionRuleInfo;
import ro.amiq.dvt.power.format.utils.DVTPFUtils;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTViewContributor;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.utils.StringMatcher;

public class PowerFormatContributor
implements IDVTViewContributor {
    public static final Comparator<TreePath> treePathComparator = (w1, w2) -> {
        if (w1 == null || w2 == null || w1.equals(w2)) {
            return 0;
        }
        if (TreePath.isParent(w1, w2)) {
            return -1;
        }
        if (TreePath.isParent(w2, w1)) {
            return 1;
        }
        Object o1 = w1.getElement();
        Object o2 = w2.getElement();
        if (o1 instanceof DVTPFInfo && o2 instanceof DVTPFInfo) {
            return ((DVTPFInfo)o1).getStartLine() - ((DVTPFInfo)o2).getStartLine();
        }
        int[] inds1 = w1.getIndices();
        int[] inds2 = w2.getIndices();
        int i = 0;
        while (i < Math.min(inds1.length, inds2.length)) {
            if (inds1[i] != inds2[i]) {
                return inds1[i] - inds2[i];
            }
            ++i;
        }
        return 0;
    };
    private IProject project;
    private DVTBaseLabelProvider labelProvider;

    public PowerFormatContributor(IProject project, DVTBaseLabelProvider labelProvider) {
        this.project = project;
        this.labelProvider = labelProvider;
    }

    @Override
    public LanguageKind getLanguageKind() {
        return LanguageKind.PF;
    }

    @Override
    public boolean adaptsTo(Object adapted) {
        return adapted instanceof DVTPFInfo || adapted instanceof ElementPath || adapted instanceof PowerFormatItems;
    }

    @Override
    public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        return this.labelProvider;
    }

    @Override
    public String getComment(Object wrapper) {
        return null;
    }

    @Override
    public void gotoElement(IProject project, Object wrapper) {
    }

    @Override
    public boolean isSelectable(Object wrapper, Object referenceData, StringMatcher matcher) {
        return false;
    }

    public String getText(Object element) {
        if (element instanceof DVTPFInfo) {
            return ((DVTPFInfo)element).getPowerDomainName();
        }
        if (element instanceof PowerFormatItems) {
            return ((PowerFormatItems)((Object)element)).getName();
        }
        if (element instanceof ElementPath) {
            return element.toString();
        }
        if (element instanceof DVTPFIsolationStrategyInfo) {
            return ((DVTPFIsolationStrategyInfo)element).getStrategyName();
        }
        if (element instanceof DVTPFRetentionRuleInfo) {
            return ((DVTPFRetentionRuleInfo)element).getRuleName();
        }
        return null;
    }

    public List<Object> getChildrenForElement(TreePath treePath, IProgressMonitor monitor) {
        Object pdInfo;
        ArrayList<Object> result = new ArrayList<Object>();
        Object element = treePath.getElement();
        DVTPFModel upfModel = DVTPFUtils.getUpfModel(this.project);
        if (upfModel == null) {
            return result;
        }
        RfMixedLangProject mixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(this.project, false);
        if (mixedLangProject == null) {
            return null;
        }
        ELManager manager = mixedLangProject.getELManager();
        if (manager == null) {
            return null;
        }
        if (element instanceof DVTPFInfo) {
            Set<ElementPath> instances = ((DVTPFInfo)element).getInstances();
            if (instances != null && !instances.isEmpty()) {
                result.add((Object)PowerFormatItems.INSTANCES);
            }
            if (((DVTPFInfo)element).hasIsolationStrategy()) {
                result.add((Object)PowerFormatItems.ISOLATION_STRATEGIES);
            }
            if (((DVTPFInfo)element).hasRetentionRules()) {
                result.add((Object)PowerFormatItems.RETENTION_RULES);
            }
        }
        if (PowerFormatItems.INSTANCES.equals(element) && treePath.getParent().getElement() instanceof DVTPFInfo) {
            pdInfo = treePath.getParent().getElement();
            Set<ElementPath> instances = ((DVTPFInfo)pdInfo).getInstances();
            for (ElementPath instance : instances) {
                if (monitor.isCanceled()) {
                    return result;
                }
                result.add(instance);
            }
        }
        if (PowerFormatItems.ISOLATION_STRATEGIES.equals(element) && treePath.getParent().getElement() instanceof DVTPFInfo) {
            pdInfo = treePath.getParent().getElement();
            Set<String> isolationStrategies = ((DVTPFInfo)pdInfo).getIsolationStategies();
            for (String isolationStategy : isolationStrategies) {
                if (monitor.isCanceled()) {
                    return result;
                }
                result.add(((DVTPFInfo)pdInfo).getIsolationStrategyByName(isolationStategy));
            }
        }
        if (PowerFormatItems.RETENTION_RULES.equals(element) && treePath.getParent().getElement() instanceof DVTPFInfo) {
            pdInfo = treePath.getParent().getElement();
            Set<String> retentionRuleNames = ((DVTPFInfo)pdInfo).getRetentionRules();
            for (String retentionRuleName : retentionRuleNames) {
                if (monitor.isCanceled()) {
                    return result;
                }
                result.add(((DVTPFInfo)pdInfo).getRetentionRuleByName(retentionRuleName));
            }
        }
        if (element instanceof DVTPFIsolationStrategyInfo) {
            result.addAll(((DVTPFIsolationStrategyInfo)element).getElements());
        }
        if (element instanceof DVTPFRetentionRuleInfo) {
            result.addAll(((DVTPFRetentionRuleInfo)element).getElements());
        }
        return result;
    }

    public List<Object> getRootPowerDomains() {
        DVTPFModel upfModel = DVTPFUtils.getUpfModel(this.project);
        if (upfModel == null) {
            return null;
        }
        Collection<DVTPFInfo> allPowerDomains = upfModel.getAllPDInfo();
        if (allPowerDomains == null) {
            return null;
        }
        return allPowerDomains.stream().sorted((o1, o2) -> o1.getStartLine() - o2.getStartLine()).collect(Collectors.toList());
    }

    public boolean canShowGotoRuleDefinitionMenu(Object element) {
        if (!(element instanceof TreePath)) {
            return false;
        }
        TreePath parent = ((TreePath)element).getParent();
        if (parent == null) {
            return false;
        }
        Object parentElement = parent.getElement();
        if (!(parentElement instanceof DVTPFRetentionRuleInfo)) {
            return false;
        }
        return ((TreePath)element).getElement() instanceof ElementPath;
    }

    public boolean canShowGotoStrategyDefinitionMenu(Object element) {
        if (!(element instanceof TreePath)) {
            return false;
        }
        TreePath parent = ((TreePath)element).getParent();
        if (parent == null) {
            return false;
        }
        Object parentElement = parent.getElement();
        if (!(parentElement instanceof DVTPFIsolationStrategyInfo)) {
            return false;
        }
        return ((TreePath)element).getElement() instanceof ElementPath;
    }

    public void gotoRuleDefinition(IProject project, TreePath selection) {
        TreePath parent = selection.getParent();
        if (parent == null) {
            return;
        }
        Object element = parent.getElement();
        if (!(element instanceof DVTPFRetentionRuleInfo) && !(element instanceof DVTPFIsolationStrategyInfo)) {
            return;
        }
        if (element instanceof DVTPFIsolationStrategyInfo) {
            DVTPFIsolationStrategyInfo info = (DVTPFIsolationStrategyInfo)element;
            GoToInfo.of(info.getFilePath(), -1, -1, info.getStartLine(), info.getDomainName(), LanguageKind.PF).open(project, true);
            return;
        }
        if (element instanceof DVTPFRetentionRuleInfo) {
            DVTPFRetentionRuleInfo info = (DVTPFRetentionRuleInfo)element;
            GoToInfo.of(info.getFilePath(), -1, -1, info.getStartLine(), info.getDomainName(), LanguageKind.PF).open(project, true);
            return;
        }
    }

    public boolean canShowPDDefinitionMenu(TreePath treePath) {
        TreePath parent = treePath.getParent();
        if (parent == null) {
            return false;
        }
        Object element = treePath.getElement();
        return element instanceof ElementPath || element instanceof PowerFormatItems || element instanceof DVTPFRetentionRuleInfo || element instanceof DVTPFIsolationStrategyInfo;
    }

    public void gotoPDDefinition(IProject project, TreePath selection) {
        TreePath parent = selection.getParent();
        while (parent != null && !(parent.getElement() instanceof DVTPFInfo)) {
            parent = parent.getParent();
        }
        if (parent == null || !(parent.getElement() instanceof DVTPFInfo)) {
            return;
        }
        DVTPFInfo powerDomain = (DVTPFInfo)parent.getElement();
        GoToInfo.of(powerDomain.getFilePath(), -1, -1, powerDomain.getStartLine(), powerDomain.getPowerDomainName(), LanguageKind.PF).open(project, true);
    }

    public boolean shouldKeepSelection(TreePath selection) {
        String parentDomainName;
        DVTPFModel upfModel = DVTPFUtils.getUpfModel(this.project);
        if (upfModel == null) {
            return false;
        }
        Object element = selection.getElement();
        if (element instanceof DVTPFInfo) {
            return upfModel.getPDInfoForPDName(((DVTPFInfo)element).getPowerDomainName()) != null;
        }
        if (element instanceof PowerFormatItems) {
            TreePath parentDomainTreePath = selection.getParent();
            if (parentDomainTreePath == null) {
                return false;
            }
            Object parentDomain = parentDomainTreePath.getElement();
            if (!(parentDomain instanceof DVTPFInfo)) {
                return false;
            }
            return upfModel.getPDInfoForPDName(((DVTPFInfo)parentDomain).getPowerDomainName()) != null;
        }
        if (!(element instanceof DVTPFRetentionRuleInfo) && !(element instanceof DVTPFIsolationStrategyInfo)) {
            TreePath parent = selection.getParent();
            if (parent == null) {
                return false;
            }
            element = parent.getElement();
        }
        if (element instanceof DVTPFRetentionRuleInfo) {
            parentDomainName = ((DVTPFRetentionRuleInfo)element).getDomainName();
            DVTPFInfo parentDomainInfo = upfModel.getPDInfoForPDName(parentDomainName);
            if (parentDomainInfo == null) {
                return false;
            }
            return parentDomainInfo.getRetentionRuleByName(((DVTPFRetentionRuleInfo)element).getRuleName()) != null;
        }
        if (element instanceof DVTPFIsolationStrategyInfo) {
            parentDomainName = ((DVTPFIsolationStrategyInfo)element).getDomainName();
            DVTPFInfo parentDomainInfo = upfModel.getPDInfoForPDName(parentDomainName);
            if (parentDomainInfo == null) {
                return false;
            }
            return parentDomainInfo.getIsolationStrategyByName(((DVTPFIsolationStrategyInfo)element).getStrategyName()) != null;
        }
        return false;
    }

    public static enum PowerFormatItems {
        INSTANCES("Instances"),
        RETENTION_RULES("Retention Rules"),
        ISOLATION_STRATEGIES("Isolation Strategies");

        private String name;

        private PowerFormatItems(String string2) {
            this.name = string2;
        }

        public String getName() {
            return this.name;
        }
    }
}

