/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.projectexplorer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.ICommonFilterDescriptor;
import org.eclipse.ui.navigator.INavigatorFilterService;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.views.projectexplorer.PENode;

public class PEHideNodeHandler
extends AbstractHandler {
    public static final String FILTER_ID = "org.eclipse.ui.navigator.resources.filters.DVTExamples";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Object element = structuredSelection.getFirstElement();
        if (element == null || !(element instanceof PENode)) {
            return null;
        }
        this.hide((PENode)element);
        this.howToShowDialog();
        return null;
    }

    private void hide(PENode node) {
        try {
            IWorkbenchPage page = DVTUiUtils.getActivePage();
            if (page == null) {
                return;
            }
            CommonNavigator view = (CommonNavigator)page.showView("org.eclipse.ui.navigator.ProjectExplorer");
            if (view == null) {
                return;
            }
            INavigatorFilterService filterService = view.getNavigatorContentService().getFilterService();
            if (filterService == null) {
                return;
            }
            ICommonFilterDescriptor[] filterDescriptors = filterService.getVisibleFilterDescriptors();
            if (filterDescriptors == null) {
                return;
            }
            List<ViewerFilter> visibleActiveFilters = Arrays.asList(filterService.getVisibleFilters(true));
            ArrayList<String> activeFilterIds = new ArrayList<String>();
            ICommonFilterDescriptor[] iCommonFilterDescriptorArray = filterDescriptors;
            int n = filterDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                ICommonFilterDescriptor filterDescriptor = iCommonFilterDescriptorArray[n2];
                ViewerFilter filter = filterService.getViewerFilter(filterDescriptor);
                if (visibleActiveFilters.contains(filter)) {
                    activeFilterIds.add(filterDescriptor.getId());
                }
                ++n2;
            }
            activeFilterIds.add(FILTER_ID);
            filterService.activateFilterIdsAndUpdateViewer(activeFilterIds.toArray(new String[activeFilterIds.size()]));
            filterService.persistFilterActivationState();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void howToShowDialog() {
        new MessageDialog(Utils.getActiveShell(), "Hide DVT-Examples", null, "You have chosen to hide DVT-Examples from the Project Explorer!\n\nTo show it again, click the View Menu button in the Project Explorer,\nthen pick the Customize View sub-menu.", 2, new String[]{IDialogConstants.OK_LABEL}, 0){

            protected Control createMessageArea(Composite composite) {
                Image image = this.getImage();
                if (image == null || this.message == null) {
                    return composite;
                }
                this.imageLabel = new Label(composite, 0);
                image.setBackground(this.imageLabel.getBackground());
                this.imageLabel.setImage(image);
                GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.imageLabel);
                Link link = new Link(composite, this.getMessageLabelStyle());
                link.setText(this.message);
                DVTUiUtils.setPlatformLinkColor((Link)link);
                GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)link);
                link.addSelectionListener((SelectionListener)new SelectionAdapter(){});
                return composite;
            }
        }.open();
    }
}

