/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.projectexplorer;

import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import ro.amiq.dvt.dvtcommand.DVTCommand;

@Root(name="node")
public class PENode {
    private boolean isHidden;
    @ElementList(entry="node", inline=true, required=false)
    private List<PENode> children = new ArrayList<PENode>();
    @Attribute(name="name")
    private String displayName;
    private PENode parent;
    @Attribute(name="icon")
    private String iconFile;
    @Element(name="command", required=false)
    private DVTCommand doubleClickAction;
    @Attribute(name="id", required=false)
    private String id;

    public PENode() {
    }

    public PENode(String displayName) {
        this.displayName = displayName;
    }

    public PENode(String displayName, String iconFile) {
        this(displayName);
        this.setIconFile(iconFile);
    }

    public void addChild(PENode n) {
        this.children.add(n);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<PENode> getChildren() {
        return this.children;
    }

    public PENode getParent() {
        return this.parent;
    }

    public void setParentsRecursive(PENode parent) {
        this.parent = parent;
        if (this.children == null || this.children.isEmpty()) {
            return;
        }
        for (PENode child : this.children) {
            child.setParentsRecursive(this);
        }
    }

    public String getIconFile() {
        return this.iconFile;
    }

    public void setIconFile(String iconFile) {
        this.iconFile = iconFile;
    }

    public DVTCommand getCommand() {
        return this.doubleClickAction;
    }

    public void setDoubleClickAction(DVTCommand doubleClickAction) {
        this.doubleClickAction = doubleClickAction;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void setHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }
}

