/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.projectexplorer;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import ro.amiq.dvt.dvtcommand.DVTCommand;
import ro.amiq.dvt.dvtcommand.DVTCommandParameter;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.views.projectexplorer.PENode;

public class PENodeAction
extends Action {
    private Runnable runnable;

    public PENodeAction(IWorkbenchPartSite site) {
        try {
            ISelection selection = site.getSelectionProvider().getSelection();
            if (selection.isEmpty()) {
                return;
            }
            IStructuredSelection structSel = (IStructuredSelection)selection;
            if (structSel.isEmpty() || !(structSel.getFirstElement() instanceof PENode)) {
                return;
            }
            PENode selectedNode = (PENode)structSel.getFirstElement();
            DVTCommand nodeCommand = selectedNode.getCommand();
            if (nodeCommand == null) {
                return;
            }
            String commandId = nodeCommand.getCommandId();
            ICommandService commandService = (ICommandService)site.getService(ICommandService.class);
            if (commandService == null) {
                return;
            }
            Command command = commandService.getCommand(commandId);
            if (command == null) {
                return;
            }
            List<DVTCommandParameter> commandParameters = nodeCommand.getDVTCommandParameters();
            HashMap<String, String> commandParametersHash = new HashMap<String, String>();
            for (DVTCommandParameter parameter : commandParameters) {
                commandParametersHash.put(parameter.getName(), parameter.getValue());
            }
            final ParameterizedCommand paramCommand = ParameterizedCommand.generateCommand((Command)command, commandParametersHash);
            if (paramCommand == null) {
                return;
            }
            final IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            if (handlerService == null) {
                return;
            }
            this.runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        handlerService.executeCommand(paramCommand, null);
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
            };
            this.setText(command.getName());
            this.setToolTipText(command.getDescription());
            this.setDescription(command.getDescription());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void run() {
        try {
            if (this.runnable != null) {
                this.runnable.run();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

