/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.projectexplorer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.core.Persister;
import ro.amiq.dvt.settings.DVTSFiles;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.views.projectexplorer.PENode;
import ro.amiq.dvt.ui.views.projectexplorer.PENodes;

public enum PENodesManager {
    INSTANCE;

    public static final String XML_NAME = "project_explorer_nodes.xml";
    private List<PENode> fModel;

    private PENodesManager() {
        this.load();
    }

    public void load() {
        this.fModel = new ArrayList<PENode>();
        try {
            URL xmlURL = PENode.class.getResource(XML_NAME);
            if (xmlURL == null) {
                return;
            }
            InputStream stream = xmlURL.openStream();
            this.load(stream, null);
            stream.close();
            List allNodesFiles = DVTSFiles.PROJECT_EXPLORER_NODES.getAllFiles(true);
            if (allNodesFiles == null) {
                return;
            }
            for (File f2 : allNodesFiles) {
                stream = f2.toURI().toURL().openStream();
                this.load(stream, f2);
                stream.close();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void load(InputStream stream, File file) throws Exception, IOException {
        Persister serializer = new Persister();
        PENodes content = (PENodes)serializer.read(PENodes.class, stream);
        List<PENode> nodes = content.getNodes();
        for (PENode node : nodes) {
            String id = node.getId();
            if (id == null || id.isEmpty()) {
                id = String.valueOf(node.getDisplayName()) + (file == null ? "" : " in " + file.getAbsolutePath());
            }
            node.setId(id);
            node.setHidden(false);
            node.setParentsRecursive(null);
            this.fModel.add(node);
        }
    }

    public List<PENode> getModel() {
        return this.fModel;
    }
}

