/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.refactoring;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import ro.amiq.dvt.DVTRefactorConnectWizardInput;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.util.RfGUIReferencesUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.RefactoringConnectOutOfSyncDiagramDVTNotification;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.refactor.connect.ConnectContributors;
import ro.amiq.dvt.ui.refactor.connect.ConnectInstancesTextPreviewJob;
import ro.amiq.dvt.ui.refactor.connect.ConnectInstancesWithoutPreivewJob;
import ro.amiq.dvt.ui.refactor.connect.IRefactorConnectAlgorithm;
import ro.amiq.dvt.ui.refactor.connect.PreviewInDiagramJob;
import ro.amiq.dvt.ui.refactor.connect.RefactorInputWrapper;
import ro.amiq.dvt.ui.refactor.connect.STATUS_KIND;
import ro.amiq.dvt.ui.refactor.connect.TextChange;
import ro.amiq.dvt.ui.refactor.designelement.DVTRefactorDesignElementUtils;
import ro.amiq.dvt.ui.utils.DVTColorUtil;

public class RefactoringConnectView
extends ViewPart {
    private static final String RESET_STRING = "Reset";
    private static final String COMPUTING_CHANGES = "Computing changes...";
    private VALIDATE_KIND state = VALIDATE_KIND.SRC_PATH;
    private static final String PREVIEW_IN_DIAGRAM = "Diagram Preview";
    private static final String CODE_PREVIEW = "Code Preview";
    private static final String GENERATING_PREVIEW_DIAGRAM = "Generating preview diagram...";
    private static final String COMPUTE_CHANGES_JOB = "Preview diagram";
    public static final String ID = "ro.amiq.dvt.ui.views.RefactoringConnectView";
    private Group fConnectToolbar;
    private String[] fSrcPath;
    private String[] fDstPath;
    private IRfPortElement fSrcPort;
    private IRfPortElement fDstPort;
    private StyledText fDstTxt;
    private StyledText fSrcTxt;
    private DVTRefactorConnectWizardInput fInfo = new DVTRefactorConnectWizardInput();
    private Set<RefactorInputWrapper> fResult;
    private List<TextFileChange> fChangeResult;
    private IProject fProject;
    private Text fVlogOutputPortName;
    private Text fVlogInputPortName;
    private Text fVlogParentSignal;
    private Text fVlogSignalType;
    private Text fVlogSignalWidth;
    private DDiagramEditor editor;
    private Button applyChanges;
    private Link fMessageLabel;
    private Label fImageLabel;
    private Button compute;
    private StyleRange fDstStyleRange;
    private StyleRange fSrcStyleRange;
    private Button fCancelCangesButton;
    protected Job computeChangesJob;
    public boolean hasVlog = true;
    public boolean hasVhdl;
    private Text fVhdlSignalType;
    private Text fVhdlSignalWidth;

    private void swap() {
        String auxText = this.getSrcTxt();
        this.fSrcTxt.setText(this.getDstTxt());
        this.fDstTxt.setText(auxText);
        StyleRange auxStyleRange = this.fSrcStyleRange;
        this.fSrcStyleRange = this.fDstStyleRange;
        this.fDstStyleRange = auxStyleRange;
        if (this.fSrcStyleRange != null) {
            this.fSrcTxt.setStyleRange(this.fSrcStyleRange);
        }
        if (this.fDstStyleRange != null) {
            this.fDstTxt.setStyleRange(this.fDstStyleRange);
        }
        String[] auxPath = this.fDstPath;
        this.fDstPath = this.fSrcPath;
        this.fSrcPath = auxPath;
        IRfPortElement auxPort = this.fSrcPort;
        this.fSrcPort = this.fDstPort;
        this.fDstPort = auxPort;
    }

    public void createPartControl(Composite parent) {
        this.fConnectToolbar = new Group(parent, 0);
        this.fConnectToolbar.setLayout((Layout)new GridLayout());
        this.fConnectToolbar.setLayoutData((Object)new GridData(4, 4, true, true));
        Group pathsOptionsComposite = new Group((Composite)this.fConnectToolbar, 0);
        pathsOptionsComposite.setText("");
        pathsOptionsComposite.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)pathsOptionsComposite);
        ModifyListener ml = e -> {
            this.updateAndValidate();
            this.validateAndSetViewInfo();
        };
        this.createPathsComposite((Composite)pathsOptionsComposite, ml);
        this.createOptionsComposite((Composite)pathsOptionsComposite, ml);
        this.createMessageComposite();
        this.createButtonsComposite();
    }

    private Job getComputeChangesJob() {
        return new Job(COMPUTE_CHANGES_JOB){

            protected IStatus run(IProgressMonitor monitor) {
                Boolean[] connectActivated = new Boolean[]{false};
                String[] status = new String[]{STATUS_KIND.EMPTY_STATUS.toString()};
                monitor.beginTask(RefactoringConnectView.GENERATING_PREVIEW_DIAGRAM, -1);
                RefactoringConnectView.this.fResult = null;
                RefactoringConnectView.this.updateGUIPartInitialState();
                try {
                    List<IRefactorConnectAlgorithm> algs = ConnectContributors.getAll();
                    for (IRefactorConnectAlgorithm alg : algs) {
                        alg.setProject(RefactoringConnectView.this.getProject());
                        if (!alg.isSupportedProject()) continue;
                        if (RefactoringConnectView.this.getSrcPort() != null && RefactoringConnectView.this.getSrcPort().getDeclaration() == null) {
                            status[0] = "Output port invalid";
                        }
                        if (RefactoringConnectView.this.getDstPort() != null && RefactoringConnectView.this.getDstPort().getDeclaration() == null) {
                            status[0] = "Input port invalid";
                        }
                        IRfNamedElement srcInstance = DVTRefactorDesignElementUtils.getElementFromSegments(RefactoringConnectView.this.fSrcPath, RefactoringConnectView.this.fProject);
                        IRfNamedElement dstInstance = DVTRefactorDesignElementUtils.getElementFromSegments(RefactoringConnectView.this.fDstPath, RefactoringConnectView.this.fProject);
                        if (srcInstance == null || srcInstance.getDeclaration() == null) {
                            status[0] = "Output instance is invalid";
                        }
                        if (dstInstance == null || dstInstance.getDeclaration() == null) {
                            status[0] = "Output instance is invalid";
                        }
                        if (srcInstance != null && srcInstance.isPrecompiledDB()) {
                            status[0] = "Output instance is precompiled";
                        }
                        if (dstInstance != null && dstInstance.isPrecompiledDB()) {
                            status[0] = "Output instance is precompiled";
                        }
                        alg.setRefactorInput(RefactoringConnectView.this.getInfo());
                        String validateWrappers = alg.validateWrappers(RefactoringConnectView.this.getSrcPath(), RefactoringConnectView.this.getSrcPort(), RefactoringConnectView.this.getDstPath(), RefactoringConnectView.this.getDstPort(), RefactoringConnectView.this.getProject(), RefactoringConnectView.this.getInfo(), monitor);
                        if (!status[0].isEmpty() || validateWrappers == null) continue;
                        status[0] = validateWrappers;
                    }
                    Boolean[] hasSideEffects = new Boolean[]{false};
                    RefactoringConnectView.this.fChangeResult = RefactoringConnectView.this.computeChanges(monitor, connectActivated, status, algs, hasSideEffects);
                }
                catch (OperationCanceledException operationCanceledException) {
                    status[0] = STATUS_KIND.COMPUTING_STOP.toString();
                }
                RefactoringConnectView.this.updateGuiPartCompleted(connectActivated, status);
                if (!status[0].isEmpty() || monitor.isCanceled()) {
                    return Status.OK_STATUS;
                }
                if (RefactoringConnectView.this.editor == null) {
                    return Status.OK_STATUS;
                }
                RfGUIReferencesUtils.closeConnectWizardAndShowPreviewDiagram(RefactoringConnectView.this);
                return Status.OK_STATUS;
            }
        };
    }

    private void updateGUIPartInitialState() {
        Utils.asyncExec(() -> {
            this.fMessageLabel.setText(COMPUTING_CHANGES);
            this.fCancelCangesButton.setEnabled(true);
        });
    }

    private void createMessageComposite() {
        Group container = new Group((Composite)this.fConnectToolbar, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo((Composite)container);
        GridDataFactory.fillDefaults().align(4, 1024).grab(true, false).applyTo((Control)container);
        container.setText("");
        Composite buttonsAndIcon = new Composite((Composite)container, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(buttonsAndIcon);
        GridDataFactory.fillDefaults().align(1, 4).grab(false, false).applyTo((Control)buttonsAndIcon);
        this.compute = new Button(buttonsAndIcon, 8);
        this.compute.setText("Compute Changes");
        this.compute.setEnabled(false);
        this.compute.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RefactoringConnectView.this.computeChangesJob = RefactoringConnectView.this.getComputeChangesJob();
                RefactoringConnectView.this.computeChangesJob.setUser(true);
                RefactoringConnectView.this.computeChangesJob.schedule();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fCancelCangesButton = new Button(buttonsAndIcon, 0);
        this.fCancelCangesButton.setEnabled(false);
        this.fCancelCangesButton.setImage(DVTImages.imageCache.getImage(DVTImages.STOP_CURRENT_BUILD_PROCESS));
        this.fCancelCangesButton.setEnabled(false);
        this.fCancelCangesButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (RefactoringConnectView.this.computeChangesJob != null) {
                    RefactoringConnectView.this.computeChangesJob.cancel();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fImageLabel = new Label(buttonsAndIcon, 0);
        this.fMessageLabel = new Link((Composite)container, 2048);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.fMessageLabel);
        this.fImageLabel.setImage(DVTImages.imageCache.getImage(DVTImages.DESC_INFO_TIP));
        this.fMessageLabel.setText(this.state.toString());
        this.fMessageLabel.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (RefactoringConnectView.CODE_PREVIEW.equals(e.text)) {
                    new ConnectInstancesTextPreviewJob(RefactoringConnectView.this).schedule();
                } else if (RefactoringConnectView.PREVIEW_IN_DIAGRAM.equals(e.text)) {
                    new PreviewInDiagramJob(RefactoringConnectView.this).schedule();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void updateGuiPartCompleted(Boolean[] connectActivated, String[] status) {
        Utils.asyncExec(() -> {
            this.applyChanges.setEnabled(connectActivated[0].booleanValue());
            this.fMessageLabel.setText(status[0]);
            if (!status[0].isEmpty()) {
                this.fImageLabel.setImage(DVTImages.imageCache.getImage(DVTImages.DESC_ERROR_TASK));
            } else {
                this.fImageLabel.setImage(DVTImages.imageCache.getImage(DVTImages.DESC_INFO_TIP));
                this.fMessageLabel.setText(VALIDATE_KIND.VLOG_INPUT_COMPUTED.toString());
            }
            this.fCancelCangesButton.setEnabled(false);
            if (this.editor != null) {
                this.editor.close();
                this.editor = null;
            }
        });
    }

    private List<TextFileChange> computeChanges(IProgressMonitor monitor, Boolean[] connectActivated, String[] status, List<IRefactorConnectAlgorithm> algs, Boolean[] hasSideEffects) {
        if (!status[0].isEmpty()) {
            return null;
        }
        LinkedHashSet<RefactorInputWrapper> resultWrappers = new LinkedHashSet<RefactorInputWrapper>();
        ArrayList<TextFileChange> result = new ArrayList<TextFileChange>();
        for (IRefactorConnectAlgorithm alg : algs) {
            alg.setProject(this.getProject());
            if (!alg.isSupportedProject()) continue;
            alg.setRefactorInput(this.getInfo());
            Set<RefactorInputWrapper> directChg = alg.computeDirectChangeWrappers(this.getSrcPath(), this.getSrcPort(), this.getDstPath(), this.getDstPort(), this.getProject(), monitor);
            Set<RefactorInputWrapper> indirectChg = alg.computeIndirectChangeWrappers(this.getSrcPath(), this.getSrcPort(), this.getDstPath(), this.getDstPort(), this.getProject(), monitor);
            resultWrappers.addAll(directChg);
            resultWrappers.addAll(indirectChg);
            hasSideEffects[0] = indirectChg != null && !indirectChg.isEmpty();
            Set<TextChange> textChgs = alg.computeChangesFromWrappers(resultWrappers, monitor);
            HashMap<IFile, ArrayList<TextChange>> textChgsByFile = new HashMap<IFile, ArrayList<TextChange>>();
            for (TextChange textChange : textChgs) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IFile key = textChange.file;
                ArrayList<TextChange> listChgs = (ArrayList<TextChange>)textChgsByFile.get(key);
                if (listChgs == null) {
                    listChgs = new ArrayList<TextChange>();
                    textChgsByFile.put(key, listChgs);
                }
                listChgs.add(textChange);
            }
            for (Map.Entry entry : textChgsByFile.entrySet()) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IFile file = (IFile)entry.getKey();
                TextFileChange txc = alg.getPreviewHDLColoring(file);
                txc.setEdit((TextEdit)new MultiTextEdit());
                for (TextChange textChg : (List)entry.getValue()) {
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    if (textChg.offset < 0) continue;
                    txc.getEdit().addChild((TextEdit)new ReplaceEdit(textChg.offset, textChg.length, textChg.text));
                }
                result.add(txc);
            }
            connectActivated[0] = true;
        }
        this.fResult = resultWrappers;
        return result;
    }

    public void closeDiagramAndView() {
        if (this.editor != null) {
            this.editor.close();
            this.editor = null;
        }
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        activePage.hideView((IViewPart)this);
    }

    private void createButtonsComposite() {
        Composite container = new Composite((Composite)this.fConnectToolbar, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).applyTo(container);
        GridDataFactory.fillDefaults().align(131072, 1024).grab(false, false).applyTo((Control)container);
        Button close = new Button(container, 8);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)close);
        close.setText("Close");
        close.setEnabled(true);
        close.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RefactoringConnectView.this.closeDiagramAndView();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.applyChanges = new Button(container, 8);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)this.applyChanges);
        this.applyChanges.setText("Apply Changes");
        this.applyChanges.setEnabled(false);
        this.applyChanges.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                new ConnectInstancesWithoutPreivewJob(RefactoringConnectView.this).schedule();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void createOptionsComposite(Composite parent, ModifyListener ml) {
        Composite optionsContainer = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).applyTo(optionsContainer);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)optionsContainer);
        Composite leftContainer = new Composite(optionsContainer, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)leftContainer);
        GridLayoutFactory.fillDefaults().numColumns(5).equalWidth(false).applyTo(leftContainer);
        Label outputPortLabel = new Label(leftContainer, 0);
        outputPortLabel.setText("Output name:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(false, false).applyTo((Control)outputPortLabel);
        this.fVlogOutputPortName = new Text(leftContainer, 2048);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).span(4, 1).applyTo((Control)this.fVlogOutputPortName);
        this.fVlogOutputPortName.setText(this.getInfo().getVlogOutputPortName());
        this.fVlogOutputPortName.addModifyListener(ml);
        Label inputPortLabel = new Label(leftContainer, 0);
        inputPortLabel.setText("Input name:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(false, false).applyTo((Control)inputPortLabel);
        this.fVlogInputPortName = new Text(leftContainer, 2048);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).span(4, 1).applyTo((Control)this.fVlogInputPortName);
        this.fVlogInputPortName.setText(this.getInfo().getVlogInputPortName());
        this.fVlogInputPortName.addModifyListener(ml);
        Label connectRootLabel = new Label(leftContainer, 0);
        connectRootLabel.setText("Signal name:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(false, false).applyTo((Control)connectRootLabel);
        this.fVlogParentSignal = new Text(leftContainer, 2048);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).span(4, 1).applyTo((Control)this.fVlogParentSignal);
        this.fVlogParentSignal.setText(this.getInfo().getVlogParentSignal());
        this.fVlogParentSignal.addModifyListener(ml);
        Composite rightContainer = new Composite(optionsContainer, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)rightContainer);
        GridLayoutFactory.fillDefaults().numColumns(5).equalWidth(false).applyTo(rightContainer);
        Label typeLabel = new Label(rightContainer, 0);
        typeLabel.setText("Signal type:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(false, false).applyTo((Control)typeLabel);
        this.fVlogSignalType = new Text(rightContainer, 2048);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).span(2, 1).applyTo((Control)this.fVlogSignalType);
        this.fVlogSignalType.setText(this.getInfo().getVlogSignalType());
        this.fVlogSignalType.addModifyListener(ml);
        this.fVhdlSignalType = new Text(rightContainer, 2048);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).span(2, 1).applyTo((Control)this.fVhdlSignalType);
        this.fVhdlSignalType.setText(this.fInfo.getVhdlSignalType());
        this.fVhdlSignalType.addModifyListener(ml);
        Label widthLabel = new Label(rightContainer, 0);
        widthLabel.setText("Signal width:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(false, false).applyTo((Control)widthLabel);
        this.fVlogSignalWidth = new Text(rightContainer, 2048);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).span(2, 1).applyTo((Control)this.fVlogSignalWidth);
        this.fVlogSignalWidth.setText(this.getInfo().getVlogSignalWidth());
        this.fVlogSignalWidth.addModifyListener(ml);
        this.fVlogSignalWidth.setMessage("e.g. 7:0");
        this.fVhdlSignalWidth = new Text(rightContainer, 2048);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).span(2, 1).applyTo((Control)this.fVhdlSignalWidth);
        this.fVhdlSignalWidth.setText(this.getInfo().getVhdlSignalWidth());
        this.fVhdlSignalWidth.addModifyListener(ml);
        this.fVhdlSignalWidth.setMessage("e.g. 7 downto 0");
        Label spacer = new Label(rightContainer, 0);
        GridDataFactory.fillDefaults().align(131072, 128).grab(true, false).span(4, 1).applyTo((Control)spacer);
        Button reset = new Button(rightContainer, 8);
        GridDataFactory.fillDefaults().align(131072, 128).grab(true, false).applyTo((Control)reset);
        reset.setText(RESET_STRING);
        reset.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RefactoringConnectView.this.resetView();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void createPathsComposite(Composite parent, ModifyListener ml) {
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(container);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)container);
        Label outputLabel = new Label(container, 0);
        outputLabel.setText("Output: ");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(false, false).applyTo((Control)outputLabel);
        this.fSrcTxt = new StyledText(container, 2048);
        this.fSrcTxt.addModifyListener(ml);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fSrcTxt, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.filter.backgroundColor"), true);
        this.fSrcTxt.setEditable(false);
        this.fSrcTxt.setEnabled(false);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.fSrcTxt);
        this.fSrcTxt.setToolTipText("Output Instance");
        Button swapButton = new Button(container, 8);
        swapButton.setImage(DVTImages.imageCache.getImage(DVTImages.SWAP));
        swapButton.setToolTipText("Swap Output instance with Input Instance");
        GridDataFactory.fillDefaults().span(1, 2).align(16384, 4).grab(false, true).applyTo((Control)swapButton);
        swapButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RefactoringConnectView.this.swap();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Label inputLabel = new Label(container, 0);
        inputLabel.setText("Input: ");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(false, false).applyTo((Control)inputLabel);
        this.fDstTxt = new StyledText(container, 2048);
        this.fDstTxt.addModifyListener(ml);
        this.fDstTxt.setEditable(false);
        this.fDstTxt.setEnabled(false);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fDstTxt, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.filter.backgroundColor"), true);
        this.fDstTxt.setToolTipText("Input Instance");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.fDstTxt);
    }

    private void validateAndSetViewInfo() {
        VALIDATE_KIND validate = this.validate();
        VALIDATE_KIND vALIDATE_KIND = this.state = validate == null ? VALIDATE_KIND.VLOG_INPUT_COMPLETED : validate;
        if (this.fMessageLabel != null) {
            this.fMessageLabel.setText(this.state == null ? "" : this.state.toString());
        }
        if (this.fImageLabel != null) {
            this.fImageLabel.setImage(DVTImages.imageCache.getImage(DVTImages.DESC_INFO_TIP));
        }
        if (this.compute != null) {
            this.compute.setEnabled(validate == null);
        }
        if (this.compute != null) {
            this.applyChanges.setEnabled(false);
        }
        if (this.editor != null && this.state == VALIDATE_KIND.VLOG_INPUT_COMPLETED) {
            new RefactoringConnectOutOfSyncDiagramDVTNotification(this.editor, 256, "Refactoring connect preview changed").create();
        }
    }

    public void setFocus() {
        this.fConnectToolbar.getParent().setFocus();
    }

    public IRfPortElement getDstPort() {
        return this.fDstPort;
    }

    public IRfPortElement getSrcPort() {
        return this.fSrcPort;
    }

    public String[] getDstPath() {
        return this.fDstPath;
    }

    public String[] getSrcPath() {
        return this.fSrcPath;
    }

    public boolean setProject(IProject project) {
        if (this.fProject != null && !this.fProject.equals((Object)project)) {
            if (TestHelper.isTestMode()) {
                this.updateGuiForProject(project);
                this.fProject = project;
                return true;
            }
            MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Refactoring Connect: project change detection", null, "A refactoring connect session is already in progress for project'" + this.fProject.getName() + "'. Do you want to abort it and start a new one for project '" + project.getName() + "'?", 5, new String[]{"Yes", "No"}, 0);
            int open = dialog.open();
            if (open == 0) {
                this.updateGuiForProject(project);
                this.fProject = project;
                return true;
            }
            return false;
        }
        this.fProject = project;
        this.updateGuiForProject(project);
        return true;
    }

    private void updateGuiForProject(IProject project) {
        try {
            boolean isVlog = project.hasNature("ro.amiq.vlogdt.VlogNature");
            boolean isVhdl = project.hasNature("ro.amiq.vhdldt.VhdlNature");
            GridData vlogSignalTypeData = (GridData)this.fVlogSignalType.getLayoutData();
            GridData vhdlSignalTypeData = (GridData)this.fVhdlSignalType.getLayoutData();
            GridData vlogSignalWidthData = (GridData)this.fVlogSignalWidth.getLayoutData();
            GridData vhdlSignalWidthData = (GridData)this.fVhdlSignalWidth.getLayoutData();
            vlogSignalTypeData.exclude = !isVlog;
            vhdlSignalTypeData.exclude = !isVhdl;
            vlogSignalWidthData.exclude = !isVlog;
            boolean bl = vhdlSignalWidthData.exclude = !isVhdl;
            if (isVhdl && isVlog) {
                vlogSignalTypeData.horizontalSpan = 2;
                vhdlSignalTypeData.horizontalSpan = 2;
                vlogSignalWidthData.horizontalSpan = 2;
                vhdlSignalWidthData.horizontalSpan = 2;
            } else if (isVlog) {
                vlogSignalTypeData.horizontalSpan = 4;
                vhdlSignalTypeData.horizontalSpan = 0;
                vlogSignalWidthData.horizontalSpan = 4;
                vhdlSignalWidthData.horizontalSpan = 0;
            } else if (isVhdl) {
                vlogSignalTypeData.horizontalSpan = 0;
                vhdlSignalTypeData.horizontalSpan = 4;
                vlogSignalWidthData.horizontalSpan = 0;
                vhdlSignalWidthData.horizontalSpan = 4;
            }
            this.fVlogSignalType.setLayoutData((Object)vlogSignalTypeData);
            this.fVhdlSignalType.setLayoutData((Object)vhdlSignalTypeData);
            this.fVlogSignalWidth.setLayoutData((Object)vlogSignalWidthData);
            this.fVhdlSignalWidth.setLayoutData((Object)vhdlSignalWidthData);
            this.fVlogSignalType.setVisible(isVlog);
            this.fVhdlSignalType.setVisible(isVhdl);
            this.fVlogSignalWidth.setVisible(isVlog);
            this.fVhdlSignalWidth.setVisible(isVhdl);
            this.fConnectToolbar.pack(true);
            this.fConnectToolbar.layout(true);
        }
        catch (CoreException e1) {
            DVTLogger.INSTANCE.logError((Throwable)e1);
        }
    }

    private void updateAndValidate() {
        String vlogTrimmedOutPortName = this.fVlogOutputPortName == null ? "" : this.fVlogOutputPortName.getText().trim();
        String vlogTrimmedInPortName = this.fVlogInputPortName == null ? "" : this.fVlogInputPortName.getText().trim();
        String vlogTrimmedParentSignal = this.fVlogParentSignal == null ? "" : this.fVlogParentSignal.getText().trim();
        String vlogTrimmedSignalType = this.fVlogSignalType == null ? "" : this.fVlogSignalType.getText().trim();
        String vlogTrimmedSignalWidth = this.fVlogSignalWidth == null ? "" : this.fVlogSignalWidth.getText().trim();
        String vhdlTrimmedOutPortName = this.fVlogOutputPortName == null ? "" : this.fVlogOutputPortName.getText().trim();
        String vhdlTrimmedInPortName = this.fVlogInputPortName == null ? "" : this.fVlogInputPortName.getText().trim();
        String vhdlTrimmedParentSignal = this.fVlogParentSignal == null ? "" : this.fVlogParentSignal.getText().trim();
        String vhdlTrimmedSignalType = this.fVhdlSignalType == null ? "" : this.fVhdlSignalType.getText().trim();
        String vhdlTrimmedSignalWidth = this.fVhdlSignalWidth == null ? "" : this.fVhdlSignalWidth.getText().trim();
        this.getInfo().updateVlogConnectInput(vlogTrimmedOutPortName, vlogTrimmedInPortName, vlogTrimmedParentSignal, vlogTrimmedSignalType, vlogTrimmedSignalWidth);
        this.getInfo().updateVhdlConnectInput(vhdlTrimmedOutPortName, vhdlTrimmedInPortName, vhdlTrimmedParentSignal, vhdlTrimmedSignalType, vhdlTrimmedSignalWidth);
    }

    public DVTRefactorConnectWizardInput getInfo() {
        return this.fInfo;
    }

    protected static char[] getAutoactivationChars() {
        String lowercaseLetters = "abcdefghijklmnopqrstuvwxyz";
        String uppercaseLetters = lowercaseLetters.toUpperCase();
        String numbers = "0123456789";
        String delete = new String(new char[]{'\b'});
        String allChars = String.valueOf(lowercaseLetters) + uppercaseLetters + numbers + delete;
        return allChars.toCharArray();
    }

    public void resetView() {
        this.fDstTxt.setText("");
        this.fSrcTxt.setText("");
        this.state = VALIDATE_KIND.VLOG_OUTPUT;
        this.fMessageLabel.setText(this.state.toString());
        this.fImageLabel.setImage(DVTImages.imageCache.getImage(DVTImages.DESC_INFO_TIP));
        this.fVlogOutputPortName.setText("out_port");
        this.fVlogInputPortName.setText("in_port");
        this.fVlogParentSignal.setText("connect_root");
        this.fVlogSignalType.setText("wire");
        this.fVhdlSignalType.setText("std_logic");
        this.fVlogSignalWidth.setText("");
        this.fVhdlSignalWidth.setText("");
        this.fVlogSignalWidth.setMessage("e.g. 7:0");
        this.fVhdlSignalWidth.setMessage("e.g. 7 downto 0");
        this.applyChanges.setEnabled(false);
        this.compute.setEnabled(false);
    }

    public void dispose() {
        if (this.editor != null) {
            this.editor.close();
        }
        this.editor = null;
        super.dispose();
    }

    public DDiagramEditor getEditor() {
        return this.editor;
    }

    public void setEditor(DDiagramEditor editor) {
        this.editor = editor;
    }

    public void setDstPath(String[] dstString, IRfPortElement port) {
        this.fDstPort = port;
        this.fDstPath = dstString;
        if (dstString == null || dstString.length == 0) {
            return;
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < dstString.length) {
            if (i != 0) {
                result.append(".");
            }
            result.append(dstString[i]);
            ++i;
        }
        this.fDstTxt.setText(String.valueOf(result.toString()) + (port == null ? "" : "." + port.getName()));
        if (port == null) {
            this.fDstStyleRange = null;
            this.fVlogInputPortName.setText("in_port");
            return;
        }
        StyleRange styleRange = new StyleRange();
        styleRange.start = result.length() + 1;
        styleRange.length = port.getName().length();
        styleRange.fontStyle = 1;
        this.fDstStyleRange = styleRange;
        this.fDstTxt.setStyleRange(styleRange);
        this.fVlogInputPortName.setText(port.getName());
    }

    public void setSrcPath(String[] srcString, IRfPortElement port) {
        this.fSrcPort = port;
        this.fSrcPath = srcString;
        if (srcString == null || srcString.length == 0) {
            return;
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < srcString.length) {
            if (i != 0) {
                result.append(".");
            }
            result.append(srcString[i]);
            ++i;
        }
        this.fSrcTxt.setText(String.valueOf(result.toString()) + (port == null ? "" : "." + port.getName()));
        if (port == null) {
            this.fSrcStyleRange = null;
            this.fVlogOutputPortName.setText("out_port");
            this.fVlogOutputPortName.setEnabled(true);
            return;
        }
        StyleRange styleRange = new StyleRange();
        styleRange.start = result.length() + 1;
        styleRange.length = port.getName().length();
        styleRange.fontStyle = 1;
        this.fSrcStyleRange = styleRange;
        this.fSrcTxt.setStyleRange(styleRange);
        this.fVlogOutputPortName.setText(port.getName());
    }

    public String getDstTxt() {
        return this.fDstTxt == null ? "" : this.fDstTxt.getText();
    }

    public String getSrcTxt() {
        return this.fSrcTxt == null ? "" : this.fSrcTxt.getText();
    }

    private VALIDATE_KIND validate() {
        if (this.fMessageLabel == null || this.fImageLabel == null) {
            return VALIDATE_KIND.SRC_PATH;
        }
        VALIDATE_KIND validatePaths = this.validatePaths();
        if (validatePaths != null) {
            return validatePaths;
        }
        VALIDATE_KIND validateOptions = this.validateOptions();
        if (validateOptions != null) {
            return validateOptions;
        }
        return null;
    }

    private VALIDATE_KIND validateOptions() {
        if (this.fVlogOutputPortName == null || this.fVlogOutputPortName.getText().isEmpty()) {
            return VALIDATE_KIND.VLOG_OUTPUT;
        }
        if (this.fVlogInputPortName == null || this.fVlogInputPortName.getText().isEmpty()) {
            return VALIDATE_KIND.VLOG_INPUT;
        }
        if (this.fVlogParentSignal == null || this.fVlogParentSignal.getText().isEmpty()) {
            return VALIDATE_KIND.VLOG_SIGNAL_NAME;
        }
        if (this.fVlogSignalType == null || this.fVlogSignalType.getText().isEmpty()) {
            return VALIDATE_KIND.VLOG_SIGNAL_TYPE;
        }
        if (this.fVlogSignalWidth == null) {
            return VALIDATE_KIND.VLOG_SIGNAL_WIDTH;
        }
        return null;
    }

    private VALIDATE_KIND validatePaths() {
        if (this.fSrcTxt == null || this.fSrcTxt.getText().isEmpty()) {
            return VALIDATE_KIND.SRC_PATH;
        }
        if (this.fDstTxt == null || this.fDstTxt.getText().isEmpty()) {
            return VALIDATE_KIND.DST_PATH;
        }
        return null;
    }

    protected void popUnsupportedElement() {
        if (TestHelper.isTestMode()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Limited Operation", null, "Not all the refactoring connect arguments are specified.", 1, new String[]{"OK"}, 0);
            dialog.open();
        });
    }

    public Set<RefactorInputWrapper> getResult() {
        return this.fResult;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public boolean isViewVisible() {
        return true;
    }

    public CompositeChange getChangeResult() {
        CompositeChange change = new CompositeChange("all changes");
        for (TextFileChange textFileChange : this.fChangeResult) {
            TextFileChange copyTextFileChange = new TextFileChange(textFileChange.getName(), textFileChange.getFile());
            TextEdit textEdit = textFileChange.getEdit();
            copyTextFileChange.setEdit(textEdit);
            change.add((Change)copyTextFileChange);
        }
        return change;
    }

    static enum Lang {
        VLOG,
        VHDL,
        MIXED;

    }

    static enum VALIDATE_KIND {
        SRC_PATH("Output path is not specified.\nRight click on a signal or instance and choose Refactor > Connect"),
        DST_PATH("Input path is not specified.\nRight click on a signal or instance and choose Refactor > Connect"),
        VLOG_OUTPUT("Ouput port name is not specified"),
        VLOG_INPUT("Input port name is not specified"),
        VLOG_SIGNAL_NAME("Signal name is not specified"),
        VLOG_SIGNAL_TYPE("Signal type is not specified"),
        VLOG_SIGNAL_WIDTH("Signal width is not specified"),
        VLOG_INPUT_COMPLETED("Press 'Compute...' in order to compute the changes."),
        VLOG_INPUT_COMPUTED("Press <a>Diagram Preview</a> / <a>Code Preview</a> in order to connect.");

        String string;

        private VALIDATE_KIND(String string2) {
            this.string = string2;
        }

        public String toString() {
            return this.string;
        }
    }
}

