/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.registers;

import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.interpreter.IXXVMRegBlock;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.interpreter.DVTXInterpreterViewsLabelProvider;
import ro.amiq.dvt.ui.views.interpreter.IInterpreterViewsCommon;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;

public class DVTXRegistersLabelProvider
extends DVTXInterpreterViewsLabelProvider {
    private boolean isTreeModeSet;
    private boolean isDisplayMode16Set;

    @Override
    public Image getColumnImage(Object element, int columnIndex) {
        if (!(element instanceof IXXVMRegBlock) && columnIndex == 1) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if (element == null) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        IXXVMRegBlock xvmRegBlock = (IXXVMRegBlock)element;
        if (columnIndex == 0) {
            if (!xvmRegBlock.isBlockRegisters()) {
                return DVTImages.imageCache.getImage(DVTImages.XVM_REGISTER);
            }
            return DVTImages.imageCache.getImage(DVTImages.XVM_REGISTER_BLOCK);
        }
        String sequencerName = xvmRegBlock.getSequencerName();
        if (columnIndex == 3 && !xvmRegBlock.isBlockRegisters() && sequencerName != null && !sequencerName.isEmpty()) {
            return DVTImages.imageCache.getImage(DVTImages.XVM_COMPONENT_INSTANCE);
        }
        return DVTImages.imageCache.getImage(DVTImages.NONE);
    }

    @Override
    public String getColumnText(Object obj, int columnIndex) {
        String dataContent = this.getLabelInfo(obj, columnIndex);
        return ViewsUtils.trimBeginningText(dataContent, (Integer)this.fColumnIndexesSizes.get(columnIndex) / 10);
    }

    @Override
    public Image getImage(Object element) {
        if (element instanceof TreePath) {
            element = ((TreePath)element).getElement();
        }
        if (!(element instanceof IXXVMRegBlock)) {
            return null;
        }
        return !((IXXVMRegBlock)element).isBlockRegisters() ? DVTImages.imageCache.getImage(DVTImages.XVM_REGISTER) : DVTImages.imageCache.getImage(DVTImages.XVM_REGISTER_BLOCK);
    }

    public void setDisplayHierarhical(boolean displayHierarhical) {
        this.isTreeModeSet = displayHierarhical;
    }

    public void setDisplayMode16(boolean isDisplayMode16Set) {
        this.isDisplayMode16Set = isDisplayMode16Set;
    }

    @Override
    public String getColumnTextWithoutTrimming(Object parentNode, int columnIndex) {
        return this.getLabelInfo(parentNode, columnIndex);
    }

    @Override
    public String getLabelInfo(Object parentNode, int columnIndex) {
        if (parentNode instanceof TreePath) {
            parentNode = ((TreePath)parentNode).getElement();
        }
        if (!(parentNode instanceof IXXVMRegBlock)) {
            return "";
        }
        IXXVMRegBlock register = (IXXVMRegBlock)parentNode;
        boolean isInterpreterState = IInterpreterViewsCommon.isInterpreterMode();
        String dataContent = "";
        String seqName = register.getSequencerName();
        switch (columnIndex) {
            case 0: {
                String string = dataContent = this.isTreeModeSet ? register.getName() : register.getRegisterFullName();
                if (!isInterpreterState || register.isBlockRegisters() || seqName != null && !seqName.isEmpty()) break;
                dataContent = String.valueOf(dataContent) + " [unmapped]";
                break;
            }
            case 1: {
                if (register.getKind() != IXXVMRegBlock.RegisterKind.REGISTER) break;
                dataContent = this.isDisplayMode16Set ? register.getAddressBase16() : register.getAddressBase10();
                break;
            }
            case 2: {
                dataContent = register.getRights();
                break;
            }
            case 3: {
                if (!isInterpreterState) break;
                dataContent = register.getSequencerName();
                break;
            }
            case 4: {
                dataContent = register.getComment();
                break;
            }
        }
        return dataContent;
    }
}

