/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.registers;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.diagrams.wavedrom.BitFieldFactory;
import ro.amiq.dvt.interpreter.IXXVMRegBlock;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.IXvmFactoryInitListener;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.EclipseUtils;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.projectcolors.ProjectColorUtils;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.DVTViewEvent;
import ro.amiq.dvt.ui.views.IDVTDynamicTableLayout;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.InspectViewUpdateEvent;
import ro.amiq.dvt.ui.views.TextFilterObject;
import ro.amiq.dvt.ui.views.ViewDataContainer;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.ViewsUtilsCommon;
import ro.amiq.dvt.ui.views.inspect.InspectViewComponent;
import ro.amiq.dvt.ui.views.inspect.InspectViewSelectionListener;
import ro.amiq.dvt.ui.views.inspect.InspectViewWavedromComponent;
import ro.amiq.dvt.ui.views.interpreter.DVTXInterpreterViewsLabelProvider;
import ro.amiq.dvt.ui.views.interpreter.IInterpreterViewsCommon;
import ro.amiq.dvt.ui.views.lazy.tree.DVTModelEvent;
import ro.amiq.dvt.ui.views.lazy.tree.DVTModelEventType;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTLazyTable;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTModel;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeIteratorType;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeMessageCompositeType;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeAction;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeRevealInViewActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSearchActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeUpdateViewActionArguments;
import ro.amiq.dvt.ui.views.lazy.views.CollapseAllAction;
import ro.amiq.dvt.ui.views.lazy.views.DVTLazyViewUtils;
import ro.amiq.dvt.ui.views.lazy.views.ExpandAllAction;
import ro.amiq.dvt.ui.views.registers.LazyRegisterTestUtils;
import ro.amiq.dvt.ui.views.registers.RegistersBaseDisplayKind;
import ro.amiq.dvt.ui.views.registers.RegistersDisplayKind;
import ro.amiq.dvt.ui.views.registers.RegistersSortKind;
import ro.amiq.dvt.ui.views.registers.RegistersViewActions;
import ro.amiq.dvt.ui.views.registers.RegistersViewCommon;
import ro.amiq.dvt.ui.views.registers.RegistersViewModel;
import ro.amiq.dvt.ui.views.registers.XRegistersViewUtils;
import ro.amiq.dvt.utils.StringMatcher;

public class RegistersView
extends RegistersViewCommon
implements IXvmFactoryInitListener,
IDVTLazyTable,
IDVTDynamicTableLayout {
    private static final String COMMENT = "Comment";
    private static final String SEQUENCER = "Sequencer";
    private static final String RIGHTS = "Rights";
    private static final String ADDRESS = "Address";
    private static final String NAME = "Name";
    private Label labelInfo;
    private Composite controlParent;
    private Composite childComposite;
    private static final int COLUMN_SIZE = 25;
    private static final String FILTER_BY_HIERARCHICAL_NAME_OR_ADDRESS = "Filter by: hierarchical name";
    private Action sortByAddressAction;
    private LazyRegisterTestUtils registerTestUtils = new LazyRegisterTestUtils(this);
    private Composite sashChildTree;
    private Combo fAddressBaseValueCombo;
    private Combo fDisplayKindCombo;
    private final StackLayout fLayout = new StackLayout();
    private Composite wrapperInspectView;
    private TextFilterObject filter;
    private InspectViewWavedromComponent fWaveDromViewComponent;
    private InspectViewComponent fInspectViewComponent;
    private ToggleInspectWaveDromPanelAction fToggleInspectWaveDromPanelAction = new ToggleInspectWaveDromPanelAction();
    private SashForm upperSashForm;

    @Override
    public void dispose() {
        if (this.currentContributor != null) {
            this.currentContributor.clearStateListeners();
        }
        tableColumns.clear();
        super.dispose();
    }

    public void setDisplayKind(RegistersDisplayKind kind) {
        this.fDisplayKindCombo.setText(kind.getText());
    }

    public RegistersDisplayKind getDisplayKind() {
        RegistersDisplayKind[] kind = new RegistersDisplayKind[1];
        Display.getDefault().syncExec(() -> {
            registersDisplayKindArray[0] = RegistersDisplayKind.valueOf(this.fDisplayKindCombo.getText());
        });
        return kind[0];
    }

    public RegistersSortKind getSortKind() {
        if (this.sortByAddressAction != null) {
            return this.sortByAddressAction.isChecked() ? RegistersSortKind.ADDRESS : RegistersSortKind.NAME;
        }
        return PrefConst.getRegistersViewSortByAddress() ? RegistersSortKind.ADDRESS : RegistersSortKind.NAME;
    }

    public void setBaseDisplayKind(RegistersBaseDisplayKind kind) {
        this.fAddressBaseValueCombo.setText(kind.getText());
    }

    public RegistersBaseDisplayKind getBaseDisplayKind() {
        RegistersBaseDisplayKind[] kind = new RegistersBaseDisplayKind[1];
        Display.getDefault().syncExec(() -> {
            registersBaseDisplayKindArray[0] = RegistersBaseDisplayKind.valueOf(this.fAddressBaseValueCombo.getText());
        });
        return kind[0];
    }

    @Override
    public void setInput(ViewDataContainer dataContainer) {
        this.dataContainer = dataContainer;
    }

    @Override
    public ViewDataContainer getDataContainer() {
        return this.dataContainer;
    }

    @Override
    public Control getControlToColorBg() {
        if (this.labelInfo == null) {
            return null;
        }
        return this.labelInfo.getParent();
    }

    @Override
    public Control getControlToColorFg() {
        return this.labelInfo;
    }

    @Override
    public IProject getProject() {
        if (this.dataContainer == null || this.dataContainer.getProject() == null) {
            return null;
        }
        return this.dataContainer.getProject();
    }

    @Override
    public void setCancelActionEnabled(boolean enabled) {
    }

    public Action getAlphabeticalSortAction() {
        return this.sortByAddressAction;
    }

    @Override
    public void createToolBar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        if (actionBars == null) {
            return;
        }
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.removeAll();
        if (toolBarManager.getItems().length > 0) {
            toolBarManager.add((IContributionItem)new Separator());
        }
        this.sortByAddressAction = new RegistersViewActions.RegistersViewSortByAddress(this);
        toolBarManager.add((IAction)this.sortByAddressAction);
        toolBarManager.add((IAction)this.fToggleInspectWaveDromPanelAction);
        toolBarManager.add((IContributionItem)new Separator());
        LazyTree lazyTree = this.getLazyTree();
        toolBarManager.add((IAction)new ExpandAllAction(lazyTree));
        toolBarManager.add((IAction)new CollapseAllAction(lazyTree));
        toolBarManager.update(true);
    }

    @Override
    public IDVTModel getModel(Class<? extends IDVTModel> modelClass) {
        return this.registersViewModel;
    }

    @Override
    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public void selectionChanged() {
    }

    @Override
    public LazyTreeIteratorType getIteratorType() {
        return LazyTreeIteratorType.LAZY_REGISTERS;
    }

    @Override
    public Objection getObjection() {
        return Objection.REGISTERS;
    }

    @Override
    public LazyRegisterTestUtils getLazyTreeTestUtils() {
        return this.registerTestUtils;
    }

    @Override
    public String getMessageText() {
        if (this.getProject() == null || !this.getProject().isAccessible() || !ro.amiq.dvt.utils.Utils.hasDvtNature(this.getProject())) {
            return "Select a DVT Project or file.";
        }
        if (!this.getTextFilter("default-filter").getText().isEmpty()) {
            if (this.registersViewModel == null) {
                return LazyTreeMessageCompositeType.NO_DATA.getMessage();
            }
            return LazyTreeMessageCompositeType.NO_MATCHES_FOUND.getMessage();
        }
        if (this.registersViewModel != null && this.registersViewModel.hasInterpreterFailed()) {
            this.registersViewModel = null;
            return LazyTreeMessageCompositeType.INTERPRETER_FAILED.getMessage();
        }
        return LazyTreeMessageCompositeType.NO_DATA.getMessage();
    }

    @Override
    public void gotoSelectedElement(String treeId) {
        TreePath selectedElement = this.getLazyTree().getSelection();
        if (selectedElement == null) {
            return;
        }
        IProject project = this.getProject();
        if (project == null) {
            return;
        }
        this.currentContributor.gotoElement(project, selectedElement);
    }

    @Override
    public String prepareText(String textFilterId, String text) {
        return text;
    }

    @Override
    public HistoryItem getHistoryItem() {
        IProject project;
        HistoryItem xvhHistoryItem;
        if (IInterpreterViewsCommon.isInterpreterMode() && (xvhHistoryItem = this.getXVHHistoryItem(project = DVTPlugin.getSelectionManager().getLastSelectedProject())) != null) {
            return xvhHistoryItem;
        }
        if (this.dataContainer == null) {
            return null;
        }
        return this.dataContainer.getHistoryItem();
    }

    private void updateLabelInfo() {
        Display.getDefault().asyncExec(() -> {
            if (this.labelInfo == null || this.labelInfo.isDisposed()) {
                return;
            }
            this.labelInfo.setText(this.getLabelInfoText());
            ObjectionManager.getInstance().clear(Objection.REGISTERS_LABEL);
        });
    }

    @Override
    public void stringMatcherUpdated(String uIJobTextFilterId) {
        this.updateLabelInfo();
        this.getLazyTree().doAction(LazyTreeAction.SEARCH, new LazyTreeSearchActionArguments(true, true, this.registersViewModel, Objection.REGISTERS));
    }

    @Override
    public Text getTextFilter(String textFilterId) {
        TextFilterObject textFilterObject = this.getTextFilterObject(textFilterId);
        if (textFilterObject == null) {
            return null;
        }
        Text textFilter = textFilterObject.getTextFilter();
        if (textFilter.isDisposed()) {
            return null;
        }
        return textFilter;
    }

    @Override
    public ILabelProvider getTreeLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public StringMatcher[] getTreeSearchSegments() {
        TextFilterObject textFilterObject = this.getTextFilterObject("default-filter");
        if (textFilterObject == null) {
            return null;
        }
        return textFilterObject.getSearchSegments();
    }

    @Override
    public boolean[] getTreeSearchStrictness() {
        TextFilterObject textFilterObject = this.getTextFilterObject("default-filter");
        if (textFilterObject == null) {
            return null;
        }
        return textFilterObject.getSearchTextStrictness();
    }

    @Override
    public List<String> getMemberNames(IDVTElementWrapper node) {
        return null;
    }

    @Override
    public boolean isFiltered() {
        TextFilterObject textFilterObject = this.getTextFilterObject("default-filter");
        if (textFilterObject == null) {
            return false;
        }
        return textFilterObject.isFiltered();
    }

    @Override
    public void update(BuildEvents updateEvent) {
        try {
            boolean resetTop;
            this.updateLabelInfo();
            this.updateLabelProvider();
            boolean isComputed = IInterpreterViewsCommon.isInterpreterMode();
            if (isComputed && updateEvent != BuildEvents.INCREMENTAL_BUILD) {
                this.registersViewModel = null;
                this.clean();
                updateEvent = updateEvent == BuildEvents.PRE_INTERPRETER_MODE ? updateEvent : BuildEvents.INTERPRETER_MODE;
            }
            IProject project = this.getProject();
            if (updateEvent == null && (project == null || !project.isAccessible()) || updateEvent != BuildEvents.INTERPRETER_MODE && updateEvent != BuildEvents.INTERPRETER_FAILED && updateEvent != BuildEvents.PRE_INTERPRETER_MODE && updateEvent != BuildEvents.GUI_FILTERS_WORKSPACE && updateEvent != BuildEvents.INTERPRETER_ACTION_VIEW && updateEvent != BuildEvents.INCREMENTAL_BUILD) {
                this.registersViewModel = null;
                this.clean();
            }
            this.currentContributor = XRegistersViewUtils.getViewContributor(isComputed || updateEvent == BuildEvents.PRE_INTERPRETER_MODE || updateEvent == BuildEvents.INTERPRETER_MODE || updateEvent == BuildEvents.INTERPRETER_FAILED);
            if (updateEvent == BuildEvents.GUI_FILTERS_WORKSPACE) {
                return;
            }
            if (!this.currentContributor.c(project)) {
                return;
            }
            if (project != null && project.hasNature("ro.amiq.vlogdt.VlogNature") && this.currentContributor != null && !this.currentContributor.isModelBuildDone(project)) {
                this.currentContributor.buildModel(project);
                return;
            }
            LazyTree lazyTree = this.getLazyTree();
            if (lazyTree == null) {
                return;
            }
            if (this.registersViewModel == null && updateEvent == BuildEvents.INTERPRETER_ACTION_VIEW) {
                return;
            }
            boolean resetSelection = updateEvent == null;
            boolean isInterpreterMode = updateEvent == BuildEvents.INTERPRETER_MODE;
            boolean resetModel = updateEvent == null || updateEvent == BuildEvents.FULL_BUILD || this.currentContributor.isStatic() && updateEvent == BuildEvents.INCREMENTAL_BUILD;
            boolean interpreterFailed = updateEvent == BuildEvents.INTERPRETER_FAILED;
            boolean isPreInterpreterMode = updateEvent == BuildEvents.PRE_INTERPRETER_MODE;
            boolean isInterpreterFinishedEvent = updateEvent == BuildEvents.INTERPRETER_MODE || updateEvent == BuildEvents.INTERPRETER_FAILED;
            ProjectColorUtils.setFgBg(this, this.getProject().getName());
            boolean bl = resetTop = updateEvent == null || updateEvent != BuildEvents.INCREMENTAL_BUILD && updateEvent != BuildEvents.INTERPRETER_FAILED && updateEvent != BuildEvents.INTERPRETER_MODE;
            if (this.registersViewModel == null || isPreInterpreterMode || isInterpreterMode || resetModel) {
                if (isPreInterpreterMode) {
                    this.fWaveDromViewComponent.generateWavedromDiagram("");
                }
                this.registersViewModel = new RegistersViewModel(this.getProject(), (DVTBaseLabelProvider)this.getLabelProvider(), this, isPreInterpreterMode);
            }
            if (interpreterFailed) {
                this.registersViewModel.setHasInterpreterFailed(true);
                if (this.fWaveDromViewComponent != null) {
                    this.fWaveDromViewComponent.generateWavedromDiagram("");
                }
            }
            lazyTree.doAction(LazyTreeAction.UPDATE_VIEW, new LazyTreeUpdateViewActionArguments(this, this.registersViewModel, resetSelection, resetTop, resetModel, isInterpreterFinishedEvent ? Objection.REGISTERS_INTERPRETED : Objection.REGISTERS));
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void updateLabelProvider() {
        this.labelProvider.setDisplayHierarhical(RegistersDisplayKind.valueOf(this.fDisplayKindCombo.getText()) == RegistersDisplayKind.Tree);
        this.labelProvider.setDisplayMode16(RegistersBaseDisplayKind.valueOf(this.fAddressBaseValueCombo.getText()) == RegistersBaseDisplayKind.Hex);
    }

    @Override
    public void clean() {
        IProject project = this.getProject();
        if (project == null || !project.isAccessible() || !ro.amiq.dvt.utils.Utils.hasDvtNature(project)) {
            this.labelInfo.setText(LazyTreeMessageCompositeType.NO_DVT_PROJECT_SELECTED.getMessage());
            ProjectColorUtils.setFgBg(this, null);
        } else {
            this.labelInfo.setText("[" + project.getName() + "]");
            ProjectColorUtils.setFgBg(this, project.getName());
        }
        if (this.getLazyTree() != null) {
            this.getLazyTree().doAction(LazyTreeAction.CLEAN, new LazyTreeActionArguments(Objection.REGISTERS));
        }
        this.dataContainer = new ViewDataContainer(project, null);
        this.fWaveDromViewComponent.generateWavedromDiagram("");
        this.createAndSyncTreeColumns(this.getLazyTree().getTopTable(), this.getLazyTree().getTree(), this.getLazyTree().getScrolledComposite());
    }

    @Override
    protected void createViewSpecificPartControl(Composite parent) {
        this.controlParent = parent;
        LazyTree lazyTree = new LazyTree(this);
        this.setLazyTree(lazyTree);
        this.childComposite = new Composite(parent, 0);
        this.childComposite.setLayoutData((Object)new GridData(1808));
        this.childComposite.setLayout((Layout)DVTLazyViewUtils.LAYOUT);
        SashForm mainSashForm = new SashForm(this.childComposite, 512);
        mainSashForm.setLayout((Layout)DVTLazyViewUtils.LAYOUT);
        mainSashForm.setFont(this.childComposite.getFont());
        mainSashForm.setLayoutData((Object)new GridData(1808));
        Composite fUpperSashFormComposite = new Composite((Composite)mainSashForm, 0);
        fUpperSashFormComposite.setLayout((Layout)DVTLazyViewUtils.LAYOUT);
        fUpperSashFormComposite.setLayoutData((Object)new GridData(1808));
        Composite labelComposite = new Composite(fUpperSashFormComposite, 0);
        GridLayout labelLayout = new GridLayout(1, false);
        labelComposite.setLayout((Layout)labelLayout);
        labelComposite.setLayoutData((Object)new GridData(4, 1, false, false));
        this.labelInfo = new Label(labelComposite, 16384);
        this.labelInfo.setFont(labelComposite.getFont());
        this.labelInfo.setLayoutData((Object)new GridData(768));
        this.updateLabelInfo();
        this.upperSashForm = new SashForm(fUpperSashFormComposite, 256);
        this.upperSashForm.setLayout((Layout)DVTLazyViewUtils.TWO_PART_LAYOUT);
        this.upperSashForm.setLayoutData((Object)new GridData(1808));
        this.sashChildTree = new Composite((Composite)this.upperSashForm, 0);
        this.sashChildTree.setLayout((Layout)DVTLazyViewUtils.LAYOUT);
        this.sashChildTree.setLayoutData((Object)new GridData(1808));
        Composite comboComposite = new Composite(this.sashChildTree, 0);
        comboComposite.setLayout((Layout)DVTLazyViewUtils.TWO_PART_LAYOUT);
        comboComposite.setLayoutData((Object)new GridData(2));
        Composite addressBaseComposite = new Composite(comboComposite, 0);
        addressBaseComposite.setLayout((Layout)DVTLazyViewUtils.TWO_PART_LAYOUT);
        addressBaseComposite.setLayoutData((Object)new GridData(2));
        Label addressBaseValueLabel = new Label(addressBaseComposite, 0);
        addressBaseValueLabel.setFont(addressBaseComposite.getFont());
        addressBaseValueLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        addressBaseValueLabel.setText("Address Radix:");
        this.fAddressBaseValueCombo = new Combo(addressBaseComposite, 4);
        GridData layoutData = new GridData(16384, 1, false, false);
        layoutData.widthHint = 100;
        this.fAddressBaseValueCombo.setLayoutData((Object)layoutData);
        this.fAddressBaseValueCombo.add(RegistersBaseDisplayKind.Dec.getText(), 0);
        this.fAddressBaseValueCombo.add(RegistersBaseDisplayKind.Hex.getText(), 1);
        this.fAddressBaseValueCombo.setText(RegistersBaseDisplayKind.Hex.getText());
        this.fAddressBaseValueCombo.addModifyListener(e -> this.update(BuildEvents.INTERPRETER_ACTION_VIEW));
        Composite displayKindComposite = new Composite(comboComposite, 0);
        displayKindComposite.setLayout((Layout)DVTLazyViewUtils.TWO_PART_LAYOUT);
        displayKindComposite.setLayoutData((Object)new GridData(2));
        Label displayKindLabel = new Label(displayKindComposite, 0);
        displayKindLabel.setFont(displayKindLabel.getFont());
        displayKindLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        displayKindLabel.setText("Display mode:");
        this.fDisplayKindCombo = new Combo(displayKindComposite, 4);
        GridData layoutDataDisplayKind = new GridData(16384, 1, false, false);
        layoutDataDisplayKind.widthHint = 100;
        this.fDisplayKindCombo.setLayoutData((Object)layoutDataDisplayKind);
        this.fDisplayKindCombo.add(RegistersDisplayKind.Tree.getText(), 0);
        this.fDisplayKindCombo.add(RegistersDisplayKind.List.getText(), 1);
        this.fDisplayKindCombo.setText(RegistersDisplayKind.Tree.getText());
        this.fDisplayKindCombo.addModifyListener(e -> this.update(BuildEvents.INTERPRETER_ACTION_VIEW));
        this.createTextFilter("default-filter", this.sashChildTree, "default-tree", false);
        this.filter = this.getTextFilterObject("default-filter");
        this.filter.setTextFilterMessage(FILTER_BY_HIERARCHICAL_NAME_OR_ADDRESS);
        lazyTree.setSearchBar(this.filter);
        lazyTree.setLabelProvider(this.getLabelProvider(), false);
        lazyTree.install(this.sashChildTree);
        Tree fTree = lazyTree.getTree();
        fTree.setHeaderVisible(false);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.upperSashForm);
        this.wrapperInspectView = new Composite((Composite)this.upperSashForm, 2048);
        this.wrapperInspectView.setLayout((Layout)this.fLayout);
        this.wrapperInspectView.setLayoutData((Object)new GridData(4));
        if (EclipseUtils.hasWorkingBrowser()) {
            this.fWaveDromViewComponent = new InspectViewWavedromComponent(this.wrapperInspectView);
            this.fWaveDromViewComponent.setVisible(PrefConst.getRegistersShowInspectViewWaveDrom());
        }
        this.fInspectViewComponent = new InspectViewComponent(this.wrapperInspectView);
        this.fInspectViewComponent.setVisible(PrefConst.getRegistersShowInspectViewWaveDrom());
        this.addSelectionChangedListener(InspectViewSelectionListener.getInstance());
        fTree.addKeyListener((KeyListener)this.getKeyListener("default-filter", "default-tree"));
        DVTMixedLangModelManager.getInstance().addXvmFactoryInitListeners(this);
    }

    @Override
    protected void createCustomContextMenu(IMenuManager manager) {
    }

    @Override
    public void createAndSyncTreeColumns(Table topTable, Tree tree, ScrolledComposite scrolledComposite) {
        boolean isInterpreterState;
        if (topTable.isDisposed() || tree.isDisposed() || scrolledComposite.isDisposed()) {
            return;
        }
        int n = tree.getSize().x;
        if (n == 0 || n >= 1000) {
            n = 1000;
        }
        boolean bl = isInterpreterState = this.getHistoryItem() != null && this.getHistoryItem().isInterpreterActive();
        if (this.sortByAddressAction != null) {
            this.sortByAddressAction.setEnabled(isInterpreterState);
        }
        if (this.fAddressBaseValueCombo != null) {
            this.fAddressBaseValueCombo.setEnabled(isInterpreterState);
        }
        int defaultWidth = n * 25 / 100;
        int interpreterStateWidth = isInterpreterState ? defaultWidth : 0;
        this.updateOrInstallTableColumn(this.getLazyTree(), 16384, NAME, 0, defaultWidth);
        this.labelProvider.updateColumnSize(0, defaultWidth);
        this.updateOrInstallTableColumn(this.getLazyTree(), 16384, ADDRESS, 1, interpreterStateWidth);
        this.labelProvider.updateColumnSize(1, interpreterStateWidth);
        this.updateOrInstallTableColumn(this.getLazyTree(), 16384, RIGHTS, 2, defaultWidth);
        this.labelProvider.updateColumnSize(2, defaultWidth);
        this.updateOrInstallTableColumn(this.getLazyTree(), 16384, SEQUENCER, 3, interpreterStateWidth);
        this.labelProvider.updateColumnSize(3, interpreterStateWidth);
        this.updateOrInstallTableColumn(this.getLazyTree(), 16384, COMMENT, 4, defaultWidth);
        this.labelProvider.updateColumnSize(4, defaultWidth);
    }

    public Composite getControlParent() {
        return this.controlParent;
    }

    public List<Object> getTreeElementsForRoot(Object root) {
        return this.registersViewModel.getTreeElementsForRoot(root);
    }

    public void baseDecimalTestAction() {
        Display.getDefault().syncExec(() -> {
            this.fAddressBaseValueCombo.setText(RegistersBaseDisplayKind.Dec.getText());
            this.update(BuildEvents.INTERPRETER_ACTION_VIEW);
        });
    }

    public void displayFormatTestAction() {
        Display.getDefault().syncExec(() -> {
            this.fDisplayKindCombo.setText(RegistersDisplayKind.List.getText());
            this.update(BuildEvents.INTERPRETER_ACTION_VIEW);
        });
    }

    @Override
    public int getViewColumnCount() {
        return 5;
    }

    @Override
    public void fireSelectionChanged(SelectionChangedEvent event) {
        super.fireSelectionChanged(event);
        ISelection selection = event.getSelection();
        if (!(selection instanceof StructuredSelection) || selection.isEmpty()) {
            return;
        }
        Object wrapper = ((StructuredSelection)selection).getFirstElement();
        Object rfElement = null;
        if (!(wrapper instanceof IDVTElementWrapper)) {
            return;
        }
        rfElement = ((IDVTElementWrapper)wrapper).getRfElement();
        if (wrapper instanceof TreePath) {
            rfElement = ((TreePath)wrapper).getElement();
        }
        if (!(rfElement instanceof IXXVMRegBlock)) {
            return;
        }
        IXXVMRegBlock regBlock = (IXXVMRegBlock)rfElement;
        if (regBlock.isBlockRegisters()) {
            this.fInspectViewComponent.update(new InspectViewUpdateEvent((IDVTElementWrapper)wrapper, event));
            this.fLayout.topControl = this.fInspectViewComponent;
            this.wrapperInspectView.layout();
            return;
        }
        if (this.fWaveDromViewComponent != null) {
            this.fWaveDromViewComponent.generateWavedromDiagram(BitFieldFactory.getModel(regBlock.getRegBlockAssocType(), ElementPath.EMPTY_PATH));
            this.fLayout.topControl = this.fWaveDromViewComponent.getBrowser();
            this.wrapperInspectView.layout();
        }
    }

    public void revealInRegistersView(GoToInfo goToInfo, IRfNamedElement namedElement) {
        TreePath treePath = this.currentContributor.createTreePath(goToInfo, namedElement);
        if (treePath == null) {
            ViewsUtils.popOKDialog(2, "Registers", "The selected register was not found in Registers View!");
            return;
        }
        if (treePath == TreePath.TOP_DUMMY_TREE_PATH) {
            return;
        }
        this.registersViewModel = new RegistersViewModel(this.getProject(), this.labelProvider, this, false);
        this.getLazyTree().doAction(LazyTreeAction.REVEAL_IN_VIEW, new LazyTreeRevealInViewActionArguments(treePath, false, Objection.REGISTERS));
    }

    @Override
    public void postXvmReadyUpdate() {
        IProject project = this.getProject();
        if (project == null) {
            return;
        }
        DVTViewEvent event = new DVTViewEvent(DVTViewEvent.EventKind.CUSTOM, null, new ViewDataContainer(project, null));
        event.setOverrideView(true);
        event.setCustomImplementation(new DVTViewEvent.CustomEventImplementation(){

            @Override
            public void run() {
                if (!(this.view instanceof RegistersView)) {
                    return;
                }
                ViewsUtilsCommon.updateView((RegistersView)this.view, BuildEvents.INCREMENTAL_BUILD, false);
            }
        });
        Utils.safeRunSynchInUIThread(() -> ViewsUtils.notifyAllViewsById("ro.amiq.dvt.ui.views.RegistersView", event, false));
    }

    public TextFilterObject getFilter() {
        return this.filter;
    }

    @Override
    public void stateChanged(DVTModelEvent event) {
        if (event == null || event.getEventType() != DVTModelEventType.MODEL_COMPUTING_DONE) {
            return;
        }
        this.updateLabelInfo();
    }

    public static class DVTRegistersViewLabelProviderListener
    implements Runnable {
        private final DVTXInterpreterViewsLabelProvider labelProvider;
        private final TableColumn tableColumn;
        private final int columnIndex;

        public DVTRegistersViewLabelProviderListener(DVTXInterpreterViewsLabelProvider labelProvider, TableColumn tableColumn, int columnIndex) {
            this.labelProvider = labelProvider;
            this.tableColumn = tableColumn;
            this.columnIndex = columnIndex;
        }

        @Override
        public void run() {
            this.labelProvider.updateColumnSize(this.columnIndex, this.tableColumn.getWidth());
        }
    }

    class ToggleInspectWaveDromPanelAction
    extends Action {
        private static final String TOGGLE_INSPECT_PANEL = "Toggle Inspect Panel";

        public ToggleInspectWaveDromPanelAction() {
            super(TOGGLE_INSPECT_PANEL, 2);
            this.setDescription(TOGGLE_INSPECT_PANEL);
            this.setToolTipText(TOGGLE_INSPECT_PANEL);
            this.setImageDescriptor(DVTImages.INSPECT_LAYOUT);
            this.setChecked(PrefConst.getRegistersShowInspectViewWaveDrom());
        }

        public void run() {
            PrefConst.setRegisterShowInspectViewWaveDrom(this.isChecked());
            RegistersView.this.fInspectViewComponent.setVisible(PrefConst.getRegistersShowInspectViewWaveDrom());
            RegistersView.this.fWaveDromViewComponent.setVisible(PrefConst.getRegistersShowInspectViewWaveDrom());
            RegistersView.this.upperSashForm.layout();
        }
    }
}

